/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.ViewerCommands;
import org.jpedal.examples.viewer.commands.OpenFile;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.ImageDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public final class SwingPortfolioUtils {
    private SwingPortfolioUtils() {
    }

    public static boolean saveFile(PdfObjectReader reader, PdfObject fileObject, File output) {
        try {
            boolean created;
            PdfObject efObj = fileObject.getDictionary(5398);
            reader.checkResolved(efObj);
            PdfObject fileObj = efObj.getDictionary(22);
            reader.checkResolved(fileObj);
            byte[] stream = fileObj.getDecodedStream();
            if (!output.exists() && !(created = output.createNewFile())) {
                return false;
            }
            ObjectStore.writeToFile(output.getAbsolutePath(), stream);
        }
        catch (IOException e2) {
            LogWriter.writeLog(e2);
            return false;
        }
        return true;
    }

    public static void openFile(SwingGUI gui, PdfObjectReader reader, PdfObject fileObject, String filename) {
        PdfObject efObj = fileObject.getDictionary(5398);
        reader.checkResolved(efObj);
        PdfObject fileObj = efObj.getDictionary(22);
        reader.checkResolved(fileObj);
        byte[] stream = fileObj.getDecodedStream();
        try {
            String fileName = ObjectStore.createTempFile(filename).getAbsolutePath();
            ObjectStore.writeToFile(fileName, stream);
            Commands currentCommands = gui.getCommand();
            if (OpenFile.isSupportedFileExtension(filename)) {
                currentCommands.executeCommand(ViewerCommands.OPENFILE, new Object[]{fileName});
            } else {
                String message = Messages.getMessage("PdfPortfolio.OpenNativeWarningStart") + filename + Messages.getMessage("PdfPortfolio.OpenNativeWarningEnd");
                int result = gui.showConfirmDialog(message, Messages.getMessage("PdfPortfolio.OpenNativeWarningTitle"), 0);
                if (result == 0) {
                    currentCommands.executeCommand(ViewerCommands.OPENINSYSTEMDEFAULT, new Object[]{fileName});
                }
            }
        }
        catch (IOException e2) {
            LogWriter.writeLog(e2);
        }
    }

    public static ImageIcon createThumbnail(PdfObject thumb, PdfObjectReader reader, ImageDecoder imageDecoder, int maxWidth, int maxHeight) {
        if (thumb != null) {
            reader.checkResolved(thumb);
            byte[] decodedStream = reader.readStream(thumb, true, true, false, false, false, thumb.getCacheName(reader.getObjectReader()));
            BufferedImage img = imageDecoder.processImageXObject(thumb, "", decodedStream, "");
            float xScale = (float)maxWidth / (float)img.getWidth();
            float altScale = (float)maxHeight / (float)img.getHeight();
            if (altScale < xScale) {
                xScale = altScale;
            }
            if (xScale > 1.0f) {
                xScale = 1.0f;
            }
            return new ImageIcon(img.getScaledInstance((int)((float)img.getWidth() * xScale), (int)((float)img.getHeight() * xScale), 0));
        }
        BufferedImage bi2 = new BufferedImage(maxWidth, maxHeight, 2);
        Graphics2D g2 = bi2.createGraphics();
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(2.0f));
        g2.drawRect(1, 2, maxWidth - 2, maxHeight - 3);
        g2.drawLine(0, 0, maxWidth, maxHeight);
        return new ImageIcon(bi2);
    }
}

