/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingMouseUtils;
import org.jpedal.examples.viewer.gui.swing.SwingPortfolioContextMenu;
import org.jpedal.examples.viewer.gui.swing.SwingPortfolioUtils;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.image.DO;
import org.jpedal.utils.StringUtils;

public class SwingPortfolioTile
extends JScrollPane {
    private final JPanel tilePanel;
    private final SwingGUI currentGui;

    public SwingPortfolioTile(SwingGUI gui) {
        this.currentGui = gui;
        FlowLayout flowLayout = new FlowLayout(0);
        this.tilePanel = new JPanel(flowLayout);
        this.tilePanel.setBackground(gui.getPdfDecoder().getBackground());
        this.getViewport().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                super.componentResized(e2);
                int width = (int)e2.getComponent().getSize().getWidth();
                int height = SwingPortfolioTile.this.tilePanel.getComponentCount() / (width / 144);
                if (SwingPortfolioTile.this.tilePanel.getComponentCount() % (width / 144) > 0) {
                    ++height;
                }
                SwingPortfolioTile.this.tilePanel.setPreferredSize(new Dimension(width, height *= 192));
                SwingPortfolioTile.this.tilePanel.validate();
            }
        });
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(20);
        this.getViewport().add(this.tilePanel);
    }

    public void loadCollectionValues(PdfDecoderInt decode_pdf) {
        this.tilePanel.removeAll();
        PdfObjectReader reader = decode_pdf.getIO();
        Object[] files = reader.getNamesLookup().getEmbeddedFiles();
        DO imageDecoder = new DO(1, reader, null, decode_pdf.getObjectStore(), decode_pdf.getPdfImageData(), decode_pdf.getPdfPageData(), "");
        imageDecoder.setParams(new ParserOptions());
        imageDecoder.setRes(new PdfObjectCache());
        for (int i2 = 0; i2 != files.length; i2 += 2) {
            int pathEnd;
            String filename;
            PdfObject pObj = (PdfObject)files[i2 + 1];
            reader.checkResolved(pObj);
            PdfObject thumb = pObj.getDictionary(944061782);
            ImageIcon icon = SwingPortfolioUtils.createThumbnail(thumb, reader, imageDecoder, 128, 128);
            byte[] filenameBytes = pObj.getTextStreamValueAsByte(9494);
            if (filenameBytes == null) {
                filenameBytes = pObj.getTextStreamValueAsByte(22);
            }
            if ((filename = StringUtils.getTextString(filenameBytes, false)) != null && (pathEnd = filename.lastIndexOf(47)) != -1) {
                filename = filename.substring(pathEnd + 1);
            }
            Tile tile = new Tile(reader, pObj, icon, filename);
            this.tilePanel.add(tile);
        }
    }

    class Tile
    extends JPanel {
        private final PdfObject fileObject;
        private final PdfObjectReader reader;
        static final int tileWidth = 144;
        static final int tileHeight = 192;
        final MouseListener listener = new MouseAdapter(){
            final SwingPortfolioContextMenu menu;
            {
                this.menu = new SwingPortfolioContextMenu(SwingPortfolioTile.this.currentGui);
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                switch (SwingMouseUtils.getMouseButton(me)) {
                    case 1: {
                        int pathEnd;
                        String filename;
                        if (me.getClickCount() != 2 || Tile.this.fileObject == null) break;
                        byte[] filenameBytes = Tile.this.fileObject.getTextStreamValueAsByte(9494);
                        if (filenameBytes == null) {
                            filenameBytes = Tile.this.fileObject.getTextStreamValueAsByte(22);
                        }
                        if ((filename = StringUtils.getTextString(filenameBytes, false)) != null && (pathEnd = filename.lastIndexOf(47)) != -1) {
                            filename = filename.substring(pathEnd + 1);
                        }
                        SwingPortfolioUtils.openFile(SwingPortfolioTile.this.currentGui, Tile.this.reader, Tile.this.fileObject, filename);
                        break;
                    }
                    case 3: {
                        this.menu.setUpObjects(Tile.this.reader, Tile.this.fileObject);
                        this.menu.show(me.getComponent(), me.getX(), me.getY());
                    }
                }
            }
        };

        Tile(PdfObjectReader reader, PdfObject fileObject, ImageIcon icon, String filename) {
            this.fileObject = fileObject;
            this.reader = reader;
            this.setLayout(new BorderLayout());
            JLabel iconLabel = new JLabel(icon);
            JLabel fileLabel = new JLabel(filename, 0);
            iconLabel.setAlignmentX(0.5f);
            fileLabel.setAlignmentX(0.5f);
            this.add((Component)iconLabel, "Center");
            this.add((Component)fileLabel, "South");
            this.setBorder(BorderFactory.createMatteBorder(2, 2, 6, 2, Color.BLACK));
            iconLabel.addMouseListener(this.listener);
            fileLabel.addMouseListener(this.listener);
            this.addMouseListener(this.listener);
            this.setPreferredSize(new Dimension(144, 192));
        }
    }
}

