/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingCheckBoxMenuItem;
import org.jpedal.examples.viewer.gui.swing.SwingMouseUtils;
import org.jpedal.examples.viewer.gui.swing.SwingPortfolioContextMenu;
import org.jpedal.examples.viewer.gui.swing.SwingPortfolioUtils;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.CollectionObject;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.image.DO;
import org.jpedal.utils.Messages;
import org.jpedal.utils.StringUtils;

public class SwingPortfolioDetail
extends JScrollPane {
    private final int thumbnailSmallestSide;
    private PdfObjectReader reader;
    private DefaultTableModel model;
    private final JTable table;
    private final JPopupMenu menu;
    private final HashMap<String, TableColumn> columns = new HashMap();

    public SwingPortfolioDetail(final SwingGUI gui) {
        this.thumbnailSmallestSide = 64;
        this.menu = new JPopupMenu();
        this.table = new JTable(){
            final DefaultTableCellRenderer renderCenter = new DefaultTableCellRenderer();
            {
                this.renderCenter.setVerticalAlignment(1);
                this.renderCenter.setHorizontalAlignment(0);
            }

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return this.getPreferredSize().width < this.getParent().getWidth();
            }

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column != 0) {
                    return this.renderCenter;
                }
                return super.getCellRenderer(row, column);
            }

            @Override
            public Class<?> getColumnClass(int column) {
                if (this.getValueAt(0, column) != null) {
                    return this.getValueAt(0, column).getClass();
                }
                return super.getColumnClass(column);
            }
        };
        this.table.setAutoCreateRowSorter(true);
        this.table.setFocusable(false);
        this.table.setRowHeight(this.thumbnailSmallestSide);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setDefaultEditor(Object.class, null);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                super.mouseClicked(e2);
                if (SwingMouseUtils.getMouseButton(e2) == 3) {
                    SwingPortfolioDetail.this.menu.show(e2.getComponent(), e2.getX(), e2.getY());
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){
            final SwingPortfolioContextMenu menu;
            {
                this.menu = new SwingPortfolioContextMenu(gui);
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                PdfObject fileObject;
                Point p2;
                JTable table = (JTable)me.getSource();
                int row = table.rowAtPoint(p2 = me.getPoint());
                if (row != -1) {
                    fileObject = (PdfObject)SwingPortfolioDetail.this.model.getValueAt(table.convertRowIndexToModel(row), SwingPortfolioDetail.this.model.getColumnCount() - 1);
                } else {
                    fileObject = null;
                    table.clearSelection();
                }
                if (fileObject != null) {
                    switch (SwingMouseUtils.getMouseButton(me)) {
                        case 1: {
                            int pathEnd;
                            String filename;
                            if (me.getClickCount() != 2) break;
                            byte[] filenameBytes = fileObject.getTextStreamValueAsByte(9494);
                            if (filenameBytes == null) {
                                filenameBytes = fileObject.getTextStreamValueAsByte(22);
                            }
                            if ((filename = StringUtils.getTextString(filenameBytes, false)) != null && (pathEnd = filename.lastIndexOf(47)) != -1) {
                                filename = filename.substring(pathEnd + 1);
                            }
                            SwingPortfolioUtils.openFile(gui, SwingPortfolioDetail.this.reader, fileObject, filename);
                            break;
                        }
                        case 3: {
                            this.menu.setUpObjects(SwingPortfolioDetail.this.reader, fileObject);
                            this.menu.show(me.getComponent(), me.getX(), me.getY());
                        }
                    }
                }
            }
        });
        this.getViewport().setBackground(gui.getPdfDecoder().getBackground());
        this.getViewport().add(this.table);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
    }

    void clearValues() {
        this.columns.clear();
        if (this.menu != null) {
            this.menu.removeAll();
        }
    }

    void loadEmbeddedFilesValues(PdfObjectReader reader, Object[] embeddedFiles, int[] locationInFile) {
        this.clearValues();
        this.model = new DefaultTableModel();
        this.table.setModel(this.model);
        this.table.setFillsViewportHeight(true);
        this.reader = reader;
        String[] columnNames = new String[]{Messages.getMessage("PdfAttachments.nameColumn"), Messages.getMessage("PdfAttachments.descriptionColumn"), Messages.getMessage("PdfAttachments.modifiedDateColumn"), Messages.getMessage("PdfAttachments.sizeColumn"), Messages.getMessage("PdfAttachments.relationshipColumn"), Messages.getMessage("PdfAttachments.locationInFile")};
        String[][] tableData = new String[columnNames.length][embeddedFiles.length / 2];
        boolean locationColumnEmpty = true;
        for (int i2 = 0; i2 < embeddedFiles.length; i2 += 2) {
            String modDate;
            String desc;
            String filename;
            PdfObject pObj = (PdfObject)embeddedFiles[i2 + 1];
            reader.checkResolved(pObj);
            PdfObject efObj = pObj.getDictionary(5398);
            reader.checkResolved(efObj);
            PdfObject fileObj = efObj.getDictionary(22);
            reader.checkResolved(fileObj);
            PdfObject paramsObj = fileObj.getDictionary(1110531444);
            reader.checkResolved(paramsObj);
            byte[] filenameBytes = pObj.getTextStreamValueAsByte(9494);
            if (filenameBytes == null) {
                filenameBytes = pObj.getTextStreamValueAsByte(22);
            }
            if ((filename = StringUtils.getTextString(filenameBytes, false)) != null) {
                int pathEnd = filename.lastIndexOf(47);
                if (pathEnd != -1) {
                    filename = filename.substring(pathEnd + 1);
                }
                tableData[0][i2 / 2] = "<html>" + filename.replaceAll("\n", "<br>") + "</html>";
            } else {
                tableData[0][i2 / 2] = (String)embeddedFiles[i2];
            }
            byte[] descBytes = pObj.getTextStreamValueAsByte(339034931);
            if (descBytes != null && (desc = StringUtils.getTextString(descBytes, false)) != null) {
                tableData[1][i2 / 2] = "<html>" + desc.replaceAll("\n", "<br>") + "</html>";
            }
            tableData[2][i2 / 2] = Messages.getMessage("PdfPortfolio.Unknown");
            if (paramsObj != null && (modDate = paramsObj.getTextStreamValue(340689769)) != null) {
                tableData[2][i2 / 2] = "<html>" + SwingPortfolioDetail.convertDateStringToReadableDate(modDate) + "</html>";
            }
            int size = 0;
            if (paramsObj != null) {
                size = paramsObj.getInt(590957109);
            }
            tableData[3][i2 / 2] = SwingPortfolioDetail.convertFileSizeToReadableSize(size);
            tableData[4][i2 / 2] = "";
            if (locationInFile == null || locationInFile.length <= 0 || i2 / 2 >= locationInFile.length) continue;
            if (locationColumnEmpty && locationInFile[i2 / 2] != -1) {
                locationColumnEmpty = false;
            }
            tableData[5][i2 / 2] = locationInFile[i2 / 2] != -1 ? Integer.toString(locationInFile[i2 / 2]) : "";
        }
        if (locationColumnEmpty) {
            columnNames[5] = null;
        }
        ColumnData[] cols = new ColumnData[columnNames.length];
        for (int i3 = 0; i3 != cols.length; ++i3) {
            cols[i3] = new ColumnData(0, 0, i3, columnNames[i3], true, tableData[i3]);
        }
        this.loadValuesIntoTable(cols, embeddedFiles);
    }

    public void loadCollectionValues(PdfDecoderInt decode_pdf) {
        this.clearValues();
        this.model = new DefaultTableModel();
        this.table.setModel(this.model);
        this.table.setFillsViewportHeight(false);
        PdfObject collectionObj = decode_pdf.getIO().getPDFObject(-2139781200);
        this.reader = decode_pdf.getIO();
        this.reader.checkResolved(collectionObj);
        PdfObject schema = collectionObj.getDictionary(943022180);
        this.reader.checkResolved(schema);
        PdfKeyPairsIterator keyPairs = schema.getKeyPairsIterator();
        boolean defaultAscending = true;
        int sortColumnID = -1;
        PdfObject sort = collectionObj.getDictionary(591348292);
        if (sort != null) {
            String colName;
            decode_pdf.getIO().checkResolved(sort);
            byte[][] sortArray = sort.getStringArray(35);
            boolean[] ascendingArray = sort.getBooleanArray(17);
            if (sortArray != null) {
                colName = StringUtils.getTextString(sortArray[0], true);
                if (colName != null) {
                    colName = colName.substring(1);
                }
                sortColumnID = PdfDictionary.stringToInt(colName);
            } else {
                colName = sort.getName(35);
                if (colName != null) {
                    sortColumnID = PdfDictionary.stringToInt(colName);
                }
            }
            defaultAscending = ascendingArray != null ? ascendingArray[0] : sort.getBoolean(17);
        }
        Object[] files = this.reader.getNamesLookup().getEmbeddedFiles();
        DO imageDecoder = new DO(1, this.reader, null, decode_pdf.getObjectStore(), decode_pdf.getPdfImageData(), decode_pdf.getPdfPageData(), "");
        imageDecoder.setParams(new ParserOptions());
        imageDecoder.setRes(new PdfObjectCache());
        this.model.addColumn((Object)"Thumbnail", this.generateFileThumbnails(this.reader, files, imageDecoder));
        ArrayList<ColumnData> tableData = this.createTableColumnData(keyPairs, files);
        tableData.sort((o1, o2) -> {
            if (o1.getOrder() < o2.getOrder()) {
                return -1;
            }
            if (o1.getOrder() > o2.getOrder()) {
                return 1;
            }
            return 0;
        });
        this.loadValuesIntoTable(tableData.toArray(new ColumnData[0]), files);
        this.sortTableByColumn(tableData, sortColumnID, defaultAscending);
    }

    private ArrayList<ColumnData> createTableColumnData(PdfKeyPairsIterator keyPairs, Object[] files) {
        ArrayList<ColumnData> tableData = new ArrayList<ColumnData>();
        ObjectDecoder objectDecoder = new ObjectDecoder(this.reader.getObjectReader());
        while (keyPairs.hasMorePairs()) {
            String key = keyPairs.getNextKeyAsString();
            byte[] value = keyPairs.getNextValueAsBytes();
            CollectionObject obj = new CollectionObject(new String(value));
            int type = PdfDictionary.stringToInt(key);
            obj.setUnresolvedData(value, type);
            objectDecoder.checkResolved(obj);
            if (obj.getNameAsConstant(1147962727) != -1) {
                tableData.add(new ColumnData(type, obj.getNameAsConstant(1147962727), obj.getInt(31), obj.getTextStreamValue(30), obj.getBoolean(38), this.getColumnData(files, PdfDictionary.stringToInt(key), obj.getNameAsConstant(1147962727), objectDecoder)));
            }
            keyPairs.nextPair();
        }
        this.addDefaultColumns(objectDecoder, tableData, files);
        return tableData;
    }

    private void addDefaultColumns(ObjectDecoder objectDecoder, ArrayList<ColumnData> tableData, Object[] files) {
        boolean defaultsVisible = true;
        for (ColumnData col : tableData) {
            if (!col.isVisibility()) continue;
            defaultsVisible = false;
            break;
        }
        int[] keys = new int[]{879393130, 2005904833, 340689769, 590957109, -1547905827, 1806481572};
        int[] keyTypes = new int[]{22, 339034931, 340689769, 590957109, -1547905827, 1806481572};
        String[] names = new String[]{Messages.getMessage("PdfAttachments.nameColumn"), Messages.getMessage("PdfAttachments.descriptionColumn"), Messages.getMessage("PdfAttachments.modifiedDateColumn"), Messages.getMessage("PdfAttachments.sizeColumn"), Messages.getMessage("PdfAttachments.compressedSize"), Messages.getMessage("PdfAttachments.created")};
        for (int i2 = 0; i2 != keys.length; ++i2) {
            int key = keys[i2];
            int type = keyTypes[i2];
            boolean exists = false;
            for (ColumnData data : tableData) {
                if (data.getKey() != key && data.getSubType() != type) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            tableData.add(new ColumnData(key, type, i2, names[i2], defaultsVisible, this.getColumnData(files, key, type, objectDecoder)));
        }
    }

    private void sortTableByColumn(ArrayList<ColumnData> tableData, int columnID, boolean ascending) {
        int sortCol = 1;
        for (ColumnData col : tableData) {
            if (col.getKey() == columnID) break;
            ++sortCol;
        }
        this.table.getRowSorter().toggleSortOrder(sortCol);
        if (!ascending) {
            this.table.getRowSorter().toggleSortOrder(sortCol);
        }
    }

    private Object[] getColumnData(Object[] files, int intKey, int type, ObjectDecoder objectDecoder) {
        Object[] columnData = new Object[files.length / 2];
        block8: for (int i2 = 0; i2 != files.length; i2 += 2) {
            PdfObject pObj = (PdfObject)files[i2 + 1];
            this.reader.checkResolved(pObj);
            PdfObject efObj = pObj.getDictionary(5398);
            this.reader.checkResolved(efObj);
            PdfObject fileObj = efObj.getDictionary(22);
            this.reader.checkResolved(fileObj);
            PdfObject paramsObj = fileObj.getDictionary(1110531444);
            this.reader.checkResolved(paramsObj);
            if (type != 30 && type != 35 && type != 20) {
                intKey = type;
            }
            switch (intKey) {
                case -1547905827: {
                    if (fileObj.stream == null) continue block8;
                    columnData[i2 / 2] = SwingPortfolioDetail.convertFileSizeToReadableSize(fileObj.stream.length);
                    continue block8;
                }
                case 339034931: {
                    String desc;
                    byte[] descBytes = pObj.getTextStreamValueAsByte(339034931);
                    if (descBytes == null || (desc = StringUtils.getTextString(descBytes, false)) == null) continue block8;
                    columnData[i2 / 2] = "<html>" + desc.replaceAll("\n", "<br>") + "</html>";
                    continue block8;
                }
                case 1806481572: {
                    String creationDate = paramsObj.getTextStreamValue(1806481572);
                    if (creationDate == null) continue block8;
                    columnData[i2 / 2] = "<html>" + SwingPortfolioDetail.convertDateStringToReadableDate(creationDate) + "</html>";
                    continue block8;
                }
                case 340689769: {
                    String modDate = paramsObj.getTextStreamValue(340689769);
                    if (modDate == null) continue block8;
                    columnData[i2 / 2] = "<html>" + SwingPortfolioDetail.convertDateStringToReadableDate(modDate) + "</html>";
                    continue block8;
                }
                case 590957109: {
                    int size = paramsObj.getInt(590957109);
                    columnData[i2 / 2] = SwingPortfolioDetail.convertFileSizeToReadableSize(size);
                    continue block8;
                }
                case 22: 
                case 879393130: {
                    SwingPortfolioDetail.getFilenameField(pObj, columnData, i2);
                    continue block8;
                }
                default: {
                    PdfObject ciObj = pObj.getDictionary(4889);
                    if (ciObj == null) continue block8;
                    this.reader.checkResolved(ciObj);
                    SwingPortfolioDetail.handleCollectionItem(ciObj, objectDecoder, intKey, type, columnData, i2);
                }
            }
        }
        return columnData;
    }

    private static void handleCollectionItem(PdfObject ciObj, ObjectDecoder objectDecoder, int intKey, int type, Object[] columnData, int column) {
        PdfKeyPairsIterator ciIterator = ciObj.getKeyPairsIterator();
        while (ciIterator.hasMorePairs()) {
            String colKey = ciIterator.getNextKeyAsString();
            byte[] colValue = ciIterator.getNextValueAsBytes();
            if (intKey == PdfDictionary.stringToInt(colKey)) {
                String strValue = StringUtils.getTextString(colValue, true);
                if (strValue == null) break;
                if (strValue.matches("[0-9]* [0-9]* R")) {
                    CollectionObject subItemObj = new CollectionObject(strValue);
                    subItemObj.setUnresolvedData(colValue, -2139781200);
                    objectDecoder.checkResolved(subItemObj);
                    strValue = subItemObj.getTextStreamValue(20);
                }
                switch (type) {
                    case 20: {
                        columnData[column / 2] = "<html>" + SwingPortfolioDetail.convertDateStringToReadableDate(strValue) + "</html>";
                        break;
                    }
                    case 30: 
                    case 35: {
                        columnData[column / 2] = "<html>" + strValue.replaceAll("\n", "<br>") + "</html>";
                    }
                }
                break;
            }
            ciIterator.nextPair();
        }
    }

    private static void getFilenameField(PdfObject pObj, Object[] columnData, int column) {
        int pathEnd;
        String filename;
        byte[] filenameBytes = pObj.getTextStreamValueAsByte(9494);
        if (filenameBytes == null) {
            filenameBytes = pObj.getTextStreamValueAsByte(22);
        }
        if ((filename = StringUtils.getTextString(filenameBytes, false)) != null && (pathEnd = filename.lastIndexOf(47)) != -1) {
            filename = filename.substring(pathEnd + 1);
        }
        if (filename != null) {
            columnData[column / 2] = "<html>" + filename.replaceAll("\n", "<br>") + "</html>";
        }
    }

    private void loadValuesIntoTable(ColumnData[] tableData, Object[] files) {
        int i2;
        for (int i3 = 0; i3 != tableData.length; ++i3) {
            if (tableData[i3] == null) continue;
            this.model.addColumn((Object)tableData[i3].getName(), tableData[i3].getColumnData());
        }
        Object[] fileObjects = new PdfObject[files.length / 2];
        for (int f2 = 0; f2 < files.length; f2 += 2) {
            fileObjects[f2 / 2] = (PdfObject)files[f2 + 1];
        }
        this.model.addColumn((Object)"FileObject", fileObjects);
        SwingPortfolioDetail.removeColumn("FileObject", this.table, this.columns);
        for (i2 = 0; i2 != this.table.getColumnModel().getColumnCount(); ++i2) {
            TableColumn column = this.table.getColumnModel().getColumn(i2);
            column.setMinWidth(120);
        }
        for (i2 = tableData.length - 1; i2 >= 0; --i2) {
            if (tableData[i2] == null || tableData[i2].isVisibility()) continue;
            SwingPortfolioDetail.removeColumn(tableData[i2].getName(), this.table, this.columns);
        }
        for (i2 = 0; i2 != tableData.length; ++i2) {
            if (tableData[i2] == null) continue;
            SwingCheckBoxMenuItem item = new SwingCheckBoxMenuItem(tableData[i2].getName());
            item.setSelected(tableData[i2].isVisibility());
            item.addActionListener(e2 -> {
                String name = ((AbstractButton)e2.getSource()).getText();
                if (((AbstractButton)e2.getSource()).isSelected()) {
                    SwingPortfolioDetail.addColumn(name, tableData, this.table, this.columns);
                } else {
                    SwingPortfolioDetail.removeColumn(name, this.table, this.columns);
                }
                this.table.setPreferredSize(this.table.getMinimumSize());
            });
            this.menu.add(item);
        }
        this.table.setPreferredSize(this.table.getMinimumSize());
    }

    private Object[] generateFileThumbnails(PdfObjectReader reader, Object[] files, DO imageDecoder) {
        Object[] thumbnails = new Object[files.length / 2];
        for (int i2 = 0; i2 != files.length; i2 += 2) {
            PdfObject pObj = (PdfObject)files[i2 + 1];
            reader.checkResolved(pObj);
            PdfObject efObj = pObj.getDictionary(5398);
            reader.checkResolved(efObj);
            PdfObject thumb = pObj.getDictionary(944061782);
            ImageIcon icon = SwingPortfolioUtils.createThumbnail(thumb, reader, imageDecoder, this.thumbnailSmallestSide, this.thumbnailSmallestSide);
            thumbnails[i2 / 2] = icon;
        }
        return thumbnails;
    }

    PdfObject getSelectedFile() {
        int row = this.table.getSelectedRow();
        if (row != -1) {
            return (PdfObject)this.model.getValueAt(this.table.convertRowIndexToModel(row), this.model.getColumnCount() - 1);
        }
        return null;
    }

    JTable getTable() {
        return this.table;
    }

    private static String convertDateStringToReadableDate(String dateString) {
        if (dateString != null) {
            StringBuilder date = new StringBuilder(dateString);
            date.delete(0, 2);
            date.insert(10, ':');
            date.insert(13, ':');
            date.insert(16, ' ');
            String year = date.substring(0, 4);
            String day = date.substring(6, 8);
            date.delete(6, 8);
            date.delete(0, 4);
            date.insert(0, day);
            date.insert(4, year);
            date.insert(2, '/');
            date.insert(5, '/');
            date.insert(10, ' ');
            return date.toString();
        }
        return "";
    }

    private static String convertFileSizeToReadableSize(long size) {
        if (size > 0L) {
            String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
            int digitGroups = (int)(Math.log10(size) / Math.log10(1000.0));
            return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1000.0, digitGroups)) + ' ' + units[digitGroups];
        }
        return "0 B";
    }

    private static void addColumn(String name, ColumnData[] allColumns, JTable table, HashMap<String, TableColumn> columns) {
        TableColumn removedColumn;
        if (name != null && (removedColumn = columns.get(name)) != null) {
            int idx = 1;
            for (ColumnData colName : allColumns) {
                if (colName.getName().equals(name)) break;
                ++idx;
            }
            table.getColumnModel().addColumn(removedColumn);
            table.moveColumn(table.getColumnCount() - 1, idx);
        }
    }

    private static void removeColumn(String name, JTable table, HashMap<String, TableColumn> columns) {
        if (name != null) {
            int idx = table.getColumnModel().getColumnIndex(name);
            TableColumn removedColumn = table.getColumnModel().getColumn(idx);
            table.getColumnModel().removeColumn(removedColumn);
            columns.put(String.valueOf(removedColumn.getHeaderValue()), removedColumn);
        }
    }

    private class ColumnData
    implements Comparator<ColumnData> {
        private final int key;
        private final int subType;
        private final int order;
        private final String name;
        private final boolean visibility;
        private final Object[] columnData;

        ColumnData(int key, int subType, int order, String name, boolean visibility, Object[] columnData) {
            this.key = key;
            this.subType = subType;
            this.order = order;
            this.name = name;
            this.visibility = visibility;
            this.columnData = columnData;
        }

        int getKey() {
            return this.key;
        }

        int getSubType() {
            return this.subType;
        }

        int getOrder() {
            return this.order;
        }

        String getName() {
            return this.name;
        }

        boolean isVisibility() {
            return this.visibility;
        }

        Object[] getColumnData() {
            return this.columnData;
        }

        @Override
        public int compare(ColumnData o1, ColumnData o2) {
            if (o1.order < o2.order) {
                return -1;
            }
            if (o1.order > o2.order) {
                return 1;
            }
            return 0;
        }
    }
}

