/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jpedal.examples.viewer.commands.OpenFile;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingPortfolioUtils;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.Messages;
import org.jpedal.utils.StringUtils;

public class SwingPortfolioContextMenu
extends JPopupMenu {
    private final SwingGUI currentGUI;
    private final JFileChooser chooser;
    private final JMenuItem openFile;
    private PdfObjectReader reader;
    private PdfObject fileObject;

    public SwingPortfolioContextMenu(SwingGUI gui) {
        this.currentGUI = gui;
        this.chooser = new JFileChooser();
        this.openFile = new JMenuItem(Messages.getMessage("PdfPortfolio.OpenInViewer"));
        this.openFile.addActionListener(e2 -> {
            int pathEnd;
            String filename;
            byte[] filenameBytes = this.fileObject.getTextStreamValueAsByte(9494);
            if (filenameBytes == null) {
                filenameBytes = this.fileObject.getTextStreamValueAsByte(22);
            }
            if ((filename = StringUtils.getTextString(filenameBytes, false)) != null && (pathEnd = filename.lastIndexOf(47)) != -1) {
                filename = filename.substring(pathEnd + 1);
            }
            SwingPortfolioUtils.openFile(this.currentGUI, this.reader, this.fileObject, filename);
        });
        JMenuItem extractFile = new JMenuItem(Messages.getMessage("PdfPortfolio.Extract"));
        extractFile.addActionListener(e2 -> {
            String filename;
            byte[] filenameBytes = this.fileObject.getTextStreamValueAsByte(9494);
            if (filenameBytes == null) {
                filenameBytes = this.fileObject.getTextStreamValueAsByte(22);
            }
            if ((filename = StringUtils.getTextString(filenameBytes, false)) != null) {
                int pathEnd = filename.lastIndexOf(47);
                if (pathEnd != -1) {
                    filename = filename.substring(pathEnd + 1);
                }
                String ext = filename.substring(filename.lastIndexOf(46) + 1);
                this.chooser.setSelectedFile(new File(filename));
                this.chooser.setFileFilter(new FileFilterer(new String[]{ext}, ext.toUpperCase() + " (*." + ext + ')'));
                int result = this.chooser.showSaveDialog(extractFile);
                switch (result) {
                    case 0: {
                        File outputFile = this.chooser.getSelectedFile();
                        if (SwingPortfolioUtils.saveFile(this.reader, this.fileObject, outputFile)) break;
                        gui.showMessageDialog(Messages.getMessage("PdfPortfolio.FailedSave") + ' ' + outputFile.getAbsolutePath());
                        break;
                    }
                }
            }
        });
        this.add(this.openFile);
        this.add(extractFile);
    }

    public void setUpObjects(PdfObjectReader objectReader, PdfObject fileObj) {
        this.reader = objectReader;
        this.fileObject = fileObj;
    }

    @Override
    public void show(Component invoker, int x2, int y2) {
        int pathEnd;
        String filename;
        byte[] filenameBytes = this.fileObject.getTextStreamValueAsByte(9494);
        if (filenameBytes == null) {
            filenameBytes = this.fileObject.getTextStreamValueAsByte(22);
        }
        if ((filename = StringUtils.getTextString(filenameBytes, false)) != null && (pathEnd = filename.lastIndexOf(47)) != -1) {
            filename = filename.substring(pathEnd + 1);
        }
        if (OpenFile.isSupportedFileExtension(filename)) {
            this.openFile.setText(Messages.getMessage("PdfPortfolio.OpenInViewer"));
        } else {
            this.openFile.setText(Messages.getMessage("PdfPortfolio.OpenInNative"));
        }
        super.show(invoker, x2, y2);
    }
}

