/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.ViewerCommands;
import org.jpedal.examples.viewer.gui.SwingGUI;

public class SwingPageChanger
implements ActionListener {
    private final SwingGUI gui;
    private final Values commonValues;
    private final int page;

    public SwingPageChanger(SwingGUI gui, Values values, int page) {
        this.gui = gui;
        this.commonValues = values;
        this.page = page + 1;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (!Values.isProcessing() && this.commonValues.getCurrentPage() != this.page) {
            if (!this.gui.getPdfDecoder().isPageAvailable(this.page)) {
                this.gui.showMessageDialog("Page " + this.page + " is not yet loaded");
                return;
            }
            this.gui.resetStatusMessage("");
            this.gui.getCommand().executeCommand(ViewerCommands.GOTO, new Object[]{Integer.toString(this.page)});
        }
    }
}

