/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jpedal.PdfDecoder;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.objects.PdfPageData;
import org.jpedal.parser.DecoderOptions;

public final class SwingMouseUtils {
    private SwingMouseUtils() {
    }

    public static int getPageAtCoords(int x2, int y2, int rotation, PdfDecoder decode_pdf) {
        switch (decode_pdf.getDisplayView()) {
            case 1: {
                return SwingMouseUtils.getPageAtPointSingleDisplay(x2, y2, rotation, decode_pdf);
            }
            case 2: {
                return SwingMouseUtils.getPageAtPointContinuousDisplay(x2, y2, rotation, decode_pdf);
            }
            case 3: {
                return SwingMouseUtils.getPageAtPointContinuousFacingDisplay(x2, y2, rotation, decode_pdf);
            }
            case 4: {
                return SwingMouseUtils.getPageAtPointFacingDisplay(x2, y2, rotation, decode_pdf);
            }
        }
        return -1;
    }

    private static int getPageAtPointSingleDisplay(int x2, int y2, int rotation, PdfDecoder decode_pdf) {
        int pageHeight;
        int pageWidth;
        int pageNumber = decode_pdf.getPageNumber();
        if (rotation % 180 == 90) {
            pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
            pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
        } else {
            pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
            pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
        }
        Rectangle pageArea = new Rectangle(decode_pdf.getWidth() / 2 - pageWidth / 2, decode_pdf.getInsetH(), pageWidth, pageHeight);
        if (pageArea.contains(x2, y2)) {
            return pageNumber;
        }
        return -1;
    }

    private static int getPageAtPointContinuousDisplay(int x2, int y2, int rotation, PdfDecoder decode_pdf) {
        block10: {
            Rectangle pageArea;
            int pageHeight;
            int pageWidth;
            int pageNumber;
            Display pages;
            block9: {
                pages = decode_pdf.getPages();
                pageNumber = decode_pdf.getPageNumber();
                if (rotation % 180 == 90) {
                    pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
                    pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
                } else {
                    pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
                    pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
                }
                pageArea = new Rectangle(decode_pdf.getWidth() / 2 - pageWidth / 2, pages.getYCordForPage(pageNumber), pageWidth, pageHeight);
                if (pageArea.contains(x2, y2)) {
                    return pageNumber;
                }
                if (y2 >= pageArea.y || pageNumber <= 1) break block9;
                while (pageNumber > 1) {
                    --pageNumber;
                    if (rotation % 180 == 90) {
                        pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
                        pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
                    } else {
                        pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
                        pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
                    }
                    if (!(pageArea = new Rectangle(decode_pdf.getWidth() / 2 - pageWidth / 2, pages.getYCordForPage(pageNumber), pageWidth, pageHeight)).contains(x2, y2)) continue;
                    return pageNumber;
                }
                break block10;
            }
            if (!((double)y2 > pageArea.getMaxY()) || pageNumber >= decode_pdf.getPageCount()) break block10;
            while (pageNumber < decode_pdf.getPageCount()) {
                ++pageNumber;
                if (rotation % 180 == 90) {
                    pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
                    pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
                } else {
                    pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
                    pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
                }
                if (!(pageArea = new Rectangle(decode_pdf.getWidth() / 2 - pageWidth / 2, pages.getYCordForPage(pageNumber), pageWidth, pageHeight)).contains(x2, y2)) continue;
                return pageNumber;
            }
        }
        return -1;
    }

    private static int getPageAtPointContinuousFacingDisplay(int x2, int y2, int rotation, PdfDecoder decode_pdf) {
        int pageHeight;
        int pageWidth;
        int pageNumber = decode_pdf.getPageNumber();
        Display pages = decode_pdf.getPages();
        boolean separateCover = pages.getBoolean(Display.BoolValue.SEPARATE_COVER);
        if (separateCover) {
            if (x2 > decode_pdf.getWidth() / 2 && pageNumber % 2 == 0 && pageNumber < decode_pdf.getPageCount()) {
                ++pageNumber;
            }
            if (x2 < decode_pdf.getWidth() / 2 && pageNumber % 2 == 1 && pageNumber > 1) {
                --pageNumber;
            }
        } else {
            if (x2 > decode_pdf.getWidth() / 2 && pageNumber % 2 == 1 && pageNumber < decode_pdf.getPageCount()) {
                ++pageNumber;
            }
            if (x2 < decode_pdf.getWidth() / 2 && pageNumber % 2 == 0 && pageNumber > 1) {
                --pageNumber;
            }
        }
        if (rotation % 180 == 90) {
            pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
            pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
        } else {
            pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
            pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
        }
        return SwingMouseUtils.getPageNumberUnderPoint(x2, y2, rotation, decode_pdf, pages, pageNumber, pageWidth, pageHeight);
    }

    private static int getPageNumberUnderPoint(int x2, int y2, int rotation, PdfDecoder decode_pdf, Display pages, int pageNumber, int pageWidth, int pageHeight) {
        block8: {
            Rectangle pageArea;
            int xAdjustment;
            block7: {
                xAdjustment = SwingMouseUtils.getXAdjustmentForContinuousFacing(decode_pdf, pageNumber, pageWidth);
                pageArea = new Rectangle(xAdjustment, pages.getYCordForPage(pageNumber), pageWidth, pageHeight);
                if (pageArea.contains(x2, y2)) {
                    return pageNumber;
                }
                if (y2 >= pageArea.y || pageNumber <= 1) break block7;
                while (pageNumber > 1) {
                    --pageNumber;
                    if (rotation % 180 == 90) {
                        pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
                        pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
                    } else {
                        pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
                        pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
                    }
                    if (!(pageArea = new Rectangle(xAdjustment = SwingMouseUtils.getXAdjustmentForContinuousFacing(decode_pdf, pageNumber, pageWidth), pages.getYCordForPage(pageNumber), pageWidth, pageHeight)).contains(x2, y2)) continue;
                    return pageNumber;
                }
                break block8;
            }
            if (!((double)y2 > pageArea.getMaxY()) || pageNumber >= decode_pdf.getPageCount()) break block8;
            while (pageNumber < decode_pdf.getPageCount()) {
                ++pageNumber;
                if (rotation % 180 == 90) {
                    pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
                    pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
                } else {
                    pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
                    pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
                }
                if (!(pageArea = new Rectangle(xAdjustment = SwingMouseUtils.getXAdjustmentForContinuousFacing(decode_pdf, pageNumber, pageWidth), pages.getYCordForPage(pageNumber), pageWidth, pageHeight)).contains(x2, y2)) continue;
                return pageNumber;
            }
        }
        return -1;
    }

    private static int getXAdjustmentForContinuousFacing(PdfDecoder decode_pdf, int pageNumber, int pageWidth) {
        int xAdjustment = decode_pdf.getWidth() / 2;
        if (decode_pdf.getPageCount() == 2) {
            xAdjustment = pageNumber == 1 ? (xAdjustment -= pageWidth + 5) : (xAdjustment += 5);
        } else {
            boolean isLeftPage;
            if (decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER)) {
                isLeftPage = pageNumber % 2 == 0;
            } else {
                boolean bl2 = isLeftPage = pageNumber % 2 == 1;
            }
            xAdjustment = isLeftPage ? (xAdjustment -= pageWidth + 5) : (xAdjustment += 5);
        }
        if (xAdjustment < 0) {
            xAdjustment = 0;
        }
        return xAdjustment;
    }

    private static int getPageAtPointFacingDisplay(int x2, int y2, int rotation, PdfDecoder decode_pdf) {
        int pageNumber = decode_pdf.getPageNumber();
        if (decode_pdf.getPageCount() == 2) {
            int pageHeight;
            int pageWidth;
            if (rotation % 180 == 90) {
                pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxHeight(1);
                pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxWidth(1);
            } else {
                pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxWidth(1);
                pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxHeight(1);
            }
            Rectangle pageArea = new Rectangle(decode_pdf.getWidth() / 2, decode_pdf.getInsetH(), pageWidth, pageHeight);
            if (pageArea.contains(x2, y2)) {
                return 1;
            }
            if (rotation % 180 == 90) {
                pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxHeight(2);
                pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxWidth(2);
            } else {
                pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxWidth(2);
                pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxHeight(2);
            }
            pageArea = new Rectangle(decode_pdf.getWidth() / 2, decode_pdf.getInsetH(), pageWidth, pageHeight);
            if (pageArea.contains(x2, y2)) {
                return 2;
            }
        } else {
            Rectangle pageArea;
            int pageHeight;
            int pageWidth;
            if (pageNumber % 2 == 0) {
                if (rotation % 180 == 90) {
                    pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
                    pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
                } else {
                    pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
                    pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
                }
                pageArea = new Rectangle(decode_pdf.getWidth() / 2 - pageWidth, decode_pdf.getInsetH(), pageWidth, pageHeight);
                if (pageArea.contains(x2, y2)) {
                    return pageNumber;
                }
            }
            if (pageNumber != 1 && pageNumber < decode_pdf.getPageCount()) {
                ++pageNumber;
            }
            if (rotation % 180 == 90) {
                pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
                pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
            } else {
                pageWidth = decode_pdf.getPdfPageData().getScaledCropBoxWidth(pageNumber);
                pageHeight = decode_pdf.getPdfPageData().getScaledCropBoxHeight(pageNumber);
            }
            pageArea = new Rectangle(decode_pdf.getWidth() / 2, decode_pdf.getInsetH(), pageWidth, pageHeight);
            if (pageArea.contains(x2, y2)) {
                return pageNumber;
            }
        }
        return -1;
    }

    public static Point getCoordsOnPage(int x2, int y2, int page, PdfDecoderInt decode_pdf, SwingGUI currentGUI, Values commonValues) {
        switch (decode_pdf.getDisplayView()) {
            case 1: {
                return SwingMouseUtils.getPageCoordsInSingleDisplayMode(x2, y2, decode_pdf, currentGUI, commonValues);
            }
            case 2: {
                return SwingMouseUtils.getPageCoordsInContinuousDisplayMode(x2, y2, page, decode_pdf, currentGUI, commonValues);
            }
            case 4: {
                return SwingMouseUtils.getPageCoordsInFacingDisplayMode(x2, y2, page, decode_pdf, currentGUI, commonValues);
            }
            case 3: {
                return SwingMouseUtils.getPageCoordsInContinuousFacingDisplayMode(x2, y2, page, decode_pdf, currentGUI, commonValues);
            }
        }
        return new Point(-1, -1);
    }

    private static Point getPageCoordsInSingleDisplayMode(int x2, int y2, PdfDecoderInt decode_pdf, SwingGUI currentGUI, Values commonValues) {
        float scaling = currentGUI.getScaling();
        int inset = SwingGUI.getPDFDisplayInset();
        int rotation = currentGUI.getRotation();
        int ex = SwingMouseUtils.adjustForAlignment(x2, decode_pdf) - inset;
        int ey = y2 - inset;
        PdfPageData page_data = decode_pdf.getPdfPageData();
        int mediaH = page_data.getMediaBoxHeight(commonValues.getCurrentPage());
        if (commonValues.maxViewY != 0) {
            ex = (int)((double)((float)ex - (float)commonValues.dx * scaling) / commonValues.viewportScale);
            ey = (int)(((double)mediaH - (double)((float)mediaH - (float)ey / scaling - (float)commonValues.dy) / commonValues.viewportScale) * (double)scaling);
        }
        x2 = (int)((float)ex / scaling);
        y2 = (int)((float)ey / scaling);
        int cropX = page_data.getCropBoxX(commonValues.getCurrentPage());
        int cropY = page_data.getCropBoxY(commonValues.getCurrentPage());
        int cropW = page_data.getCropBoxWidth(commonValues.getCurrentPage());
        int cropH = page_data.getCropBoxHeight(commonValues.getCurrentPage());
        switch (rotation) {
            case 90: {
                int tmp = x2 + cropY;
                x2 = y2 + cropX;
                y2 = tmp;
                break;
            }
            case 180: {
                x2 = cropW + cropX - x2;
                y2 += cropY;
                break;
            }
            case 270: {
                int tmp = cropH + cropY - x2;
                x2 = cropW + cropX - y2;
                y2 = tmp;
                break;
            }
            default: {
                x2 += cropX;
                y2 = decode_pdf.getDisplayView() == 1 ? cropH + cropY - y2 : cropY + y2;
            }
        }
        return new Point(x2, y2);
    }

    private static Point getPageCoordsInContinuousDisplayMode(int x2, int y2, int page, PdfDecoderInt decode_pdf, SwingGUI currentGUI, Values commonValues) {
        PdfPageData page_data = decode_pdf.getPdfPageData();
        float scaling = currentGUI.getScaling();
        int inset = SwingGUI.getPDFDisplayInset();
        int rotation = currentGUI.getRotation();
        y2 = rotation % 180 == 90 ? decode_pdf.getPages().getYCordForPage(page) + page_data.getScaledCropBoxWidth(page) + decode_pdf.getInsetH() - y2 : decode_pdf.getPages().getYCordForPage(page) + page_data.getScaledCropBoxHeight(page) + decode_pdf.getInsetH() - y2;
        int ex = SwingMouseUtils.adjustForAlignment(x2, decode_pdf) - inset;
        int ey = y2 - inset;
        int mediaH = page_data.getMediaBoxHeight(commonValues.getCurrentPage());
        if (commonValues.maxViewY != 0) {
            ex = (int)((double)((float)ex - (float)commonValues.dx * scaling) / commonValues.viewportScale);
            ey = (int)(((double)mediaH - (double)((float)mediaH - (float)ey / scaling - (float)commonValues.dy) / commonValues.viewportScale) * (double)scaling);
        }
        x2 = (int)((float)ex / scaling);
        y2 = (int)((float)ey / scaling);
        int cropX = page_data.getCropBoxX(commonValues.getCurrentPage());
        int cropY = page_data.getCropBoxY(commonValues.getCurrentPage());
        int cropW = page_data.getCropBoxWidth(commonValues.getCurrentPage());
        int cropH = page_data.getCropBoxHeight(commonValues.getCurrentPage());
        switch (rotation) {
            case 90: {
                int tmp = x2 + cropY;
                x2 = cropX + (cropW - y2);
                y2 = tmp;
                break;
            }
            case 180: {
                x2 = cropW + cropX - x2;
                y2 = cropY + cropH - y2;
                break;
            }
            case 270: {
                int tmp = cropH + cropY - x2;
                x2 = cropX + y2;
                y2 = tmp;
                break;
            }
            default: {
                x2 += cropX;
                y2 = decode_pdf.getDisplayView() == 1 ? cropH + cropY - y2 : cropY + y2;
            }
        }
        return new Point(x2, y2);
    }

    private static Point getPageCoordsInContinuousFacingDisplayMode(int x2, int y2, int page, PdfDecoderInt decode_pdf, SwingGUI currentGUI, Values commonValues) {
        PdfPageData page_data = decode_pdf.getPdfPageData();
        float scaling = currentGUI.getScaling();
        int inset = SwingGUI.getPDFDisplayInset();
        int rotation = currentGUI.getRotation();
        y2 = rotation % 180 == 90 ? decode_pdf.getPages().getYCordForPage(page) + page_data.getScaledCropBoxWidth(page) + decode_pdf.getInsetH() - y2 : decode_pdf.getPages().getYCordForPage(page) + page_data.getScaledCropBoxHeight(page) + decode_pdf.getInsetH() - y2;
        int ex = SwingMouseUtils.adjustForAlignment(x2 -= decode_pdf.getPages().getXCordForPage(page) - decode_pdf.getInsetW(), decode_pdf) - inset;
        int ey = y2 - inset;
        int cropW = page_data.getCropBoxWidth(commonValues.getCurrentPage());
        int cropH = page_data.getCropBoxHeight(commonValues.getCurrentPage());
        if (commonValues.maxViewY != 0) {
            ex = (int)((double)((float)ex - (float)commonValues.dx * scaling) / commonValues.viewportScale);
            ey = (int)(((double)cropH - (double)((float)cropH - (float)ey / scaling - (float)commonValues.dy) / commonValues.viewportScale) * (double)scaling);
        }
        x2 = (int)((float)ex / scaling);
        y2 = (int)((float)ey / scaling);
        int cropX = page_data.getCropBoxX(commonValues.getCurrentPage());
        int cropY = page_data.getCropBoxY(commonValues.getCurrentPage());
        switch (rotation) {
            case 90: {
                int tmp = x2 + cropY;
                x2 = cropX + (cropW - y2);
                y2 = tmp;
                break;
            }
            case 180: {
                x2 = cropW + cropX - x2;
                y2 = cropY + cropH - y2;
                break;
            }
            case 270: {
                int tmp = cropH + cropY - x2;
                x2 = cropX + y2;
                y2 = tmp;
                break;
            }
            default: {
                x2 += cropX;
                y2 = decode_pdf.getDisplayView() == 1 ? cropH + cropY - y2 : cropY + y2;
            }
        }
        return new Point(x2, y2);
    }

    private static Point getPageCoordsInFacingDisplayMode(int x2, int y2, int page, PdfDecoderInt decode_pdf, SwingGUI currentGUI, Values commonValues) {
        PdfPageData page_data = decode_pdf.getPdfPageData();
        float scaling = currentGUI.getScaling();
        int inset = SwingGUI.getPDFDisplayInset();
        int rotation = currentGUI.getRotation();
        int ex = SwingMouseUtils.adjustForAlignment(x2, decode_pdf) - inset;
        int ey = y2 - inset;
        int mediaH = page_data.getMediaBoxHeight(commonValues.getCurrentPage());
        if (commonValues.maxViewY != 0) {
            ex = (int)((double)((float)ex - (float)commonValues.dx * scaling) / commonValues.viewportScale);
            ey = (int)(((double)mediaH - (double)((float)mediaH - (float)ey / scaling - (float)commonValues.dy) / commonValues.viewportScale) * (double)scaling);
        }
        x2 = (int)((float)ex / scaling);
        y2 = (int)((float)ey / scaling);
        int cropX = page_data.getCropBoxX(commonValues.getCurrentPage());
        int cropY = page_data.getCropBoxY(commonValues.getCurrentPage());
        int cropW = page_data.getCropBoxWidth(commonValues.getCurrentPage());
        int cropH = page_data.getCropBoxHeight(commonValues.getCurrentPage());
        switch (rotation) {
            case 90: {
                int tmp = x2 + cropY;
                x2 = y2 + cropX;
                y2 = tmp;
                break;
            }
            case 180: {
                x2 = cropW + cropX - x2;
                y2 += cropY;
                break;
            }
            case 270: {
                int tmp = cropH + cropY - x2;
                x2 = cropW + cropX - y2;
                y2 = tmp;
                break;
            }
            default: {
                x2 += cropX;
                y2 = cropH + cropY - y2;
            }
        }
        if (decode_pdf.getPageCount() == 2 && page == 2 || page % 2 == 1) {
            x2 -= cropW;
        }
        return new Point(x2, y2);
    }

    private static int adjustForAlignment(int cx, PdfDecoderInt decode_pdf) {
        if (decode_pdf.getPageAlignment() == 2) {
            int width = decode_pdf.getPaneBounds()[0];
            int pdfWidth = decode_pdf.getPDFWidth();
            if (decode_pdf.getDisplayView() != 1) {
                pdfWidth = decode_pdf.getMaxSizeWH()[0];
            }
            if (width > pdfWidth) {
                cx -= (width - pdfWidth) / 2;
            }
        }
        return cx;
    }

    public static Point getGlassPaneCoordsInSingleDisplayMode(int x2, int y2, PdfDecoder decode_pdf, SwingGUI currentGUI, Values commonValues) {
        float scaling = currentGUI.getScaling();
        int inset = SwingGUI.getPDFDisplayInset();
        int rotation = currentGUI.getRotation();
        PdfPageData page_data = decode_pdf.getPdfPageData();
        int mediaH = page_data.getMediaBoxHeight(commonValues.getCurrentPage());
        int cropX = page_data.getCropBoxX(commonValues.getCurrentPage());
        int cropY = page_data.getCropBoxY(commonValues.getCurrentPage());
        int cropW = page_data.getCropBoxWidth(commonValues.getCurrentPage());
        int cropH = page_data.getCropBoxHeight(commonValues.getCurrentPage());
        switch (rotation) {
            case 90: {
                int tmp = x2 - cropX;
                x2 = y2 - cropY;
                y2 = tmp;
                break;
            }
            case 180: {
                x2 = cropW + cropX - x2;
                y2 -= cropY;
                break;
            }
            case 270: {
                int tmp = cropW + cropX - x2;
                x2 = cropH + cropY - y2;
                y2 = tmp;
                break;
            }
            default: {
                x2 -= cropX;
                y2 = decode_pdf.getDisplayView() == 1 ? cropH + cropY - y2 : cropY + y2;
            }
        }
        x2 = (int)((float)x2 * scaling);
        y2 = (int)((float)y2 * scaling);
        if (commonValues.maxViewY != 0) {
            x2 = (int)((double)((float)x2 + (float)commonValues.dx / scaling) * commonValues.viewportScale);
            y2 = (int)(((double)mediaH + (double)((float)mediaH + (float)y2 * scaling + (float)commonValues.dy) * commonValues.viewportScale) / (double)scaling);
        }
        if (decode_pdf.getPageAlignment() == 2) {
            int width = decode_pdf.getPaneBounds()[0];
            int pdfWidth = decode_pdf.getPDFWidth();
            if (decode_pdf.getDisplayView() != 1) {
                pdfWidth = decode_pdf.getMaxSizeWH()[0];
            }
            if (width > pdfWidth) {
                x2 += (width - pdfWidth) / 2;
            }
        }
        return new Point(x2 += inset, y2 += inset);
    }

    public static int getMouseButton(MouseEvent me) {
        if (DecoderOptions.isRunningOnMac && me.getButton() == 1 && me.isControlDown()) {
            return 3;
        }
        int button = me.getButton();
        if (button == 0) {
            if ((me.getModifiersEx() & 0x400) != 0) {
                button = 1;
            } else if ((me.getModifiersEx() & 0x800) != 0) {
                button = 2;
            } else if ((me.getModifiersEx() & 0x1000) != 0) {
                button = 3;
            }
        }
        return button;
    }
}

