/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.time.Instant;
import javax.swing.RepaintManager;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.ViewerCommands;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingMouseContextMenu;
import org.jpedal.examples.viewer.gui.swing.SwingMouseFunctionality;
import org.jpedal.examples.viewer.gui.swing.SwingMouseUtils;
import org.jpedal.objects.PdfPageData;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.GUIDisplay;
import org.jpedal.render.SwingDisplay;
import org.jpedal.text.TextLines;
import org.jpedal.utils.LogWriter;

public class SwingMouseSelector
implements SwingMouseFunctionality {
    private final PdfDecoder decode_pdf;
    private final SwingGUI currentGUI;
    private final Values commonValues;
    private final Commands currentCommands;
    private PdfPageData page_data;
    private int clickCount;
    private long lastTime = -1L;
    private int pageMouseIsOver = -1;
    private int pageOfHighlight = -1;
    private boolean startHighlighting;
    private int lastId = -1;
    private int old_m_x2 = -1;
    private int old_m_y2 = -1;
    private boolean altIsDown;
    private SwingMouseContextMenu rightClick;
    private boolean menuCreated;

    public SwingMouseSelector(PdfDecoder decode_pdf, SwingGUI currentGUI, Values commonValues, Commands currentCommands) {
        this.decode_pdf = decode_pdf;
        this.currentGUI = currentGUI;
        this.commonValues = commonValues;
        this.currentCommands = currentCommands;
        this.page_data = decode_pdf.getPdfPageData();
    }

    public void dispose() {
        this.page_data = null;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.decode_pdf.getDisplayView() == 1 && SwingMouseSelector.isOtherKey(event)) {
            long currentTime = Instant.now().toEpochMilli();
            if (this.lastTime + 500L < currentTime) {
                this.clickCount = 0;
            }
            this.lastTime = currentTime;
            if (this.clickCount != 4) {
                ++this.clickCount;
            }
            this.decode_pdf.updateCursorBoxOnScreen(null, 0);
            this.decode_pdf.getPages().setHighlightedImage(null);
            this.decode_pdf.getTextLines().clearHighlights();
            int page = this.commonValues.getCurrentPage();
            Point mousePoint = this.getCoordsOnPage(event.getX(), event.getY(), page);
            int mouseX = (int)mousePoint.getX();
            int mouseY = (int)mousePoint.getY();
            String foundUrl = "true".equalsIgnoreCase(this.currentGUI.getProperties().getValue("treatURLTextAsLinks")) ? this.decode_pdf.getTextLines().getLinkAtPageLocation(page, mouseX, mouseY) : null;
            if (foundUrl != null) {
                boolean hasValidProtocol = false;
                for (int i2 = 0; i2 < foundUrl.length() && foundUrl.charAt(i2) != '/'; ++i2) {
                    char c2 = foundUrl.charAt(i2);
                    if (c2 != ':') continue;
                    String s2 = foundUrl.substring(0, i2).toLowerCase();
                    if (!SwingMouseSelector.isValidProtocol(s2)) break;
                    hasValidProtocol = true;
                    break;
                }
                if (!hasValidProtocol) {
                    foundUrl = "https://" + foundUrl;
                }
                try {
                    URL url = new URL(foundUrl);
                    Desktop.getDesktop().browse(url.toURI());
                }
                catch (Exception e1) {
                    LogWriter.writeLog("Exception attempting to open link: " + e1);
                }
            } else {
                SwingDisplay swingRenderer = (SwingDisplay)this.decode_pdf.getDynamicRenderer();
                int id2 = swingRenderer.isInsideImage(mouseX, mouseY);
                this.lastId = SwingMouseSelector.highlightImage(swingRenderer, this.decode_pdf, this.lastId, id2);
                if (id2 == -1 && this.clickCount > 1) {
                    SwingMouseSelector.handleMultiClickEvent(this.decode_pdf, this.currentCommands, mousePoint, this.clickCount, this.pageMouseIsOver);
                }
            }
        }
    }

    private static boolean isValidProtocol(String protocol) {
        int len = protocol.length();
        if (len < 1) {
            return false;
        }
        char c2 = protocol.charAt(0);
        if (!Character.isLetter(c2)) {
            return false;
        }
        for (int i2 = 1; i2 < len; ++i2) {
            c2 = protocol.charAt(i2);
            if (Character.isLetterOrDigit(c2) || c2 == '.' || c2 == '+' || c2 == '-') continue;
            return false;
        }
        return true;
    }

    private static void handleMultiClickEvent(PdfDecoder decode_pdf, Commands currentCommands, Point mousePoint, int clickCount, int pageMouseIsOver) {
        int mouseX = (int)mousePoint.getX();
        int mouseY = (int)mousePoint.getY();
        switch (clickCount) {
            case 2: {
                int[][] lineAreas = decode_pdf.getTextLines().getLineAreasAs2DArray(pageMouseIsOver);
                if (lineAreas == null) break;
                int[] point = new int[]{mouseX, mouseY, 1, 1};
                for (int i2 = 0; i2 != lineAreas.length; ++i2) {
                    if (!TextLines.intersects(point, lineAreas[i2])) continue;
                    decode_pdf.updateCursorBoxOnScreen(lineAreas[i2], DecoderOptions.highlightColor.getRGB());
                    decode_pdf.getTextLines().addHighlights(new int[][]{lineAreas[i2]}, false, pageMouseIsOver);
                }
                break;
            }
            case 3: {
                int[] para = decode_pdf.getTextLines().setFoundParagraphAsArray(mouseX, mouseY, pageMouseIsOver);
                if (para == null) break;
                decode_pdf.updateCursorBoxOnScreen(para, DecoderOptions.highlightColor.getRGB());
                break;
            }
            case 4: {
                currentCommands.executeCommand(ViewerCommands.SELECTALL, null);
            }
        }
    }

    private static int highlightImage(SwingDisplay swingRenderer, PdfDecoder decode_pdf, int lastId, int id2) {
        if (lastId != id2 && id2 != -1) {
            int[] rectParams = swingRenderer.getAreaAsArray(id2);
            if (rectParams != null) {
                int h2 = rectParams[3];
                int w2 = rectParams[2];
                int x2 = rectParams[0];
                int y2 = rectParams[1];
                swingRenderer.setneedsHorizontalInvert(false);
                swingRenderer.setneedsVerticalInvert(false);
                if (w2 < 0) {
                    swingRenderer.setneedsHorizontalInvert(true);
                    w2 = -w2;
                    x2 -= w2;
                }
                if (h2 < 0) {
                    swingRenderer.setneedsVerticalInvert(true);
                    h2 = -h2;
                    y2 -= h2;
                }
                decode_pdf.getPages().setHighlightedImage(new int[]{x2, y2, w2, h2});
                decode_pdf.repaint(x2, y2, w2, h2);
            }
        } else {
            decode_pdf.getPages().setHighlightedImage(null);
            decode_pdf.repaint();
            id2 = -1;
        }
        return id2;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if ((this.decode_pdf.getDisplayView() == 1 || this.decode_pdf.getDisplayView() == 2 && this.decode_pdf.getDisplayView() == 3) && SwingMouseSelector.isOtherKey(event)) {
            int[][] rectParams = this.decode_pdf.getTextLines().getHighlightedAreasAs2DArray(this.commonValues.getCurrentPage());
            this.decode_pdf.updateCursorBoxOnScreen(null, 0);
            this.decode_pdf.getPages().setHighlightedImage(null);
            this.decode_pdf.getTextLines().clearHighlights();
            this.decode_pdf.grabFocus();
            Point values = this.getCoordsOnPage(event.getX(), event.getY(), this.commonValues.getCurrentPage());
            this.commonValues.m_x1 = (int)values.getX();
            this.commonValues.m_y1 = (int)values.getY();
            if (rectParams != null && rectParams.length > 0) {
                this.decode_pdf.getPages().refreshDisplay();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.decode_pdf.getDisplayView() == 1 || this.decode_pdf.getDisplayView() == 2 && this.decode_pdf.getDisplayView() == 3) {
            if (SwingMouseSelector.isOtherKey(event)) {
                this.mouseReleasedPrimaryButton();
            } else if (SwingMouseUtils.getMouseButton(event) == 3 && "true".equalsIgnoreCase(this.currentGUI.getProperties().getValue("allowRightClick"))) {
                this.mouseReleasedSecondaryButton(event.getX(), event.getY());
            }
        }
    }

    private void mouseReleasedSecondaryButton(int x2, int y2) {
        if (!this.menuCreated) {
            this.createRightClickMenu();
        }
        this.rightClick.enableImageOptions(this.decode_pdf.getPages().getHighlightedImage() != null);
        this.rightClick.enableTextOptions(this.decode_pdf.getTextLines().getHighlightedAreasAs2DArray(this.commonValues.getCurrentPage()) != null);
        if (this.decode_pdf.isOpen()) {
            this.rightClick.show(x2, y2);
        }
    }

    private void mouseReleasedPrimaryButton() {
        if (this.startHighlighting) {
            this.startHighlighting = false;
        }
        this.page_data = this.decode_pdf.getPdfPageData();
        int cropX = this.page_data.getCropBoxX(this.commonValues.getCurrentPage());
        int cropY = this.page_data.getCropBoxY(this.commonValues.getCurrentPage());
        int mediaH = this.page_data.getMediaBoxHeight(this.commonValues.getCurrentPage());
        this.repaintArea(new Rectangle(this.commonValues.m_x1 - cropX, this.commonValues.m_y2 + cropY, this.commonValues.m_x2 - this.commonValues.m_x1 + cropX, this.commonValues.m_y1 - this.commonValues.m_y2 + cropY), mediaH);
        this.decode_pdf.repaint();
        if (this.currentCommands.extractingAsImage) {
            this.decode_pdf.updateCursorBoxOnScreen(null, 0);
            this.decode_pdf.getTextLines().clearHighlights();
            this.decode_pdf.getPages().setHighlightedImage(null);
            this.decode_pdf.setCursor(Cursor.getPredefinedCursor(0));
            this.currentCommands.executeCommand(ViewerCommands.EXTRACTASIMAGE, null);
            this.currentCommands.extractingAsImage = false;
            DecoderOptions.showMouseBox = false;
        }
        this.pageOfHighlight = -1;
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (SwingMouseSelector.isOtherKey(event)) {
            this.altIsDown = event.isAltDown();
            if (!this.startHighlighting) {
                this.startHighlighting = true;
            }
            Point values = this.getCoordsOnPage(event.getX(), event.getY(), this.commonValues.getCurrentPage());
            if (this.pageMouseIsOver == this.pageOfHighlight) {
                this.commonValues.m_x2 = (int)values.getX();
                this.commonValues.m_y2 = (int)values.getY();
            }
            if (this.commonValues.isPDF()) {
                this.generateNewCursorBox();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.clickCount = 0;
    }

    private void createRightClickMenu() {
        this.rightClick = new SwingMouseContextMenu(this.currentGUI);
        this.decode_pdf.add(this.rightClick.getContextMenu());
        this.menuCreated = true;
    }

    private void generateNewCursorBox() {
        if (this.old_m_x2 != -1 || this.old_m_y2 != -1 || Math.abs(this.commonValues.m_x2 - this.old_m_x2) > 5 || Math.abs(this.commonValues.m_y2 - this.old_m_y2) > 5) {
            int top_x = this.commonValues.m_x1;
            if (this.commonValues.m_x1 > this.commonValues.m_x2) {
                top_x = this.commonValues.m_x2;
            }
            int top_y = this.commonValues.m_y1;
            if (this.commonValues.m_y1 > this.commonValues.m_y2) {
                top_y = this.commonValues.m_y2;
            }
            int w2 = Math.abs(this.commonValues.m_x2 - this.commonValues.m_x1);
            int h2 = Math.abs(this.commonValues.m_y2 - this.commonValues.m_y1);
            int[] currentRectangle = new int[]{top_x, top_y, w2, h2};
            this.decode_pdf.updateCursorBoxOnScreen(currentRectangle, DecoderOptions.highlightColor.getRGB());
            if (!this.currentCommands.extractingAsImage) {
                SwingMouseSelector.setTextHighlight(this.decode_pdf, this.commonValues, this.altIsDown, this.pageOfHighlight, currentRectangle);
            }
            this.old_m_x2 = this.commonValues.m_x2;
            this.old_m_y2 = this.commonValues.m_y2;
        }
        this.decode_pdf.getPages().refreshDisplay();
        this.decode_pdf.repaint();
    }

    private static void setTextHighlight(PdfDecoder decode_pdf, Values commonValues, boolean altIsDown, int page, int[] currentRectangle) {
        int type = ((GUIDisplay)decode_pdf.getDynamicRenderer()).getObjectUnderneath(commonValues.m_x1, commonValues.m_y1);
        if (altIsDown && type != 1 && type != 4 && type != 5 && type != 6) {
            decode_pdf.getTextLines().clearHighlights();
            decode_pdf.getTextLines().addHighlights(new int[][]{currentRectangle}, true, page);
        } else {
            int[] r2 = new int[]{commonValues.m_x1, commonValues.m_y1, commonValues.m_x2 - commonValues.m_x1, commonValues.m_y2 - commonValues.m_y1};
            decode_pdf.getTextLines().addHighlights(new int[][]{r2}, false, page);
        }
    }

    private Point getPageCoords(int x2, int y2, int page) {
        int[] flag = new int[2];
        flag[0] = 1;
        int pageUnderMouse = SwingMouseUtils.getPageAtCoords(x2, y2, this.currentGUI.getRotation(), this.decode_pdf);
        if (pageUnderMouse == -1) {
            pageUnderMouse = page;
            this.currentGUI.setMultibox(flag);
        } else {
            flag[1] = 1;
            this.currentGUI.setMultibox(flag);
            if (this.pageOfHighlight == -1 && this.startHighlighting) {
                this.pageOfHighlight = pageUnderMouse;
            }
            this.pageMouseIsOver = pageUnderMouse;
        }
        return SwingMouseUtils.getCoordsOnPage(x2, y2, pageUnderMouse, this.decode_pdf, this.currentGUI, this.commonValues);
    }

    private Point getPageCoordsInFacingDisplayMode(int x2, int y2) {
        Point pageCoordinates;
        int[] flag = new int[2];
        flag[0] = 1;
        int page = SwingMouseUtils.getPageAtCoords(x2, y2, this.currentGUI.getRotation(), this.decode_pdf);
        if (page == -1) {
            this.currentGUI.setMultibox(flag);
            pageCoordinates = new Point(-1, -1);
        } else {
            flag[1] = 1;
            this.currentGUI.setMultibox(flag);
            pageCoordinates = SwingMouseUtils.getCoordsOnPage(x2, y2, page, this.decode_pdf, this.currentGUI, this.commonValues);
        }
        return pageCoordinates;
    }

    public Point getCoordsOnPage(int x2, int y2, int page) {
        switch (this.decode_pdf.getDisplayView()) {
            case 1: 
            case 2: 
            case 3: {
                Point pagePosition = this.getPageCoords(x2, y2, page);
                x2 = pagePosition.x;
                y2 = pagePosition.y;
                break;
            }
            case 4: {
                Point pagePosition = this.getPageCoordsInFacingDisplayMode(x2, y2);
                x2 = pagePosition.x;
                y2 = pagePosition.y;
                break;
            }
        }
        return new Point(x2, y2);
    }

    private void repaintArea(Rectangle screenBox, int maxY) {
        int strip = 10;
        float scaling = this.decode_pdf.getScaling();
        int x2 = (int)((float)screenBox.x * scaling) - 10;
        int y2 = (int)((float)(maxY - screenBox.y - screenBox.height) * scaling) - 10;
        int width = (int)((float)(screenBox.x + screenBox.width) * scaling) + 10 + 10;
        int height = (int)((float)(screenBox.y + screenBox.height) * scaling) + 10 + 10;
        RepaintManager currentManager = RepaintManager.currentManager(this.decode_pdf);
        currentManager.addDirtyRegion(this.decode_pdf, x2, y2, width, height);
    }

    private static boolean isOtherKey(MouseEvent event) {
        return SwingMouseUtils.getMouseButton(event) == 1 || SwingMouseUtils.getMouseButton(event) == 0;
    }
}

