/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingMouseFunctionality;
import org.jpedal.examples.viewer.gui.swing.SwingMouseUtils;

public class SwingMousePanMode
implements SwingMouseFunctionality {
    private Point currentPoint;
    private final PdfDecoder decode_pdf;
    private boolean overDisplay = true;

    public SwingMousePanMode(PdfDecoder decode_pdf) {
        this.decode_pdf = decode_pdf;
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.overDisplay = true;
        this.currentPoint = arg0.getPoint();
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.overDisplay = false;
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        if (SwingMouseUtils.getMouseButton(arg0) == 1 || SwingMouseUtils.getMouseButton(arg0) == 2) {
            this.currentPoint = arg0.getPoint();
            SwingGUI gui = (SwingGUI)this.decode_pdf.getExternalHandler(11);
            this.decode_pdf.setCursor(gui.getGUICursor().getCursor(2));
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        SwingGUI gui = (SwingGUI)this.decode_pdf.getExternalHandler(11);
        this.decode_pdf.setCursor(gui.getGUICursor().getCursor(1));
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        if (this.overDisplay && (SwingMouseUtils.getMouseButton(e2) == 1 || SwingMouseUtils.getMouseButton(e2) == 2)) {
            Point newPoint = e2.getPoint();
            int diffX = this.currentPoint.x - newPoint.x;
            int diffY = this.currentPoint.y - newPoint.y;
            Rectangle view = this.decode_pdf.getVisibleRect();
            view.x += diffX;
            view.y += diffY;
            if (!view.contains(this.decode_pdf.getVisibleRect())) {
                this.decode_pdf.scrollRectToVisible(view);
            }
        }
    }
}

