/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.Map;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jpedal.PdfDecoder;
import org.jpedal.display.Display;
import org.jpedal.display.DisplayOffsets;
import org.jpedal.display.swing.MultiDisplay;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.ViewerCommands;
import org.jpedal.examples.viewer.commands.PageNavigator;
import org.jpedal.examples.viewer.gui.MouseSelector;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingMouseFunctionality;
import org.jpedal.examples.viewer.gui.swing.SwingMouseUtils;
import org.jpedal.external.AnnotationHandler;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.utils.LogWriter;

public class SwingMousePageTurn
implements SwingMouseFunctionality {
    private final PdfDecoder decode_pdf;
    private final SwingGUI currentGUI;
    private final Values commonValues;
    private final Commands currentCommands;
    private long lastPress;
    private boolean drawingTurnover;
    private boolean previewTurnover;
    private double middleDragStartX;
    private double middleDragStartY;
    private double xVelocity;
    private double yVelocity;
    private Timer middleDragTimer;
    private long timeOfLastPageChange;
    private final DisplayOffsets offsets;

    public SwingMousePageTurn(PdfDecoder decode_pdf, SwingGUI currentGUI, Values commonValues, Commands currentCommands) {
        this.decode_pdf = decode_pdf;
        this.currentGUI = currentGUI;
        this.commonValues = commonValues;
        this.currentCommands = currentCommands;
        this.offsets = (DisplayOffsets)decode_pdf.getExternalHandler(37);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.decode_pdf.getDisplayView() == 1 && SwingMouseUtils.getMouseButton(event) == 1 && this.decode_pdf.getExternalHandler(25) != null) {
            int[] pos = MouseSelector.updateXY(event.getX(), event.getY(), this.decode_pdf, this.commonValues);
            this.checkLinks(true, this.decode_pdf.getIO(), pos[0], pos[1]);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.previewTurnover && this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4 && SwingMouseUtils.getMouseButton(event) == 1) {
            this.drawingTurnover = true;
            this.decode_pdf.setCursor(this.currentGUI.getGUICursor().getCursor(2));
            this.lastPress = System.currentTimeMillis();
        }
        if (SwingMouseUtils.getMouseButton(event) == 2) {
            System.out.println("Button 2");
        }
        if (SwingMouseUtils.getMouseButton(event) == 2) {
            this.middleDragStartX = (double)event.getX() - this.decode_pdf.getVisibleRect().getX();
            this.middleDragStartY = (double)event.getY() - this.decode_pdf.getVisibleRect().getY();
            this.decode_pdf.setCursor(this.currentGUI.getGUICursor().getCursor(4));
            if (this.middleDragTimer == null) {
                this.middleDragTimer = new Timer(100, e2 -> {
                    Rectangle r2 = this.decode_pdf.getVisibleRect();
                    r2.translate((int)this.xVelocity, (int)this.yVelocity);
                    if (this.xVelocity < -2.0) {
                        if (this.yVelocity < -2.0) {
                            this.decode_pdf.setCursor(this.currentGUI.getGUICursor().getCursor(6));
                        } else if (this.yVelocity > 2.0) {
                            this.decode_pdf.setCursor(this.currentGUI.getGUICursor().getCursor(12));
                        } else {
                            this.decode_pdf.setCursor(this.currentGUI.getGUICursor().getCursor(5));
                        }
                    } else if (this.xVelocity > 2.0) {
                        if (this.yVelocity < -2.0) {
                            this.decode_pdf.setCursor(this.currentGUI.getGUICursor().getCursor(8));
                        } else if (this.yVelocity > 2.0) {
                            this.decode_pdf.setCursor(this.currentGUI.getGUICursor().getCursor(10));
                        } else {
                            this.decode_pdf.setCursor(this.currentGUI.getGUICursor().getCursor(9));
                        }
                    } else if (this.yVelocity < -2.0) {
                        this.decode_pdf.setCursor(this.currentGUI.getGUICursor().getCursor(7));
                    } else if (this.yVelocity > 2.0) {
                        this.decode_pdf.setCursor(this.currentGUI.getGUICursor().getCursor(11));
                    } else {
                        this.decode_pdf.setCursor(this.currentGUI.getGUICursor().getCursor(4));
                    }
                    this.decode_pdf.scrollRectToVisible(r2);
                    Display display = this.decode_pdf.getPages();
                    if (display instanceof MultiDisplay) {
                        display.decodeOtherPages(this.decode_pdf.getPageNumber());
                    }
                });
            }
            this.middleDragTimer.start();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
            this.drawingTurnover = false;
            boolean dragLeft = this.offsets.getDragLeft();
            boolean dragTop = this.offsets.getDragTop();
            if (this.lastPress + 200L > System.currentTimeMillis()) {
                if (dragLeft) {
                    this.currentCommands.executeCommand(ViewerCommands.BACKPAGE, null);
                } else {
                    this.currentCommands.executeCommand(ViewerCommands.FORWARDPAGE, null);
                }
                this.previewTurnover = false;
                this.decode_pdf.setCursor(this.currentGUI.getGUICursor().getCursor(3));
            } else {
                Point corner = new Point();
                corner.y = this.decode_pdf.getInsetH();
                if (!dragTop) {
                    corner.y = (int)((float)corner.y + (float)this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * this.decode_pdf.getScaling());
                }
                corner.x = dragLeft ? (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 - (double)((float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling())) : (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 + (double)((float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling()));
                this.testFall(corner, event.getPoint(), dragLeft);
            }
        }
        if (SwingMouseUtils.getMouseButton(event) == 2) {
            this.xVelocity = 0.0;
            this.yVelocity = 0.0;
            this.decode_pdf.setCursor(this.currentGUI.getGUICursor().getCursor(3));
            this.middleDragTimer.stop();
            this.decode_pdf.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (SwingMouseUtils.getMouseButton(event) == 1) {
            if (this.decode_pdf.getExternalHandler(25) != null) {
                int[] pos = MouseSelector.updateXY(event.getX(), event.getY(), this.decode_pdf, this.commonValues);
                this.checkLinks(true, this.decode_pdf.getIO(), pos[0], pos[1]);
            }
            if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && (this.drawingTurnover || this.previewTurnover) && this.decode_pdf.getDisplayView() == 4) {
                this.decode_pdf.setCursor(this.currentGUI.getGUICursor().getCursor(2));
                if (this.offsets.getDragLeft()) {
                    if (this.offsets.getDragTop()) {
                        this.decode_pdf.setUserOffsets(event.getX(), event.getY(), 996);
                    } else {
                        this.decode_pdf.setUserOffsets(event.getX(), event.getY(), 998);
                    }
                } else if (this.offsets.getDragTop()) {
                    this.decode_pdf.setUserOffsets(event.getX(), event.getY(), 997);
                } else {
                    this.decode_pdf.setUserOffsets(event.getX(), event.getY(), 999);
                }
            }
        } else if (SwingMouseUtils.getMouseButton(event) == 2) {
            this.xVelocity = ((double)event.getX() - this.decode_pdf.getVisibleRect().getX() - this.middleDragStartX) / 4.0;
            this.yVelocity = ((double)event.getY() - this.decode_pdf.getVisibleRect().getY() - this.middleDragStartY) / 4.0;
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.decode_pdf.getDisplayView() == 4 && this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && ((SwingGUI)this.decode_pdf.getExternalHandler(11)).getPageTurnScalingAppropriate() && !this.decode_pdf.getPdfPageData().hasMultipleSizes() && !PageNavigator.getPageTurnAnimating()) {
            Point cursor;
            float pageH = (float)this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * this.decode_pdf.getScaling() - 1.0f;
            float pageW = (float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling() - 1.0f;
            if ((this.decode_pdf.getPdfPageData().getRotation(1) + this.currentGUI.getRotation()) % 180 == 90) {
                float temp = pageH;
                pageH = pageW + 1.0f;
                pageW = temp;
            }
            Point corner = new Point();
            if (this.commonValues.getCurrentPage() + 1 < this.commonValues.getPageCount()) {
                corner.x = (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 + (double)pageW);
                corner.y = (int)((float)this.decode_pdf.getInsetH() + pageH);
                cursor = event.getPoint();
                if (cursor.x > corner.x - 30 && cursor.x <= corner.x && (cursor.y > corner.y - 30 && cursor.y <= corner.y || (float)cursor.y >= (float)corner.y - pageH && (float)cursor.y < (float)corner.y - pageH + 30.0f)) {
                    this.decode_pdf.setCursor(this.currentGUI.getGUICursor().getCursor(1));
                    this.previewTurnover = true;
                    if ((float)cursor.y >= (float)corner.y - pageH && (float)cursor.y < (float)corner.y - pageH + 30.0f) {
                        corner.y = (int)((float)corner.y - pageH);
                        this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 997);
                    } else {
                        this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 999);
                    }
                } else {
                    if (this.offsets.getDragTop()) {
                        corner.y = (int)((float)corner.y - pageH);
                    }
                    this.testFall(corner, cursor, false);
                }
            }
            if (this.commonValues.getCurrentPage() != 1) {
                corner.x = (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 - (double)pageW);
                corner.y = (int)((float)this.decode_pdf.getInsetH() + pageH);
                cursor = event.getPoint();
                if (cursor.x < corner.x + 30 && cursor.x >= corner.x && (cursor.y > corner.y - 30 && cursor.y <= corner.y || (float)cursor.y >= (float)corner.y - pageH && (float)cursor.y < (float)corner.y - pageH + 30.0f)) {
                    this.decode_pdf.setCursor(this.currentGUI.getGUICursor().getCursor(1));
                    this.previewTurnover = true;
                    if ((float)cursor.y >= (float)corner.y - pageH && (float)cursor.y < (float)corner.y - pageH + 30.0f) {
                        corner.y = (int)((float)corner.y - pageH);
                        this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 996);
                    } else {
                        this.decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 998);
                    }
                } else {
                    if (this.offsets.getDragTop()) {
                        corner.y = (int)((float)corner.y - pageH);
                    }
                    this.testFall(corner, cursor, true);
                }
            }
        }
        if (this.decode_pdf.getExternalHandler(25) != null) {
            int[] pos = MouseSelector.updateXY(event.getX(), event.getY(), this.decode_pdf, this.commonValues);
            this.checkLinks(false, this.decode_pdf.getIO(), pos[0], pos[1]);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this.decode_pdf.getDisplayView() == 5) {
            return;
        }
        if ("true".equalsIgnoreCase(this.currentGUI.getProperties().getValue("allowScrollwheelZoom")) && event.isControlDown()) {
            int scaling = this.getScaling();
            float value = event.getWheelRotation();
            if ((scaling != 1 || value < 0.0f) && !((float)scaling + (value = value < 0.0f ? 1.25f : 0.8f) < 0.0f)) {
                float currentScaling = (float)scaling * value;
                currentScaling = (int)currentScaling == scaling ? (float)(scaling + 1) : (float)((int)currentScaling);
                if (currentScaling < 1.0f) {
                    currentScaling = 1.0f;
                }
                if (currentScaling > 1000.0f) {
                    currentScaling = 1000.0f;
                }
                Rectangle r2 = this.decode_pdf.getVisibleRect();
                double x2 = (double)event.getX() / this.decode_pdf.getBounds().getWidth();
                double y2 = (double)event.getY() / this.decode_pdf.getBounds().getHeight();
                this.currentGUI.snapScalingToDefaults(currentScaling);
                SwingUtilities.invokeLater(() -> {
                    try {
                        this.decode_pdf.scrollRectToVisible(new Rectangle((int)(x2 * (double)this.decode_pdf.getWidth() - r2.getWidth() / 2.0), (int)(y2 * (double)this.decode_pdf.getHeight() - r2.getHeight() / 2.0), (int)this.decode_pdf.getVisibleRect().getWidth(), (int)this.decode_pdf.getVisibleRect().getHeight()));
                        this.decode_pdf.repaint();
                    }
                    catch (Exception e2) {
                        LogWriter.writeLog(e2);
                    }
                });
            }
        } else {
            JScrollBar scroll = ((JScrollPane)this.decode_pdf.getParent().getParent()).getVerticalScrollBar();
            if ((scroll.getValue() >= scroll.getMaximum() - scroll.getHeight() || scroll.getHeight() == 0) && event.getUnitsToScroll() > 0 && this.timeOfLastPageChange + 700L < System.currentTimeMillis() && this.currentGUI.getValues().getCurrentPage() < this.decode_pdf.getPageCount()) {
                this.timeOfLastPageChange = System.currentTimeMillis();
                this.currentCommands.executeCommand(ViewerCommands.FORWARDPAGE, null);
                SwingUtilities.invokeLater(() -> scroll.setValue(scroll.getMinimum()));
            } else if (scroll.getValue() == scroll.getMinimum() && event.getUnitsToScroll() < 0 && this.timeOfLastPageChange + 700L < System.currentTimeMillis() && this.currentGUI.getValues().getCurrentPage() > 1) {
                this.timeOfLastPageChange = System.currentTimeMillis();
                this.currentCommands.executeCommand(ViewerCommands.BACKPAGE, null);
                SwingUtilities.invokeLater(() -> scroll.setValue(scroll.getMaximum()));
            } else {
                Area rect = new Area(this.decode_pdf.getVisibleRect());
                AffineTransform transform = new AffineTransform();
                transform.translate(0.0, event.getUnitsToScroll() * this.decode_pdf.getScrollInterval());
                rect = rect.createTransformedArea(transform);
                this.decode_pdf.scrollRectToVisible(rect.getBounds());
            }
        }
    }

    private int getScaling() {
        int scaling = this.currentGUI.getSelectedComboIndex(252);
        if (scaling != -1) {
            scaling = (int)this.decode_pdf.getDPIFactory().removeScaling(this.decode_pdf.getScaling() * 100.0f);
        } else {
            String numberValue = (String)this.currentGUI.getSelectedComboItem(252);
            try {
                scaling = (int)Float.parseFloat(numberValue);
            }
            catch (NumberFormatException e2) {
                char c2;
                int ii;
                LogWriter.writeLog("Exception in handling scaling " + e2);
                int length = numberValue.length();
                for (ii = 0; ii < length && ((c2 = numberValue.charAt(ii)) >= '0' && c2 <= '9') | c2 == '.'; ++ii) {
                }
                if (ii > 0) {
                    numberValue = numberValue.substring(0, ii);
                }
                try {
                    scaling = (int)Float.parseFloat(numberValue);
                }
                catch (NumberFormatException e1) {
                    LogWriter.writeLog("Exception in handling scaling " + e1);
                    scaling = -1;
                }
            }
        }
        return scaling;
    }

    private void checkLinks(boolean mouseClicked, PdfObjectReader pdfObjectReader, int x2, int y2) {
        Map<FormObject, String> objs = this.currentGUI.getHotspots();
        if (objs != null) {
            ((AnnotationHandler)this.decode_pdf.getExternalHandler(25)).checkLinks(objs, mouseClicked, pdfObjectReader, x2, y2, this.currentGUI, this.commonValues);
        }
    }

    private void testFall(Point corner, Point cursor, boolean testLeft) {
        if (!this.previewTurnover) {
            return;
        }
        float width = (float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling() - 1.0f;
        if ((this.decode_pdf.getPdfPageData().getRotation(1) + this.currentGUI.getRotation()) % 180 == 90) {
            width = (float)this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * this.decode_pdf.getScaling();
        }
        float pageW = width;
        if (!testLeft) {
            if (!this.offsets.getDragLeft()) {
                this.decode_pdf.setCursor(Cursor.getDefaultCursor());
                Thread animation = new Thread(new AnimateCornerRight(corner, cursor, pageW));
                animation.setDaemon(true);
                PageNavigator.setPageTurnAnimating(true, this.currentGUI);
                animation.start();
                this.previewTurnover = false;
            }
        } else if (this.previewTurnover && this.offsets.getDragLeft()) {
            this.decode_pdf.setCursor(Cursor.getDefaultCursor());
            Thread animation = new Thread(new AnimateCornerLeft(corner, cursor, pageW));
            animation.setDaemon(true);
            PageNavigator.setPageTurnAnimating(true, this.currentGUI);
            animation.start();
            this.previewTurnover = false;
        }
    }

    private void changePage(boolean forward) {
        int page;
        if (!forward) {
            page = this.commonValues.getCurrentPage() - 2;
            if (page == 0) {
                page = 1;
            }
        } else {
            page = this.commonValues.getCurrentPage() + 1;
            if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) ? page % 2 == 1 : page % 2 == 0) {
                ++page;
            }
        }
        this.commonValues.setCurrentPage(page);
        this.currentGUI.setPageNumber();
        this.decode_pdf.setPageParameters(this.currentGUI.getScaling(), this.commonValues.getCurrentPage());
        this.currentGUI.decodePage();
    }

    private final class AnimateCornerRight
    implements Runnable {
        final Point corner;
        final Point cursor;
        final float pageW;

        private AnimateCornerRight(Point corner, Point cursor, float pageW) {
            this.corner = corner;
            this.cursor = cursor;
            this.pageW = pageW;
        }

        @Override
        public void run() {
            this.corner.x = (int)(SwingMousePageTurn.this.decode_pdf.getVisibleRect().getWidth() / 2.0 + (double)this.pageW);
            boolean fallBack = true;
            if ((float)this.cursor.x < (float)this.corner.x - this.pageW) {
                this.corner.x = (int)((float)this.corner.x - 2.0f * this.pageW);
                fallBack = false;
            }
            int velocity = 1;
            if (fallBack && this.cursor.x >= this.corner.x) {
                this.cursor.x = this.corner.x - 1;
            }
            if (!fallBack && this.cursor.x <= this.corner.x) {
                this.cursor.x = this.corner.x + 1;
            }
            if (!SwingMousePageTurn.this.offsets.getDragTop() && this.cursor.y >= this.corner.y) {
                this.cursor.y = this.corner.y - 1;
            }
            if (SwingMousePageTurn.this.offsets.getDragTop() && this.cursor.y <= this.corner.y) {
                this.cursor.y = this.corner.y + 1;
            }
            double distX = this.corner.x - this.cursor.x;
            double distY = this.corner.y - this.cursor.y;
            while (fallBack && this.cursor.getX() <= this.corner.getX() || !fallBack && this.cursor.getX() >= this.corner.getX() || !SwingMousePageTurn.this.offsets.getDragTop() && this.cursor.getY() <= this.corner.getY() || SwingMousePageTurn.this.offsets.getDragTop() && this.cursor.getY() >= this.corner.getY()) {
                double xMove = (double)velocity * distX * 0.002;
                double yMove = (double)velocity * distY * 0.002;
                if (Math.abs(xMove) < 1.0) {
                    xMove /= Math.abs(xMove);
                }
                if (Math.abs(yMove) < 1.0) {
                    yMove /= Math.abs(yMove);
                }
                this.cursor.setLocation(this.cursor.getX() + xMove, this.cursor.getY() + yMove);
                if (SwingMousePageTurn.this.offsets.getDragTop()) {
                    SwingMousePageTurn.this.decode_pdf.setUserOffsets((int)this.cursor.getX(), (int)this.cursor.getY(), 997);
                } else {
                    SwingMousePageTurn.this.decode_pdf.setUserOffsets((int)this.cursor.getX(), (int)this.cursor.getY(), 999);
                }
                if (velocity < 32) {
                    velocity *= 2;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    LogWriter.writeLog(e2);
                }
            }
            if (!fallBack) {
                SwingMousePageTurn.this.changePage(true);
            }
            SwingMousePageTurn.this.decode_pdf.setUserOffsets(0, 0, 995);
            PageNavigator.setPageTurnAnimating(false, SwingMousePageTurn.this.currentGUI);
        }
    }

    private final class AnimateCornerLeft
    implements Runnable {
        final Point corner;
        final Point cursor;
        final float pageW;

        private AnimateCornerLeft(Point corner, Point cursor, float pageW) {
            this.corner = corner;
            this.cursor = cursor;
            this.pageW = pageW;
        }

        @Override
        public void run() {
            this.corner.x = (int)(SwingMousePageTurn.this.decode_pdf.getVisibleRect().getWidth() / 2.0 - (double)this.pageW);
            boolean fallBack = true;
            if ((float)this.cursor.x > (float)this.corner.x + this.pageW) {
                this.corner.x = (int)((float)this.corner.x + 2.0f * this.pageW);
                fallBack = false;
            }
            int velocity = 1;
            if (!fallBack && this.cursor.x >= this.corner.x) {
                this.cursor.x = this.corner.x - 1;
            }
            if (fallBack && this.cursor.x <= this.corner.x) {
                this.cursor.x = this.corner.x + 1;
            }
            if (!SwingMousePageTurn.this.offsets.getDragTop() && this.cursor.y >= this.corner.y) {
                this.cursor.y = this.corner.y - 1;
            }
            if (SwingMousePageTurn.this.offsets.getDragTop() && this.cursor.y <= this.corner.y) {
                this.cursor.y = this.corner.y + 1;
            }
            double distX = this.corner.x - this.cursor.x;
            double distY = this.corner.y - this.cursor.y;
            while (!fallBack && this.cursor.getX() <= this.corner.getX() || fallBack && this.cursor.getX() >= this.corner.getX() || !SwingMousePageTurn.this.offsets.getDragTop() && this.cursor.getY() <= this.corner.getY() || SwingMousePageTurn.this.offsets.getDragTop() && this.cursor.getY() >= this.corner.getY()) {
                double xMove = (double)velocity * distX * 0.002;
                double yMove = (double)velocity * distY * 0.002;
                if (Math.abs(xMove) < 1.0) {
                    xMove /= Math.abs(xMove);
                }
                if (Math.abs(yMove) < 1.0) {
                    yMove /= Math.abs(yMove);
                }
                this.cursor.setLocation(this.cursor.getX() + xMove, this.cursor.getY() + yMove);
                if (SwingMousePageTurn.this.offsets.getDragTop()) {
                    SwingMousePageTurn.this.decode_pdf.setUserOffsets((int)this.cursor.getX(), (int)this.cursor.getY(), 996);
                } else {
                    SwingMousePageTurn.this.decode_pdf.setUserOffsets((int)this.cursor.getX(), (int)this.cursor.getY(), 998);
                }
                if (velocity < 32) {
                    velocity *= 2;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    LogWriter.writeLog(e2);
                }
            }
            if (!fallBack) {
                SwingMousePageTurn.this.changePage(false);
            }
            SwingMousePageTurn.this.decode_pdf.setUserOffsets(0, 0, 995);
            PageNavigator.setPageTurnAnimating(false, SwingMousePageTurn.this.currentGUI);
        }
    }
}

