/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoder;
import org.jpedal.display.Display;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.MouseMode;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.ViewerCommands;
import org.jpedal.examples.viewer.gui.MouseSelector;
import org.jpedal.examples.viewer.gui.SingleViewTransferHandler;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingAnnotationPanel;
import org.jpedal.examples.viewer.gui.swing.SwingMouseAnnotations;
import org.jpedal.examples.viewer.gui.swing.SwingMouseFunctionality;
import org.jpedal.examples.viewer.gui.swing.SwingMousePageTurn;
import org.jpedal.examples.viewer.gui.swing.SwingMousePanMode;
import org.jpedal.examples.viewer.gui.swing.SwingMouseSelector;
import org.jpedal.examples.viewer.gui.swing.SwingMouseUtils;
import org.jpedal.io.annotation.WritableAnnotation;
import org.jpedal.io.annotation.utils.AnnotationUtils;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.render.GUIDisplay;
import org.jpedal.utils.LogWriter;

public class SwingMouseListener
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private final PdfDecoder decode_pdf;
    private final SwingGUI currentGUI;
    private final Values commonValues;
    private final Commands currentCommands;
    private final SwingMouseSelector selectionFunctions;
    private final SwingMousePanMode panningFunctions;
    private final SwingMousePageTurn pageTurnFunctions;
    private final SwingMouseAnnotations annotationFunctions;
    private static SwingMouseFunctionality customMouseFunctions;
    static final int annotationSelecionRange = 5;
    private final MouseMode mouseMode;
    private Component scrollComponent;
    private Component formComponent;
    private boolean allowCoordUpdate = true;

    public SwingMouseListener(PdfDecoder decode_pdf, SwingGUI currentGUI, Values commonValues, Commands currentCommands) {
        this.decode_pdf = decode_pdf;
        this.currentGUI = currentGUI;
        this.commonValues = commonValues;
        this.currentCommands = currentCommands;
        this.mouseMode = currentCommands.getMouseMode();
        this.selectionFunctions = new SwingMouseSelector(decode_pdf, currentGUI, commonValues, currentCommands);
        this.panningFunctions = new SwingMousePanMode(decode_pdf);
        this.pageTurnFunctions = new SwingMousePageTurn(decode_pdf, currentGUI, commonValues, currentCommands);
        this.annotationFunctions = currentGUI.getGlassPane() != null ? currentGUI.getAnnotationPanel().getAnnotationListener() : null;
    }

    public void setupMouse() {
        if (this.currentGUI.getGlassPane() != null) {
            this.currentGUI.getGlassPane().addMouseMotionListener(this);
            this.currentGUI.getGlassPane().addMouseListener(this);
            this.currentGUI.getGlassPane().addMouseWheelListener(this);
        } else {
            this.decode_pdf.addMouseMotionListener(this);
            this.decode_pdf.addMouseListener(this);
            this.decode_pdf.addMouseWheelListener(this);
        }
        this.decode_pdf.setDefaultCursor(Cursor.getPredefinedCursor(0));
        SingleViewTransferHandler singleViewTransferHandler = new SingleViewTransferHandler(this.currentGUI, this.currentCommands);
        this.decode_pdf.setTransferHandler(singleViewTransferHandler);
    }

    public void dispose() {
        this.selectionFunctions.dispose();
        this.decode_pdf.removeMouseMotionListener(this);
        this.decode_pdf.removeMouseListener(this);
        this.decode_pdf.removeMouseWheelListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        if (this.annotationFunctions != null) {
            if (this.scrollComponent != null) {
                SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), this.scrollComponent, e2, e2.getX(), e2.getY());
                return;
            }
            e2.translatePoint(-this.decode_pdf.getX(), -this.decode_pdf.getY());
        }
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                if (this.annotationFunctions != null) {
                    Point p2 = SwingMouseUtils.getCoordsOnPage(e2.getX(), e2.getY(), this.decode_pdf.getPageNumber(), this.decode_pdf, this.currentGUI, this.currentGUI.getValues());
                    if (p2 == null) break;
                    FormObject form = AnnotationUtils.isOverForm(this.decode_pdf, p2.x, p2.y, 5);
                    if (form != null) {
                        Component component = SwingUtilities.getDeepestComponentAt(this.decode_pdf, e2.getX(), e2.getY());
                        if (component == null) break;
                        SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), component, e2, e2.getX() + this.decode_pdf.getX(), e2.getY() + this.decode_pdf.getY());
                        break;
                    }
                    this.selectionFunctions.mouseClicked(e2);
                    break;
                }
                this.selectionFunctions.mouseClicked(e2);
                break;
            }
        }
        if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
            this.pageTurnFunctions.mouseClicked(e2);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseClicked(e2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        if (this.annotationFunctions != null) {
            if (this.scrollComponent != null) {
                SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), this.scrollComponent, e2, e2.getX(), e2.getY());
                return;
            }
            e2.translatePoint(-this.decode_pdf.getX(), -this.decode_pdf.getY());
        }
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                break;
            }
            case 1: {
                this.panningFunctions.mouseEntered(e2);
            }
        }
        if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
            this.pageTurnFunctions.mouseEntered(e2);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseEntered(e2);
        }
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        if (this.annotationFunctions != null) {
            if (this.scrollComponent != null) {
                SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), this.scrollComponent, e2, e2.getX(), e2.getY());
                return;
            }
            e2.translatePoint(-this.decode_pdf.getX(), -this.decode_pdf.getY());
        }
        int[] flag = new int[]{1, 0};
        this.currentGUI.setMultibox(flag);
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mouseExited(e2);
                break;
            }
            case 1: {
                this.panningFunctions.mouseExited(e2);
            }
        }
        if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
            this.pageTurnFunctions.mouseExited(e2);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseExited(e2);
        }
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (this.annotationFunctions != null) {
            if (this.scrollComponent != null) {
                SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), this.scrollComponent, e2, e2.getX(), e2.getY());
                return;
            }
            e2.translatePoint(-this.decode_pdf.getX(), -this.decode_pdf.getY());
        }
        if (SwingMouseUtils.getMouseButton(e2) == 2) {
            if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
                this.pageTurnFunctions.mousePressed(e2);
            } else {
                this.panningFunctions.mousePressed(e2);
            }
        } else {
            switch (this.mouseMode.getMouseMode()) {
                case 0: {
                    if (this.annotationFunctions != null) {
                        this.handlePossibleAnnotationPressed(e2);
                        break;
                    }
                    this.selectionFunctions.mousePressed(e2);
                    break;
                }
                case 1: {
                    this.panningFunctions.mousePressed(e2);
                }
            }
            if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
                this.pageTurnFunctions.mousePressed(e2);
            }
            if (customMouseFunctions != null) {
                customMouseFunctions.mousePressed(e2);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (this.annotationFunctions != null) {
            if (this.scrollComponent != null) {
                SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), this.scrollComponent, e2, e2.getX(), e2.getY());
                return;
            }
            e2.translatePoint(-this.decode_pdf.getX(), -this.decode_pdf.getY());
        }
        if (SwingMouseUtils.getMouseButton(e2) == 2) {
            if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
                this.pageTurnFunctions.mousePressed(e2);
            } else {
                this.panningFunctions.mousePressed(e2);
            }
        } else {
            switch (this.mouseMode.getMouseMode()) {
                case 0: {
                    if (this.annotationFunctions != null) {
                        boolean isLink;
                        Point p2 = SwingMouseUtils.getCoordsOnPage(e2.getX(), e2.getY(), this.decode_pdf.getPageNumber(), this.decode_pdf, this.currentGUI, this.currentGUI.getValues());
                        if (p2 == null) {
                            return;
                        }
                        FormObject obj = AnnotationUtils.isOverForm(this.decode_pdf, p2.x, p2.y, 5);
                        boolean bl2 = isLink = AnnotationUtils.isURLLink(obj) && SwingMouseUtils.getMouseButton(e2) == 3;
                        if (this.currentGUI.getAnnotationPanel() != null && (this.currentGUI.getAnnotationPanel().getAnnotationType() != null || this.annotationFunctions.getFormMode() == SwingAnnotationPanel.FORMMODE.EDIT || isLink)) {
                            if (isLink && obj != null) {
                                Component comp = (Component)obj.getGUIComponent();
                                Point componentPoint = SwingUtilities.convertPoint(this.currentGUI.getGlassPane(), e2.getX(), e2.getY(), comp);
                                this.annotationFunctions.selectAnnotation(obj);
                                this.annotationFunctions.showEditContextMenu((Component)obj.getGUIComponent(), componentPoint.x, componentPoint.y);
                                break;
                            }
                            this.annotationFunctions.mouseReleased(e2);
                            break;
                        }
                        if (this.formComponent != null) {
                            SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), this.formComponent, e2, e2.getX() + this.decode_pdf.getX(), e2.getY() + this.decode_pdf.getY());
                            break;
                        }
                        this.selectionFunctions.mouseReleased(e2);
                        break;
                    }
                    this.selectionFunctions.mouseReleased(e2);
                    break;
                }
                case 1: {
                    this.panningFunctions.mouseReleased(e2);
                }
            }
            if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
                this.pageTurnFunctions.mouseReleased(e2);
            }
            if (customMouseFunctions != null) {
                customMouseFunctions.mouseReleased(e2);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        ((Component)e2.getSource()).setCursor(this.decode_pdf.getCursor());
        if (this.annotationFunctions != null) {
            if (this.scrollComponent != null) {
                SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), this.scrollComponent, e2, e2.getX(), e2.getY());
                return;
            }
            e2.translatePoint(-this.decode_pdf.getX(), -this.decode_pdf.getY());
        }
        this.scrollAndUpdateCoords(e2);
        if (SwingMouseUtils.getMouseButton(e2) == 2) {
            if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
                this.pageTurnFunctions.mousePressed(e2);
            } else {
                this.panningFunctions.mousePressed(e2);
            }
        } else {
            switch (this.mouseMode.getMouseMode()) {
                case 0: {
                    this.mouseDraggedForTextSelectMode(e2);
                    break;
                }
                case 1: {
                    this.panningFunctions.mouseDragged(e2);
                }
            }
            if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
                this.pageTurnFunctions.mouseDragged(e2);
            }
            if (customMouseFunctions != null) {
                customMouseFunctions.mouseDragged(e2);
            }
        }
    }

    private void mouseDraggedForTextSelectMode(MouseEvent e2) {
        if (this.annotationFunctions != null) {
            if (this.currentGUI.getAnnotationPanel() != null && (this.currentGUI.getAnnotationPanel().getAnnotationType() != null || this.annotationFunctions.getFormMode() == SwingAnnotationPanel.FORMMODE.EDIT)) {
                this.annotationFunctions.mouseDragged(e2);
            } else {
                Point p2 = SwingMouseUtils.getCoordsOnPage(e2.getX(), e2.getY(), this.decode_pdf.getPageNumber(), this.decode_pdf, this.currentGUI, this.currentGUI.getValues());
                FormObject form = null;
                if (p2 != null) {
                    form = AnnotationUtils.isOverForm(this.decode_pdf, p2.x, p2.y);
                }
                if (form == null) {
                    if (this.formComponent != null) {
                        int ID2 = 505;
                        SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), this.formComponent, e2, e2.getX() + this.decode_pdf.getX(), e2.getY() + this.decode_pdf.getY(), 505);
                        this.formComponent = null;
                    }
                } else if (this.formComponent != null) {
                    SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), this.formComponent, e2, e2.getX() + this.decode_pdf.getX(), e2.getY() + this.decode_pdf.getY());
                }
                this.selectionFunctions.mouseDragged(e2);
                this.currentGUI.getGlassPane().setCursor(this.decode_pdf.getCursor());
            }
        } else {
            this.selectionFunctions.mouseDragged(e2);
        }
    }

    public static void setCustomMouseFunctions(SwingMouseFunctionality cmf) {
        customMouseFunctions = cmf;
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        ((Component)e2.getSource()).setCursor(this.decode_pdf.getCursor());
        this.checkForMovableComponent(e2);
        Point p2 = this.selectionFunctions.getCoordsOnPage(e2.getX(), e2.getY(), this.commonValues.getCurrentPage());
        int x2 = (int)p2.getX();
        int y2 = (int)p2.getY();
        if (this.mouseMode.getMouseMode() == 0) {
            if (this.annotationFunctions != null) {
                this.handleMovementOverForms(e2);
            }
            if (!this.currentCommands.extractingAsImage) {
                this.getObjectUnderneath(x2, y2);
            }
            this.handlePossibleAnnotationMovement(e2, x2, y2);
        }
        if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
            this.pageTurnFunctions.mouseMoved(e2);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseMoved(e2);
        }
        if (this.allowCoordUpdate) {
            this.updateCoords(x2, y2);
            this.allowCoordUpdate = false;
        }
    }

    private void handlePossibleAnnotationPressed(MouseEvent e2) {
        Point pageCoords = this.selectionFunctions.getCoordsOnPage(e2.getX(), e2.getY(), this.decode_pdf.getPageNumber());
        if (this.currentGUI.getAnnotationPanel() != null && this.currentGUI.getAnnotationPanel().getAnnotationType() != null) {
            if (this.annotationFunctions.canBePlaced((int)pageCoords.getX(), (int)pageCoords.getY())) {
                this.annotationFunctions.mousePressed(e2);
            }
        } else {
            FormObject fo = AnnotationUtils.isOverForm(this.decode_pdf, (int)pageCoords.getX(), (int)pageCoords.getY(), 5);
            if (fo != null && (AnnotationUtils.isResizableAnnotation(fo) || AnnotationUtils.isDraggableAnnotation(fo) || fo.getNameAsConstant(1147962727) == 1919840408)) {
                this.handleAnnotationSelection(fo, pageCoords, e2);
            } else {
                this.annotationFunctions.deselectAnnotation();
                this.annotationFunctions.setFormMode(SwingAnnotationPanel.FORMMODE.CREATION);
                if (this.formComponent != null) {
                    SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), this.formComponent, e2, e2.getX() + this.decode_pdf.getX(), e2.getY() + this.decode_pdf.getY());
                } else {
                    this.selectionFunctions.mousePressed(e2);
                }
            }
        }
    }

    private void handleAnnotationSelection(FormObject fo, Point p2, MouseEvent e2) {
        if (SwingMouseListener.isOverVisiblePortion(fo, p2.x, p2.y)) {
            this.decode_pdf.updateCursorBoxOnScreen(null, 0);
            this.decode_pdf.getPages().setHighlightedImage(null);
            this.decode_pdf.getTextLines().clearHighlights();
            this.annotationFunctions.setFormMode(SwingAnnotationPanel.FORMMODE.EDIT);
            this.annotationFunctions.mousePressed(e2);
            this.annotationFunctions.startComponentListener();
            Component com = SwingUtilities.getDeepestComponentAt(this.currentGUI.getPageContainer(), e2.getX() + this.decode_pdf.getX(), e2.getY() + this.decode_pdf.getY());
            if (com != null && "org.jpedal.examples.viewer.gui.swing.AnnotationEditor$DragTab".equals(com.getClass().getName())) {
                this.scrollComponent = com;
                SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), this.scrollComponent, e2, e2.getX(), e2.getY());
            }
        } else {
            this.annotationFunctions.deselectAnnotation();
            this.annotationFunctions.setFormMode(SwingAnnotationPanel.FORMMODE.CREATION);
        }
    }

    private void handlePossibleAnnotationMovement(MouseEvent e2, int pageX, int pageY) {
        SwingAnnotationPanel annotPanel = this.currentGUI.getAnnotationPanel();
        if (annotPanel != null && this.annotationFunctions != null && (annotPanel.getAnnotationType() != null || this.annotationFunctions.getFormMode() == SwingAnnotationPanel.FORMMODE.EDIT)) {
            if (!this.currentCommands.extractingAsImage && annotPanel.getAnnotationType() != null && annotPanel.getAnnotationType() != WritableAnnotation.AnnotationType.HIGHLIGHT && this.annotationFunctions.canBePlaced(pageX, pageY)) {
                this.decode_pdf.setCursor(Cursor.getPredefinedCursor(1));
                this.currentGUI.getGlassPane().setCursor(this.decode_pdf.getCursor());
            }
            this.annotationFunctions.mouseMoved(e2);
        } else {
            this.selectionFunctions.mouseMoved(e2);
        }
    }

    private void handleMovementOverForms(MouseEvent e2) {
        if (this.currentGUI.getAnnotationPanel() != null && (this.currentGUI.getAnnotationPanel().getAnnotationType() != null || this.annotationFunctions.getFormMode() == SwingAnnotationPanel.FORMMODE.EDIT)) {
            this.formComponent = null;
            this.annotationFunctions.mouseMoved(e2);
        } else {
            Point p1 = SwingMouseUtils.getCoordsOnPage(e2.getX(), e2.getY(), this.decode_pdf.getPageNumber(), this.decode_pdf, this.currentGUI, this.currentGUI.getValues());
            if (p1 != null) {
                FormObject form = AnnotationUtils.isOverForm(this.decode_pdf, p1.x, p1.y);
                if (form != null) {
                    this.passMovementEventToNewComponent(e2);
                } else if (this.formComponent != null) {
                    SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), this.formComponent, e2, e2.getX() + this.decode_pdf.getX(), e2.getY() + this.decode_pdf.getY(), 505);
                    this.formComponent = null;
                }
            }
        }
    }

    private void passMovementEventToNewComponent(MouseEvent e2) {
        Component component = SwingUtilities.getDeepestComponentAt(this.decode_pdf, e2.getX(), e2.getY());
        if (this.formComponent != null && component != null && !component.equals(this.formComponent)) {
            SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), this.formComponent, e2, e2.getX() + this.decode_pdf.getX(), e2.getY() + this.decode_pdf.getY(), 505);
            this.formComponent = null;
        }
        if (component != null) {
            int ID2 = this.formComponent == null ? 504 : e2.getID();
            SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), component, e2, e2.getX() + this.decode_pdf.getX(), e2.getY() + this.decode_pdf.getY(), ID2);
            this.formComponent = component;
        }
    }

    private void checkForMovableComponent(MouseEvent e2) {
        if (this.annotationFunctions != null) {
            Component com = this.getMovableComponent(e2);
            if (com != null) {
                if (!com.equals(this.scrollComponent)) {
                    if (this.scrollComponent != null) {
                        SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), this.scrollComponent, e2, e2.getX(), e2.getY(), 505);
                    }
                    this.scrollComponent = com;
                    SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), this.scrollComponent, e2, e2.getX(), e2.getY(), 504);
                } else {
                    SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), com, e2, e2.getX(), e2.getY());
                }
            } else {
                if (this.scrollComponent != null) {
                    SwingMouseListener.passAlongEvent(this.currentGUI.getGlassPane(), this.scrollComponent, e2, e2.getX(), e2.getY(), 505);
                }
                this.scrollComponent = null;
            }
            e2.translatePoint(-this.decode_pdf.getX(), -this.decode_pdf.getY());
        }
    }

    private Component getMovableComponent(MouseEvent e2) {
        String name;
        Component com = SwingUtilities.getDeepestComponentAt(this.currentGUI.getPageContainer(), e2.getX(), e2.getY());
        if (!(com == null || "javax.swing.JScrollPane$ScrollBar".equals(name = com.getClass().getName()) || "com.sun.java.swing.plaf.windows.WindowsScrollBarUI$WindowsArrowButton".equals(name) || "org.jpedal.objects.acroforms.overridingImplementations.PdfSwingPopup$PopupTitleBar".equals(name) || "org.jpedal.objects.acroforms.overridingImplementations.PdfSwingPopup$PopupContentArea".equals(name) || "org.jpedal.examples.viewer.gui.swing.AnnotationEditor$ResizeTab".equals(name) || "org.jpedal.examples.viewer.gui.swing.AnnotationEditor$AnnotationTextInput".equals(name))) {
            com = null;
        }
        return com;
    }

    private void getObjectUnderneath(int x2, int y2) {
        if (this.decode_pdf.getDisplayView() == 1) {
            Cursor cursor;
            if (this.scrollComponent != null) {
                cursor = this.scrollComponent.getCursor();
            } else if (this.formComponent != null) {
                cursor = this.formComponent.getCursor();
            } else {
                int type = ((GUIDisplay)this.decode_pdf.getDynamicRenderer()).getObjectUnderneath(x2, y2);
                switch (type) {
                    case -1: {
                        cursor = Cursor.getPredefinedCursor(0);
                        break;
                    }
                    case 3: {
                        cursor = Cursor.getPredefinedCursor(1);
                        break;
                    }
                    default: {
                        cursor = Cursor.getPredefinedCursor(2);
                    }
                }
            }
            this.decode_pdf.setCursor(cursor);
            JPanel glassPane = this.currentGUI.getGlassPane();
            if (glassPane != null) {
                glassPane.setCursor(cursor);
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        if ("true".equalsIgnoreCase(this.currentGUI.getProperties().getValue("allowScrollwheelZoom")) && (event.isMetaDown() || event.isControlDown())) {
            this.handleMouseWheelZoom(event);
        } else if (event.isMetaDown() || event.isShiftDown()) {
            SwingMouseListener.scrollView(this.decode_pdf, event.getUnitsToScroll() * this.decode_pdf.getScrollInterval(), 0);
        } else {
            switch (this.decode_pdf.getDisplayView()) {
                case 5: {
                    break;
                }
                case 4: {
                    if (!this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON)) break;
                    this.pageTurnFunctions.mouseWheelMoved(event);
                    break;
                }
                case 1: {
                    JScrollBar scroll = this.currentGUI.getVerticalScrollBar();
                    if (scroll == null) {
                        return;
                    }
                    SwingMouseListener.handlePageScrolling(scroll, event, this.decode_pdf.getPageCount());
                }
                default: {
                    SwingMouseListener.scrollView(this.decode_pdf, 0, event.getUnitsToScroll() * this.decode_pdf.getScrollInterval());
                }
            }
        }
    }

    private static void scrollView(PdfDecoder decode_pdf, int x2, int y2) {
        Area rect = new Area(decode_pdf.getVisibleRect());
        AffineTransform transform = new AffineTransform();
        transform.translate(x2, y2);
        rect = rect.createTransformedArea(transform);
        decode_pdf.scrollRectToVisible(rect.getBounds());
    }

    private static void handlePageScrolling(JScrollBar scroll, MouseWheelEvent event, int pageCount) {
        int scrollToPage = scroll.getValue();
        if (scroll.getValue() <= scroll.getMaximum() && event.getUnitsToScroll() > 0 && scrollToPage < pageCount) {
            SwingMouseListener.scrollToPage(scroll, ++scrollToPage);
        } else if (scroll.getValue() >= scroll.getMinimum() && event.getUnitsToScroll() < 0 && scrollToPage >= 1) {
            SwingMouseListener.scrollToPage(scroll, --scrollToPage);
        }
    }

    private static void scrollToPage(JScrollBar scroll, int scrollToPage) {
        if (SwingUtilities.isEventDispatchThread()) {
            scroll.setValue(scrollToPage);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> scroll.setValue(scrollToPage));
            }
            catch (InterruptedException | InvocationTargetException e2) {
                LogWriter.writeLog("Exception in handling mouse value " + e2);
                SwingUtilities.invokeLater(() -> scroll.setValue(scrollToPage));
            }
        }
    }

    private void handleMouseWheelZoom(MouseWheelEvent event) {
        if (event.getWheelRotation() < 0) {
            this.currentCommands.executeCommand(ViewerCommands.ZOOMIN, null);
        } else if (event.getWheelRotation() > 0) {
            this.currentCommands.executeCommand(ViewerCommands.ZOOMOUT, null);
        }
    }

    private void scrollAndUpdateCoords(MouseEvent event) {
        int interval = this.decode_pdf.getScrollInterval();
        Rectangle visible_test = new Rectangle(MouseSelector.adjustForAlignment(event.getX(), this.decode_pdf), event.getY(), interval, interval);
        if (this.currentGUI.allowScrolling() && !this.decode_pdf.getVisibleRect().contains(visible_test)) {
            this.decode_pdf.scrollRectToVisible(visible_test);
        }
        int page = this.commonValues.getCurrentPage();
        Point p2 = this.selectionFunctions.getCoordsOnPage(event.getX(), event.getY(), page);
        int x2 = (int)p2.getX();
        int y2 = (int)p2.getY();
        this.updateCoords(x2, y2);
    }

    private void updateCoords(int x2, int y2) {
        if (this.decode_pdf.getDisplayView() != 1) {
            if (this.decode_pdf.getDisplayView() == 4 || this.decode_pdf.getDisplayView() == 2 || this.decode_pdf.getDisplayView() == 3) {
                int xOffset;
                if (this.decode_pdf.getDisplayView() == 4 && this.decode_pdf.getPageNumber() < this.decode_pdf.getPageCount() && x2 >= (xOffset = this.decode_pdf.getPdfPageData().getCropBoxWidth(this.decode_pdf.getPageNumber()))) {
                    x2 -= xOffset;
                }
            } else {
                x2 = 0;
                y2 = 0;
            }
        }
        if (Values.isProcessing() || this.commonValues.getSelectedFile() == null) {
            this.currentGUI.setCoordText("  X:  Y:   ");
        } else {
            this.currentGUI.setCoordText("  X: " + x2 + " Y: " + y2 + ' ');
        }
    }

    public void allowMouseCoordsUpdate() {
        this.allowCoordUpdate = true;
    }

    private static boolean isOverVisiblePortion(FormObject form, int x2, int y2) {
        int ey;
        int sy;
        int ex;
        BufferedImage icon = (BufferedImage)((ImageIcon)((AbstractButton)form.getGUIComponent()).getIcon()).getImage();
        if (icon == null) {
            return true;
        }
        float scale = (float)icon.getWidth() / (float)form.getBoundingRectangle().width;
        float ix = (float)(x2 - form.getBoundingRectangle().x) * scale;
        float iy = (float)(form.getBoundingRectangle().height - (y2 - form.getBoundingRectangle().y)) * scale;
        int sx = (int)(ix - 5.0f * scale);
        if (sx < 0) {
            sx = 0;
        }
        if ((ex = (int)(ix + 5.0f * scale)) >= icon.getWidth()) {
            ex = icon.getWidth() - 1;
        }
        if ((sy = (int)(iy - 5.0f * scale)) < 0) {
            sy = 0;
        }
        if ((ey = (int)(iy + 5.0f * scale)) >= icon.getHeight()) {
            ey = icon.getHeight() - 1;
        }
        for (int fy = sy; fy <= ey; ++fy) {
            for (int fx = sx; fx <= ex; ++fx) {
                int rgb = icon.getRGB(fx, fy);
                if (rgb == 0) continue;
                return true;
            }
        }
        return false;
    }

    private static void passAlongEvent(Component from, Component to, MouseEvent e2, int x2, int y2) {
        SwingMouseListener.passAlongEvent(from, to, e2, x2, y2, e2.getID());
    }

    private static void passAlongEvent(Component from, Component to, MouseEvent e2, int x2, int y2, int id2) {
        Point componentPoint = SwingUtilities.convertPoint(from, x2, y2, to);
        to.dispatchEvent(new MouseEvent(to, id2, e2.getWhen(), e2.getModifiersEx(), componentPoint.x, componentPoint.y, e2.getClickCount(), e2.isPopupTrigger(), e2.getButton()));
    }
}

