/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Point;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import org.jpedal.PdfDecoder;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.ViewerCommands;
import org.jpedal.examples.viewer.commands.Copy;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingMouseUtils;
import org.jpedal.io.Speech;
import org.jpedal.render.SwingDisplay;
import org.jpedal.utils.Messages;

class SwingMouseContextMenu {
    private final SwingGUI currentGUI;
    private final JPopupMenu rightClick;
    private final JMenuItem copy;
    private final JMenuItem selectAll;
    private final JMenuItem deselectall;
    private final JMenu extract;
    private final JMenuItem extractText;
    private final JMenuItem extractImage;
    private final JMenuItem snapShot;
    private final JMenuItem speakHighlighted;
    private int xPos;
    private int yPos;
    final FileFilter jpgFileFilter = new FileFilter(){

        @Override
        public boolean accept(File f2) {
            return f2.isDirectory() || f2.getName().toLowerCase().endsWith(".jpg") || f2.getName().toLowerCase().endsWith(".jpeg");
        }

        @Override
        public String getDescription() {
            return "JPG (*.jpg)";
        }
    };
    final FileFilter pngFileFilter = new FileFilter(){

        @Override
        public boolean accept(File f2) {
            return f2.isDirectory() || f2.getName().toLowerCase().endsWith(".png");
        }

        @Override
        public String getDescription() {
            return "PNG (*.png)";
        }
    };
    final FileFilter tifFileFilter = new FileFilter(){

        @Override
        public boolean accept(File f2) {
            return f2.isDirectory() || f2.getName().toLowerCase().endsWith(".tif") || f2.getName().toLowerCase().endsWith(".tiff");
        }

        @Override
        public String getDescription() {
            return "TIF (*.tiff)";
        }
    };

    SwingMouseContextMenu(SwingGUI currentGUI) {
        this.currentGUI = currentGUI;
        this.rightClick = new JPopupMenu();
        this.copy = new JMenuItem(Messages.getMessage("PdfRightClick.copy"));
        this.selectAll = new JMenuItem(Messages.getMessage("PdfRightClick.selectAll"));
        this.deselectall = new JMenuItem(Messages.getMessage("PdfRightClick.deselectAll"));
        this.extract = new JMenu(Messages.getMessage("PdfRightClick.extract"));
        this.extractText = new JMenuItem(Messages.getMessage("PdfRightClick.extractText"));
        this.extractImage = new JMenuItem(Messages.getMessage("PdfRightClick.extractImage"));
        ImageIcon snapshotIcon = new ImageIcon(currentGUI.getGUICursor().getURLForImage("snapshot_menu.gif"));
        this.snapShot = new JMenuItem(Messages.getMessage("PdfRightClick.snapshot"), snapshotIcon);
        this.speakHighlighted = new JMenuItem("Speak Highlighted text");
        this.init();
    }

    public JPopupMenu getContextMenu() {
        return this.rightClick;
    }

    public void enableTextOptions(boolean enable) {
        this.extractText.setEnabled(enable);
        this.speakHighlighted.setEnabled(enable);
        this.copy.setEnabled(enable);
    }

    public void enableImageOptions(boolean enable) {
        this.extractImage.setEnabled(enable);
    }

    public void show(int x2, int y2) {
        PdfDecoder decode_pdf = this.currentGUI.getPdfDecoder();
        Point mousePoint = SwingMouseUtils.getCoordsOnPage(x2, y2, decode_pdf.getPageNumber(), decode_pdf, this.currentGUI, this.currentGUI.getValues());
        if (mousePoint != null) {
            this.xPos = (int)mousePoint.getX();
            this.yPos = (int)mousePoint.getY();
            this.rightClick.show(decode_pdf, x2, y2);
        }
    }

    private void init() {
        boolean useSpeech;
        this.rightClick.add(this.copy);
        this.copy.addActionListener(e2 -> {
            if (this.currentGUI.getPdfDecoder().getDisplayView() == 1) {
                this.currentGUI.getCommand().executeCommand(ViewerCommands.COPY, null);
            } else if (SwingGUI.showMessages) {
                this.currentGUI.showMessageDialog("Copy is only available in single page display mode");
            }
        });
        this.rightClick.addSeparator();
        this.rightClick.add(this.selectAll);
        this.selectAll.addActionListener(e2 -> this.currentGUI.getCommand().executeCommand(ViewerCommands.SELECTALL, null));
        this.rightClick.add(this.deselectall);
        this.deselectall.addActionListener(e2 -> this.currentGUI.getCommand().executeCommand(ViewerCommands.DESELECTALL, null));
        this.rightClick.addSeparator();
        this.rightClick.add(this.extract);
        this.extract.add(this.extractText);
        this.extractText.addActionListener(e2 -> {
            if (this.currentGUI.getPdfDecoder().getDisplayView() == 1) {
                this.currentGUI.getCommand().executeCommand(ViewerCommands.EXTRACTTEXT, null);
            } else if (SwingGUI.showMessages) {
                this.currentGUI.showMessageDialog("Text Extraction is only available in single page display mode");
            }
        });
        this.extract.add(this.extractImage);
        this.extractImage.addActionListener(e2 -> {
            PdfDecoder decode_pdf = this.currentGUI.getPdfDecoder();
            if (decode_pdf.getPages().getHighlightedImage() == null) {
                if (SwingGUI.showMessages) {
                    JOptionPane.showMessageDialog(decode_pdf, "No image has been selected for extraction.", "No image selected", 0);
                }
            } else if (decode_pdf.getDisplayView() == 1) {
                this.extractImage(decode_pdf);
            }
        });
        this.extract.add(this.snapShot);
        this.snapShot.addActionListener(e2 -> this.currentGUI.getCommand().executeCommand(ViewerCommands.SNAPSHOT, null));
        Speech speech = (Speech)this.currentGUI.getPdfDecoder().getExternalHandler(32);
        boolean bl2 = useSpeech = speech != null;
        if (useSpeech) {
            String option = this.currentGUI.getProperties().getValue("voice");
            if (option != null && option.contains("(")) {
                option = option.substring(0, option.indexOf(40));
            }
            speech.setVoice(option);
            this.rightClick.addSeparator();
        }
        this.speakHighlighted.addActionListener(arg0 -> {
            if (useSpeech) {
                if (this.currentGUI.getPdfDecoder().getDisplayView() == 1) {
                    Thread speak = new Thread(() -> {
                        String text = Copy.copySelectedText(this.currentGUI.getPdfDecoder(), this.currentGUI, this.currentGUI.getValues());
                        speech.speakText(text);
                    });
                    speak.setDaemon(true);
                    speak.start();
                } else if (SwingGUI.showMessages) {
                    this.currentGUI.showMessageDialog("Speak text is only available in single page display mode");
                }
            }
        });
        if (useSpeech) {
            this.rightClick.add(this.speakHighlighted);
        }
    }

    private void extractImage(PdfDecoderInt decode_pdf) {
        JFileChooser jf = new JFileChooser();
        jf.addChoosableFileFilter(this.tifFileFilter);
        jf.addChoosableFileFilter(this.pngFileFilter);
        jf.addChoosableFileFilter(this.jpgFileFilter);
        jf.showSaveDialog(null);
        File f2 = jf.getSelectedFile();
        boolean failed = false;
        if (f2 != null) {
            String filename = f2.getAbsolutePath();
            String type = jf.getFileFilter().getDescription().substring(0, 3).toLowerCase();
            if (filename.indexOf(46) != -1) {
                String testExt;
                switch (testExt = filename.substring(filename.indexOf(46) + 1).toLowerCase()) {
                    case "jpg": 
                    case "jpeg": {
                        type = "jpg";
                        break;
                    }
                    case "tif": 
                    case "tiff": {
                        type = "tiff";
                        break;
                    }
                    case "png": {
                        type = "png";
                        break;
                    }
                    default: {
                        if (SwingGUI.showMessages) {
                            JOptionPane.showMessageDialog(null, "Sorry, we can not currently save images to ." + testExt + " files.");
                        }
                        failed = true;
                    }
                }
            }
            if ("tif".equals(type)) {
                type = "tiff";
            }
            if ("all".equals(type)) {
                type = "png";
            }
            if (!filename.toLowerCase().endsWith('.' + type)) {
                filename = filename + '.' + type;
            }
            if (!failed) {
                SwingDisplay swingRenderer = (SwingDisplay)decode_pdf.getDynamicRenderer();
                int id2 = -1;
                if (decode_pdf.getDisplayView() == 1) {
                    id2 = swingRenderer.isInsideImage(this.xPos, this.yPos);
                }
                swingRenderer.saveImage(id2, filename, type);
            }
        }
    }
}

