/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.AnnotationCreator;
import org.jpedal.examples.viewer.gui.swing.AnnotationEditor;
import org.jpedal.examples.viewer.gui.swing.SwingAnnotationPanel;
import org.jpedal.examples.viewer.gui.swing.SwingMouseFunctionality;
import org.jpedal.examples.viewer.gui.swing.SwingMouseUtils;
import org.jpedal.io.annotation.WritableAnnotation;
import org.jpedal.objects.raw.FormObject;

public class SwingMouseAnnotations
implements SwingMouseFunctionality {
    private SwingAnnotationPanel.FORMMODE currentMode = SwingAnnotationPanel.FORMMODE.CREATION;
    private final AnnotationCreator creator;
    private final AnnotationEditor editor;
    private final SwingGUI currentGUI;

    public SwingMouseAnnotations(PdfDecoder decode_pdf, SwingGUI currentGUI) {
        JPanel glassPane = currentGUI.getGlassPane();
        if (glassPane != null) {
            glassPane.setLayout(null);
        }
        this.currentGUI = currentGUI;
        this.creator = new AnnotationCreator(decode_pdf, currentGUI);
        this.editor = new AnnotationEditor(decode_pdf, currentGUI);
    }

    public void dispose() {
        this.editor.dispose();
    }

    void showEditContextMenu(Component invoker, int x2, int y2) {
        this.editor.showEditContextMenu(invoker, x2, y2);
    }

    public void cancelCreation() {
        this.creator.cancelCreation();
    }

    private void hideAnnotationResizeTabs() {
        this.editor.hideAnnotationResizeTabs();
    }

    public void selectAnnotation(FormObject f2) {
        this.editor.selectAnnotation(f2);
    }

    public void deselectAnnotation() {
        this.editor.deselectAnnotation();
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        switch (this.currentMode) {
            case CREATION: {
                this.creator.createAnnotation(e2.getX(), e2.getY(), SwingMouseUtils.getMouseButton(e2), e2.getClickCount());
                break;
            }
            case EDIT: {
                this.editor.selectAnnotation(e2.getX(), e2.getY());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        WritableAnnotation.AnnotationType type;
        if (this.currentMode == SwingAnnotationPanel.FORMMODE.CREATION && this.creator.isCreating() && SwingMouseAnnotations.isDraggableAnnotation(type = (WritableAnnotation.AnnotationType)((Object)this.currentGUI.getAnnotationPanel().getAnnotationType()))) {
            this.creator.updateDragAnnotation(e2.getX(), e2.getY());
            FormObject annot = this.creator.getCurrentAnnotation();
            if (WritableAnnotation.AnnotationType.FREETEXT == type) {
                Rectangle bounds = annot.getBoundingRectangle();
                if (bounds.getWidth() != 0.0 && bounds.getHeight() != 0.0) {
                    this.editor.selectAnnotation(annot);
                    this.editor.showTextInput();
                }
            } else if (WritableAnnotation.AnnotationType.LINK == type) {
                this.editor.selectAnnotation(annot);
                this.editor.openPropertiesWindow();
            }
            this.creator.completeDragCreationAnnotations(e2.getX(), e2.getY());
        }
    }

    private static boolean isDraggableAnnotation(WritableAnnotation.AnnotationType type) {
        return type == WritableAnnotation.AnnotationType.CIRCLE || type == WritableAnnotation.AnnotationType.SQUARE || type == WritableAnnotation.AnnotationType.LINE || type == WritableAnnotation.AnnotationType.FREETEXT || type == WritableAnnotation.AnnotationType.HIGHLIGHT || type == WritableAnnotation.AnnotationType.INK || type == WritableAnnotation.AnnotationType.LINK;
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        WritableAnnotation.AnnotationType type;
        if (SwingMouseUtils.getMouseButton(e2) == 3) {
            return;
        }
        if (this.currentMode == SwingAnnotationPanel.FORMMODE.CREATION && this.creator.isCreating() && SwingMouseAnnotations.isDraggableAnnotation(type = (WritableAnnotation.AnnotationType)((Object)this.currentGUI.getAnnotationPanel().getAnnotationType()))) {
            this.creator.updateDragAnnotation(e2.getX(), e2.getY());
        }
    }

    public boolean canBePlaced(int x2, int y2) {
        return this.creator.canBePlaced(x2, y2);
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        if (this.currentMode == SwingAnnotationPanel.FORMMODE.CREATION && this.creator.isCreating()) {
            this.creator.updateMoveAnnotation(e2.getX(), e2.getY());
        }
    }

    public void startComponentListener() {
        this.editor.startComponentListener();
    }

    public void setFormMode(SwingAnnotationPanel.FORMMODE mode) {
        if (mode == SwingAnnotationPanel.FORMMODE.CREATION && this.currentMode == SwingAnnotationPanel.FORMMODE.CREATION && this.creator.isCreating()) {
            this.cancelCreation();
        }
        if (mode != this.currentMode && this.editor.isEditing()) {
            this.hideAnnotationResizeTabs();
        }
        this.currentMode = mode;
        this.editor.clearCurrentAnnotation();
        this.creator.clearCurrentAnnotation();
    }

    SwingAnnotationPanel.FORMMODE getFormMode() {
        return this.currentMode;
    }

    public void updateSelectionPosition() {
        this.editor.updateResizeTabs();
    }
}

