/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyListener;
import org.jpedal.display.swing.SingleDisplay;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.ViewerCommands;
import org.jpedal.examples.viewer.gui.Buttons;
import org.jpedal.examples.viewer.gui.swing.SwingCheckBoxMenuItem;
import org.jpedal.examples.viewer.gui.swing.SwingCommandListener;
import org.jpedal.examples.viewer.gui.swing.SwingMenuItem;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.JavaFXHelper;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class SwingMenuItems {
    private JMenuBar currentMenu = new JMenuBar();
    private final HashMap<Integer, JMenuItem> menuItems = new HashMap();
    private final HashMap<Integer, JMenu> menuMap = new HashMap();
    private final PropertiesFile properties;
    private SwingCommandListener currentCommandListener;
    private boolean debugMode;

    public SwingMenuItems(PropertiesFile properties) {
        this.properties = properties;
    }

    public boolean isMenuItemExist(int ID2) {
        return this.getMenuItem(ID2) != null;
    }

    public void setMenuItem(int ID2, boolean enabled, boolean visible) {
        if (ID2 == 300) {
            this.currentMenu.setEnabled(enabled);
            this.currentMenu.setVisible(visible);
        } else if (this.getMenuItem(ID2) != null) {
            this.getMenuItem(ID2).setEnabled(enabled);
            this.getMenuItem(ID2).setVisible(visible);
        } else if (this.getMenu(ID2) != null) {
            this.getMenu(ID2).setEnabled(enabled);
            this.getMenu(ID2).setVisible(visible);
        }
    }

    public void setMenuItemVisibility(int ID2, boolean visible) {
        if (ID2 == 300) {
            this.currentMenu.setVisible(visible);
        } else if (this.getMenuItem(ID2) != null) {
            this.getMenuItem(ID2).setVisible(visible);
        } else if (this.getMenu(ID2) != null) {
            this.getMenu(ID2).setVisible(visible);
        }
    }

    public JMenu getMenu(int ID2) {
        return this.menuMap.get(ID2);
    }

    public JMenuItem getMenuItem(int ID2) {
        return this.menuItems.get(ID2);
    }

    public JMenuBar getCurrentMenu() {
        return this.currentMenu;
    }

    /*
     * WARNING - void declaration
     */
    public void dispose() {
        Collection<JMenuItem> items = this.menuItems.values();
        Iterator<JMenuItem> itemIterator = items.iterator();
        while (itemIterator.hasNext()) {
            JMenuItem item = itemIterator.next();
            ActionListener[] al2 = item.getActionListeners();
            for (int k2 = 0; k2 != al2.length; ++k2) {
                item.removeActionListener(al2[k2]);
            }
            ChangeListener[] cl = item.getChangeListeners();
            for (int k3 = 0; k3 != cl.length; ++k3) {
                item.removeChangeListener(cl[k3]);
            }
            ItemListener[] il = item.getItemListeners();
            for (int k4 = 0; k4 != il.length; ++k4) {
                item.removeItemListener(il[k4]);
            }
            item.removeActionListener(this.currentCommandListener);
            item.removeAll();
            itemIterator.remove();
        }
        Collection<JMenu> menus = this.menuMap.values();
        Iterator<JMenu> menuIterator = menus.iterator();
        while (menuIterator.hasNext()) {
            MenuKeyListener[] menuKeyListenerArray;
            MenuDragMouseListener[] mdl;
            ItemListener[] il;
            void var10_20;
            ChangeListener[] cl;
            ActionListener[] al3;
            JMenuItem menu = menuIterator.next();
            for (ActionListener actionListener : al3 = menu.getActionListeners()) {
                menu.removeActionListener(actionListener);
            }
            ChangeListener[] changeListenerArray = cl = menu.getChangeListeners();
            int n2 = changeListenerArray.length;
            boolean bl2 = false;
            while (var10_20 < n2) {
                ChangeListener l3 = changeListenerArray[var10_20];
                menu.removeChangeListener(l3);
                ++var10_20;
            }
            for (ItemListener l4 : il = menu.getItemListeners()) {
                menu.removeItemListener(l4);
            }
            for (MenuDragMouseListener l5 : mdl = menu.getMenuDragMouseListeners()) {
                menu.removeMenuDragMouseListener(l5);
            }
            for (MenuKeyListener l6 : menuKeyListenerArray = menu.getMenuKeyListeners()) {
                menu.removeMenuKeyListener(l6);
            }
            menu.removeActionListener(this.currentCommandListener);
            menu.removeAll();
            menuIterator.remove();
        }
        this.menuMap.clear();
        this.menuItems.clear();
        if (this.currentMenu != null) {
            this.currentMenu.removeAll();
            this.currentMenu = null;
        }
        this.currentCommandListener = null;
    }

    public void setBackNavigationItemsEnabled(boolean enabled) {
        if (this.menuItems.containsKey(52)) {
            this.menuItems.get(52).setEnabled(enabled);
        }
        if (this.menuItems.containsKey(50)) {
            this.menuItems.get(50).setEnabled(enabled);
        }
    }

    public void setForwardNavigationItemsEnabled(boolean enabled) {
        if (this.menuItems.containsKey(53)) {
            this.menuItems.get(53).setEnabled(enabled);
        }
        if (this.menuItems.containsKey(55)) {
            this.menuItems.get(55).setEnabled(enabled);
        }
    }

    public void setGoToNavigationItemEnabled(boolean enabled) {
        if (this.menuItems.containsKey(56)) {
            this.menuItems.get(56).setEnabled(enabled);
        }
    }

    private void addMenuItem(JMenu parentMenu, String text, String toolTip, int ID2) {
        JMenuItem menuItem = this.getNewMenuItem(parentMenu, text, toolTip, ID2);
        this.menuItems.put(ID2, menuItem);
        switch (ID2) {
            case 500: {
                this.menuItems.get(ID2).setName("resaveForms");
                break;
            }
            case 5: {
                this.menuItems.get(ID2).setName("saveas");
                break;
            }
            case 7: {
                this.menuItems.get(ID2).setName("exit");
                break;
            }
            case 31: {
                this.menuItems.get(ID2).setSelected(true);
                break;
            }
            case 32: {
                boolean separateCoverOn = "true".equalsIgnoreCase(this.properties.getValue("separateCoverOn"));
                ((JCheckBoxMenuItem)this.menuItems.get(ID2)).setState(separateCoverOn);
                SingleDisplay.default_separateCover = separateCoverOn;
                this.menuItems.get(ID2).setName("separateCover");
                break;
            }
            case 38: 
            case 39: {
                this.menuItems.get(ID2).setVisible(this.debugMode);
                break;
            }
            default: {
                ViewerCommands command = ViewerCommands.createFromID(ID2);
                if (command == null) break;
                this.menuItems.get(ID2).setName(command.name().toLowerCase());
            }
        }
    }

    private JMenuItem getNewMenuItem(JMenu parentMenu, String text, String toolTip, int ID2) {
        JMenuItem menuItem;
        if (ID2 == 32 || ID2 == 30 || ID2 == 31 || ID2 == 66 || ID2 == 65) {
            menuItem = new SwingCheckBoxMenuItem(text);
            ((SwingCheckBoxMenuItem)menuItem).setID(ID2);
        } else {
            menuItem = new SwingMenuItem(text);
            ((SwingMenuItem)menuItem).setID(ID2);
        }
        if (!toolTip.isEmpty()) {
            menuItem.setToolTipText(toolTip);
        }
        SwingMenuItems.setKeyAccelerators(ID2, menuItem);
        menuItem.addActionListener(this.currentCommandListener);
        parentMenu.add(menuItem);
        return menuItem;
    }

    private void initLayoutMenus(JMenu pageLayout, String[] descriptions, int[] value, Buttons buttons, Commands currentCommands) {
        int count = value.length;
        for (int i2 = 0; i2 < count; ++i2) {
            JCheckBoxMenuItem pageView = new JCheckBoxMenuItem(descriptions[i2]);
            pageView.setBorder(BorderFactory.createEmptyBorder());
            buttons.getLayoutGroup().add(pageView);
            if (i2 == 0) {
                pageView.setSelected(true);
            }
            if (pageLayout == null) continue;
            switch (value[i2]) {
                case 57: {
                    pageView.addActionListener(e2 -> currentCommands.executeCommand(ViewerCommands.SINGLE, null));
                    break;
                }
                case 58: {
                    pageView.addActionListener(e2 -> currentCommands.executeCommand(ViewerCommands.CONTINUOUS, null));
                    break;
                }
                case 60: {
                    pageView.addActionListener(e2 -> currentCommands.executeCommand(ViewerCommands.FACING, null));
                    break;
                }
                case 59: {
                    pageView.addActionListener(e2 -> currentCommands.executeCommand(ViewerCommands.CONTINUOUS_FACING, null));
                    break;
                }
                case 61: {
                    pageView.addActionListener(e2 -> currentCommands.executeCommand(ViewerCommands.PAGEFLOW, null));
                }
            }
            this.menuItems.put(value[i2], pageView);
            pageLayout.add(pageView);
        }
        buttons.setPageLayoutButtonsEnabled(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMenusForDisplayMode(int commandIDForDislayMode, int mouseMode) {
        block17: {
            switch (commandIDForDislayMode) {
                case 57: {
                    if (this.menuItems.containsKey(31)) {
                        this.menuItems.get(31).setEnabled(true);
                        this.menuItems.get(31).setSelected(true);
                    }
                    if (!this.menuItems.containsKey(30)) return;
                    this.menuItems.get(30).setEnabled(true);
                    this.menuItems.get(30).setSelected(false);
                    return;
                }
                case 61: {
                    if (this.menuItems.containsKey(31)) {
                        this.menuItems.get(31).setEnabled(false);
                        this.menuItems.get(31).setSelected(false);
                    }
                    if (!this.menuItems.containsKey(30)) return;
                    this.menuItems.get(30).setEnabled(false);
                    this.menuItems.get(30).setSelected(true);
                    return;
                }
                case 58: 
                case 59: 
                case 60: {
                    if (this.menuItems.containsKey(31)) {
                        this.menuItems.get(31).setEnabled(false);
                        this.menuItems.get(31).setSelected(false);
                    }
                    if (!this.menuItems.containsKey(30)) return;
                    this.menuItems.get(30).setEnabled(true);
                    this.menuItems.get(30).setSelected(true);
                    return;
                }
                case 29: {
                    switch (mouseMode) {
                        case 0: {
                            if (this.menuItems.containsKey(31)) {
                                this.menuItems.get(31).setSelected(true);
                            }
                            if (!this.menuItems.containsKey(30)) return;
                            this.menuItems.get(30).setSelected(false);
                            break block17;
                        }
                        case 1: {
                            if (this.menuItems.containsKey(31)) {
                                this.menuItems.get(31).setSelected(false);
                            }
                            if (!this.menuItems.containsKey(30)) return;
                            this.menuItems.get(30).setSelected(true);
                        }
                    }
                }
            }
        }
    }

    private void addToMainMenu(JMenu fileMenuList) {
        fileMenuList.getPopupMenu().setLightWeightPopupEnabled(!JavaFXHelper.isJavaFXAvailable());
        this.currentMenu.add(fileMenuList);
    }

    public void createMainMenu(boolean includeAll, SwingCommandListener currentCommandListener, Commands currentCommands, Buttons buttons) {
        this.currentCommandListener = currentCommandListener;
        this.createFileMenu(includeAll, currentCommands);
        this.createEditMenu();
        this.createViewMenu(currentCommands, buttons);
        this.createExportMenu(includeAll);
        this.createHelpMenu();
    }

    private void createHelpMenu() {
        JMenu helpMenu = new JMenu(Messages.getMessage("PdfViewerHelpMenu.text"));
        this.addToMainMenu(helpMenu);
        this.addMenuItem(helpMenu, Messages.getMessage("PdfViewerHelpMenu.VisitWebsite"), "", 15);
        this.addMenuItem(helpMenu, Messages.getMessage("PdfViewerHelpMenuTip.text"), "", 20);
        this.addMenuItem(helpMenu, Messages.getMessage("PdfViewerHelpMenuabout.text"), Messages.getMessage("PdfViewerHelpMenuTooltip.about"), 1);
        this.addMenuItem(helpMenu, Messages.getMessage("PdfViewerHelpMenuTutorial.text"), "Visit https://support.idrsolutions.com/jpedal/", 998);
        this.menuMap.put(998, helpMenu);
    }

    private void createExportMenu(boolean includeAll) {
        JMenu exportMenu = new JMenu(Messages.getMessage("PdfViewerExportMenu.text"));
        this.addToMainMenu(exportMenu);
        JMenu contentMenu = new JMenu(Messages.getMessage("PdfViewerExportMenuContent.text"));
        contentMenu.getPopupMenu().setLightWeightPopupEnabled(!JavaFXHelper.isJavaFXAvailable());
        exportMenu.add(contentMenu);
        this.addMenuItem(contentMenu, Messages.getMessage("PdfViewerExportMenuImages.text"), "", 3);
        this.addMenuItem(contentMenu, Messages.getMessage("PdfViewerExportMenuText.text"), "", 4);
        this.addMenuItem(exportMenu, Messages.getMessage("PdfViewerExportMenuBitmap.text"), "", 2);
        if (includeAll && LogWriter.isRunningFromIDE) {
            JMenu debugViewport = new JMenu("Debug");
            debugViewport.setForeground(Color.blue);
            this.addToMainMenu(debugViewport);
            this.addMenuItem(debugViewport, "Reset viewport", "Resets the viewport to the default value", 1002);
            this.addMenuItem(debugViewport, "Enable acceleration", "Enable Hardware diplay acceleration for screen", 1003);
            this.addMenuItem(debugViewport, "Disable acceleration", "Disable Hardware diplay acceleration for screen", 1004);
            this.addMenuItem(debugViewport, "Show form NAMES", "displays a list of all the forms names", 1006);
            this.addMenuItem(debugViewport, "Wipe properties on exit", "deletes the properties file on exit", 1007);
            this.addMenuItem(debugViewport, "Always show mouse coords", "prevents anything other than mouse coordinates displaying in the multibox", 1008);
            this.menuMap.put(-1, debugViewport);
        }
        this.menuMap.put(307, exportMenu);
        this.menuMap.put(304, contentMenu);
    }

    private void createViewMenu(Commands currentCommands, Buttons buttons) {
        JMenu viewMenu = new JMenu(Messages.getMessage("PdfViewerViewMenu.text"));
        this.addToMainMenu(viewMenu);
        JMenu goToMenu = new JMenu(Messages.getMessage("GoToViewMenuGoto.text"));
        goToMenu.getPopupMenu().setLightWeightPopupEnabled(!JavaFXHelper.isJavaFXAvailable());
        viewMenu.add(goToMenu);
        this.addMenuItem(goToMenu, Messages.getMessage("GoToViewMenuGoto.FirstPage"), "", 50);
        this.addMenuItem(goToMenu, Messages.getMessage("GoToViewMenuGoto.BackPage"), "", 52);
        this.addMenuItem(goToMenu, Messages.getMessage("GoToViewMenuGoto.ForwardPage"), "", 53);
        this.addMenuItem(goToMenu, Messages.getMessage("GoToViewMenuGoto.LastPage"), "", 55);
        this.addMenuItem(goToMenu, Messages.getMessage("GoToViewMenuGoto.GoTo"), "", 56);
        String addSeparator = this.properties.getValue("Previousdocument") + this.properties.getValue("Nextdocument");
        if (!addSeparator.isEmpty() && addSeparator.toLowerCase().contains("true")) {
            goToMenu.addSeparator();
        }
        this.addMenuItem(goToMenu, Messages.getMessage("GoToViewMenuGoto.PreviousDoucment"), "", 16);
        this.addMenuItem(goToMenu, Messages.getMessage("GoToViewMenuGoto.NextDoucment"), "", 17);
        JMenu pageLayoutMenu = new JMenu(Messages.getMessage("PageLayoutViewMenu.PageLayout"));
        pageLayoutMenu.getPopupMenu().setLightWeightPopupEnabled(!JavaFXHelper.isJavaFXAvailable());
        viewMenu.add(pageLayoutMenu);
        String[] descriptions = new String[]{Messages.getMessage("PageLayoutViewMenu.SinglePage"), Messages.getMessage("PageLayoutViewMenu.Continuous"), Messages.getMessage("PageLayoutViewMenu.ContinousFacing"), Messages.getMessage("PageLayoutViewMenu.Facing"), Messages.getMessage("PageLayoutViewMenu.PageFlow")};
        int[] value = new int[]{57, 58, 59, 60, 61};
        this.initLayoutMenus(pageLayoutMenu, descriptions, value, buttons, currentCommands);
        JMenu portfolioMenu = new JMenu(Messages.getMessage("PageLayoutViewMenu.Portfolio"));
        portfolioMenu.getPopupMenu().setLightWeightPopupEnabled(!JavaFXHelper.isJavaFXAvailable());
        viewMenu.add(portfolioMenu);
        this.addMenuItem(portfolioMenu, Messages.getMessage("PageLayoutViewMenu.Tiles"), Messages.getMessage("PdfViewerViewMenuTooltip.tiles"), 66);
        this.addMenuItem(portfolioMenu, Messages.getMessage("PageLayoutViewMenu.Details"), Messages.getMessage("PdfViewerViewMenuTooltip.details"), 65);
        portfolioMenu.setVisible(false);
        this.menuMap.put(309, pageLayoutMenu);
        this.menuMap.put(319, portfolioMenu);
        if ("true".equals(this.properties.getValue("separateCover"))) {
            this.addMenuItem(viewMenu, Messages.getMessage("PdfViewerViewMenuSeparateCover.text"), Messages.getMessage("PdfViewerViewMenuTooltip.separateCover"), 32);
        }
        if ("true".equals(this.properties.getValue("panMode")) || "true".equals(this.properties.getValue("textSelect"))) {
            viewMenu.addSeparator();
            if ("true".equals(this.properties.getValue("panMode"))) {
                this.addMenuItem(viewMenu, Messages.getMessage("PdfViewerViewMenuPanMode.text"), Messages.getMessage("PdfViewerViewMenuTooltip.panMode"), 30);
            }
            if ("true".equals(this.properties.getValue("textSelect"))) {
                this.addMenuItem(viewMenu, Messages.getMessage("PdfViewerViewMenuTextSelectMode.text"), Messages.getMessage("PdfViewerViewMenuTooltip.textSelect"), 31);
            }
            viewMenu.addSeparator();
        }
        this.addMenuItem(viewMenu, Messages.getMessage("PdfViewerViewMenuFullScreenMode.text"), Messages.getMessage("PdfViewerViewMenuTooltip.fullScreenMode"), 62);
        this.addMenuItem(viewMenu, Messages.getMessage("PdfViewer.XrefMenuItemText"), Messages.getMessage("PdfViewer.XrefMenuItemToolTip"), 38);
        this.addMenuItem(viewMenu, Messages.getMessage("PdfViewer.ObjectsMenuItemText"), Messages.getMessage("PdfViewer.ObjectsMenuItemToolTip"), 39);
        this.menuMap.put(312, viewMenu);
        this.menuMap.put(311, goToMenu);
    }

    private void createEditMenu() {
        JMenu editMenu = new JMenu(Messages.getMessage("PdfViewerEditMenu.text"));
        this.addToMainMenu(editMenu);
        this.addMenuItem(editMenu, Messages.getMessage("PdfViewerEditMenuCopy.text"), Messages.getMessage("PdfViewerEditMenuTooltip.Copy"), 25);
        this.addMenuItem(editMenu, Messages.getMessage("PdfViewerEditMenuSelectall.text"), Messages.getMessage("PdfViewerEditMenuTooltip.Selectall"), 26);
        this.addMenuItem(editMenu, Messages.getMessage("PdfViewerEditMenuDeselectall.text"), Messages.getMessage("PdfViewerEditMenuTooltip.Deselectall"), 27);
        String addSeparator = this.properties.getValue("Preferences");
        if (!addSeparator.isEmpty() && "true".equalsIgnoreCase(addSeparator)) {
            editMenu.addSeparator();
        }
        this.addMenuItem(editMenu, Messages.getMessage("PdfViewerEditMenuPreferences.text"), Messages.getMessage("PdfViewerEditMenuTooltip.Preferences"), 24);
        this.menuMap.put(310, editMenu);
    }

    private void createFileMenu(boolean includeAll, Commands currentCommands) {
        JMenu fileMenu = new JMenu(Messages.getMessage("PdfViewerFileMenu.text"));
        this.addToMainMenu(fileMenu);
        this.menuMap.put(317, fileMenu);
        JMenu openMenu = new JMenu(Messages.getMessage("PdfViewerFileMenuOpen.text"));
        openMenu.getPopupMenu().setLightWeightPopupEnabled(!JavaFXHelper.isJavaFXAvailable());
        fileMenu.add(openMenu);
        this.addMenuItem(openMenu, Messages.getMessage("PdfViewerFileMenuOpen.text"), Messages.getMessage("PdfViewerFileMenuTooltip.open"), 10);
        this.addMenuItem(openMenu, Messages.getMessage("PdfViewerFileMenuOpenurl.text"), Messages.getMessage("PdfViewerFileMenuTooltip.openurl"), 14);
        String addSeparator = this.properties.getValue("Save") + this.properties.getValue("Resaveasforms") + this.properties.getValue("Find");
        if (!addSeparator.isEmpty() && "true".equalsIgnoreCase(addSeparator)) {
            fileMenu.addSeparator();
        }
        this.addMenuItem(fileMenu, Messages.getMessage("PdfViewerFileMenuSave.text"), Messages.getMessage("PdfViewerFileMenuTooltip.save"), 5);
        if (includeAll) {
            this.addMenuItem(fileMenu, Messages.getMessage("PdfViewerFileMenuResaveForms.text"), Messages.getMessage("PdfViewerFileMenuTooltip.saveForms"), 500);
        }
        this.addMenuItem(fileMenu, Messages.getMessage("PdfViewerFileMenuFind.text"), Messages.getMessage("PdfViewerFileMenuTooltip.find"), 12);
        addSeparator = this.properties.getValue("Documentproperties");
        if (!addSeparator.isEmpty() && "true".equalsIgnoreCase(addSeparator)) {
            fileMenu.addSeparator();
        }
        this.addMenuItem(fileMenu, Messages.getMessage("PdfViewerFileMenuDocProperties.text"), Messages.getMessage("PdfViewerFileMenuTooltip.props"), 9);
        addSeparator = this.properties.getValue("Print");
        if (!addSeparator.isEmpty() && "true".equalsIgnoreCase(addSeparator)) {
            fileMenu.addSeparator();
        }
        this.addMenuItem(fileMenu, Messages.getMessage("PdfViewerFileMenuPrint.text"), Messages.getMessage("PdfViewerFileMenuTooltip.print"), 6);
        addSeparator = this.properties.getValue("Recentdocuments");
        if (!addSeparator.isEmpty() && "true".equalsIgnoreCase(addSeparator)) {
            fileMenu.addSeparator();
            currentCommands.recentDocumentsOption();
        }
        if (!(addSeparator = this.properties.getValue("Exit")).isEmpty() && "true".equalsIgnoreCase(addSeparator)) {
            fileMenu.addSeparator();
        }
        this.addMenuItem(fileMenu, Messages.getMessage("PdfViewerFileMenuExit.text"), Messages.getMessage("PdfViewerFileMenuTooltip.exit"), 7);
        this.menuMap.put(316, openMenu);
    }

    private static void setKeyAccelerators(int ID2, JMenuItem menuItem) {
        int systemMask = 128;
        if (DecoderOptions.isRunningOnMac) {
            systemMask = 256;
        }
        switch (ID2) {
            case 12: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(70, systemMask));
                break;
            }
            case 5: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(83, systemMask));
                break;
            }
            case 6: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(80, systemMask));
                break;
            }
            case 7: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(81, systemMask));
                break;
            }
            case 9: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(68, systemMask));
                break;
            }
            case 10: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(79, systemMask));
                break;
            }
            case 14: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(85, systemMask));
                break;
            }
            case 16: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(37, 576));
                break;
            }
            case 17: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(39, 576));
                break;
            }
            case 50: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(36, systemMask));
                break;
            }
            case 52: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(38, systemMask));
                break;
            }
            case 53: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(40, systemMask));
                break;
            }
            case 55: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(35, systemMask));
                break;
            }
            case 56: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(78, systemMask | 0x40));
                break;
            }
            case 2: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(66, 512));
                break;
            }
            case 25: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(67, systemMask));
                break;
            }
            case 26: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(65, systemMask));
                break;
            }
            case 27: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(65, systemMask + 64));
                break;
            }
            case 24: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(75, systemMask));
            }
        }
    }

    public void setCheckMenuItemSelected(int ID2, boolean b2) {
        switch (ID2) {
            case 31: {
                if (!this.menuItems.containsKey(31)) break;
                this.menuItems.get(31).setSelected(b2);
                break;
            }
            case 30: {
                if (!this.menuItems.containsKey(30)) break;
                this.menuItems.get(30).setSelected(b2);
                break;
            }
            case 32: {
                if (!this.menuItems.containsKey(32)) break;
                this.menuItems.get(32).setSelected(b2);
                break;
            }
            default: {
                LogWriter.writeLog("Only TEXTSELECT, PANMODE and SEPARATECOVER are Accepted IDs");
            }
        }
    }

    public void addToMenu(Object menuItem, int parentMenuID) {
        this.getMenu(parentMenuID).add((JMenuItem)menuItem);
    }

    public void checkMenuItemSeparators() {
        int menuCount = this.currentMenu.getMenuCount();
        for (int i2 = 0; i2 != menuCount; ++i2) {
            SwingMenuItems.checkMenuItemSeparators(this.currentMenu.getMenu(i2));
        }
    }

    private static void checkMenuItemSeparators(JMenu component) {
        String className;
        boolean separatorAtStart = true;
        boolean lastWasSeparator = false;
        Object lastComp = null;
        for (Component comp : component.getMenuComponents()) {
            String className2 = comp.getClass().getName();
            if (className2.endsWith(".JMenu")) {
                SwingMenuItems.checkMenuItemSeparators((JMenu)comp);
            } else if (className2.endsWith("JPopupMenu$Separator")) {
                comp.setVisible(!lastWasSeparator && !separatorAtStart);
                lastWasSeparator = true;
            } else if (comp.isVisible()) {
                lastWasSeparator = false;
                separatorAtStart = false;
            }
            if (!comp.isVisible()) continue;
            lastComp = comp;
        }
        if (lastComp != null && (className = lastComp.getClass().getName()).endsWith("JPopupMenu$Separator")) {
            ((Component)lastComp).setVisible(false);
        }
    }

    public void setDebugMode(boolean enableDebugMode) {
        this.debugMode = enableDebugMode;
    }
}

