/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.gui.CheckNode;
import org.jpedal.examples.viewer.gui.CheckRenderer;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class SwingLayersPanel
extends JPanel {
    private PdfLayerList layersObject;
    private final DefaultMutableTreeNode topLayer = new DefaultMutableTreeNode("Layers");

    public void reinitialise(PdfLayerList layersObject, PdfDecoderInt decode_pdf, Object scrollPane, int currentPage) {
        this.layersObject = layersObject;
        this.removeAll();
        this.setLayout(new BorderLayout());
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Info");
        Map<String, String> metaData = layersObject.getMetaData();
        for (String nextKey : metaData.keySet()) {
            String value = metaData.get(nextKey);
            top.add(new DefaultMutableTreeNode(nextKey + '=' + value));
        }
        JTree infoTree = new JTree(top);
        infoTree.setToolTipText("Double click to see any metadata");
        infoTree.setRootVisible(true);
        infoTree.collapseRow(0);
        this.add((Component)infoTree, "North");
        Object[] layerNames = layersObject.getDisplayTree();
        if (layerNames != null) {
            this.topLayer.removeAllChildren();
            JTree layersTree = new JTree(this.topLayer);
            layersTree.setName("LayersTree");
            layersTree.addTreeSelectionListener(e2 -> {
                String name;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)layersTree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                StringBuilder rawName = new StringBuilder((String)node.getUserObject());
                if (node.getParent() != null) {
                    Object[] patentNames = ((DefaultMutableTreeNode)node.getParent()).getUserObjectPath();
                    int size = patentNames.length;
                    for (int jj = size - 1; jj > 0; --jj) {
                        rawName.append('\uffff').append(patentNames[jj]);
                    }
                }
                if (layersObject.isLayerName(name = rawName.toString()) && !layersObject.isLocked(name)) {
                    SwingUtilities.invokeLater(new ToggleLayer(decode_pdf, scrollPane, node, name, currentPage, layersTree));
                }
            });
            this.topLayer.removeAllChildren();
            SwingLayersPanel.addLayersToTree(layerNames, this.topLayer, true, layersObject);
            layersTree.setRootVisible(true);
            layersTree.expandRow(0);
            layersTree.setCellRenderer(new CheckRenderer());
            layersTree.getSelectionModel().setSelectionMode(1);
            this.add((Component)layersTree, "Center");
        }
    }

    private static void addLayersToTree(Object[] layerNames, DefaultMutableTreeNode topLayer, boolean isEnabled, PdfLayerList layersObject) {
        DefaultMutableTreeNode currentNode = topLayer;
        boolean parentEnabled = isEnabled;
        boolean parentIsSelected = true;
        for (Object layerName : layerNames) {
            if (layerName instanceof Object[]) {
                DefaultMutableTreeNode oldNode = currentNode;
                SwingLayersPanel.addLayersToTree((Object[])layerName, currentNode, isEnabled && parentIsSelected, layersObject);
                currentNode = oldNode;
                isEnabled = parentEnabled;
                continue;
            }
            parentEnabled = isEnabled;
            if (layerName == null) continue;
            String name = layerName instanceof String ? (String)layerName : StringUtils.getTextString((byte[])layerName, true);
            String title = name;
            int ptr = name.indexOf(65535);
            if (ptr != -1) {
                title = title.substring(0, ptr);
            }
            if (name.endsWith(" R") || topLayer == null) continue;
            if (!layersObject.isLayerName(name)) {
                currentNode = new DefaultMutableTreeNode(title);
                topLayer.add(currentNode);
                topLayer = currentNode;
                parentIsSelected = true;
                continue;
            }
            currentNode = new CheckNode(title);
            topLayer.add(currentNode);
            if (layersObject.isVisible(name)) {
                ((CheckNode)currentNode).setSelected(true);
                parentIsSelected = true;
            } else {
                parentIsSelected = false;
            }
            if (isEnabled) {
                isEnabled = !layersObject.isLocked(name);
            }
            ((CheckNode)currentNode).setEnabled(isEnabled);
        }
    }

    public void resetLayers() {
        this.topLayer.removeAllChildren();
    }

    private void syncTreeDisplay(DefaultMutableTreeNode topLayer, boolean isEnabled) {
        int count = topLayer.getChildCount();
        boolean parentIsEnabled = isEnabled;
        int ii = 0;
        do {
            CheckNode cc;
            String childName;
            isEnabled = parentIsEnabled;
            boolean isSelected = true;
            TreeNode childNode = count == 0 ? topLayer : topLayer.getChildAt(ii);
            if (childNode instanceof CheckNode && this.layersObject.isLayerName(childName = (cc = (CheckNode)childNode).getText())) {
                if (isEnabled) {
                    isEnabled = !this.layersObject.isLocked(childName);
                }
                isSelected = this.layersObject.isVisible(childName);
                cc.setSelected(isSelected);
                cc.setEnabled(isEnabled);
            }
            if (childNode.getChildCount() <= 0) continue;
            int childCount = childNode.getChildCount();
            for (int i2 = 0; i2 < childCount; ++i2) {
                this.syncTreeDisplay((DefaultMutableTreeNode)childNode.getChildAt(i2), isEnabled && isSelected);
            }
        } while (++ii < count);
    }

    private final class ToggleLayer
    implements Runnable {
        final PdfDecoderInt decode_pdf;
        final Object scrollPane;
        final DefaultMutableTreeNode node;
        final String layerName;
        final int currentPage;
        final JTree layersTree;

        private ToggleLayer(PdfDecoderInt decode_pdf, Object scrollPane, DefaultMutableTreeNode node, String layerName, int currentPage, JTree layersTree) {
            this.decode_pdf = decode_pdf;
            this.scrollPane = scrollPane;
            this.node = node;
            this.layerName = layerName;
            this.currentPage = currentPage;
            this.layersTree = layersTree;
        }

        @Override
        public void run() {
            CheckNode checkNode;
            ((Component)((Object)this.decode_pdf)).setCursor(Cursor.getPredefinedCursor(3));
            ((Component)((Object)this.decode_pdf)).invalidate();
            ((JComponent)((Object)this.decode_pdf)).updateUI();
            ((Component)((Object)this.decode_pdf)).validate();
            if (this.scrollPane != null) {
                ((Component)this.scrollPane).invalidate();
                ((JComponent)this.scrollPane).updateUI();
                ((Component)this.scrollPane).validate();
            }
            if (!(checkNode = (CheckNode)this.node).isEnabled()) {
                checkNode.setSelected(checkNode.isSelected());
                ShowGUIMessage.showstaticGUIMessage(" This layer has been disabled because its parent layer is disabled ", "Parent Layer disabled");
            } else {
                boolean reversedStatus = !checkNode.isSelected();
                checkNode.setSelected(reversedStatus);
                SwingLayersPanel.this.layersObject.setVisiblity(this.layerName, reversedStatus);
                SwingLayersPanel.this.syncTreeDisplay(SwingLayersPanel.this.topLayer, true);
                try {
                    this.decode_pdf.decodePage(this.currentPage);
                }
                catch (Exception e1) {
                    LogWriter.writeLog(e1);
                }
                this.decode_pdf.waitForDecodingToFinish();
                this.decode_pdf.repaintOffscreenImage();
                this.decode_pdf.repaint();
            }
            this.layersTree.invalidate();
            this.layersTree.clearSelection();
            this.layersTree.repaint();
            ((Component)((Object)this.decode_pdf)).setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

