/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class SwingButton
extends JButton {
    private int ID;

    public void init(URL path, int ID2, String toolTip) {
        this.ID = ID2;
        this.setToolTipText(toolTip);
        this.setBorderPainted(false);
        this.setOpaque(false);
        if (path != null) {
            ImageIcon icon = new ImageIcon(path);
            this.setIcon(icon);
            SwingButton.createPressedLook(this, icon);
        }
        this.setFocusable(false);
    }

    private static void createPressedLook(AbstractButton button, ImageIcon icon) {
        BufferedImage image = new BufferedImage(icon.getIconWidth() + 2, icon.getIconHeight() + 2, 2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.drawImage(icon.getImage(), 1, 1, null);
        g2.dispose();
        ImageIcon iconPressed = new ImageIcon(image);
        button.setPressedIcon(iconPressed);
    }

    public void setIcon(URL url) {
        ImageIcon icon = new ImageIcon(url);
        this.setIcon(icon);
        SwingButton.createPressedLook(this, icon);
    }

    public int getID() {
        return this.ID;
    }
}

