/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingPortfolioDetail;
import org.jpedal.examples.viewer.gui.swing.SwingPortfolioUtils;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.Messages;
import org.jpedal.utils.StringUtils;

public class SwingAttachmentsPanel
extends JPanel {
    private SwingPortfolioDetail fileDetails;
    private final JButton open;
    private final JButton save;

    public SwingAttachmentsPanel(final SwingGUI currentGUI) {
        this.fileDetails = new SwingPortfolioDetail(currentGUI);
        JPanel topPanel = new JPanel();
        this.open = new JButton(new ImageIcon(currentGUI.getGUICursor().getURLForImage("openSystem.png")));
        this.open.setName("OPEN_ATTACHMENT");
        this.save = new JButton(new ImageIcon(currentGUI.getGUICursor().getURLForImage("save.gif")));
        this.save.setName("SAVE_ATTACHMENT");
        this.open.setToolTipText(Messages.getMessage("PdfViewerToolbarTooltip.openFile"));
        this.save.setToolTipText(Messages.getMessage("PdfPortfolio.Extract"));
        this.open.addActionListener(e2 -> SwingAttachmentsPanel.open(this.fileDetails, currentGUI));
        this.save.addActionListener(new ActionListener(){
            final JFileChooser chooser = new JFileChooser();

            @Override
            public void actionPerformed(ActionEvent e2) {
                SwingAttachmentsPanel.save(SwingAttachmentsPanel.this.fileDetails, currentGUI, this.chooser, (Component)e2.getSource());
            }
        });
        JTable table = this.fileDetails.getTable();
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                super.mouseReleased(e2);
                int row = ((JTable)e2.getSource()).getSelectedRow();
                SwingAttachmentsPanel.this.open.setEnabled(row != -1);
                SwingAttachmentsPanel.this.save.setEnabled(row != -1);
            }

            @Override
            public void mouseClicked(MouseEvent e2) {
                super.mouseClicked(e2);
                int row = ((JTable)e2.getSource()).getSelectedRow();
                SwingAttachmentsPanel.this.open.setEnabled(row != -1);
                SwingAttachmentsPanel.this.save.setEnabled(row != -1);
            }
        });
        int row = table.getSelectedRow();
        this.open.setEnabled(row != -1);
        this.save.setEnabled(row != -1);
        topPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        topPanel.add((Component)this.open, constraints);
        constraints.gridx = 1;
        constraints.weightx = 2.0;
        topPanel.add((Component)this.save, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        this.setLayout(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 2.0;
        constraints.fill = 1;
        this.add((Component)topPanel, constraints);
        constraints.gridy = 1;
        constraints.weightx = 2.0;
        constraints.weighty = 2.0;
        this.add((Component)this.fileDetails, constraints);
    }

    private static void save(SwingPortfolioDetail fileDetails, SwingGUI currentGUI, JFileChooser chooser, Component parentComp) {
        PdfObject fileObject = fileDetails.getSelectedFile();
        if (fileObject != null) {
            String filename;
            byte[] filenameBytes = fileObject.getTextStreamValueAsByte(9494);
            if (filenameBytes == null) {
                filenameBytes = fileObject.getTextStreamValueAsByte(22);
            }
            if ((filename = StringUtils.getTextString(filenameBytes, false)) != null) {
                int pathEnd = filename.lastIndexOf(47);
                if (pathEnd != -1) {
                    filename = filename.substring(pathEnd + 1);
                }
                String ext = filename.substring(filename.lastIndexOf(46) + 1);
                chooser.setSelectedFile(new File(filename));
                chooser.setFileFilter(new FileFilterer(new String[]{ext}, ext.toUpperCase() + " (*." + ext + ')'));
                int result = chooser.showSaveDialog(parentComp);
                switch (result) {
                    case 0: {
                        File outputFile = chooser.getSelectedFile();
                        if (SwingPortfolioUtils.saveFile(currentGUI.getPdfDecoder().getIO(), fileObject, outputFile)) break;
                        currentGUI.showMessageDialog(Messages.getMessage("PdfPortfolio.FailedSave") + ' ' + outputFile.getAbsolutePath());
                        break;
                    }
                }
            }
        }
    }

    private static void open(SwingPortfolioDetail fileDetails, SwingGUI currentGUI) {
        PdfObject fileObject = fileDetails.getSelectedFile();
        if (fileObject != null) {
            int pathEnd;
            String filename;
            byte[] filenameBytes = fileObject.getTextStreamValueAsByte(9494);
            if (filenameBytes == null) {
                filenameBytes = fileObject.getTextStreamValueAsByte(22);
            }
            if ((filename = StringUtils.getTextString(filenameBytes, false)) != null && (pathEnd = filename.lastIndexOf(47)) != -1) {
                filename = filename.substring(pathEnd + 1);
            }
            SwingPortfolioUtils.openFile(currentGUI, currentGUI.getPdfDecoder().getIO(), fileObject, filename);
        } else {
            currentGUI.showMessageDialog(Messages.getMessage("PdfPortfolio.FailedOpen"));
        }
    }

    public boolean loadEmbeddedFileData(PdfDecoderInt decode_pdf, Object[] embeddedFiles) {
        this.open.setEnabled(false);
        this.save.setEnabled(false);
        PdfObjectReader reader = decode_pdf.getIO();
        Object[] tempForms = decode_pdf.getFormRenderer().getFormComponents(null, ReturnValues.FORMOBJECTS_FROM_NAME, -1);
        Object[] totalFiles = null;
        int[] locationInFile = null;
        if (tempForms != null) {
            FormObject[] formArray = (FormObject[])Arrays.copyOf(tempForms, tempForms.length, FormObject[].class);
            ArrayList<FormObject> fileAttachments = new ArrayList<FormObject>();
            for (FormObject form : formArray) {
                if (form.getNameAsConstant(1147962727) != -1113876231) continue;
                fileAttachments.add(form);
            }
            if (!fileAttachments.isEmpty()) {
                int embeddedFilesLength = 0;
                if (embeddedFiles != null) {
                    totalFiles = new Object[embeddedFiles.length + fileAttachments.size() * 2];
                    System.arraycopy(embeddedFiles, 0, totalFiles, 0, embeddedFiles.length);
                    embeddedFilesLength = embeddedFiles.length;
                } else {
                    totalFiles = new Object[fileAttachments.size() * 2];
                }
                locationInFile = new int[totalFiles.length];
                Arrays.fill(locationInFile, -1);
                for (int i2 = 0; i2 != fileAttachments.size(); ++i2) {
                    int pathEnd;
                    String filename;
                    byte[] filenameBytes;
                    PdfObject fs = ((FormObject)fileAttachments.get(i2)).getDictionary(5667);
                    reader.checkResolved(fs);
                    byte[] desc = fs.getTextStreamValueAsByte(339034931);
                    if (desc == null) {
                        fs.setTextStreamValue(339034931, ((FormObject)fileAttachments.get(i2)).getTextStreamValueAsByte(1216184967));
                    }
                    if ((filenameBytes = fs.getTextStreamValueAsByte(9494)) == null) {
                        filenameBytes = fs.getTextStreamValueAsByte(22);
                    }
                    if ((filename = StringUtils.getTextString(filenameBytes, false)) != null && (pathEnd = filename.lastIndexOf(47)) != -1) {
                        filename = filename.substring(pathEnd + 1);
                    }
                    totalFiles[embeddedFilesLength + i2 * 2] = filename;
                    totalFiles[embeddedFilesLength + i2 * 2 + 1] = fs;
                    locationInFile[embeddedFilesLength + i2] = ((FormObject)fileAttachments.get(i2)).getPageNumber();
                }
            }
        }
        if (totalFiles == null && embeddedFiles != null) {
            totalFiles = embeddedFiles;
            locationInFile = new int[totalFiles.length];
            Arrays.fill(locationInFile, -1);
        }
        if (totalFiles != null && totalFiles.length > 0) {
            this.fileDetails.loadEmbeddedFilesValues(reader, totalFiles, locationInFile);
            return true;
        }
        return false;
    }

    public void dispose() {
        this.fileDetails.clearValues();
        this.fileDetails = null;
    }
}

