/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import org.jpedal.PdfDecoder;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.io.annotation.utils.AnnotationUtils;
import org.jpedal.objects.acroforms.creation.AnnotationFactory;
import org.jpedal.objects.acroforms.creation.SwingAPImageHandler;
import org.jpedal.objects.acroforms.overridingImplementations.FixImageIcon;
import org.jpedal.objects.acroforms.overridingImplementations.PdfSwingPopup;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.Messages;

class SwingAnnotationProperties
extends JDialog {
    private final JPanel contents = new JPanel();
    private final GridBagConstraints gbc = new GridBagConstraints();
    private JTextField authorInput;
    private JLabel annotationAuthor;
    private SpinnerNumberModel lineWidthModel;
    private JSpinner lineWidth;
    private JLabel lineWidthLabel;
    private SpinnerNumberModel opacityModel;
    private JSpinner opacity;
    private JLabel opacityLabel;
    private JLabel fontSelectorLabel;
    private DefaultComboBoxModel<String> fontSelectorModel;
    private JComboBox<String> fontSelector;
    private JComboBox<String> textIcon;
    private final String[] textIconNames;
    private JLabel iconSelectorLabel;
    private SpinnerNumberModel fontSizeModel;
    private JSpinner fontSize;
    private JLabel fontSizeLabel;
    private JPanel colorPanel;
    private JLabel colorLabel;
    private JPanel icolorPanel;
    private JLabel icolorLabel;
    private JTextField uriInput;
    private JLabel annotationURI;
    private final JButton ok;
    private FormObject form;
    private final PdfDecoder decode_pdf;
    private final SwingGUI currentGUI;

    SwingAnnotationProperties(PdfDecoder decode_pdf, SwingGUI currentGUI) {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setIconImage(null);
        this.setTitle(Messages.getMessage("PdfFormCreation.Properties"));
        this.decode_pdf = decode_pdf;
        this.currentGUI = currentGUI;
        this.textIconNames = new String[]{"Check", "CheckMark", "Circle", "Comment", "Cross", "CrossHairs", "Help", "Insert", "Key", "NewParagraph", "Note", "Paragraph", "RightArrow", "RightPointer", "Star", "UpArrow", "UpLeftArrow"};
        this.contents.setLayout(new GridBagLayout());
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.ipadx = 10;
        this.gbc.ipady = 10;
        this.gbc.insets = new Insets(10, 10, 10, 10);
        this.addAuthorInput(this.contents);
        this.addFontSelector(this.contents);
        this.addFontSize(this.contents);
        this.addStrokeColor(this.contents);
        this.addFillColor(this.contents);
        this.addLineWidth(this.contents);
        this.addOpacity(this.contents);
        this.add((Component)this.contents, "Center");
        this.ok = new JButton(Messages.getMessage("PdfPreferences.OK"));
        this.ok.setName("OK");
        this.ok.addActionListener(e2 -> {
            this.applyValues();
            this.setVisible(false);
        });
        JButton cancel = new JButton(Messages.getMessage("PdfPreferences.Cancel"));
        cancel.setName("Cancel");
        cancel.addActionListener(e2 -> this.setVisible(false));
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        Box b2 = Box.createHorizontalBox();
        b2.add(this.ok);
        b2.add(cancel);
        bottom.add(b2);
        this.add((Component)bottom, "South");
        this.pack();
    }

    private void applyValues() {
        this.form.setTextStreamValue(36, this.authorInput.getText());
        int annotType = this.form.getNameAsConstant(1147962727);
        switch (annotType) {
            case 980909433: {
                this.applyFreeTextSpecificValues();
                break;
            }
            case 473513531: {
                this.applyLinkSpecificValues();
                break;
            }
            default: {
                int idx;
                if (SwingAnnotationProperties.useStrokeColour(this.form)) {
                    SwingAnnotationProperties.applyStrokeColor(this.form, this.colorPanel.getBackground());
                }
                if (SwingAnnotationProperties.useFillColor(this.form)) {
                    SwingAnnotationProperties.applyFillColor(this.form, this.icolorPanel.getBackground());
                }
                if (SwingAnnotationProperties.useLineWidth(this.form)) {
                    this.applyLineWidth(this.form, this.lineWidthModel.getNumber().intValue());
                }
                if (SwingAnnotationProperties.useOpacity(this.form)) {
                    this.form.setFloatNumber(4881, this.opacityModel.getNumber().floatValue() / 100.0f);
                }
                if (!SwingAnnotationProperties.useTextIconSelect(this.form) || (idx = this.textIcon.getSelectedIndex()) < 0 || idx >= this.textIconNames.length) break;
                SwingAnnotationProperties.applyTextIcon(this.form, this.textIconNames[idx]);
            }
        }
        SwingAnnotationProperties.updateAnnotationAppearance(this.decode_pdf, this.form);
        this.currentGUI.getAnnotationPanel().getAnnotationListener().selectAnnotation(this.form);
        this.currentGUI.getValues().setFormsChanged(true);
        this.currentGUI.setViewerTitle();
    }

    private static void applyTextIcon(FormObject form, String textIconName) {
        form.setName(506543413, textIconName.getBytes());
        float[] apSize = AnnotationUtils.getTextIconDimensions(textIconName);
        float[] formBounds = form.getFloatArray(573911876);
        form.setFloatArray(573911876, new float[]{formBounds[0], formBounds[3] - apSize[1], formBounds[0] + apSize[0], formBounds[3]});
    }

    private void applyLineWidth(FormObject form, int newWidth) {
        int oldWidth;
        PdfObject dict = form.getDictionary(4643);
        if (dict == null) {
            dict = new FormObject();
            form.setDictionary(4643, dict);
        }
        if ((oldWidth = dict.getInt(39)) == -1) {
            oldWidth = 1;
        }
        int deltaWidth = newWidth - oldWidth;
        dict.setIntNumber(39, newWidth);
        if (deltaWidth != 0) {
            switch (form.getNameAsConstant(1147962727)) {
                case 1654331: 
                case 473513525: 
                case 1014528638: 
                case 1110658926: 
                case 1160865142: 
                case 1230470778: {
                    SwingAnnotationProperties.applyWidthDifference(deltaWidth, form);
                }
            }
        }
        form.setTextStreamValue(29, AnnotationFactory.getCurrentDateAsString().getBytes());
        this.currentGUI.getAnnotationPanel().populateList(this.decode_pdf);
    }

    private static void applyFillColor(FormObject form, Color ic) {
        if (ic == null || ic.getAlpha() == 0) {
            form.setFloatArray(6419, new float[0]);
        } else {
            form.setFloatArray(6419, new float[]{(float)ic.getRed() / 255.0f, (float)ic.getGreen() / 255.0f, (float)ic.getBlue() / 255.0f});
        }
    }

    private static void applyStrokeColor(FormObject form, Color c2) {
        if (c2 == null || c2.getAlpha() == 0) {
            form.setFloatArray(19, new float[0]);
        } else {
            form.setFloatArray(19, new float[]{(float)c2.getRed() / 255.0f, (float)c2.getGreen() / 255.0f, (float)c2.getBlue() / 255.0f});
            FormObject popup = (FormObject)form.getDictionary(1061176672);
            if (popup != null) {
                PdfSwingPopup popupGUI = (PdfSwingPopup)popup.getGUIComponent();
                popupGUI.setColor(form.getFloatArray(19));
            }
        }
    }

    private static void applyWidthDifference(int deltaWidth, FormObject form) {
        float[] bounds = form.getFloatArray(573911876);
        bounds[0] = bounds[0] - (float)deltaWidth;
        bounds[1] = bounds[1] - (float)deltaWidth;
        bounds[2] = bounds[2] + (float)deltaWidth;
        bounds[3] = bounds[3] + (float)deltaWidth;
        form.setFloatArray(573911876, bounds);
    }

    private void applyFreeTextSpecificValues() {
        ((Component)this.form.getGUIComponent()).setBackground(this.icolorPanel.getBackground());
        String DSString = this.form.getTextStreamValue(5155);
        String fontName = AnnotationUtils.getFontNameForForm(this.form);
        if (this.fontSelector.getSelectedIndex() > 0) {
            fontName = (String)this.fontSelector.getSelectedItem();
            this.form.setDictionary(4384, new FormObject(4384));
        }
        DSString = DSString.replaceFirst("font:.*?;", "font: " + fontName + ' ' + this.fontSizeModel.getNumber().floatValue() + "pt;");
        DSString = DSString.replaceFirst("color:.*", "color:#" + Integer.toHexString(this.colorPanel.getBackground() != null ? this.colorPanel.getBackground().getRGB() : 0).substring(2));
        this.form.setTextStreamValue(5155, DSString.getBytes());
        this.form.setFloatNumber(4881, this.opacityModel.getNumber().floatValue() / 100.0f);
    }

    private void applyLinkSpecificValues() {
        String newURI = this.uriInput.getText();
        FormObject link = new FormObject(17);
        link.setName(608780341, "Action".getBytes());
        link.setName(35, "URI".getBytes());
        link.setTextStreamValue(2433561, newURI.getBytes());
        this.form.setDictionary(17, link);
        ((JComponent)this.form.getGUIComponent()).setToolTipText(newURI);
    }

    void loadFormObject(FormObject form) {
        this.setLocation((int)((double)this.currentGUI.getGlassPane().getLocationOnScreen().x + (this.currentGUI.getGlassPane().getBounds().getWidth() - (double)this.getWidth()) / 2.0), (int)((double)this.currentGUI.getGlassPane().getLocationOnScreen().y + (this.currentGUI.getGlassPane().getBounds().getHeight() - (double)this.getHeight()) / 2.0));
        this.form = form;
        this.contents.removeAll();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.ipadx = 10;
        this.gbc.ipady = 10;
        this.gbc.insets = new Insets(10, 10, 10, 10);
        this.addAuthorInput(this.contents);
        this.authorInput.setText(form.getTextStreamValue(36));
        if (SwingAnnotationProperties.useFontSelect(form)) {
            this.setupFont(form);
        }
        if (SwingAnnotationProperties.useTextIconSelect(form)) {
            this.setupIcon(form);
        }
        if (SwingAnnotationProperties.useURISelect(form)) {
            this.addURISelect(this.contents);
            String uri = form.getDictionary(17).getTextStreamValue(2433561);
            this.uriInput.setText(uri);
            this.uriInput.setColumns(20);
        }
        if (SwingAnnotationProperties.useStrokeColour(form)) {
            this.setupLineColor(form);
        }
        if (SwingAnnotationProperties.useFillColor(form)) {
            this.addFillColor(this.contents);
            Color ic = FormObject.generateColor(form.getFloatArray(6419));
            if (ic == null) {
                ic = new Color(0, 0, 0, 0);
            }
            this.icolorPanel.setBackground(ic);
        }
        if (SwingAnnotationProperties.useLineWidth(form)) {
            this.setupLineWidth(form);
        }
        if (SwingAnnotationProperties.useOpacity(form)) {
            this.addOpacity(this.contents);
            float opacityValue = form.getFloatNumber(4881);
            this.opacityModel.setValue((int)(opacityValue * 100.0f));
        }
        this.ok.requestFocusInWindow();
    }

    private void setupFont(FormObject form) {
        this.addFontSelector(this.contents);
        this.addFontSize(this.contents);
        String name = AnnotationUtils.getFontNameForForm(form);
        float size = AnnotationUtils.getFontSizeForForm(form);
        this.fontSelectorModel.removeElementAt(0);
        this.fontSelectorModel.insertElementAt(name, 0);
        this.fontSelectorModel.setSelectedItem(name);
        this.fontSize.setValue(Float.valueOf(size));
    }

    private void setupLineColor(FormObject form) {
        this.addStrokeColor(this.contents);
        Color c2 = FormObject.generateColor(form.getFloatArray(19));
        if (form.getNameAsConstant(1147962727) == 980909433) {
            c2 = AnnotationUtils.getFontColorFromFormAsHexString(form);
        }
        if (c2 == null) {
            c2 = new Color(0, 0, 0, 0);
        }
        this.colorPanel.setBackground(c2);
    }

    private void setupIcon(FormObject form) {
        this.addTextIconSelector(this.contents);
        String name = form.getName(506543413);
        if (name == null || name.isEmpty()) {
            name = "Note";
        }
        for (int i2 = 0; i2 != this.textIconNames.length; ++i2) {
            if (!name.equals(this.textIconNames[i2])) continue;
            this.textIcon.setSelectedIndex(i2);
        }
    }

    private void setupLineWidth(FormObject form) {
        this.addLineWidth(this.contents);
        PdfObject dict = form.getDictionary(4643);
        if (dict != null) {
            int lineWidth = form.getDictionary(4643).getInt(39);
            if (lineWidth == -1) {
                lineWidth = 1;
            }
            this.lineWidthModel.setValue(lineWidth);
        } else {
            this.lineWidthModel.setValue(1);
        }
    }

    private static boolean useFillColor(FormObject form) {
        int annotType = form.getNameAsConstant(1147962727);
        return annotType == 1160865142 || annotType == 1110658926 || annotType == 1230470778;
    }

    private static boolean useFontSelect(FormObject form) {
        return form.getNameAsConstant(1147962727) == 980909433;
    }

    private static boolean useTextIconSelect(FormObject form) {
        return form.getNameAsConstant(1147962727) == 607471684;
    }

    private static boolean useStrokeColour(FormObject form) {
        return form.getNameAsConstant(1147962727) != 473513531;
    }

    private static boolean useLineWidth(FormObject form) {
        int annotType = form.getNameAsConstant(1147962727);
        return annotType != 980909433 && annotType != 1919840408 && annotType != 607471684 && annotType != 473513531;
    }

    private static boolean useOpacity(FormObject form) {
        int annotType = form.getNameAsConstant(1147962727);
        return annotType != 473513531 && annotType != 607471684 && annotType != 1919840408;
    }

    private static boolean useURISelect(FormObject form) {
        return form.getNameAsConstant(1147962727) == 473513531;
    }

    private void addAuthorInput(JPanel dialog) {
        if (this.authorInput == null) {
            this.annotationAuthor = new JLabel("Author: ");
            this.authorInput = new JTextField();
        }
        dialog.add((Component)this.annotationAuthor, this.gbc);
        ++this.gbc.gridx;
        this.gbc.gridwidth = 3;
        this.gbc.fill = 2;
        dialog.add((Component)this.authorInput, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 0;
        ++this.gbc.gridy;
    }

    private void addStrokeColor(JPanel dialog) {
        if (this.colorPanel == null) {
            this.colorLabel = new JLabel("Color: ");
            this.colorPanel = new JPanel();
            this.colorPanel.setName("StrokeColor");
            this.colorPanel.setBorder(new LineBorder(Color.BLACK, 1));
            this.colorPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    Color c2 = JColorChooser.showDialog(SwingAnnotationProperties.this.decode_pdf, "Stroke Color", SwingAnnotationProperties.this.colorPanel.getBackground());
                    if (c2 != null) {
                        SwingAnnotationProperties.this.colorPanel.setBackground(new Color(c2.getRGB()));
                        SwingAnnotationProperties.this.opacityModel.setValue(Float.valueOf((float)c2.getAlpha() / 2.55f));
                    }
                }
            });
        }
        dialog.add((Component)this.colorLabel, this.gbc);
        ++this.gbc.gridx;
        dialog.add((Component)this.colorPanel, this.gbc);
        ++this.gbc.gridx;
        if (this.gbc.gridx == 4) {
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
        }
    }

    private void addFillColor(JPanel dialog) {
        if (this.icolorPanel == null) {
            this.icolorLabel = new JLabel("Fill Color: ");
            this.icolorPanel = new JPanel();
            this.icolorPanel.setName("FillColor");
            this.icolorPanel.setBorder(new LineBorder(Color.BLACK, 1));
            this.icolorPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    Color c2 = JColorChooser.showDialog(SwingAnnotationProperties.this.decode_pdf, "Fill Color", SwingAnnotationProperties.this.icolorPanel.getBackground());
                    if (c2 != null) {
                        SwingAnnotationProperties.this.icolorPanel.setBackground(new Color(c2.getRGB()));
                        SwingAnnotationProperties.this.opacityModel.setValue(Float.valueOf((float)c2.getAlpha() / 2.55f));
                    }
                }
            });
        }
        dialog.add((Component)this.icolorLabel, this.gbc);
        ++this.gbc.gridx;
        dialog.add((Component)this.icolorPanel, this.gbc);
        ++this.gbc.gridx;
        if (this.gbc.gridx == 4) {
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
        }
    }

    private void addLineWidth(JPanel dialog) {
        if (this.lineWidth == null) {
            this.lineWidthLabel = new JLabel("Line Width: ");
            this.lineWidthModel = new SpinnerNumberModel(2, 1, 12, 1);
            this.lineWidth = new JSpinner(this.lineWidthModel);
            this.lineWidth.setName("linewidth");
        }
        dialog.add((Component)this.lineWidthLabel, this.gbc);
        ++this.gbc.gridx;
        dialog.add((Component)this.lineWidth, this.gbc);
        ++this.gbc.gridx;
        if (this.gbc.gridx == 4) {
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
        }
    }

    private void addOpacity(JPanel dialog) {
        if (this.opacity == null) {
            this.opacityLabel = new JLabel("Opacity: ");
            this.opacityModel = new SpinnerNumberModel(100, 0, 100, 1);
            this.opacity = new JSpinner(this.opacityModel);
            this.opacity.setName("opacity");
        }
        dialog.add((Component)this.opacityLabel, this.gbc);
        ++this.gbc.gridx;
        dialog.add((Component)this.opacity, this.gbc);
        ++this.gbc.gridx;
        if (this.gbc.gridx == 4) {
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
        }
    }

    private void addFontSelector(JPanel dialog) {
        if (this.fontSelector == null) {
            this.fontSelectorLabel = new JLabel("Font: ");
            this.fontSelectorModel = new DefaultComboBoxModel<String>(new String[]{"", "Courier", "Courier-Bold", "Courier-BoldOblique", "Courier-Oblique", "Helvetica", "Helvetica-Bold", "Helvetica-BoldOblique", "Helvetica-Oblique", "Times-Bold", "Times-BoldItalic", "Times-Italic", "Times-Roman"});
            this.fontSelector = new JComboBox<String>(this.fontSelectorModel);
        }
        dialog.add((Component)this.fontSelectorLabel, this.gbc);
        ++this.gbc.gridx;
        dialog.add(this.fontSelector, this.gbc);
        ++this.gbc.gridx;
        if (this.gbc.gridx == 4) {
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
        }
    }

    private void addTextIconSelector(JPanel dialog) {
        if (this.textIcon == null) {
            this.iconSelectorLabel = new JLabel("Icon:  ");
            DefaultComboBoxModel<String> textIconModel = new DefaultComboBoxModel<String>(new String[]{"Check", "Checkmark", "Circle", "Comment", "Cross", "Cross Hairs", "Help", "Insert Text", "Key", "New Paragraph", "Text Note", "Paragraph", "Right Arrow", "Right Pointer", "Star", "Up Arrow", "Up-Left Arrow"});
            this.textIcon = new JComboBox<String>(textIconModel);
        }
        dialog.add((Component)this.iconSelectorLabel, this.gbc);
        ++this.gbc.gridx;
        dialog.add(this.textIcon, this.gbc);
        ++this.gbc.gridx;
        if (this.gbc.gridx == 4) {
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
        }
    }

    private void addFontSize(JPanel dialog) {
        if (this.fontSize == null) {
            this.fontSizeLabel = new JLabel("Font Size: ");
            this.fontSizeModel = new SpinnerNumberModel(6, 6, 24, 1);
            this.fontSize = new JSpinner(this.fontSizeModel);
        }
        dialog.add((Component)this.fontSizeLabel, this.gbc);
        ++this.gbc.gridx;
        dialog.add((Component)this.fontSize, this.gbc);
        ++this.gbc.gridx;
        if (this.gbc.gridx == 4) {
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
        }
    }

    private void addURISelect(JPanel dialog) {
        if (this.uriInput == null) {
            this.annotationURI = new JLabel("URL: ");
            this.uriInput = new JTextField();
        }
        dialog.add((Component)this.annotationURI, this.gbc);
        ++this.gbc.gridx;
        dialog.add((Component)this.uriInput, this.gbc);
        ++this.gbc.gridx;
        if (this.gbc.gridx == 4) {
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
        }
    }

    static void updateAnnotationAppearance(PdfDecoderInt decode_pdf, FormObject currentAnnot) {
        switch (currentAnnot.getNameAsConstant(1147962727)) {
            case 1654331: 
            case 473513525: 
            case 607471684: 
            case 980909433: 
            case 1014528638: 
            case 1110658926: 
            case 1160865142: 
            case 1230470778: 
            case 1919840408: {
                AnnotationUtils.createAPObjectForFormObject(currentAnnot, decode_pdf.getIO());
                SwingAPImageHandler apImageHandler = new SwingAPImageHandler(decode_pdf.getIO());
                apImageHandler.setAPImages(currentAnnot, (AbstractButton)currentAnnot.getGUIComponent());
                currentAnnot.setAppreancesUsed(true);
                break;
            }
            default: {
                ((AbstractButton)currentAnnot.getGUIComponent()).setIcon(new FixImageIcon(currentAnnot, AnnotationFactory.getIcon(currentAnnot, decode_pdf.getScaling()), 0));
            }
        }
        decode_pdf.getFormRenderer().displayComponentsOnscreen(decode_pdf.getPageNumber(), decode_pdf.getPageNumber());
        decode_pdf.getPages().forceRedraw();
        decode_pdf.repaint();
    }
}

