/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.ViewerCommands;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingMouseAnnotations;
import org.jpedal.examples.viewer.gui.swing.SwingMouseUtils;
import org.jpedal.io.annotation.AnnotationWriter;
import org.jpedal.io.annotation.FormWriter;
import org.jpedal.io.annotation.WritableAnnotation;
import org.jpedal.io.annotation.utils.AnnotationUtils;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class SwingAnnotationPanel {
    private ButtonGroup buttons;
    private JList<FormObject> annotList;
    private DefaultListModel<FormObject> listModel;
    private final SwingGUI currentGUI;
    private SwingMouseAnnotations mouseListener;
    private Object annotationType;
    private final JPanel panel;
    private final Comparator<FormObject> compareForms = (o1, o2) -> -(o1.getPageNumber() - o2.getPageNumber());
    private final ArrayList<WritableAnnotation> annotations = new ArrayList();

    public SwingAnnotationPanel(SwingGUI currentGUI) {
        this.currentGUI = currentGUI;
        this.panel = new JPanel();
        this.init();
    }

    public void populateList(PdfDecoderInt decode_pdf) {
        FormObject lastSelected = this.annotList.getSelectedValue();
        Object[] tempForms = decode_pdf.getFormRenderer().getFormComponents(null, ReturnValues.FORMOBJECTS_FROM_NAME, -1);
        FormObject[] formArray = (FormObject[])Arrays.copyOf(tempForms, tempForms.length, FormObject[].class);
        Arrays.sort(formArray, this.compareForms);
        this.listModel.clear();
        for (FormObject form : formArray) {
            boolean isLink;
            boolean bl2 = isLink = form.getNameAsConstant(1147962727) == 473513531;
            if (isLink) {
                isLink = false;
                FormObject link = (FormObject)form.getDictionary(17);
                if (link != null) {
                    isLink = "URI".equals(link.getName(35));
                }
            }
            if (!AnnotationUtils.isEditableAnnotation(form) && !isLink) continue;
            this.listModel.add(0, form);
        }
        for (int i2 = 0; i2 < this.annotations.size(); ++i2) {
            boolean isLink;
            WritableAnnotation annot = this.annotations.get(i2);
            FormObject form = annot.getFormObject();
            if (form == null) continue;
            boolean bl3 = isLink = form.getNameAsConstant(1147962727) == 473513531;
            if (isLink) {
                isLink = false;
                FormObject link = (FormObject)form.getDictionary(17);
                if (link != null) {
                    isLink = "URI".equals(link.getName(35));
                }
            }
            if (AnnotationUtils.isEditableAnnotation(form) || isLink) {
                this.listModel.add(0, form);
                continue;
            }
            this.annotations.remove(annot);
            --i2;
        }
        this.annotList.setSelectedValue(lastSelected, true);
    }

    public SwingMouseAnnotations getAnnotationListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new SwingMouseAnnotations(this.currentGUI.getPdfDecoder(), this.currentGUI);
        }
        return this.mouseListener;
    }

    public void dispose() {
        if (this.mouseListener != null) {
            this.mouseListener.dispose();
        }
        this.mouseListener = null;
        Enumeration<AbstractButton> theButtons = this.buttons.getElements();
        while (theButtons.hasMoreElements()) {
            AbstractButton button = theButtons.nextElement();
            SwingAnnotationPanel.removeListenersFromButtons(button);
            this.buttons.remove(button);
        }
        this.listModel.clear();
        for (ListSelectionListener listener : this.annotList.getListSelectionListeners()) {
            this.annotList.removeListSelectionListener(listener);
        }
    }

    private static void removeListenersFromButtons(AbstractButton button) {
        for (ActionListener actionListener : button.getActionListeners()) {
            button.removeActionListener(actionListener);
        }
        for (EventListener eventListener : button.getMouseListeners()) {
            button.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : button.getChangeListeners()) {
            button.removeChangeListener((ChangeListener)eventListener);
        }
    }

    private void init() {
        this.buttons = new ButtonGroup();
        this.createButton(this.buttons, "annotCircle.png", "annotCircleSelected.png", Messages.getMessage("PdfAnnotationTooltip.Circle"), WritableAnnotation.AnnotationType.CIRCLE);
        this.createButton(this.buttons, "annotSquare.png", "annotSquareSelected.png", Messages.getMessage("PdfAnnotationTooltip.Square"), WritableAnnotation.AnnotationType.SQUARE);
        this.createButton(this.buttons, "annotLine.png", "annotLineSelected.png", Messages.getMessage("PdfAnnotationTooltip.Line"), WritableAnnotation.AnnotationType.LINE);
        this.createButton(this.buttons, "annotInk.png", "annotInkSelected.png", Messages.getMessage("PdfAnnotationTooltip.Ink"), WritableAnnotation.AnnotationType.INK);
        this.createButton(this.buttons, "annotPolyLine.png", "annotPolylineSelected.png", Messages.getMessage("PdfAnnotationTooltip.Polyline"), WritableAnnotation.AnnotationType.POLYLINE);
        this.createButton(this.buttons, "annotPolygon.png", "annotPolygonSelected.png", Messages.getMessage("PdfAnnotationTooltip.Polygon"), WritableAnnotation.AnnotationType.POLYGON);
        this.createButton(this.buttons, "annotHighlight.png", "annotHighlightSelected.png", Messages.getMessage("PdfAnnotationTooltip.Highlight"), WritableAnnotation.AnnotationType.HIGHLIGHT);
        this.createButton(this.buttons, "annotText.png", "annotTextSelected.png", Messages.getMessage("PdfAnnotationTooltip.StickyNote"), WritableAnnotation.AnnotationType.TEXT);
        this.createButton(this.buttons, "annotFreeText.png", "annotFreeTextSelected.png", Messages.getMessage("PdfAnnotationTooltip.FreeText"), WritableAnnotation.AnnotationType.FREETEXT);
        this.createButton(this.buttons, "annotLink.png", "annotLinkSelected.png", Messages.getMessage("PdfAnnotationTooltip.Link"), WritableAnnotation.AnnotationType.LINK);
        this.addButtonToPanel(this.buttons);
    }

    private void addButtonToPanel(ButtonGroup buttons) {
        this.listModel = new DefaultListModel();
        this.annotList = new JList<FormObject>(this.listModel);
        FileListCellRenderer cellRenderer = new FileListCellRenderer();
        this.annotList.setCellRenderer(cellRenderer);
        ListListener annotListListener = new ListListener();
        this.annotList.addListSelectionListener(annotListListener);
        this.annotList.addMouseListener(annotListListener);
        JScrollPane scroller = new JScrollPane(this.annotList);
        Enumeration<AbstractButton> annotButtons = buttons.getElements();
        int buttonPadding = 5;
        this.panel.setLayout(new BoxLayout(this.panel, 3));
        while (annotButtons.hasMoreElements()) {
            this.panel.add(Box.createRigidArea(new Dimension(5, 5)));
            Box row = Box.createHorizontalBox();
            row.add(annotButtons.nextElement());
            if (annotButtons.hasMoreElements()) {
                row.add(Box.createRigidArea(new Dimension(5, 5)));
                row.add(annotButtons.nextElement());
            }
            this.panel.add(row);
        }
        Box listBox = Box.createHorizontalBox();
        listBox.add(scroller);
        this.panel.add(listBox);
        this.panel.add(Box.createRigidArea(new Dimension(5, 5)));
    }

    private void createButton(ButtonGroup buttons, String normalIcon, String selectedIcon, String toolTip, WritableAnnotation.AnnotationType type) {
        JToggleButton button = new JToggleButton(new ImageIcon(this.currentGUI.getGUICursor().getURLForImage(normalIcon)));
        button.setSelectedIcon(new ImageIcon(this.currentGUI.getGUICursor().getURLForImage(selectedIcon)));
        button.setToolTipText(toolTip);
        button.addActionListener(e2 -> {
            if (this.currentGUI.getPdfDecoder().getDisplayView() != 1) {
                this.currentGUI.showMessageDialog(Messages.getMessage("PageLayoutMessage.SinglePageOnly"));
                buttons.clearSelection();
            } else if (this.annotationType == type) {
                buttons.clearSelection();
                this.mouseListener.cancelCreation();
                this.annotationType = null;
            } else {
                this.mouseListener.setFormMode(FORMMODE.CREATION);
                this.annotationType = type;
            }
        });
        buttons.add(button);
    }

    public void clearListSelection() {
        this.annotList.clearSelection();
    }

    public void selectAnnotationInList(FormObject form) {
        this.annotList.setSelectedValue(form, true);
    }

    public static boolean addPanel() {
        String flattenFlag = System.getProperty("org.jpedal.flattenForm");
        return !"true".equalsIgnoreCase(flattenFlag);
    }

    public Object getAnnotationType() {
        return this.annotationType;
    }

    public void clearAnnotationType() {
        this.annotationType = null;
        this.buttons.clearSelection();
    }

    public boolean annotationAdded() {
        return !this.annotations.isEmpty();
    }

    public void clearAnnotations() {
        this.clearAnnotationType();
        this.annotations.clear();
    }

    public void addAnnotationForWriting(Object annot) {
        this.annotations.add((WritableAnnotation)annot);
    }

    public void saveAnnotations(String input, String output) {
        try {
            File original = new File(input);
            if (!original.exists()) {
                LogWriter.writeLog("Original file does not exist, can't save annotations at this time.");
                return;
            }
            File outputFile = new File(output);
            if (!outputFile.exists()) {
                outputFile.createNewFile();
            }
            AnnotationWriter.writeAnnotations(original, outputFile, this.annotations.toArray(new WritableAnnotation[0]));
        }
        catch (IOException ex) {
            LogWriter.writeLog("Exception: " + ex + " Can not create output file");
        }
    }

    public void saveAnnotationsWithFail(String input, String output) throws IOException {
        File original = new File(input);
        if (!original.exists()) {
            LogWriter.writeLog("Original file does not exist, can't save annotations at this time.");
            return;
        }
        File outputFile = new File(output);
        if (!outputFile.exists()) {
            outputFile.createNewFile();
        }
        AnnotationWriter.writeAnnotations(original, outputFile, this.annotations.toArray(new WritableAnnotation[0]));
    }

    public static void saveForms(String input, String output, Object[] objArr) {
        FormObject[] formArr = new FormObject[objArr.length];
        for (int i2 = 0; i2 < objArr.length; ++i2) {
            formArr[i2] = (FormObject)objArr[i2];
        }
        File inputFile = new File(input);
        File outputFile = new File(output);
        try {
            if (!inputFile.exists()) {
                LogWriter.writeLog("Original file does not exist, can't save Forms at this time.");
                return;
            }
            FormWriter.writeForms(inputFile, outputFile, formArr);
        }
        catch (IOException ex) {
            LogWriter.writeLog("Exception: " + ex + " Can not create output file");
        }
    }

    public JPanel getDisplayPanel() {
        return this.panel;
    }

    class ListListener
    extends MouseAdapter
    implements ListSelectionListener {
        int buttonID = -1;
        int clickX = -1;
        int clickY = -1;

        ListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e2) {
            int idx = SwingAnnotationPanel.this.annotList.getSelectedIndex();
            if (idx != -1) {
                FormObject form = (FormObject)SwingAnnotationPanel.this.listModel.getElementAt(idx);
                if (form.getPageNumber() != SwingAnnotationPanel.this.currentGUI.getPdfDecoder().getPageNumber()) {
                    SwingAnnotationPanel.this.currentGUI.getCommand().executeCommand(ViewerCommands.GOTO, new Object[]{Integer.toString(form.getPageNumber())});
                    SwingAnnotationPanel.this.currentGUI.decodePage();
                    SwingAnnotationPanel.this.currentGUI.getPdfDecoder().waitForDecodingToFinish();
                }
                SwingAnnotationPanel.this.clearAnnotationType();
                SwingAnnotationPanel.this.mouseListener.setFormMode(FORMMODE.EDIT);
                SwingAnnotationPanel.this.mouseListener.selectAnnotation(form);
                SwingAnnotationPanel.this.mouseListener.startComponentListener();
            }
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            this.buttonID = SwingMouseUtils.getMouseButton(e2);
            this.clickX = e2.getX();
            this.clickY = e2.getY();
            JList list = (JList)e2.getSource();
            int row = list.locationToIndex(e2.getPoint());
            list.clearSelection();
            list.setSelectedIndex(row);
            if (this.buttonID == 3) {
                SwingAnnotationPanel.this.mouseListener.showEditContextMenu(SwingAnnotationPanel.this.annotList, this.clickX, this.clickY);
            }
        }
    }

    class FileListCellRenderer
    extends DefaultListCellRenderer {
        private final JLabel label;
        private final Color textColor = Color.BLACK;
        private final Color selectedBackground = UIManager.getColor("List.selectionBackground");
        private final Color unselectedBackground = UIManager.getColor("List.background");
        private static final int borderSize = 1;

        FileListCellRenderer() {
            this.label = new JLabel();
            this.label.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean selected, boolean expanded) {
            String popupTitle;
            FormObject form = (FormObject)value;
            String type = PdfDictionary.showAsConstant(form.getNameAsConstant(1147962727));
            type = type.substring(type.indexOf(46) + 1);
            String file = "/org/jpedal/examples/viewer/res/annot" + type + ".png";
            String mStream = form.getTextStreamValue(29);
            String dateString = "indeterminate";
            if (mStream != null) {
                StringBuilder date = new StringBuilder(mStream);
                date.delete(0, 2);
                date.insert(10, ':');
                date.insert(13, ':');
                date.insert(16, ' ');
                String year = date.substring(0, 4);
                String day = date.substring(6, 8);
                date.delete(6, 8);
                date.delete(0, 4);
                date.insert(0, day);
                date.insert(4, year);
                date.insert(2, '/');
                date.insert(5, '/');
                date.insert(10, ' ');
                date.delete(19, date.length());
                dateString = date.toString();
            }
            if ((popupTitle = form.getTextStreamValue(36)) == null) {
                popupTitle = "";
            }
            this.label.setIcon(new ImageIcon(this.getClass().getResource(file)));
            String builder = "<html><p>Author: " + popupTitle + "</p><p>Page: " + form.getPageNumber() + "</p><p>Date: " + dateString + "</p></html>";
            this.label.setText(builder);
            if (selected) {
                this.label.setBackground(this.selectedBackground);
            } else {
                this.label.setBackground(this.unselectedBackground);
            }
            this.label.setForeground(this.textColor);
            if (index == 0) {
                this.label.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.BLACK));
            } else {
                this.label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK));
            }
            return this.label;
        }
    }

    public static enum FORMMODE {
        CREATION,
        EDIT;

    }
}

