/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.jpedal.utils.Messages;

public class SearchList
extends JList<String> {
    private final Map<Integer, Integer> textPages;
    private final Map<Integer, Object> textAreas;
    private final String pageStr;
    private String searchTerm = "";
    int NO_RESULTS_FOUND = 1;
    int SEARCH_COMPLETE_SUCCESSFULLY = 2;
    int SEARCH_INCOMPLETE = 4;
    int SEARCH_PRODUCED_ERROR = 8;

    public SearchList(DefaultListModel<String> listModel, Map<Integer, Integer> textPages, Map<Integer, Object> textAreas) {
        super(listModel);
        this.textPages = textPages;
        this.textAreas = textAreas;
        this.pageStr = Messages.getMessage("PdfViewerSearch.Page") + ' ';
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int index = this.locationToIndex(event.getPoint());
        Integer page = this.textPages.get(index);
        if (page != null) {
            return this.pageStr + page;
        }
        return null;
    }

    public Map<Integer, Integer> getTextPages() {
        return Collections.unmodifiableMap(this.textPages);
    }

    public Map<Integer, Object> textAreas() {
        return Collections.unmodifiableMap(this.textAreas);
    }

    public int getResultCount() {
        return this.textAreas.size();
    }

    public void setSearchTerm(String term) {
        this.searchTerm = term;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }
}

