/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.ViewerCommands;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingThumbnailPanel;
import org.jpedal.examples.viewer.utils.PrintStatus;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class FrameCloser
extends WindowAdapter {
    private final Commands currentCommands;
    private final SwingGUI currentGUI;
    private final PdfDecoderInt decode_pdf;
    private final SwingThumbnailPanel thumbnails;
    private final Values commonValues;
    private final PropertiesFile properties;

    public FrameCloser(Commands currentCommands, SwingGUI currentGUI, PdfDecoderInt decode_pdf, SwingThumbnailPanel thumbnails, Values commonValues, PropertiesFile properties) {
        this.currentCommands = currentCommands;
        this.currentGUI = currentGUI;
        this.decode_pdf = decode_pdf;
        this.thumbnails = thumbnails;
        this.commonValues = commonValues;
        this.properties = properties;
    }

    @Override
    public void windowClosing(WindowEvent e2) {
        if (SwingGUI.deletePropertiesOnExit) {
            String lastProperties = this.currentGUI.getPropertiesFileLocation();
            File f2 = new File(lastProperties);
            if (f2.exists()) {
                f2.delete();
            }
        } else {
            try {
                this.properties.setValue("lastDocumentPage", String.valueOf(this.commonValues.getCurrentPage()));
            }
            catch (Exception e1) {
                LogWriter.writeLog("Attempting to set propeties values " + e1);
            }
        }
        if (PrintStatus.isPrinting()) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerBusyPrinting.message"));
        }
        if (!Values.isProcessing()) {
            this.thumbnails.terminateDrawing();
            this.currentCommands.executeCommand(ViewerCommands.EXIT, null);
            this.decode_pdf.closePdfFile();
        } else {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
        }
    }
}

