/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.util.HashSet;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class ColorListCellRenderer
extends DefaultListCellRenderer {
    private final HashSet<String> commands;
    private final TreeSet<String> breaks;
    private final int width;

    public ColorListCellRenderer(HashSet<String> commands, TreeSet<String> breaks, int width) {
        this.commands = commands;
        this.breaks = breaks;
        this.width = width;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasCellFocus) {
        String command = value.toString();
        super.getListCellRendererComponent((JList<?>)list, "<html><body style='width: " + this.width + "px'>" + command + "</html>", index, isSelected, hasCellFocus);
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        if (this.commands.contains(command)) {
            if (this.breaks.contains(command)) {
                this.setForeground(Color.WHITE);
                this.setBackground(Color.RED);
            } else {
                this.setForeground(Color.BLUE);
            }
        }
        return this;
    }
}

