/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.BadLocationException;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingAnnotationPanel;
import org.jpedal.examples.viewer.gui.swing.SwingAnnotationProperties;
import org.jpedal.examples.viewer.gui.swing.SwingMouseUtils;
import org.jpedal.io.annotation.utils.AnnotationUtils;
import org.jpedal.objects.acroforms.creation.AnnotationFactory;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

class AnnotationEditor {
    private final PdfDecoder decode_pdf;
    private final SwingGUI currentGUI;
    private final SwingAnnotationPanel annotationPanel;
    private FormObject currentAnnot;
    private AnnotationTextInput textInput;
    private final JPopupMenu completeMenu;
    private final JMenuItem properties;
    private final JMenuItem delete;
    private final SwingAnnotationProperties annotationProperties;
    private final ResizeTab tabTopLeft;
    private final ResizeTab tabTop;
    private final ResizeTab tabTopRight;
    private final ResizeTab tabRight;
    private final ResizeTab tabBottomRight;
    private final ResizeTab tabBottom;
    private final ResizeTab tabBottomLeft;
    private final ResizeTab tabLeft;
    private final DragTab square;
    private static final int BORDER_WIDTH = 1;
    private final EditListener editListener = new EditListener();

    AnnotationEditor(PdfDecoder decode_pdf, SwingGUI currentGUI) {
        this.decode_pdf = decode_pdf;
        this.currentGUI = currentGUI;
        this.annotationPanel = currentGUI.getAnnotationPanel();
        this.annotationProperties = new SwingAnnotationProperties(decode_pdf, currentGUI);
        this.completeMenu = new JPopupMenu();
        this.delete = new JMenuItem(Messages.getMessage("PdfFormCreation.Delete"));
        this.delete.addActionListener(e2 -> {
            if (this.currentAnnot != null) {
                this.deleteSelectedAnnotation();
            }
            this.completeMenu.setVisible(false);
        });
        this.properties = new JMenuItem(Messages.getMessage("PdfFormCreation.Properties"));
        this.properties.addActionListener(e2 -> {
            if (this.currentAnnot != null) {
                this.annotationProperties.loadFormObject(this.currentAnnot);
                this.annotationProperties.setVisible(true);
                this.completeMenu.setVisible(false);
            }
        });
        this.completeMenu.add(this.delete);
        this.completeMenu.add(this.properties);
        this.square = new DragTab();
        this.tabTopLeft = new ResizeTab(true, false, false, true, 6);
        this.tabTop = new ResizeTab(false, false, false, true, 8);
        this.tabTopRight = new ResizeTab(false, false, true, true, 7);
        this.tabRight = new ResizeTab(false, false, true, false, 11);
        this.tabBottomRight = new ResizeTab(false, true, true, false, 5);
        this.tabBottom = new ResizeTab(false, true, false, false, 9);
        this.tabBottomLeft = new ResizeTab(true, true, false, false, 4);
        this.tabLeft = new ResizeTab(true, false, false, false, 10);
        this.addTabsToContainer(decode_pdf);
    }

    void dispose() {
        this.currentAnnot = null;
        this.decode_pdf.remove(this.square);
        this.decode_pdf.remove(this.tabTopLeft);
        this.decode_pdf.remove(this.tabTop);
        this.decode_pdf.remove(this.tabTopRight);
        this.decode_pdf.remove(this.tabRight);
        this.decode_pdf.remove(this.tabBottomRight);
        this.decode_pdf.remove(this.tabBottom);
        this.decode_pdf.remove(this.tabBottomLeft);
        this.decode_pdf.remove(this.tabLeft);
        this.annotationProperties.dispose();
        if (this.textInput != null) {
            this.decode_pdf.remove(this.textInput);
            this.textInput.removeAll();
            this.textInput = null;
        }
    }

    private void addTabsToContainer(Container c2) {
        c2.add(this.square);
        c2.setComponentZOrder(this.square, 0);
        c2.add(this.tabTopLeft);
        c2.setComponentZOrder(this.tabTopLeft, 0);
        c2.add(this.tabTop);
        c2.setComponentZOrder(this.tabTop, 0);
        c2.add(this.tabTopRight);
        c2.setComponentZOrder(this.tabTopRight, 0);
        c2.add(this.tabRight);
        c2.setComponentZOrder(this.tabRight, 0);
        c2.add(this.tabBottomRight);
        c2.setComponentZOrder(this.tabBottomRight, 0);
        c2.add(this.tabBottom);
        c2.setComponentZOrder(this.tabBottom, 0);
        c2.add(this.tabBottomLeft);
        c2.setComponentZOrder(this.tabBottomLeft, 0);
        c2.add(this.tabLeft);
        c2.setComponentZOrder(this.tabLeft, 0);
    }

    private void deleteSelectedAnnotation() {
        FormObject link;
        List<FormObject> fo = this.decode_pdf.getFormRenderer().getCompData().getFormList(true)[this.decode_pdf.getPageNumber()];
        fo.remove(this.currentAnnot);
        Component comp = (Component)this.currentAnnot.getGUIComponent();
        if (comp != null) {
            comp.getParent().remove(comp);
        }
        this.currentAnnot.setConstant(608780341, -1);
        this.currentAnnot.setConstant(1147962727, -1);
        FormObject popup = (FormObject)this.currentAnnot.getDictionary(1061176672);
        if (popup != null) {
            popup.setConstant(608780341, -1);
            popup.setConstant(1147962727, -1);
            fo.remove(popup);
            Component comp2 = (Component)popup.getGUIComponent();
            if (comp2 != null && comp2.getParent() != null) {
                comp2.getParent().remove(comp2);
            }
            popup.setConstant(608780341, -1);
            popup.setConstant(1147962727, -1);
        }
        if ((link = (FormObject)this.currentAnnot.getDictionary(17)) != null) {
            link.setConstant(608780341, -1);
            link.setConstant(1147962727, -1);
            fo.remove(link);
        }
        this.decode_pdf.repaint();
        if (!this.currentGUI.getValues().isFormsChanged()) {
            this.currentGUI.getValues().setFormsChanged(true);
            this.currentGUI.setViewerTitle();
        }
        this.deselectAnnotation();
        this.annotationPanel.populateList(this.decode_pdf);
    }

    void showEditContextMenu(Component invoker, int x2, int y2) {
        this.completeMenu.show(invoker, x2, y2);
    }

    void updateResizeTabs() {
        if (this.currentAnnot != null) {
            this.showAnnotationResizeTabs(this.currentAnnot.getFloatArray(573911876));
        }
    }

    private void showAnnotationResizeTabs(float[] rect) {
        if (this.tabTopLeft.getParent() == null) {
            this.addTabsToContainer(this.decode_pdf);
        }
        int[] iRect = this.convertCoordsFromPDFtoPane(rect);
        int tlX = iRect[0] - 1;
        int tlY = iRect[1] + 1;
        int brX = tlX + Math.abs(iRect[2]) + 2;
        int brY = tlY + Math.abs(iRect[3]) + 2;
        this.square.setSize(brX - tlX, brY - tlY);
        this.square.setLocation(tlX, tlY);
        this.square.setVisible(true);
        boolean isResizable = AnnotationUtils.isResizableAnnotation(this.currentAnnot);
        if (isResizable) {
            tlX -= this.tabTopLeft.getWidth() / 2;
            tlY -= this.tabTopLeft.getHeight() / 2;
            brX -= this.tabTopLeft.getWidth() / 2;
            brY -= this.tabTopLeft.getHeight() / 2;
            switch (this.currentGUI.getRotation()) {
                case 90: {
                    this.positionOrdinalResizeTabs(brX, brY, tlX, brY, tlX, tlY, brX, tlY);
                    this.positionCardinalResizeTabs(brX, tlY + (brY - tlY) / 2, tlX + (brX - tlX) / 2, brY, tlX, tlY + (brY - tlY) / 2, tlX + (brX - tlX) / 2, tlY);
                    break;
                }
                case 180: {
                    this.positionOrdinalResizeTabs(tlX, brY, tlX, tlY, brX, tlY, brX, brY);
                    this.positionCardinalResizeTabs(tlX + (brX - tlX) / 2, brY, tlX, tlY + (brY - tlY) / 2, tlX + (brX - tlX) / 2, tlY, brX, tlY + (brY - tlY) / 2);
                    break;
                }
                case 270: {
                    this.positionOrdinalResizeTabs(tlX, tlY, brX, tlY, brX, brY, tlX, brY);
                    this.positionCardinalResizeTabs(tlX, tlY + (brY - tlY) / 2, tlX + (brX - tlX) / 2, tlY, brX, tlY + (brY - tlY) / 2, tlX + (brX - tlX) / 2, brY);
                    break;
                }
                default: {
                    this.positionOrdinalResizeTabs(brX, tlY, brX, brY, tlX, brY, tlX, tlY);
                    this.positionCardinalResizeTabs(tlX + (brX - tlX) / 2, tlY, brX, tlY + (brY - tlY) / 2, tlX + (brX - tlX) / 2, brY, tlX, tlY + (brY - tlY) / 2);
                }
            }
        }
        this.setResizeTabVisibility(isResizable);
    }

    private int[] convertCoordsFromPDFtoPane(float[] rect) {
        int x1 = (int)rect[0];
        int x2 = (int)rect[2];
        int y1 = (int)rect[1];
        int y2 = (int)rect[3];
        Point p2 = SwingMouseUtils.getGlassPaneCoordsInSingleDisplayMode(x1, y1, this.decode_pdf, this.currentGUI, this.currentGUI.getValues());
        x1 = p2.x;
        y1 = p2.y;
        p2 = SwingMouseUtils.getGlassPaneCoordsInSingleDisplayMode(x2, y2, this.decode_pdf, this.currentGUI, this.currentGUI.getValues());
        x2 = p2.x;
        y2 = p2.y;
        int height = y2 - y1;
        int width = x2 - x1;
        switch (this.currentGUI.getRotation()) {
            case 90: {
                y2 -= height;
                break;
            }
            case 180: {
                x1 += width;
                y2 -= height;
                break;
            }
            case 270: {
                x1 += width;
            }
        }
        return new int[]{x1, y2, width, height};
    }

    private void setResizeTabVisibility(boolean isResizable) {
        this.tabTopLeft.setVisible(isResizable);
        this.tabTop.setVisible(isResizable);
        this.tabTopRight.setVisible(isResizable);
        this.tabRight.setVisible(isResizable);
        this.tabBottomRight.setVisible(isResizable);
        this.tabBottom.setVisible(isResizable);
        this.tabBottomLeft.setVisible(isResizable);
        this.tabLeft.setVisible(isResizable);
    }

    private void positionOrdinalResizeTabs(int neX, int neY, int seX, int seY, int swX, int swY, int nwX, int nwY) {
        this.tabTopRight.setLocation(neX, neY);
        this.tabBottomRight.setLocation(seX, seY);
        this.tabBottomLeft.setLocation(swX, swY);
        this.tabTopLeft.setLocation(nwX, nwY);
    }

    private void positionCardinalResizeTabs(int nX, int nY, int eX, int eY, int sX, int sY, int wX, int wY) {
        this.tabTop.setLocation(nX, nY);
        this.tabRight.setLocation(eX, eY);
        this.tabBottom.setLocation(sX, sY);
        this.tabLeft.setLocation(wX, wY);
    }

    void hideAnnotationResizeTabs() {
        this.square.setLocation(0, 0);
        this.square.setVisible(false);
        this.tabTopLeft.setLocation(0, 0);
        this.tabTopLeft.setVisible(false);
        this.tabTop.setLocation(0, 0);
        this.tabTop.setVisible(false);
        this.tabTopRight.setLocation(0, 0);
        this.tabTopRight.setVisible(false);
        this.tabRight.setLocation(0, 0);
        this.tabRight.setVisible(false);
        this.tabBottomRight.setLocation(0, 0);
        this.tabBottomRight.setVisible(false);
        this.tabBottom.setLocation(0, 0);
        this.tabBottom.setVisible(false);
        this.tabBottomLeft.setLocation(0, 0);
        this.tabBottomLeft.setVisible(false);
        this.tabLeft.setLocation(0, 0);
        this.tabLeft.setVisible(false);
        this.annotationPanel.clearListSelection();
    }

    void selectAnnotation(FormObject f2) {
        this.currentAnnot = f2;
        if (this.textInput == null) {
            this.showAnnotationResizeTabs(this.currentAnnot.getFloatArray(573911876));
        }
        this.annotationPanel.selectAnnotationInList(f2);
    }

    void deselectAnnotation() {
        if (this.textInput != null && this.currentAnnot != null) {
            this.deselectTextInput();
        }
        this.stopComponentListener();
        this.currentAnnot = null;
    }

    private void deselectTextInput() {
        String text = ((AbstractButton)this.currentAnnot.getGUIComponent()).getText();
        if (text != null && !text.equals(this.textInput.getText()) && !this.currentGUI.getValues().isFormsChanged()) {
            this.currentGUI.getValues().setFormsChanged(true);
            this.currentGUI.setViewerTitle();
        }
        try {
            String content = this.textInput.getDocument().getText(0, this.textInput.getDocument().getLength());
            this.currentAnnot.setTextStreamValue(1216184967, content);
            this.currentAnnot.setTextStreamValue(8723, this.textInput.getText());
            ((AbstractButton)this.currentAnnot.getGUIComponent()).setText(content);
        }
        catch (BadLocationException ex) {
            LogWriter.writeLog("Exception caused when saving updated text. " + ex.getMessage());
        }
        this.textInput.setVisible(false);
        this.decode_pdf.remove(this.textInput);
        SwingAnnotationProperties.updateAnnotationAppearance(this.decode_pdf, this.currentAnnot);
        ((Component)this.currentAnnot.getGUIComponent()).setVisible(true);
        this.textInput = null;
    }

    void selectAnnotation(int x2, int y2) {
        FormObject f2;
        Point p2 = SwingMouseUtils.getCoordsOnPage(x2, y2, this.decode_pdf.getPageNumber(), this.decode_pdf, this.currentGUI, this.currentGUI.getValues());
        if (p2 != null && (f2 = AnnotationUtils.isOverForm(this.decode_pdf, p2.x, p2.y, 5)) != null && AnnotationUtils.isEditableAnnotation(f2)) {
            this.selectAnnotation(f2);
            this.annotationPanel.selectAnnotationInList(f2);
        }
    }

    private void updateAnnotationPosition(Rectangle r2) {
        Rectangle original = this.currentAnnot.getBoundingRectangle();
        float scaleX = (float)r2.width / (float)original.width;
        float scaleY = (float)r2.height / (float)original.height;
        float offsetX = r2.x - original.x;
        float offsetY = r2.y - original.y;
        switch (this.currentAnnot.getNameAsConstant(1147962727)) {
            case 1014528638: 
            case 1230470778: {
                float[] values = this.currentAnnot.getFloatArray(1600681863);
                for (int i2 = 0; i2 != values.length; ++i2) {
                    if (i2 % 2 == 0) {
                        int n2 = i2;
                        values[n2] = values[n2] + offsetX;
                        values[i2] = (float)r2.x + (values[i2] - (float)r2.x) * scaleX;
                        continue;
                    }
                    int n3 = i2;
                    values[n3] = values[n3] + offsetY;
                    values[i2] = (float)r2.y + (values[i2] - (float)r2.y) * scaleY;
                }
                this.currentAnnot.setFloatArray(1600681863, values);
                break;
            }
            case 473513525: {
                float[] values = this.currentAnnot.getFloatArray(28);
                for (int i3 = 0; i3 != values.length; ++i3) {
                    if (i3 % 2 == 0) {
                        int n4 = i3;
                        values[n4] = values[n4] + offsetX;
                        values[i3] = (float)r2.x + (values[i3] - (float)r2.x) * scaleX;
                        continue;
                    }
                    int n5 = i3;
                    values[n5] = values[n5] + offsetY;
                    values[i3] = (float)r2.y + (values[i3] - (float)r2.y) * scaleY;
                }
                this.currentAnnot.setFloatArray(1600681863, values);
                break;
            }
            case 1654331: {
                float[][] verts = this.currentAnnot.getFloat2DArray(475169151);
                AnnotationEditor.updateInkListArray(verts, original, offsetX, offsetY, scaleX, scaleY);
                this.currentAnnot.setFloat2DArray(475169151, verts);
            }
        }
        this.currentAnnot.setFloatArray(573911876, AnnotationUtils.validateCoordinates(r2.x, r2.y, r2.x + r2.width, r2.y + r2.height));
        this.currentAnnot.setTextStreamValue(29, AnnotationFactory.getCurrentDateAsString().getBytes());
        this.currentGUI.getAnnotationPanel().populateList(this.decode_pdf);
    }

    private static void updateInkListArray(float[][] verts, Rectangle formsBounds, float offsetX, float offsetY, float scaleX, float scaleY) {
        for (int i2 = 0; i2 != verts.length; ++i2) {
            for (int j2 = 0; j2 != verts[i2].length; ++j2) {
                float value = verts[i2][j2];
                if (j2 % 2 == 0) {
                    value = (float)formsBounds.x + (value - (float)formsBounds.x) * scaleX;
                    value += offsetX;
                } else {
                    value = (float)formsBounds.y + (value - (float)formsBounds.y) * scaleY;
                    value += offsetY;
                }
                verts[i2][j2] = value;
            }
        }
    }

    void clearCurrentAnnotation() {
        if (this.textInput != null && this.currentAnnot != null) {
            this.deselectTextInput();
        }
        this.currentAnnot = null;
    }

    boolean isEditing() {
        return this.currentAnnot != null;
    }

    void openPropertiesWindow() {
        if (this.currentAnnot != null) {
            this.annotationProperties.loadFormObject(this.currentAnnot);
            this.annotationProperties.setVisible(true);
            this.completeMenu.setVisible(false);
        }
    }

    void startComponentListener() {
        this.decode_pdf.addComponentListener(this.editListener);
    }

    private void stopComponentListener() {
        if (this.currentAnnot != null) {
            this.hideAnnotationResizeTabs();
            ((Component)this.currentAnnot.getGUIComponent()).removeComponentListener(this.editListener);
            this.currentAnnot = null;
        }
        this.decode_pdf.removeComponentListener(this.editListener);
    }

    void showTextInput() {
        if (this.currentAnnot != null) {
            byte[] DSString;
            ((Component)this.currentAnnot.getGUIComponent()).setVisible(false);
            if (this.textInput == null) {
                this.textInput = new AnnotationTextInput();
            }
            if ((DSString = this.currentAnnot.getTextStreamValueAsByte(5155)) != null) {
                AnnotationFactory.loadFontValues(DSString, this.textInput, this.decode_pdf.getScaling());
            }
            this.textInput.setBounds(((Component)this.currentAnnot.getGUIComponent()).getBounds());
            byte[] contents = this.currentAnnot.getTextStreamValueAsByte(1216184967);
            if (contents != null) {
                this.textInput.setText(new String(contents));
            } else {
                String rc = this.currentAnnot.getTextStreamValue(8723);
                if (rc != null) {
                    this.textInput.setText(rc);
                }
            }
            this.decode_pdf.add(this.textInput);
            this.textInput.setVisible(true);
            this.textInput.setBounds(((Component)this.currentAnnot.getGUIComponent()).getBounds());
            this.textInput.requestFocusInWindow();
            this.hideAnnotationResizeTabs();
            this.currentGUI.getValues().setFormsChanged(true);
            this.currentGUI.setViewerTitle();
        }
    }

    class AnnotationTextInput
    extends JTextArea {
        AnnotationTextInput() {
            this.init();
        }

        private void init() {
            this.setBorder(new LineBorder(Color.BLACK, 1));
            this.setTabSize(3);
        }
    }

    private class DashedBorder
    extends AbstractBorder {
        private DashedBorder() {
        }

        @Override
        public void paintBorder(Component comp, Graphics g2, int x2, int y2, int w2, int h2) {
            Graphics2D gg = (Graphics2D)g2;
            gg.setColor(new Color(0.1607f, 0.4784f, 0.8f));
            gg.setStroke(new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f));
            gg.drawRect(x2 + 1, y2 + 1, w2 - 2, h2 - 2);
        }
    }

    class DragTab
    extends JPanel {
        DragTab() {
            this.init();
        }

        private void init() {
            this.setOpaque(false);
            DragListener dragger = new DragListener();
            this.addMouseListener(dragger);
            this.addMouseMotionListener(dragger);
            this.setBorder(new DashedBorder());
        }
    }

    class ResizeTab
    extends JPanel {
        ResizeTab(boolean alterOriginX, boolean alterOriginY, boolean alterWidth, boolean alterHeight, int resizeCursorDirection) {
            this.init(alterOriginX, alterOriginY, alterWidth, alterHeight);
            this.setCursor(Cursor.getPredefinedCursor(resizeCursorDirection));
        }

        private void init(boolean alterOriginX, boolean alterOriginY, boolean alterWidth, boolean alterHeight) {
            this.setBackground(Color.LIGHT_GRAY);
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.setSize(10, 10);
            this.setVisible(false);
            ResizeTabListener listener = new ResizeTabListener(alterOriginX, alterOriginY, alterWidth, alterHeight);
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
        }
    }

    class ResizeTabListener
    extends MouseAdapter {
        private final boolean alterOriginX;
        private final boolean alterOriginY;
        private final boolean alterWidth;
        private final boolean alterHeight;
        private float sx;
        private float sy;
        private boolean primaryButton;
        private Rectangle resizeBounds;

        ResizeTabListener(boolean aOriginX, boolean aOriginY, boolean aWidth, boolean aHeight) {
            this.alterOriginX = aOriginX;
            this.alterOriginY = aOriginY;
            this.alterWidth = aWidth;
            this.alterHeight = aHeight;
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            this.resizeBounds = null;
            if (AnnotationEditor.this.currentAnnot == null || !AnnotationUtils.isResizableAnnotation(AnnotationEditor.this.currentAnnot)) {
                return;
            }
            this.primaryButton = SwingMouseUtils.getMouseButton(e2) == 1;
            Point compCoords = SwingUtilities.convertPoint((Component)e2.getSource(), e2.getX(), e2.getY(), AnnotationEditor.this.decode_pdf);
            Point p2 = SwingMouseUtils.getCoordsOnPage((int)compCoords.getX(), (int)compCoords.getY(), AnnotationEditor.this.decode_pdf.getPageNumber(), AnnotationEditor.this.decode_pdf, AnnotationEditor.this.currentGUI, AnnotationEditor.this.currentGUI.getValues());
            if (p2 != null) {
                this.sx = p2.x;
                this.sy = p2.y;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (AnnotationEditor.this.currentAnnot == null || !AnnotationUtils.isResizableAnnotation(AnnotationEditor.this.currentAnnot)) {
                return;
            }
            if (this.resizeBounds != null) {
                AnnotationEditor.this.updateAnnotationPosition(this.resizeBounds);
            }
            SwingAnnotationProperties.updateAnnotationAppearance(AnnotationEditor.this.decode_pdf, AnnotationEditor.this.currentAnnot);
            AnnotationEditor.this.currentGUI.getAnnotationPanel().getAnnotationListener().selectAnnotation(AnnotationEditor.this.currentAnnot);
            if (AnnotationEditor.this.currentAnnot.getNameAsConstant(1147962727) == 980909433) {
                AnnotationEditor.this.showTextInput();
                AnnotationEditor.this.deselectTextInput();
                AnnotationEditor.this.selectAnnotation(AnnotationEditor.this.currentAnnot);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            if (!this.primaryButton || AnnotationEditor.this.currentAnnot == null || !AnnotationUtils.isResizableAnnotation(AnnotationEditor.this.currentAnnot)) {
                return;
            }
            Point compCoords = SwingUtilities.convertPoint((Component)e2.getSource(), e2.getX(), e2.getY(), AnnotationEditor.this.decode_pdf);
            Point p2 = SwingMouseUtils.getCoordsOnPage((int)compCoords.getX(), (int)compCoords.getY(), AnnotationEditor.this.decode_pdf.getPageNumber(), AnnotationEditor.this.decode_pdf, AnnotationEditor.this.currentGUI, AnnotationEditor.this.currentGUI.getValues());
            if (!AnnotationEditor.this.currentGUI.getValues().isFormsChanged()) {
                AnnotationEditor.this.currentGUI.getValues().setFormsChanged(true);
                AnnotationEditor.this.currentGUI.setViewerTitle();
            }
            if (this.resizeBounds == null) {
                this.resizeBounds = AnnotationEditor.this.currentAnnot.getBoundingRectangle();
            }
            if (p2 != null) {
                this.resizeTabLocations(this.resizeBounds, this.sx, this.sy, p2.x, p2.y);
                this.sx = p2.x;
                this.sy = p2.y;
            }
            AnnotationEditor.this.showAnnotationResizeTabs(AnnotationUtils.validateCoordinates(this.resizeBounds.x, this.resizeBounds.y, this.resizeBounds.x + this.resizeBounds.width, this.resizeBounds.y + this.resizeBounds.height));
        }

        private void resizeTabLocations(Rectangle newLocation, float x1, float y1, float x2, float y2) {
            int lX1 = AnnotationEditor.this.decode_pdf.getPdfPageData().getCropBoxX(AnnotationEditor.this.decode_pdf.getPageNumber());
            int lY1 = AnnotationEditor.this.decode_pdf.getPdfPageData().getCropBoxY(AnnotationEditor.this.decode_pdf.getPageNumber());
            int lX2 = AnnotationEditor.this.decode_pdf.getPdfPageData().getCropBoxWidth(AnnotationEditor.this.decode_pdf.getPageNumber()) + lX1;
            int lY2 = AnnotationEditor.this.decode_pdf.getPdfPageData().getCropBoxHeight(AnnotationEditor.this.decode_pdf.getPageNumber()) + lY1;
            if (this.alterOriginX) {
                if ((float)newLocation.x + (x2 - x1) > (float)lX1 && x2 > (float)lX1) {
                    if (!(x2 - x1 > 0.0f) || !((float)newLocation.width <= Math.abs(x2 - x1))) {
                        if (newLocation.width > 1 || !(x2 >= (float)(newLocation.width + newLocation.x))) {
                            newLocation.x = (int)((float)newLocation.x + (x2 - x1));
                            newLocation.width = (int)((float)newLocation.width - (x2 - x1));
                        }
                    } else {
                        newLocation.x += newLocation.width - 1;
                        newLocation.width = 1;
                    }
                } else {
                    newLocation.width += newLocation.x - lX1;
                    newLocation.x = lX1;
                }
            }
            if (this.alterOriginY) {
                if ((float)newLocation.y + (y2 - y1) > (float)lY1 && y2 > (float)lY1) {
                    if (!(y2 - y1 > 0.0f) || !((float)newLocation.height <= Math.abs(y2 - y1))) {
                        if (newLocation.height > 1 || !(y2 >= (float)(newLocation.height + newLocation.y))) {
                            newLocation.y = (int)((float)newLocation.y + (y2 - y1));
                            newLocation.height = (int)((float)newLocation.height - (y2 - y1));
                        }
                    } else {
                        newLocation.y += newLocation.height - 1;
                        newLocation.height = 1;
                    }
                } else {
                    newLocation.height += newLocation.y - lY1;
                    newLocation.y = lY1;
                }
            }
            if (this.alterWidth) {
                if ((float)(newLocation.x + newLocation.width) + (x2 - x1) < (float)lX2 && x2 < (float)lX2) {
                    if (!(x2 - x1 < 0.0f) || !((float)newLocation.width <= Math.abs(x2 - x1))) {
                        if (newLocation.width > 1 || !(x2 < (float)newLocation.x)) {
                            newLocation.width = (int)((float)newLocation.width + (x2 - x1));
                        }
                    } else {
                        newLocation.width = 1;
                    }
                } else {
                    newLocation.width = lX2 - newLocation.x;
                }
            }
            if (this.alterHeight) {
                if ((float)(newLocation.y + newLocation.height) + (y2 - y1) < (float)lY2 && y2 < (float)lY2) {
                    if (!(y2 - y1 < 0.0f) || !((float)newLocation.height <= Math.abs(y2 - y1))) {
                        if (newLocation.height > 1 || !(y2 < (float)newLocation.y)) {
                            newLocation.height = (int)((float)newLocation.height + (y2 - y1));
                        }
                    } else {
                        newLocation.height = 1;
                    }
                } else {
                    newLocation.height = lY2 - newLocation.y;
                }
            }
        }
    }

    class DragListener
    extends MouseAdapter {
        float sx;
        float sy;
        boolean primaryButton;
        Rectangle newLocation;

        DragListener() {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (AnnotationEditor.this.currentAnnot != null) {
                Point compCoords;
                Point p2;
                this.newLocation = null;
                AnnotationEditor.this.square.requestFocus();
                boolean bl2 = this.primaryButton = SwingMouseUtils.getMouseButton(e2) == 1;
                if (AnnotationUtils.isDraggableAnnotation(AnnotationEditor.this.currentAnnot) && (p2 = SwingMouseUtils.getCoordsOnPage((int)(compCoords = SwingUtilities.convertPoint((Component)e2.getSource(), e2.getX(), e2.getY(), AnnotationEditor.this.decode_pdf)).getX(), (int)compCoords.getY(), AnnotationEditor.this.decode_pdf.getPageNumber(), AnnotationEditor.this.decode_pdf, AnnotationEditor.this.currentGUI, AnnotationEditor.this.currentGUI.getValues())) != null) {
                    this.sx = p2.x;
                    this.sy = p2.y;
                }
            } else {
                AnnotationEditor.this.deselectAnnotation();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (AnnotationEditor.this.currentAnnot != null) {
                if (AnnotationUtils.isDraggableAnnotation(AnnotationEditor.this.currentAnnot)) {
                    this.sx = 0.0f;
                    this.sy = 0.0f;
                    if (this.newLocation != null) {
                        AnnotationEditor.this.updateAnnotationPosition(this.newLocation);
                    }
                    SwingAnnotationProperties.updateAnnotationAppearance(AnnotationEditor.this.decode_pdf, AnnotationEditor.this.currentAnnot);
                    AnnotationEditor.this.currentGUI.getAnnotationPanel().getAnnotationListener().selectAnnotation(AnnotationEditor.this.currentAnnot);
                }
            } else {
                AnnotationEditor.this.deselectAnnotation();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            if (AnnotationEditor.this.currentAnnot != null) {
                switch (e2.getClickCount()) {
                    case 1: {
                        if (SwingMouseUtils.getMouseButton(e2) != 3) break;
                        AnnotationEditor.this.properties.setVisible(true);
                        AnnotationEditor.this.delete.setVisible(true);
                        Point componentPoint = SwingUtilities.convertPoint(e2.getComponent(), e2.getX() - AnnotationEditor.this.decode_pdf.getX(), e2.getY() - AnnotationEditor.this.decode_pdf.getY(), AnnotationEditor.this.currentGUI.getGlassPane());
                        AnnotationEditor.this.completeMenu.show(AnnotationEditor.this.decode_pdf, (int)componentPoint.getX(), (int)componentPoint.getY());
                        AnnotationEditor.this.showAnnotationResizeTabs(AnnotationEditor.this.currentAnnot.getFloatArray(573911876));
                        break;
                    }
                    case 2: {
                        if (SwingMouseUtils.getMouseButton(e2) != 1) break;
                        Component com = (Component)AnnotationEditor.this.currentAnnot.getGUIComponent();
                        int count = 2;
                        if (AnnotationEditor.this.currentAnnot.getNameAsConstant(1147962727) == 980909433) {
                            AnnotationEditor.this.showTextInput();
                            com = AnnotationEditor.this.textInput;
                            count = 1;
                        }
                        Point componentPoint = SwingUtilities.convertPoint(e2.getComponent(), e2.getX(), e2.getY(), com);
                        com.dispatchEvent(new MouseEvent(com, 501, e2.getWhen(), e2.getModifiersEx(), componentPoint.x, componentPoint.y, count, e2.isPopupTrigger()));
                        com.dispatchEvent(new MouseEvent(com, 500, e2.getWhen(), e2.getModifiersEx(), componentPoint.x, componentPoint.y, count, e2.isPopupTrigger()));
                        com.dispatchEvent(new MouseEvent(com, 502, e2.getWhen(), e2.getModifiersEx(), componentPoint.x, componentPoint.y, count, e2.isPopupTrigger()));
                    }
                }
            } else {
                AnnotationEditor.this.deselectAnnotation();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            if (AnnotationEditor.this.currentAnnot != null) {
                this.selectAnnotation(e2);
            } else {
                AnnotationEditor.this.deselectAnnotation();
            }
        }

        private void selectAnnotation(MouseEvent e2) {
            if (this.primaryButton && AnnotationUtils.isDraggableAnnotation(AnnotationEditor.this.currentAnnot)) {
                Point compCoords = SwingUtilities.convertPoint((Component)e2.getSource(), e2.getX(), e2.getY(), AnnotationEditor.this.decode_pdf);
                Point p2 = SwingMouseUtils.getCoordsOnPage((int)compCoords.getX(), (int)compCoords.getY(), AnnotationEditor.this.decode_pdf.getPageNumber(), AnnotationEditor.this.decode_pdf, AnnotationEditor.this.currentGUI, AnnotationEditor.this.currentGUI.getValues());
                if (!AnnotationEditor.this.currentGUI.getValues().isFormsChanged()) {
                    AnnotationEditor.this.currentGUI.getValues().setFormsChanged(true);
                    AnnotationEditor.this.currentGUI.setViewerTitle();
                }
                if (this.newLocation == null) {
                    this.newLocation = AnnotationEditor.this.currentAnnot.getBoundingRectangle();
                }
                int lX1 = AnnotationEditor.this.decode_pdf.getPdfPageData().getCropBoxX(AnnotationEditor.this.decode_pdf.getPageNumber());
                int lY1 = AnnotationEditor.this.decode_pdf.getPdfPageData().getCropBoxY(AnnotationEditor.this.decode_pdf.getPageNumber());
                int lX2 = AnnotationEditor.this.decode_pdf.getPdfPageData().getCropBoxWidth(AnnotationEditor.this.decode_pdf.getPageNumber()) + lX1;
                int lY2 = AnnotationEditor.this.decode_pdf.getPdfPageData().getCropBoxHeight(AnnotationEditor.this.decode_pdf.getPageNumber()) + lY1;
                if (p2 != null) {
                    if (p2.x >= lX1 && p2.x <= lX2) {
                        if ((float)this.newLocation.x + ((float)p2.x - this.sx) >= (float)lX1 && (float)(this.newLocation.x + this.newLocation.width) + ((float)p2.x - this.sx) <= (float)lX2) {
                            this.newLocation.x = (int)((float)this.newLocation.x + ((float)p2.x - this.sx));
                        }
                    } else {
                        this.newLocation.x = p2.x < lX1 ? lX1 : lX2 - this.newLocation.width;
                    }
                    if (p2.y >= lY1 && p2.y <= lY2) {
                        if ((float)this.newLocation.y + ((float)p2.y - this.sy) >= (float)lY1 && (float)(this.newLocation.y + this.newLocation.height) + ((float)p2.y - this.sy) <= (float)lY2) {
                            this.newLocation.y = (int)((float)this.newLocation.y + ((float)p2.y - this.sy));
                        }
                    } else {
                        this.newLocation.y = p2.y < lY1 ? lY1 : lY2 - this.newLocation.height;
                    }
                    this.sx = p2.x;
                    this.sy = p2.y;
                }
                AnnotationEditor.this.showAnnotationResizeTabs(AnnotationUtils.validateCoordinates(this.newLocation.x, this.newLocation.y, this.newLocation.x + this.newLocation.width, this.newLocation.y + this.newLocation.height));
            }
        }
    }

    class EditListener
    extends ComponentAdapter {
        EditListener() {
        }

        @Override
        public void componentMoved(ComponentEvent e2) {
            if (AnnotationEditor.this.currentAnnot != null) {
                AnnotationEditor.this.showAnnotationResizeTabs(AnnotationEditor.this.currentAnnot.getFloatArray(573911876));
            }
        }

        @Override
        public void componentResized(ComponentEvent e2) {
            if (AnnotationEditor.this.currentAnnot != null) {
                AnnotationEditor.this.showAnnotationResizeTabs(AnnotationEditor.this.currentAnnot.getFloatArray(573911876));
            }
        }
    }
}

