/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingAnnotationPanel;
import org.jpedal.examples.viewer.gui.swing.SwingAnnotationProperties;
import org.jpedal.examples.viewer.gui.swing.SwingMouseUtils;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.annotation.CircleAnnotation;
import org.jpedal.io.annotation.FreeTextAnnotation;
import org.jpedal.io.annotation.HighlightAnnotation;
import org.jpedal.io.annotation.InkAnnotation;
import org.jpedal.io.annotation.LineAnnotation;
import org.jpedal.io.annotation.LinkAnnotation;
import org.jpedal.io.annotation.PolyLineAnnotation;
import org.jpedal.io.annotation.PolygonAnnotation;
import org.jpedal.io.annotation.SquareAnnotation;
import org.jpedal.io.annotation.TextAnnotation;
import org.jpedal.io.annotation.WritableAnnotation;
import org.jpedal.io.annotation.utils.AnnotationUtils;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.creation.AnnotationFactory;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.render.GUIDisplay;
import org.jpedal.utils.Messages;

class AnnotationCreator {
    private int sx;
    private int sy;
    private int ex;
    private int ey;
    private ArrayList<Integer> multiPoints;
    private final PdfDecoder decode_pdf;
    private final SwingGUI currentGUI;
    private final SwingAnnotationPanel annotationPanel;
    private FormObject currentAnnot;
    private final float[] defaultStrokeColor = new float[]{0.1607f, 0.4784f, 0.8f};
    private final JPopupMenu completeMenu;
    private final JMenuItem complete;
    private final JMenuItem cancel;
    private static final int POLYGON_END_THRESHOLD = 20;

    AnnotationCreator(final PdfDecoder decode_pdf, final SwingGUI currentGUI) {
        this.decode_pdf = decode_pdf;
        this.currentGUI = currentGUI;
        this.annotationPanel = currentGUI.getAnnotationPanel();
        this.completeMenu = new JPopupMenu();
        this.completeMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e2) {
                Point mouse = MouseInfo.getPointerInfo().getLocation();
                Point pdf = decode_pdf.getLocationOnScreen();
                Point p2 = SwingMouseUtils.getCoordsOnPage(mouse.x - pdf.x, mouse.y - pdf.y, decode_pdf.getPageNumber(), decode_pdf, currentGUI, currentGUI.getValues());
                if (p2 != null) {
                    AnnotationCreator.this.updatePolyAnnot(p2.x, p2.y);
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
            }
        });
        this.complete = new JMenuItem(Messages.getMessage("PdfFormCreation.Complete"));
        this.complete.addActionListener(e2 -> this.completePolyAnnot());
        this.cancel = new JMenuItem(Messages.getMessage("PdfFormCreation.Cancel"));
        this.cancel.addActionListener(e2 -> {
            this.cancelCreation();
            this.completeMenu.setVisible(false);
        });
        this.completeMenu.add(this.complete);
        this.completeMenu.add(this.cancel);
    }

    private static FormObject createFormObject(int pageNumber, float localSX, float localSY, float localEX, float localEY) {
        FormObject annotation = new FormObject(1044266837);
        annotation.setPageNumber(pageNumber);
        annotation.setIntNumber(22, 4);
        annotation.setTextStreamValue(36, System.getProperty("user.name"));
        annotation.setTextStreamValue(29, AnnotationFactory.getCurrentDateAsString().getBytes());
        annotation.setFloatArray(573911876, AnnotationUtils.validateCoordinates(localSX, localSY, localEX, localEY));
        return annotation;
    }

    private void addFormObjectToDisplay() {
        List<FormObject> fo = this.decode_pdf.getFormRenderer().getCompData().getFormList(true)[this.decode_pdf.getPageNumber()];
        fo.add(0, this.currentAnnot);
        FormObject po = (FormObject)this.currentAnnot.getDictionary(1061176672);
        if (po != null) {
            fo.add(0, po);
        }
        this.decode_pdf.getFormRenderer().displayComponentsOnscreen(this.decode_pdf.getPageNumber(), this.decode_pdf.getPageNumber());
    }

    void cancelCreation() {
        if (this.annotationPanel.getAnnotationType() != WritableAnnotation.AnnotationType.INK && this.currentAnnot != null) {
            List<FormObject> fo = this.decode_pdf.getFormRenderer().getCompData().getFormList(true)[this.currentAnnot.getPageNumber()];
            fo.remove(this.currentAnnot);
            if (this.currentAnnot.getGUIComponent() != null) {
                this.decode_pdf.remove((Component)this.currentAnnot.getGUIComponent());
            }
        }
        this.decode_pdf.repaint();
        this.currentAnnot = null;
        if (this.multiPoints != null) {
            this.multiPoints.clear();
            this.multiPoints = null;
        }
        if (this.annotationPanel.getAnnotationType() != WritableAnnotation.AnnotationType.HIGHLIGHT) {
            this.annotationPanel.clearAnnotationType();
        }
    }

    void createAnnotation(int x2, int y2, int button, int clickCount) {
        Point p2 = SwingMouseUtils.getCoordsOnPage(x2, y2, this.decode_pdf.getPageNumber(), this.decode_pdf, this.currentGUI, this.currentGUI.getValues());
        if (button == 1) {
            if (p2 == null) {
                return;
            }
            this.sx = p2.x;
            this.sy = p2.y;
            this.ex = p2.x + 1;
            this.ey = p2.y + 1;
            if (this.annotationPanel.getAnnotationType() != null) {
                WritableAnnotation.AnnotationType annotType = (WritableAnnotation.AnnotationType)((Object)this.annotationPanel.getAnnotationType());
                boolean addAnnotationToDisplay = false;
                if (this.currentAnnot == null) {
                    this.currentAnnot = AnnotationCreator.createFormObject(this.decode_pdf.getPageNumber(), this.sx, this.sy, this.ex, this.ey);
                    addAnnotationToDisplay = true;
                }
                switch (annotType) {
                    case CIRCLE: {
                        this.addCircleAnnotationValues(this.currentAnnot);
                        break;
                    }
                    case LINE: {
                        this.addLineAnnotationValues(this.currentAnnot);
                        break;
                    }
                    case SQUARE: {
                        this.addSquareAnnotationValues(this.currentAnnot);
                        break;
                    }
                    case TEXT: {
                        this.addTextAnnotationValues(this.currentAnnot);
                        break;
                    }
                    case HIGHLIGHT: {
                        this.handleHighlightCreationIfLocationValid(p2);
                        break;
                    }
                    case POLYLINE: {
                        this.handlePolylineCreation(addAnnotationToDisplay, clickCount);
                        break;
                    }
                    case POLYGON: {
                        this.handlePolgonCreation(addAnnotationToDisplay, clickCount);
                        break;
                    }
                    case INK: {
                        this.addInkAnnotationValues(this.currentAnnot);
                        break;
                    }
                    case FREETEXT: {
                        this.addFreeTextAnnotationValues(this.currentAnnot);
                        break;
                    }
                    case LINK: {
                        this.addLinkAnnotationValues(this.currentAnnot, this.decode_pdf.getPageNumber());
                    }
                }
                if (addAnnotationToDisplay && this.currentAnnot != null) {
                    this.decode_pdf.getFormRenderer().getCompData().setForceRedraw(true);
                    this.addFormObjectToDisplay();
                }
                if (annotType == WritableAnnotation.AnnotationType.TEXT) {
                    this.completeAnnotation();
                }
            }
        } else if (button == 3 && this.currentAnnot != null && (this.annotationPanel.getAnnotationType() == WritableAnnotation.AnnotationType.POLYGON || this.annotationPanel.getAnnotationType() == WritableAnnotation.AnnotationType.POLYLINE)) {
            this.complete.setVisible(true);
            this.cancel.setVisible(true);
            this.completeMenu.show(this.decode_pdf, x2, y2);
        }
    }

    private void handleHighlightCreationIfLocationValid(Point p2) {
        if (this.isValidHighlightPoint(p2) && (((GUIDisplay)this.decode_pdf.getDynamicRenderer()).getObjectUnderneath((int)p2.getX(), (int)p2.getY()) == 1 || ((GUIDisplay)this.decode_pdf.getDynamicRenderer()).getObjectUnderneath((int)p2.getX(), (int)p2.getY()) == 4 || ((GUIDisplay)this.decode_pdf.getDynamicRenderer()).getObjectUnderneath((int)p2.getX(), (int)p2.getY()) == 5 || ((GUIDisplay)this.decode_pdf.getDynamicRenderer()).getObjectUnderneath((int)p2.getX(), (int)p2.getY()) == 6)) {
            this.addHighlightAnnotationValues(this.currentAnnot);
        } else {
            this.currentAnnot = null;
        }
    }

    private void handlePolylineCreation(boolean addAnnotationToDisplay, int clickCount) {
        if (addAnnotationToDisplay) {
            this.addPolyLineAnnotationValues(this.currentAnnot);
        } else {
            this.addPointToPoly(this.currentAnnot);
            if (clickCount == 2) {
                this.completePolyAnnot();
            }
        }
    }

    private void handlePolgonCreation(boolean addAnnotationToDisplay, int clickCount) {
        if (addAnnotationToDisplay) {
            this.addPolygonAnnotationValues(this.currentAnnot);
        } else if (this.multiPoints.size() > 4 && AnnotationCreator.endPoly(this.multiPoints.get(0), this.multiPoints.get(1), this.sx, this.sy)) {
            this.completePolyAnnot();
        } else {
            this.addPointToPoly(this.currentAnnot);
            if (clickCount == 2) {
                this.completePolyAnnot();
            }
        }
    }

    private boolean isValidHighlightPoint(Point p2) {
        List<FormObject> fo = this.decode_pdf.getFormRenderer().getCompData().getFormList(true)[this.decode_pdf.getPageNumber()];
        for (FormObject f2 : fo) {
            Rectangle rect = f2.getBoundingRectangle();
            if (!rect.contains(p2) || f2.getNameAsConstant(1147962727) != 1919840408) continue;
            float[] points = f2.getFloatArray(1785890247);
            for (int i2 = 0; i2 < points.length; i2 += 8) {
                int maxY;
                int minX = Math.min(Math.min((int)points[i2], (int)points[i2 + 2]), Math.min((int)points[i2 + 4], (int)points[i2 + 6]));
                int maxX = Math.max(Math.max((int)points[i2], (int)points[i2 + 2]), Math.max((int)points[i2 + 4], (int)points[i2 + 6]));
                int minY = Math.min(Math.min((int)points[i2 + 1], (int)points[i2 + 3]), Math.min((int)points[i2 + 5], (int)points[i2 + 7]));
                Rectangle rect2 = new Rectangle(minX, minY, maxX - minX, (maxY = Math.max(Math.max((int)points[i2 + 1], (int)points[i2 + 3]), Math.max((int)points[i2 + 5], (int)points[i2 + 7]))) - minY);
                if (!rect2.contains(p2)) continue;
                return false;
            }
        }
        int[][] highlights = this.decode_pdf.getTextLines().getHighlightableInArea(new int[]{this.sx, this.sy, this.ex - this.sx, this.ey - this.sy}, false, this.decode_pdf.getPageNumber());
        return highlights != null;
    }

    private void addPointToPoly(FormObject currentAnnot) {
        this.multiPoints.add(this.sx);
        this.multiPoints.add(this.sy);
        AnnotationCreator.updateFormWithMultiPoints(currentAnnot, this.multiPoints);
    }

    private void completePolyAnnot() {
        switch ((WritableAnnotation.AnnotationType)((Object)this.annotationPanel.getAnnotationType())) {
            case POLYLINE: {
                this.completeAnnotation();
                this.completeMenu.setVisible(false);
                break;
            }
            case POLYGON: {
                this.multiPoints.add(this.multiPoints.get(0));
                this.multiPoints.add(this.multiPoints.get(1));
                this.currentAnnot.setConstant(1147962727, 1230470778);
                this.completeAnnotation();
                this.completeMenu.setVisible(false);
            }
        }
    }

    private void limitPointToPage(Point p2) {
        int lX1 = this.decode_pdf.getPdfPageData().getCropBoxX(this.decode_pdf.getPageNumber());
        int lY1 = this.decode_pdf.getPdfPageData().getCropBoxY(this.decode_pdf.getPageNumber());
        int lX2 = this.decode_pdf.getPdfPageData().getCropBoxWidth(this.decode_pdf.getPageNumber()) + lX1;
        int lY2 = this.decode_pdf.getPdfPageData().getCropBoxHeight(this.decode_pdf.getPageNumber()) + lY1;
        if (!this.canBePlaced(p2.x, p2.y)) {
            if (p2.x < lX1) {
                p2.x = lX1;
            }
            if (p2.x > lX2) {
                p2.x = lX2;
            }
            if (p2.y < lY1) {
                p2.y = lY1;
            }
            if (p2.y > lY2) {
                p2.y = lY2;
            }
        }
    }

    void completeDragCreationAnnotations(int x2, int y2) {
        Point p2 = SwingMouseUtils.getCoordsOnPage(x2, y2, this.decode_pdf.getPageNumber(), this.decode_pdf, this.currentGUI, this.currentGUI.getValues());
        if (p2 == null) {
            return;
        }
        this.limitPointToPage(p2);
        this.ex = p2.x;
        this.ey = p2.y;
        if (this.annotationPanel.getAnnotationType() != null) {
            if (this.annotationPanel.getAnnotationType() == WritableAnnotation.AnnotationType.INK) {
                this.updateInkAnnotation(this.currentAnnot);
            }
            this.completeAnnotation();
        }
    }

    private static boolean endPoly(int sx, int sy, int ex, int ey) {
        int y2;
        int x2 = Math.abs(sx - ex);
        return Math.sqrt(x2 * x2 + (y2 = Math.abs(sy - ey)) * y2) <= 20.0;
    }

    private void updateInkAnnotation(FormObject currentAnnot) {
        if (this.multiPoints.get(this.multiPoints.size() - 2) != this.ex || this.multiPoints.get(this.multiPoints.size() - 1) != this.ey) {
            this.multiPoints.add(this.ex);
            this.multiPoints.add(this.ey);
            AnnotationCreator.updateFormWithMultiPoints(currentAnnot, this.multiPoints);
        }
    }

    private void updateHighlightAnnotation(FormObject currentAnnot) {
        int[][] highlights = this.decode_pdf.getTextLines().getHighlightableInArea(new int[]{this.sx, this.sy, this.ex - this.sx, this.ey - this.sy}, false, this.decode_pdf.getPageNumber());
        if (highlights != null) {
            float[] quad = new float[highlights.length * 8];
            float[] rect = new float[]{this.sx, this.sy, this.ex, this.ey};
            for (int i2 = 0; i2 != highlights.length; ++i2) {
                quad[i2 * 8] = highlights[i2][0];
                quad[i2 * 8 + 1] = highlights[i2][1] + highlights[i2][3];
                quad[i2 * 8 + 2] = highlights[i2][0] + highlights[i2][2];
                quad[i2 * 8 + 3] = highlights[i2][1] + highlights[i2][3];
                quad[i2 * 8 + 4] = highlights[i2][0];
                quad[i2 * 8 + 5] = highlights[i2][1];
                quad[i2 * 8 + 6] = highlights[i2][0] + highlights[i2][2];
                quad[i2 * 8 + 7] = highlights[i2][1];
                if (rect[0] > (float)highlights[i2][0]) {
                    rect[0] = highlights[i2][0];
                }
                if (rect[1] > (float)highlights[i2][1]) {
                    rect[1] = highlights[i2][1];
                }
                if (rect[2] < (float)(highlights[i2][0] + highlights[i2][2])) {
                    rect[2] = highlights[i2][0] + highlights[i2][2];
                }
                if (!(rect[3] < (float)(highlights[i2][1] + highlights[i2][3]))) continue;
                rect[3] = highlights[i2][1] + highlights[i2][3];
            }
            currentAnnot.setFloatArray(1785890247, quad);
            currentAnnot.setFloatArray(573911876, AnnotationUtils.validateCoordinates(rect[0], rect[1], rect[2], rect[3]));
        }
    }

    private void updateLineAnnotation(FormObject currentAnnot) {
        int temp;
        int x1 = this.sx;
        int y1 = this.sy;
        int x2 = this.ex;
        int y2 = this.ey;
        if (y2 < y1) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        if (x2 < x1) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        currentAnnot.setFloatArray(573911876, AnnotationUtils.validateCoordinates(x1 - 1, y1 - 1, x2 + 1, y2 + 1));
        currentAnnot.setFloatArray(28, new float[]{this.sx, this.sy, this.ex, this.ey});
    }

    void updateMoveAnnotation(int x2, int y2) {
        Point p2 = SwingMouseUtils.getCoordsOnPage(x2, y2, this.decode_pdf.getPageNumber(), this.decode_pdf, this.currentGUI, this.currentGUI.getValues());
        if (p2 == null) {
            return;
        }
        this.ex = p2.x;
        this.ey = p2.y;
        if (this.annotationPanel.getAnnotationType() != null && !this.completeMenu.isVisible()) {
            switch ((WritableAnnotation.AnnotationType)((Object)this.annotationPanel.getAnnotationType())) {
                case POLYLINE: 
                case POLYGON: {
                    if (this.currentAnnot == null) break;
                    this.updatePolyAnnot(this.ex, this.ey);
                }
            }
        }
    }

    void updateDragAnnotation(int x2, int y2) {
        if (this.currentAnnot == null) {
            return;
        }
        Point p2 = SwingMouseUtils.getCoordsOnPage(x2, y2, this.decode_pdf.getPageNumber(), this.decode_pdf, this.currentGUI, this.currentGUI.getValues());
        if (p2 == null) {
            return;
        }
        if (this.currentAnnot.getNameAsConstant(1147962727) != 1654331) {
            this.limitPointToPage(p2);
        }
        this.ex = p2.x;
        this.ey = p2.y;
        if (this.annotationPanel.getAnnotationType() != null) {
            switch ((WritableAnnotation.AnnotationType)((Object)this.annotationPanel.getAnnotationType())) {
                case INK: {
                    this.updateInkAnnotation(this.currentAnnot);
                    break;
                }
                case HIGHLIGHT: {
                    this.updateHighlightAnnotation(this.currentAnnot);
                    break;
                }
                case LINE: {
                    this.updateLineAnnotation(this.currentAnnot);
                    break;
                }
                default: {
                    this.currentAnnot.setFloatArray(573911876, AnnotationUtils.validateCoordinates(this.sx, this.sy, this.ex, this.ey));
                }
            }
            SwingAnnotationProperties.updateAnnotationAppearance(this.decode_pdf, this.currentAnnot);
            this.decode_pdf.getPages().forceRedraw();
            this.decode_pdf.repaint();
        }
    }

    boolean canBePlaced(int x2, int y2) {
        int x1 = this.decode_pdf.getPdfPageData().getCropBoxX(this.decode_pdf.getPageNumber());
        int y1 = this.decode_pdf.getPdfPageData().getCropBoxY(this.decode_pdf.getPageNumber());
        int x22 = this.decode_pdf.getPdfPageData().getCropBoxWidth(this.decode_pdf.getPageNumber()) + x1;
        int y22 = this.decode_pdf.getPdfPageData().getCropBoxHeight(this.decode_pdf.getPageNumber()) + y1;
        return x1 <= x2 && x2 <= x22 && y1 <= y2 && y2 <= y22;
    }

    void clearCurrentAnnotation() {
        this.currentAnnot = null;
        if (this.multiPoints != null) {
            this.multiPoints.clear();
            this.multiPoints = null;
        }
    }

    boolean isCreating() {
        return this.currentAnnot != null;
    }

    private void updatePolyAnnot(int x2, int y2) {
        this.multiPoints.remove(this.multiPoints.size() - 1);
        this.multiPoints.remove(this.multiPoints.size() - 1);
        this.multiPoints.add(x2);
        this.multiPoints.add(y2);
        AnnotationCreator.updateFormWithMultiPoints(this.currentAnnot, this.multiPoints);
        SwingAnnotationProperties.updateAnnotationAppearance(this.decode_pdf, this.currentAnnot);
    }

    private float[] getBoundsOfQuadArray(FormObject formObj) {
        float[] quad = formObj.getFloatArray(1785890247);
        float[] rect = new float[]{this.sx, this.sy, this.ex, this.ey};
        for (int i2 = 0; i2 != quad.length; ++i2) {
            if (i2 % 2 == 0) {
                if (rect[0] > quad[i2]) {
                    rect[0] = quad[i2];
                }
                if (!(rect[2] < quad[i2])) continue;
                rect[2] = quad[i2];
                continue;
            }
            if (rect[1] > quad[i2]) {
                rect[1] = quad[i2];
            }
            if (!(rect[3] < quad[i2])) continue;
            rect[3] = quad[i2];
        }
        return rect;
    }

    private void completeAnnotation() {
        if (this.currentAnnot != null) {
            float[] rect = AnnotationUtils.validateCoordinates(this.sx, this.sy, this.ex, this.ey);
            WritableAnnotation.AnnotationType annotType = (WritableAnnotation.AnnotationType)((Object)this.annotationPanel.getAnnotationType());
            if (this.sx == this.ex && this.sy == this.ey && annotType != WritableAnnotation.AnnotationType.POLYLINE && annotType != WritableAnnotation.AnnotationType.POLYGON && annotType != WritableAnnotation.AnnotationType.TEXT && annotType != WritableAnnotation.AnnotationType.INK) {
                this.cancelCreation();
            } else {
                switch (annotType) {
                    case POLYLINE: {
                        AnnotationCreator.completePolyLine(this.annotationPanel, this.currentAnnot, this.decode_pdf.getPageNumber() - 1, this.currentAnnot.getFloatArray(573911876));
                        break;
                    }
                    case POLYGON: {
                        AnnotationCreator.completePolygon(this.annotationPanel, this.currentAnnot, this.decode_pdf.getPageNumber() - 1, this.currentAnnot.getFloatArray(573911876));
                        break;
                    }
                    case FREETEXT: {
                        AnnotationCreator.completeFreeText(this.annotationPanel, this.decode_pdf.getIO(), this.currentAnnot, this.decode_pdf.getPageNumber() - 1, rect);
                        break;
                    }
                    case TEXT: {
                        AnnotationCreator.completeText(this.annotationPanel, this.currentAnnot, this.decode_pdf.getPageNumber() - 1, this.currentAnnot.getBoundingRectangle());
                        break;
                    }
                    case CIRCLE: {
                        AnnotationCreator.completeCircle(this.annotationPanel, this.currentAnnot, this.decode_pdf.getPageNumber() - 1, rect);
                        break;
                    }
                    case HIGHLIGHT: {
                        AnnotationCreator.completeHighlight(this.annotationPanel, this.currentAnnot, this.decode_pdf.getPageNumber() - 1, this.getBoundsOfQuadArray(this.currentAnnot));
                        break;
                    }
                    case SQUARE: {
                        AnnotationCreator.completeSquare(this.annotationPanel, this.currentAnnot, this.decode_pdf.getPageNumber() - 1, rect);
                        break;
                    }
                    case LINE: {
                        AnnotationCreator.completeLine(this.annotationPanel, this.currentAnnot, this.decode_pdf.getPageNumber() - 1, rect, new float[]{this.sx, this.sy, this.ex, this.ey});
                        break;
                    }
                    case INK: {
                        AnnotationCreator.completeInk(this.annotationPanel, this.currentAnnot, this.decode_pdf.getPageNumber() - 1, this.currentAnnot.getBoundingRectangle());
                        break;
                    }
                    case LINK: {
                        AnnotationCreator.completeLink(this.annotationPanel, this.currentAnnot, this.decode_pdf.getPageNumber() - 1, rect);
                    }
                }
                SwingAnnotationProperties.updateAnnotationAppearance(this.decode_pdf, this.currentAnnot);
            }
            if (annotType != WritableAnnotation.AnnotationType.INK) {
                this.currentAnnot = null;
                if (this.multiPoints != null) {
                    this.multiPoints.clear();
                    this.multiPoints = null;
                }
            }
            if (annotType != WritableAnnotation.AnnotationType.HIGHLIGHT && annotType != WritableAnnotation.AnnotationType.INK) {
                this.annotationPanel.clearAnnotationType();
            }
            this.currentGUI.getValues().setFormsChanged(true);
            this.currentGUI.setViewerTitle();
            this.annotationPanel.populateList(this.decode_pdf);
        }
    }

    private static void completePolyLine(SwingAnnotationPanel annotationPanel, FormObject currentAnnot, int pageNo, float[] rect) {
        annotationPanel.addAnnotationForWriting(new PolyLineAnnotation(pageNo, rect[0], rect[1], rect[2], rect[3], currentAnnot));
    }

    private static void completePolygon(SwingAnnotationPanel annotationPanel, FormObject currentAnnot, int pageNo, float[] rect) {
        annotationPanel.addAnnotationForWriting(new PolygonAnnotation(pageNo, rect[0], rect[1], rect[2], rect[3], currentAnnot));
    }

    private static void completeFreeText(SwingAnnotationPanel annotationPanel, PdfObjectReader objectReader, FormObject currentAnnot, int pageNo, float[] rect) {
        currentAnnot.setFloatArray(573911876, rect);
        AnnotationUtils.createAPObjectForFormObject(currentAnnot, objectReader);
        annotationPanel.addAnnotationForWriting(new FreeTextAnnotation(pageNo, rect[0], rect[1], rect[2], rect[3], currentAnnot));
    }

    private static void completeText(SwingAnnotationPanel annotationPanel, FormObject currentAnnot, int pageNo, Rectangle r2) {
        annotationPanel.addAnnotationForWriting(new TextAnnotation(pageNo, (float)r2.x, (float)r2.y, (float)(r2.x + r2.width), (float)(r2.y + r2.height), currentAnnot));
    }

    private static void completeCircle(SwingAnnotationPanel annotationPanel, FormObject currentAnnot, int pageNo, float[] rect) {
        currentAnnot.setFloatArray(573911876, rect);
        annotationPanel.addAnnotationForWriting(new CircleAnnotation(pageNo, rect[0], rect[1], rect[2], rect[3], currentAnnot));
    }

    private static void completeHighlight(SwingAnnotationPanel annotationPanel, FormObject currentAnnot, int pageNo, float[] rect) {
        currentAnnot.setFloatArray(573911876, rect);
        annotationPanel.addAnnotationForWriting(new HighlightAnnotation(pageNo, rect[0], rect[1], rect[2], rect[3], currentAnnot));
    }

    private static void completeSquare(SwingAnnotationPanel annotationPanel, FormObject currentAnnot, int pageNo, float[] rect) {
        currentAnnot.setFloatArray(573911876, rect);
        annotationPanel.addAnnotationForWriting(new SquareAnnotation(pageNo, rect[0], rect[1], rect[2], rect[3], currentAnnot));
    }

    private static void completeLine(SwingAnnotationPanel annotationPanel, FormObject currentAnnot, int pageNo, float[] rect, float[] line) {
        currentAnnot.setFloatArray(573911876, rect);
        currentAnnot.setFloatArray(28, line);
        annotationPanel.addAnnotationForWriting(new LineAnnotation(pageNo, rect[0] - 1.0f, rect[1] - 1.0f, rect[2] + 1.0f, rect[3] + 1.0f, currentAnnot));
    }

    private static void completeInk(SwingAnnotationPanel annotationPanel, FormObject currentAnnot, int pageNo, Rectangle r2) {
        InkAnnotation annot = new InkAnnotation(pageNo, (float)r2.x, (float)r2.y, (float)(r2.x + r2.width), (float)(r2.y + r2.height), currentAnnot);
        float[][] inkList = currentAnnot.getFloat2DArray(475169151);
        if (inkList != null && inkList.length == 1) {
            annotationPanel.addAnnotationForWriting(annot);
        }
    }

    private static void completeLink(SwingAnnotationPanel annotationPanel, FormObject currentAnnot, int pageNo, float[] rect) {
        currentAnnot.setFloatArray(573911876, rect);
        annotationPanel.addAnnotationForWriting(new LinkAnnotation(pageNo, rect[0], rect[1], rect[2], rect[3], currentAnnot));
    }

    private void addSquareAnnotationValues(FormObject currentAnnot) {
        currentAnnot.setConstant(1147962727, 1160865142);
        currentAnnot.setFloatArray(573911876, AnnotationUtils.validateCoordinates(this.sx, this.sy, this.ex, this.ey));
        currentAnnot.setFloatArray(19, new float[]{this.defaultStrokeColor[0], this.defaultStrokeColor[1], this.defaultStrokeColor[2]});
        currentAnnot.setAppreancesUsed(true);
    }

    private void addInkAnnotationValues(FormObject currentAnnot) {
        this.multiPoints = new ArrayList();
        this.multiPoints.add(this.sx);
        this.multiPoints.add(this.sy);
        currentAnnot.setConstant(1147962727, 1654331);
        currentAnnot.setFloatArray(19, new float[]{this.defaultStrokeColor[0], this.defaultStrokeColor[1], this.defaultStrokeColor[2]});
        float[][] inkList = currentAnnot.getFloat2DArray(475169151);
        if (inkList != null) {
            float[][] newInkList = new float[inkList.length + 1][];
            System.arraycopy(inkList, 0, newInkList, 0, inkList.length);
            newInkList[newInkList.length - 1] = new float[0];
            currentAnnot.setFloat2DArray(475169151, newInkList);
        } else {
            currentAnnot.setFloat2DArray(475169151, new float[1][]);
        }
        AnnotationCreator.updateFormWithMultiPoints(currentAnnot, this.multiPoints);
    }

    private void addTextAnnotationValues(FormObject currentAnnot) {
        currentAnnot.setConstant(1147962727, 607471684);
        currentAnnot.setName(506543413, "Note".getBytes());
        float[] apDimensions = AnnotationUtils.getTextIconDimensions(currentAnnot.getName(506543413));
        currentAnnot.setFloatArray(573911876, AnnotationUtils.validateCoordinates((float)this.sx - apDimensions[0] / 2.0f, (float)this.sy - apDimensions[1] / 2.0f, (float)this.ex + apDimensions[0] / 2.0f, (float)this.ey + apDimensions[1] / 2.0f));
        currentAnnot.setFloatArray(19, new float[]{this.defaultStrokeColor[0], this.defaultStrokeColor[1], this.defaultStrokeColor[2]});
        FormObject po = new FormObject(1044266837);
        po.setIntNumber(22, 28);
        po.setBoolean(524301630, false);
        po.setConstant(1147962727, 1061176672);
        float[] rect = currentAnnot.getFloatArray(573911876);
        PdfPageData pageData = this.decode_pdf.getPdfPageData();
        if (pageData.getRotation(this.decode_pdf.getPageNumber()) % 180 != 0) {
            po.setFloatArray(573911876, AnnotationUtils.validateCoordinates(rect[2], pageData.getCropBoxHeight(this.decode_pdf.getPageNumber()) - 100, rect[2] + 160.0f, pageData.getCropBoxHeight(this.decode_pdf.getPageNumber())));
        } else {
            po.setFloatArray(573911876, AnnotationUtils.validateCoordinates(pageData.getCropBoxWidth(this.decode_pdf.getPageNumber()), rect[3] - 100.0f, pageData.getCropBoxWidth(this.decode_pdf.getPageNumber()) + 160, rect[3]));
        }
        po.setStringKey(1110793845, currentAnnot.getObjectRefAsString().getBytes());
        po.setParentPdfObj(currentAnnot);
        po.setPageNumber(this.decode_pdf.getPageNumber());
        currentAnnot.setDictionary(1061176672, po);
        currentAnnot.setAppreancesUsed(true);
    }

    private void addFreeTextAnnotationValues(FormObject currentAnnot) {
        currentAnnot.setConstant(1147962727, 980909433);
        currentAnnot.setName(6436, "/FreeTextTypewriter".getBytes());
        currentAnnot.setFloatArray(573911876, AnnotationUtils.validateCoordinates(this.sx, this.sy, this.ex, this.ey));
        currentAnnot.setTextStreamValue(5155, "font: Helvetica 12.0pt;font-stretch:Normal; text-align:left; color:#000000".getBytes());
        currentAnnot.setTextStreamValue(1216184967, "[Enter Text Here]".getBytes());
    }

    private void addLinkAnnotationValues(FormObject currentAnnot, int pageNumber) {
        currentAnnot.setConstant(1147962727, 473513531);
        currentAnnot.setFloatArray(573911876, AnnotationUtils.validateCoordinates(this.sx, this.sy, this.ex, this.ey));
        FormObject link = new FormObject(17);
        link.setPageNumber(pageNumber);
        link.setName(608780341, "Action".getBytes());
        link.setName(35, "URI".getBytes());
        link.setTextStreamValue(2433561, "https://www.idrsolutions.com".getBytes());
        currentAnnot.setDictionary(17, link);
        currentAnnot.setConstant(24, 32);
    }

    private void addHighlightAnnotationValues(FormObject currentAnnot) {
        currentAnnot.setConstant(1147962727, 1919840408);
        this.updateHighlightAnnotation(currentAnnot);
        currentAnnot.setFloatArray(19, new float[]{0.9529f, 0.9529f, 0.0823f});
    }

    private void addCircleAnnotationValues(FormObject currentAnnot) {
        currentAnnot.setConstant(1147962727, 1110658926);
        currentAnnot.setFloatArray(573911876, AnnotationUtils.validateCoordinates(this.sx, this.sy, this.ex, this.ey));
        currentAnnot.setFloatArray(19, new float[]{this.defaultStrokeColor[0], this.defaultStrokeColor[1], this.defaultStrokeColor[2]});
    }

    private void addLineAnnotationValues(FormObject currentAnnot) {
        currentAnnot.setConstant(1147962727, 473513525);
        currentAnnot.setFloatArray(573911876, AnnotationUtils.validateCoordinates(this.sx, this.sy, this.ex, this.ey));
        currentAnnot.setFloatArray(28, new float[]{this.sx, this.sy, this.ex, this.ey});
        currentAnnot.setFloatArray(19, new float[]{this.defaultStrokeColor[0], this.defaultStrokeColor[1], this.defaultStrokeColor[2]});
        currentAnnot.setAppreancesUsed(true);
    }

    private void addPolyLineAnnotationValues(FormObject currentAnnot) {
        this.multiPoints = new ArrayList();
        this.multiPoints.add(this.sx);
        this.multiPoints.add(this.sy);
        this.multiPoints.add(this.sx + 1);
        this.multiPoints.add(this.sy + 1);
        currentAnnot.setConstant(1147962727, 1014528638);
        currentAnnot.setFloatArray(573911876, AnnotationUtils.validateCoordinates(this.sx, this.sy, this.ex, this.ey));
        float[] values = new float[this.multiPoints.size()];
        for (int i2 = 0; i2 != this.multiPoints.size(); ++i2) {
            values[i2] = this.multiPoints.get(i2).intValue();
        }
        currentAnnot.setFloatArray(1600681863, values);
        currentAnnot.setFloatArray(19, new float[]{this.defaultStrokeColor[0], this.defaultStrokeColor[1], this.defaultStrokeColor[2]});
    }

    private void addPolygonAnnotationValues(FormObject currentAnnot) {
        this.multiPoints = new ArrayList();
        this.multiPoints.add(this.sx);
        this.multiPoints.add(this.sy);
        this.multiPoints.add(this.sx + 1);
        this.multiPoints.add(this.sy + 1);
        currentAnnot.setConstant(1147962727, 1230470778);
        currentAnnot.setFloatArray(573911876, AnnotationUtils.validateCoordinates(this.sx, this.sy, this.ex, this.ey));
        float[] values = new float[this.multiPoints.size()];
        for (int i2 = 0; i2 != this.multiPoints.size(); ++i2) {
            values[i2] = this.multiPoints.get(i2).intValue();
        }
        currentAnnot.setFloatArray(1600681863, values);
        currentAnnot.setFloatArray(19, new float[]{this.defaultStrokeColor[0], this.defaultStrokeColor[1], this.defaultStrokeColor[2]});
    }

    FormObject getCurrentAnnotation() {
        return this.currentAnnot;
    }

    private static void updateFormWithMultiPoints(FormObject currentAnnot, ArrayList<Integer> multiPoints) {
        float[] rect = currentAnnot.getFloatArray(573911876);
        int localSX = (int)rect[0] + 2;
        int localSY = (int)rect[1] + 2;
        int localEX = (int)rect[2] - 2;
        int localEY = (int)rect[3] - 2;
        float[] values = new float[multiPoints.size()];
        for (int i2 = 0; i2 != multiPoints.size(); ++i2) {
            if (i2 % 2 == 0) {
                if (localSX > multiPoints.get(i2)) {
                    localSX = multiPoints.get(i2);
                }
                if (localEX < multiPoints.get(i2)) {
                    localEX = multiPoints.get(i2);
                }
            } else {
                if (localSY > multiPoints.get(i2)) {
                    localSY = multiPoints.get(i2);
                }
                if (localEY < multiPoints.get(i2)) {
                    localEY = multiPoints.get(i2);
                }
            }
            values[i2] = multiPoints.get(i2).intValue();
        }
        currentAnnot.setFloatArray(573911876, AnnotationUtils.validateCoordinates(localSX - 2, localSY - 2, localEX + 2, localEY + 2));
        switch (currentAnnot.getNameAsConstant(1147962727)) {
            case 1654331: {
                float[][] inkList = currentAnnot.getFloat2DArray(475169151);
                inkList[inkList.length - 1] = values;
                currentAnnot.setFloat2DArray(475169151, inkList);
                break;
            }
            case 1014528638: 
            case 1230470778: {
                currentAnnot.setFloatArray(1600681863, values);
            }
        }
    }
}

