/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.popups.DisplayXObject;
import org.jpedal.examples.viewer.gui.popups.StreamViewer;
import org.jpedal.examples.viewer.utils.ObjectHighlighter;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class XrefViewer
extends JFrame {
    private final ObjectHighlighter objectHighlighter;
    private final PdfFileReader pdfFileReader;
    private final PdfObjectReader pdfObjectReader;
    private String currentRef = "";
    private boolean showRawStreams;
    private long currentOffset = -1L;
    private int currentOffsetLength = -1;
    private final JTextPane textPane;
    private final JScrollPane textAreaScrollPane;

    public XrefViewer(PdfObjectReader pdfObjectReader) {
        super(Messages.getMessage("PdfViewer.XrefWindowTitle"));
        this.pdfObjectReader = pdfObjectReader;
        this.pdfFileReader = pdfObjectReader.getObjectReader();
        this.objectHighlighter = new ObjectHighlighter(this.pdfFileReader);
        this.textPane = new JTextPane();
        this.textAreaScrollPane = new JScrollPane(this.textPane, 22, 30);
    }

    public void init(SwingGUI currentGUI) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.textPane.setFont(new Font("Monospaced", 0, 12));
        this.textPane.setEditable(false);
        this.textAreaScrollPane.setPreferredSize(new Dimension(600, 550));
        JPanel bottomButtons = new JPanel();
        bottomButtons.setLayout(new BorderLayout());
        JRadioButton hexButton = new JRadioButton("Hex", true);
        JRadioButton rawButton = new JRadioButton("Raw");
        ActionListener radioButtonActionListener = e2 -> {
            this.showRawStreams = rawButton.isSelected();
            this.displayObject(this.currentOffset, this.currentOffsetLength);
        };
        hexButton.addActionListener(radioButtonActionListener);
        rawButton.addActionListener(radioButtonActionListener);
        ButtonGroup radioGroup = new ButtonGroup();
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new GridBagLayout());
        radioGroup.add(hexButton);
        radioGroup.add(rawButton);
        radioPanel.add(hexButton);
        radioPanel.add(rawButton);
        bottomButtons.add((Component)radioPanel, "Before");
        JPanel rightSideButtons = new JPanel(new BorderLayout());
        JButton streamButton = new JButton("Decode Stream");
        streamButton.addActionListener(e2 -> StreamViewer.display(this.pdfObjectReader, this, this.currentRef));
        rightSideButtons.add((Component)streamButton, "Before");
        JButton imageButton = new JButton("Show Image");
        imageButton.addActionListener(e2 -> DisplayXObject.display(this.pdfObjectReader, this, this.currentRef));
        rightSideButtons.add((Component)imageButton, "After");
        bottomButtons.add((Component)rightSideButtons, "After");
        JPanel buttonsPanel = new JPanel(new GridLayout(0, 1));
        JScrollPane buttonsPanelScrollPane = new JScrollPane(buttonsPanel);
        buttonsPanelScrollPane.getVerticalScrollBar().setUnitIncrement(6);
        buttonsPanelScrollPane.setPreferredSize(new Dimension(150, 550));
        LinkedHashMap<Long, Integer> xrefData = new LinkedHashMap<Long, Integer>();
        for (int i2 = 1; i2 < this.pdfFileReader.getOffsetCapacity(); ++i2) {
            int offsetLength = this.pdfFileReader.getOffsetLength(i2);
            if (offsetLength == 0) continue;
            xrefData.put(this.pdfFileReader.getOffset(i2), offsetLength);
        }
        if (xrefData.isEmpty()) {
            LogWriter.writeLog("Cannot find Xref data");
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.XrefMissingError"));
            return;
        }
        for (Map.Entry xrefEntry : xrefData.entrySet()) {
            long offset = (Long)xrefEntry.getKey();
            int offsetLength = (Integer)xrefEntry.getValue();
            JButton button = new JButton(this.getButtonText(offset, offsetLength));
            button.addActionListener(e2 -> this.displayObject(offset, offsetLength));
            buttonsPanel.add(button);
        }
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)buttonsPanelScrollPane, gridBagConstraints);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints contentGridBagConstraints = new GridBagConstraints();
        contentGridBagConstraints.fill = 1;
        contentGridBagConstraints.gridx = 0;
        contentGridBagConstraints.gridy = 0;
        contentPane.add((Component)this.textAreaScrollPane, contentGridBagConstraints);
        contentGridBagConstraints.fill = 2;
        contentGridBagConstraints.gridx = 0;
        contentGridBagConstraints.gridy = 1;
        contentPane.add((Component)bottomButtons, contentGridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridx = 1;
        this.add((Component)contentPane, gridBagConstraints);
        this.pack();
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(currentGUI.getFrame());
        this.setVisible(true);
    }

    private String getButtonText(long offset, int offsetLength) {
        String buttonText = new String(this.pdfFileReader.getBytes(offset, offsetLength));
        int objIndex = buttonText.indexOf("obj");
        return buttonText.substring(0, objIndex) + "@ " + offset;
    }

    private void displayObject(long offset, int offsetLength) {
        if (offset == -1L || offsetLength == -1) {
            return;
        }
        this.currentOffset = offset;
        this.currentOffsetLength = offsetLength;
        byte[] bytes = this.pdfFileReader.getBytes(offset, offsetLength);
        this.objectHighlighter.highlight(this.showRawStreams ? ObjectHighlighter.getBytesAsString(bytes) : this.objectHighlighter.hexifyStream(bytes), this.textPane);
        this.textAreaScrollPane.getViewport().setViewPosition(new Point(0, 0));
        this.textPane.setCaretPosition(0);
        String object = new String(bytes);
        this.currentRef = object.substring(0, object.indexOf("obj")) + 'R';
    }
}

