/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class TipOfTheDay
extends JDialog {
    private final List<String> tipPaths = new ArrayList<String>();
    private boolean tipLoadingFailed;
    private int currentTip;
    private final JEditorPane tipPane = new JEditorPane();
    private final JCheckBox showTipsOnStartup = new JCheckBox(Messages.getMessage("PdfViewerTipOfDay.Show"));

    public TipOfTheDay(Container parent, String tipsRoot, PropertiesFile propertiesFile) {
        super((Frame)null, Messages.getMessage("PdfCustomGui.Tipoftheday"), true);
        this.setDefaultCloseOperation(2);
        try {
            this.populateTipsList(tipsRoot, this.tipPaths);
        }
        catch (IOException e2) {
            this.tipLoadingFailed = true;
            LogWriter.writeLog("Exception " + e2.getMessage());
        }
        this.currentTip = ThreadLocalRandom.current().nextInt(this.tipPaths.size());
        this.setSize(550, 350);
        this.init(propertiesFile);
        this.setLocationRelativeTo(parent);
    }

    private void init(PropertiesFile propertiesFile) {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints mainPanelConstraints = new GridBagConstraints();
        mainPanelConstraints.gridx = 0;
        mainPanelConstraints.gridy = 0;
        mainPanelConstraints.fill = 2;
        mainPanelConstraints.anchor = 19;
        mainPanelConstraints.weighty = 0.0;
        mainPanelConstraints.weightx = 0.0;
        mainPanelConstraints.insets = new Insets(10, 10, 0, 10);
        this.addTopPanel(mainPanelConstraints);
        mainPanelConstraints.fill = 1;
        mainPanelConstraints.gridy = 1;
        mainPanelConstraints.weighty = 1.0;
        mainPanelConstraints.weightx = 1.0;
        this.addCenterTip(mainPanelConstraints);
        mainPanelConstraints.fill = 2;
        mainPanelConstraints.gridy = 2;
        mainPanelConstraints.weighty = 0.0;
        mainPanelConstraints.weightx = 0.0;
        mainPanelConstraints.insets = new Insets(0, 7, 0, 10);
        this.addDisplayOnStartup(mainPanelConstraints, propertiesFile);
        mainPanelConstraints.gridy = 3;
        mainPanelConstraints.insets = new Insets(0, 0, 10, 10);
        this.addBottomButtons(mainPanelConstraints);
    }

    private void addDisplayOnStartup(GridBagConstraints mainPanelConstraints, PropertiesFile propertiesFile) {
        String propValue = propertiesFile.getValue("displaytipsonstartup");
        if (!propValue.isEmpty()) {
            this.showTipsOnStartup.setSelected("true".equals(propValue));
        }
        this.showTipsOnStartup.addActionListener(e2 -> propertiesFile.setValue("displaytipsonstartup", String.valueOf(this.showTipsOnStartup.isSelected())));
        this.getContentPane().add((Component)this.showTipsOnStartup, mainPanelConstraints);
    }

    private void addBottomButtons(GridBagConstraints mainPanelConstraints) {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 2));
        bottomPanel.add(Box.createHorizontalGlue());
        JButton previousTip = new JButton(Messages.getMessage("PdfViewerTipOfDay.Previous"));
        previousTip.addActionListener(e2 -> this.changeTip(-1));
        bottomPanel.add(previousTip);
        bottomPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton nextTip = new JButton(Messages.getMessage("PdfViewerTipOfDay.Next"));
        nextTip.addActionListener(e2 -> this.changeTip(1));
        nextTip.setPreferredSize(previousTip.getPreferredSize());
        bottomPanel.add(nextTip);
        bottomPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton close = new JButton(Messages.getMessage("PdfViewerButton.Close"));
        close.addActionListener(e2 -> {
            this.dispose();
            this.setVisible(false);
        });
        close.setPreferredSize(previousTip.getPreferredSize());
        this.setFocusTraversalPolicy(new MyFocus(this.getFocusTraversalPolicy(), close));
        close.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    TipOfTheDay.this.dispose();
                    TipOfTheDay.this.setVisible(false);
                }
            }
        });
        bottomPanel.add(close);
        this.getContentPane().add((Component)bottomPanel, mainPanelConstraints);
    }

    private void changeTip(int ammount) {
        this.currentTip += ammount;
        if (this.currentTip == this.tipPaths.size()) {
            this.currentTip = 0;
        } else if (this.currentTip == -1) {
            this.currentTip = this.tipPaths.size() - 1;
        }
        if (!this.tipLoadingFailed) {
            try {
                this.tipPane.setPage(this.getClass().getResource(this.tipPaths.get(this.currentTip)));
            }
            catch (IOException e2) {
                this.tipLoadingFailed = true;
                LogWriter.writeLog("Exception " + e2.getMessage());
            }
        }
        if (this.tipLoadingFailed) {
            this.tipPane.setText("Error displaying tips, no tip to display");
        }
    }

    private void populateTipsList(String tipRoot, List<String> items) throws IOException {
        block17: {
            try {
                URL url = this.getClass().getResource(tipRoot);
                if (url.toString().startsWith("jar")) {
                    JarURLConnection conn = (JarURLConnection)url.openConnection();
                    try (JarFile jar = conn.getJarFile();){
                        Enumeration<JarEntry> e2 = jar.entries();
                        while (e2.hasMoreElements()) {
                            JarEntry entry = e2.nextElement();
                            String name = entry.getName();
                            if (entry.isDirectory() || !name.contains("/res/tips/") || !name.endsWith(".html")) continue;
                            items.add('/' + name);
                        }
                        break block17;
                    }
                }
                try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));){
                    String inputLine;
                    while ((inputLine = in.readLine()) != null) {
                        if (inputLine.indexOf(46) == -1) {
                            this.populateTipsList(tipRoot + '/' + inputLine, items);
                            continue;
                        }
                        if (!inputLine.endsWith(".htm") && !inputLine.endsWith(".html")) continue;
                        items.add(tipRoot + '/' + inputLine);
                    }
                }
            }
            catch (IOException e3) {
                LogWriter.writeLog("Exception " + e3.getMessage());
                throw e3;
            }
        }
    }

    private void addCenterTip(GridBagConstraints mainPanelConstraints) {
        this.tipPane.setEditable(false);
        this.tipPane.setAutoscrolls(true);
        this.tipPane.addHyperlinkListener(e2 -> {
            if (e2.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                try {
                    Desktop.getDesktop().browse(new URI(e2.getURL().toExternalForm()));
                }
                catch (Exception ex) {
                    LogWriter.writeLog(ex);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.tipPane);
        scrollPane.setBorder(BorderFactory.createBevelBorder(1));
        this.getContentPane().add((Component)scrollPane, mainPanelConstraints);
        this.changeTip(0);
    }

    private void addTopPanel(GridBagConstraints mainPanelConstraints) {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 2));
        JLabel tipImage = new JLabel(new ImageIcon(this.getClass().getResource("/org/jpedal/examples/viewer/res/tip.png")));
        topPanel.add(tipImage);
        JLabel label = new JLabel(Messages.getMessage("PdfViewerTipOfDay.DidYouKnow"));
        Font font = label.getFont().deriveFont(16.0f);
        label.setFont(font);
        topPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        topPanel.add(label);
        this.getContentPane().add((Component)topPanel, mainPanelConstraints);
    }

    static class MyFocus
    extends FocusTraversalPolicy {
        final FocusTraversalPolicy original;
        final JButton close;

        MyFocus(FocusTraversalPolicy original, JButton close) {
            this.original = original;
            this.close = close;
        }

        @Override
        public Component getComponentAfter(Container arg0, Component arg1) {
            return this.original.getComponentAfter(arg0, arg1);
        }

        @Override
        public Component getComponentBefore(Container arg0, Component arg1) {
            return this.original.getComponentBefore(arg0, arg1);
        }

        @Override
        public Component getFirstComponent(Container arg0) {
            return this.original.getFirstComponent(arg0);
        }

        @Override
        public Component getLastComponent(Container arg0) {
            return this.original.getLastComponent(arg0);
        }

        @Override
        public Component getDefaultComponent(Container arg0) {
            return this.close;
        }
    }
}

