/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jpedal.PdfDecoder;
import org.jpedal.constants.JPedalSettings;
import org.jpedal.examples.viewer.gui.CheckNode;
import org.jpedal.examples.viewer.gui.CheckRenderer;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.popups.ButtonBarPanel;
import org.jpedal.examples.viewer.utils.PrintStatus;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.io.Speech;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.RenderUtils;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;
import org.w3c.dom.NodeList;

public class SwingProperties
extends JPanel {
    private final PdfDecoder decode_pdf;
    private final int TRUE_HASH = "true".hashCode();
    private final Speech speech;
    private final Map<String, String> reverseMessage = new HashMap<String, String>();
    private final String[] menuTabs = new String[]{"ShowMenubar", "ShowButtons", "ShowDisplayoptions", "ShowNavigationbar", "ShowSidetabbar"};
    private String propertiesLocation = "";
    private PropertiesFile properties;
    private JDialog propertiesDialog;
    private JTabbedPane tabs;
    private JTextField resolution;
    private JComboBox<String> searchStyle;
    private JComboBox<String> lookAndFeel;
    private JCheckBox liveSearchResuts;
    private JCheckBox border;
    private JCheckBox showFormFieldHighlights;
    private JCheckBox constantTabs;
    private JCheckBox enhancedViewer;
    private JCheckBox offScreenRendering;
    private JCheckBox enhanceFractionalLines;
    private JCheckBox treatURLTextAsLInk;
    private JCheckBox hideLineWeights;
    private JCheckBox useSmoothImage;
    private JCheckBox enhancedFacing;
    private JCheckBox thumbnailScroll;
    private JCheckBox rightClick;
    private JCheckBox scrollwheelZoom;
    private JCheckBox update;
    private JTextField pageInsets;
    private JTextField pageMoveDelay;
    private JTextField windowTitle;
    private JRadioButton darkIconSet;
    private JRadioButton classicIconSet;
    private static final String darkIconLocation = "/org/jpedal/examples/viewer/res/dark/";
    private static final String classicIconLocation = "/org/jpedal/examples/viewer/res/";
    private JTextField iconLocation;
    private JTextField printerBlacklist;
    private JComboBox<String> defaultPrinter;
    private JComboBox<String> defaultPagesize;
    private JTextField defaultPrintResolution;
    private JTextField sideTabLength;
    private JCheckBox useHinting;
    private JCheckBox autoScroll;
    private JCheckBox confirmClose;
    private JCheckBox openLastDoc;
    private JComboBox<String> pageLayout;
    private JComboBox<String> voiceSelect;
    private JPanel highlightBoxColor;
    private JPanel viewBGColor;
    private JPanel pdfDecoderBackground;
    private JPanel foreGroundColor;
    private JPanel formFieldHighlightColor;
    private JCheckBox invertHighlight;
    private JCheckBox replaceDocTextCol;
    private JCheckBox replaceDisplayBGCol;
    private JCheckBox changeTextAndLineArt;
    private JCheckBox showMouseSelectionBox;
    private JTextField highlightComposite;
    private JTextField formFieldHighlightComposite;
    private boolean preferencesSetup;
    private JButton clearHistory;
    private JLabel historyClearedLabel;
    private final KeyListener numericalKeyListener = new KeyAdapter(){
        boolean consume;

        @Override
        public void keyPressed(KeyEvent e2) {
            this.consume = !(e2.getKeyChar() >= '0' && e2.getKeyChar() <= '9' || e2.getKeyCode() == 8 && e2.getKeyCode() == 127);
        }

        @Override
        public void keyTyped(KeyEvent e2) {
            if (this.consume) {
                e2.consume();
            }
        }
    };

    private void loadBooleanValue(JCheckBox comp, String elementName) {
        String value = this.properties.getValue(elementName).toLowerCase();
        comp.setSelected(!value.isEmpty() && value.hashCode() == this.TRUE_HASH);
    }

    private void loadBooleanValue(CheckNode comp, String elementName) {
        String value = this.properties.getValue(elementName).toLowerCase();
        comp.setSelected(!value.isEmpty() && value.hashCode() == this.TRUE_HASH);
    }

    private void loadStringValue(JTextField comp, String elementName) {
        String propValue = this.properties.getValue(elementName);
        if (propValue != null && !propValue.isEmpty()) {
            comp.setText(propValue);
        }
    }

    private void loadStringValue(JTextField comp, String elementName, String defaultText) {
        String propValue = this.properties.getValue(elementName);
        if (propValue != null && !propValue.isEmpty()) {
            comp.setText(propValue);
        } else {
            comp.setText(defaultText);
        }
    }

    public SwingProperties(SwingGUI currentGUI) {
        this.decode_pdf = currentGUI.getPdfDecoder();
        this.speech = (Speech)this.decode_pdf.getExternalHandler(32);
        this.showPreferenceWindow(currentGUI);
    }

    private void showPreferenceWindow(SwingGUI currentGUI) {
        this.propertiesDialog = currentGUI.getFrame() instanceof JFrame ? new JDialog((Frame)currentGUI.getFrame()) : new JDialog();
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setDefaultCloseOperation(2);
        if (!this.preferencesSetup) {
            this.preferencesSetup = true;
            this.createPreferenceWindow(currentGUI);
        }
        if (this.properties.isReadOnly()) {
            JOptionPane.showMessageDialog(this, Messages.getMessage("PdfPreferences.readOnlyFile.text1") + '\n' + Messages.getMessage("PdfPreferences.readOnlyFile.text2"), Messages.getMessage("PdfPreferences.readOnlyFile.title"), 1);
        }
        this.propertiesDialog.setLocationRelativeTo(currentGUI.getFrame());
        this.propertiesDialog.setVisible(true);
    }

    private void saveGUIPreferences(SwingGUI gui) {
        Component[] components = this.tabs.getComponents();
        for (int i2 = 0; i2 != components.length; ++i2) {
            if (!(components[i2] instanceof JPanel)) continue;
            Component[] panelComponets = ((Container)components[i2]).getComponents();
            for (int j2 = 0; j2 != panelComponets.length; ++j2) {
                if (panelComponets[j2] instanceof JScrollPane) {
                    Component[] scrollComponents = ((Container)panelComponets[j2]).getComponents();
                    for (int k2 = 0; k2 != scrollComponents.length; ++k2) {
                        if (!(scrollComponents[k2] instanceof JViewport)) continue;
                        Component[] viewportComponents = ((Container)scrollComponents[k2]).getComponents();
                        for (int l2 = 0; l2 != viewportComponents.length; ++l2) {
                            JTree tree;
                            CheckNode root;
                            if (!(viewportComponents[l2] instanceof JTree) || (root = (CheckNode)(tree = (JTree)viewportComponents[l2]).getModel().getRoot()).getChildCount() <= 0) continue;
                            this.saveMenuPreferencesChildren(root, gui);
                        }
                    }
                }
                if (!(panelComponets[j2] instanceof JButton)) continue;
                JButton tempButton = (JButton)panelComponets[j2];
                String value = this.reverseMessage.get(tempButton.getText().substring((Messages.getMessage("PdfCustomGui.HideGuiSection") + ' ').length()));
                if (tempButton.getText().startsWith(Messages.getMessage("PdfCustomGui.HideGuiSection") + ' ')) {
                    this.properties.setValue(value, "true");
                    gui.alterProperty(value, true);
                    continue;
                }
                this.properties.setValue(value, "false");
                gui.alterProperty(value, false);
            }
        }
    }

    private void saveMenuPreferencesChildren(CheckNode root, SwingGUI gui) {
        for (int i2 = 0; i2 != root.getChildCount(); ++i2) {
            CheckNode node = (CheckNode)root.getChildAt(i2);
            String value = this.reverseMessage.get(node.getText());
            if (node.isSelected()) {
                this.properties.setValue(value, "true");
                gui.alterProperty(value, true);
            } else {
                this.properties.setValue(value, "false");
                gui.alterProperty(value, false);
            }
            if (node.getChildCount() <= 0) continue;
            this.saveMenuPreferencesChildren(node, gui);
        }
    }

    private void createPreferenceWindow(SwingGUI gui) {
        this.properties = gui.getProperties();
        this.propertiesLocation = gui.getPropertiesFileLocation();
        this.propertiesDialog.setTitle(Messages.getMessage("PdfPreferences.windowTitle"));
        this.propertiesDialog.getContentPane().setLayout(new BorderLayout());
        this.propertiesDialog.getContentPane().add((Component)this, "Center");
        this.propertiesDialog.pack();
        if (DecoderOptions.isRunningOnMac) {
            this.propertiesDialog.setSize(600, 475);
        } else {
            this.propertiesDialog.setSize(550, 450);
        }
        this.createGeneralPaneGuiItems(gui);
        this.createPageDisplayPaneGuiItems();
        this.createInterfaceGuiItems();
        this.createColorGuiItems();
        this.createPrintingGuiItems(gui);
        this.buildWindowContents(gui, this.createButtonPanel(gui));
    }

    private void buildWindowContents(SwingGUI gui, JPanel buttonPanel) {
        this.setLayout(new BorderLayout());
        JPanel toolbar = new JPanel();
        BoxLayout layout = new BoxLayout(toolbar, 1);
        toolbar.setLayout(layout);
        ButtonBarPanel buttonBarPanel = new ButtonBarPanel(toolbar);
        this.setupButtonBarPanel(buttonBarPanel, gui, toolbar);
        this.add((Component)buttonBarPanel, "Center");
        toolbar.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.gray));
        this.add((Component)buttonPanel, "South");
    }

    private JPanel createButtonPanel(SwingGUI gui) {
        JButton confirm = new JButton();
        JButton cancel = new JButton();
        JButton save = this.createSaveButtonGuiItem(gui);
        JButton reset = this.createResetButtonGuiItem(gui);
        confirm.setText(Messages.getMessage("PdfPreferences.OK"));
        cancel.setText(Messages.getMessage("PdfPreferences.Cancel"));
        confirm.addActionListener(arg0 -> {
            this.setPreferences(gui);
            try {
                this.properties.writeDoc();
            }
            catch (Exception e2) {
                LogWriter.writeLog("Attempting to write properties " + e2);
            }
            if (SwingGUI.showMessages) {
                JOptionPane.showMessageDialog(null, Messages.getMessage("PdfPreferences.savedTo") + this.propertiesLocation + '\n' + Messages.getMessage("PdfPreferences.restart"), "Restart Jpedal", 1);
            }
            this.propertiesDialog.setVisible(false);
        });
        confirm.setToolTipText(Messages.getMessage("PdfPreferences.confirm.toolTip"));
        cancel.addActionListener(arg0 -> this.propertiesDialog.setVisible(false));
        cancel.setToolTipText(Messages.getMessage("PdfPreferences.cancel.toolTip"));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        Dimension dimension = new Dimension(5, 40);
        Box.Filler filler = new Box.Filler(dimension, dimension, dimension);
        confirm.setPreferredSize(cancel.getPreferredSize());
        confirm.setEnabled(!this.properties.isReadOnly());
        buttonPanel.add(Box.createHorizontalStrut(4));
        buttonPanel.add(reset);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(confirm);
        buttonPanel.add(save);
        this.getRootPane().setDefaultButton(confirm);
        buttonPanel.add(filler);
        buttonPanel.add(cancel);
        buttonPanel.add(filler);
        buttonPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
        return buttonPanel;
    }

    private JButton createResetButtonGuiItem(SwingGUI gui) {
        JButton reset = new JButton(Messages.getMessage("PdfPreferences.ResetToDefault"));
        reset.setToolTipText(Messages.getMessage("PdfPreferences.reset.toolTip"));
        reset.addActionListener(e2 -> {
            int result = JOptionPane.showConfirmDialog(this.propertiesDialog, Messages.getMessage("PdfPreferences.reset"), Messages.getMessage("PdfPreferences.reset.popupTitle"), 0);
            if (result == 0) {
                String lastProperties = gui.getPropertiesFileLocation();
                File f2 = new File(lastProperties);
                if (f2.exists()) {
                    f2.delete();
                }
                gui.getProperties().loadProperties(lastProperties);
                try {
                    this.properties.writeDoc();
                }
                catch (Exception e22) {
                    LogWriter.writeLog("Attempting to write properties " + e22);
                }
                if (SwingGUI.showMessages) {
                    JOptionPane.showMessageDialog(this.propertiesDialog, Messages.getMessage("PdfPreferences.restart"));
                }
                this.propertiesDialog.setVisible(false);
            }
        });
        return reset;
    }

    private JButton createSaveButtonGuiItem(SwingGUI gui) {
        JButton save = new JButton(Messages.getMessage("PdfPreferences.SaveAs"));
        save.setToolTipText(Messages.getMessage("PdfPreferences.save.toolTip"));
        save.addActionListener(e2 -> {
            String lastProperties = gui.getPropertiesFileLocation();
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return ".xml";
                }

                @Override
                public boolean accept(File f2) {
                    return f2.isDirectory() || f2.getAbsolutePath().endsWith(".xml");
                }
            });
            int i2 = fileChooser.showSaveDialog(this.propertiesDialog);
            if (i2 == 0) {
                String ext = fileChooser.getFileFilter().getDescription();
                File f2 = fileChooser.getSelectedFile();
                String name = fileChooser.getName(f2);
                if (!"All Files".equals(ext) && !name.endsWith(ext)) {
                    name = name + ext;
                    f2 = new File(f2.getParent() + System.getProperty("file.separator") + name);
                }
                if (f2.exists()) {
                    f2.delete();
                }
                gui.setPropertiesFileLocation(f2.getAbsolutePath());
                this.setPreferences(gui);
                try {
                    this.properties.writeDoc();
                }
                catch (Exception e1) {
                    LogWriter.writeLog("Attempting to write properties " + e1);
                }
            }
            gui.setPropertiesFileLocation(lastProperties);
        });
        return save;
    }

    private void createPrintingGuiItems(SwingGUI gui) {
        this.defaultPrinter = new JComboBox<String>(PrintStatus.getAvailablePrinters(this.properties.getValue("printerBlacklist")));
        PrintService defaultPrintService = PrintServiceLookup.lookupDefaultPrintService();
        if (defaultPrintService != null) {
            this.defaultPrinter.addItem(Messages.getMessage("PdfPreferences.systemDefault.text") + " (" + defaultPrintService.getName() + ')');
        } else {
            this.defaultPrinter.addItem(Messages.getMessage("PdfPreferences.systemDefault.text"));
        }
        this.defaultPrinter.setToolTipText(Messages.getMessage("PdfPreferences.defaultPrinter.toolTip"));
        this.defaultPagesize = new JComboBox();
        this.defaultPagesize.setModel(new DefaultComboBoxModel<String>(gui.getPaperSizes().getPaperSizes()));
        this.defaultPagesize.setSelectedIndex(gui.getPaperSizes().getDefaultPageIndex());
        this.defaultPagesize.setToolTipText(Messages.getMessage("PdfPreferences.defaultPageSize.toolTip"));
        this.defaultPrintResolution = new JTextField();
        this.defaultPrintResolution.setToolTipText(Messages.getMessage("PdfPreferences.defaultDPI.toolTip"));
        this.printerBlacklist = new JTextField();
        this.printerBlacklist.setToolTipText(Messages.getMessage("PdfPreferences.printerBlackList.toolTip"));
    }

    private void createColorGuiItems() {
        this.invertHighlight = new JCheckBox(Messages.getMessage("PdfPreferences.InvertHighlight"));
        this.invertHighlight.setToolTipText(Messages.getMessage("PdfPreferences.invertHighlight.toolTip"));
        this.highlightBoxColor = new JPanel();
        this.highlightBoxColor.setToolTipText(Messages.getMessage("PdfPreferences.highlightBox.toolTip"));
        this.showFormFieldHighlights = new JCheckBox(Messages.getMessage("PdfCustomGui.showFormFieldHighlights"));
        this.showFormFieldHighlights.setToolTipText(Messages.getMessage("PdfCustomGui.showFormFieldHighlights.toolTip"));
        this.formFieldHighlightColor = new JPanel();
        this.formFieldHighlightColor.setToolTipText(Messages.getMessage("PdfPreferences.formFieldHighlightBox.toolTip"));
        this.highlightComposite = new JTextField(String.valueOf(DecoderOptions.highlightComposite));
        this.highlightComposite.addKeyListener(new KeyAdapter(){
            boolean consume;

            @Override
            public void keyPressed(KeyEvent e2) {
                this.consume = !(!((JTextComponent)e2.getSource()).getText().contains(".") || e2.getKeyChar() != '.' || e2.getKeyChar() >= '0' && e2.getKeyChar() <= '9' || e2.getKeyCode() == 8 && e2.getKeyCode() == 127);
            }

            @Override
            public void keyTyped(KeyEvent e2) {
                if (this.consume) {
                    e2.consume();
                }
            }
        });
        this.highlightComposite.setToolTipText(Messages.getMessage("PdfPreferences.highlightComposite.toolTip"));
        this.formFieldHighlightComposite = new JTextField();
        this.formFieldHighlightComposite.addKeyListener(new KeyAdapter(){
            boolean consume;

            @Override
            public void keyPressed(KeyEvent e2) {
                this.consume = !(!((JTextComponent)e2.getSource()).getText().contains(".") || e2.getKeyChar() != '.' || e2.getKeyChar() >= '0' && e2.getKeyChar() <= '9' || e2.getKeyCode() == 8 && e2.getKeyCode() == 127);
            }

            @Override
            public void keyTyped(KeyEvent e2) {
                if (this.consume) {
                    e2.consume();
                }
            }
        });
        this.formFieldHighlightComposite.setToolTipText(Messages.getMessage("PdfPreferences.formFieldHighlightComposite.toolTip"));
    }

    private void createInterfaceGuiItems() {
        this.createInterfaceAppearanceGuiItems();
        this.createInterfaceMouseGuiItems();
    }

    private void createInterfaceMouseGuiItems() {
        this.rightClick = new JCheckBox(Messages.getMessage("PdfCustomGui.allowRightClick"));
        this.rightClick.setToolTipText(Messages.getMessage("PdfCustomGui.allowRightClick.toolTip"));
        this.scrollwheelZoom = new JCheckBox(Messages.getMessage("PdfCustomGui.allowScrollwheelZoom"));
        this.scrollwheelZoom.setToolTipText(Messages.getMessage("PdfCustomGui.allowScrollwheelZoom.toolTip"));
        this.showMouseSelectionBox = new JCheckBox(Messages.getMessage("PdfPreferences.ShowSelectionBow"));
        this.showMouseSelectionBox.setToolTipText(Messages.getMessage("PdfPreferences.showMouseSelection.toolTip"));
    }

    private void createInterfaceAppearanceGuiItems() {
        this.windowTitle = new JTextField();
        this.windowTitle.setToolTipText(Messages.getMessage("PdfPreferences.windowTitle.toolTip"));
        this.darkIconSet = new JRadioButton(Messages.getMessage("PdfViewerViewMenu.darkIconButton"));
        this.classicIconSet = new JRadioButton(Messages.getMessage("PdfViewerViewMenu.classicIconButton"));
        ButtonGroup skinGroup = new ButtonGroup();
        skinGroup.add(this.darkIconSet);
        skinGroup.add(this.classicIconSet);
        this.darkIconSet.addActionListener(e2 -> this.iconLocation.setText(darkIconLocation));
        this.classicIconSet.addActionListener(e2 -> this.iconLocation.setText(classicIconLocation));
        this.iconLocation = new JTextField();
        this.iconLocation.setToolTipText(Messages.getMessage("PdfPreferences.iconLocation.toolTip"));
        this.iconLocation.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                if (SwingProperties.darkIconLocation.equals(SwingProperties.this.iconLocation.getText())) {
                    SwingProperties.this.darkIconSet.setSelected(true);
                }
                if (SwingProperties.classicIconLocation.equals(SwingProperties.this.iconLocation.getText())) {
                    SwingProperties.this.classicIconSet.setSelected(true);
                }
            }
        });
        this.searchStyle = new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.WindowSearch"), Messages.getMessage("PageLayoutViewMenu.TabbedSearch"), Messages.getMessage("PageLayoutViewMenu.MenuSearch")});
        this.searchStyle.setToolTipText(Messages.getMessage("PdfPreferences.searchStyle.toolTip"));
        this.liveSearchResuts = new JCheckBox(Messages.getMessage("PageLayoutViewMenu.LiveSearchResults"));
        this.liveSearchResuts.setToolTipText(Messages.getMessage("PdfPreferences.LiveSearchResults.toolTip"));
        this.sideTabLength = new JTextField();
        this.sideTabLength.setToolTipText(Messages.getMessage("PdfPreferences.sideTabLength.toolTip"));
        this.constantTabs = new JCheckBox(Messages.getMessage("PdfCustomGui.consistentTabs"));
        this.constantTabs.setToolTipText(Messages.getMessage("PdfCustomGui.consistentTabs.toolTip"));
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        String[] classNames = new String[lafs.length + 1];
        classNames[0] = "SystemDefault";
        for (int i2 = 0; i2 != lafs.length; ++i2) {
            classNames[i2 + 1] = lafs[i2].getClassName();
        }
        this.lookAndFeel = new JComboBox<String>(classNames);
        this.lookAndFeel.setToolTipText(Messages.getMessage("PdfPreferences.lookAndFeel.toolTip"));
    }

    private void createPageDisplayPaneGuiItems() {
        this.enhancedViewer = new JCheckBox(Messages.getMessage("PdfCustomGui.enhancedViewer"));
        this.enhancedViewer.setToolTipText(Messages.getMessage("PdfCustomGui.enhancedViewer.toolTip"));
        this.offScreenRendering = new JCheckBox(Messages.getMessage("PdfCustomGui.offScreenRendering"));
        this.offScreenRendering.setToolTipText(Messages.getMessage("PdfCustomGui.offScreenRendering.toolTip"));
        this.enhanceFractionalLines = new JCheckBox(Messages.getMessage("PdfCustomGui.enhanceFractionalLines"));
        this.enhanceFractionalLines.setToolTipText(Messages.getMessage("PdfCustomGui.enhanceFractionalLines.toolTip"));
        this.treatURLTextAsLInk = new JCheckBox(Messages.getMessage("PdfCustomGui.treatURLTextAsLInk"));
        this.treatURLTextAsLInk.setToolTipText(Messages.getMessage("PdfCustomGui.treatURLTextAsLInk.toolTip"));
        this.hideLineWeights = new JCheckBox(Messages.getMessage("PdfCustomGui.hideLineWeights"));
        this.hideLineWeights.setToolTipText(Messages.getMessage("PdfCustomGui.hideLineWeights.toolTip"));
        this.useSmoothImage = new JCheckBox(Messages.getMessage("PdfCustomGui.useSmoothImage"));
        this.useSmoothImage.setToolTipText(Messages.getMessage("PdfCustomGui.useSmoothImage.toolTip"));
        this.border = new JCheckBox(Messages.getMessage("PageLayoutViewMenu.Borders_Show"));
        this.border.setToolTipText(Messages.getMessage("PageLayoutViewMenu.Borders.toolTip"));
        this.pageInsets = new JTextField();
        this.pageInsets.setToolTipText(Messages.getMessage("PdfPreferences.pageInsets.toolTip"));
        this.pageMoveDelay = new JTextField();
        this.pageMoveDelay.setToolTipText(Messages.getMessage("PdfPreferences.pageMoveDelay.toolTip"));
        this.pageLayout = new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.SinglePage"), Messages.getMessage("PageLayoutViewMenu.Continuous"), Messages.getMessage("PageLayoutViewMenu.ContinousFacing"), Messages.getMessage("PageLayoutViewMenu.Facing"), Messages.getMessage("PageLayoutViewMenu.PageFlow")});
        this.pageLayout.setToolTipText(Messages.getMessage("PdfPreferences.pageLayout.toolTip"));
        this.enhancedFacing = new JCheckBox(Messages.getMessage("PdfCustomGui.enhancedFacing"));
        this.enhancedFacing.setToolTipText(Messages.getMessage("PdfCustomGui.enhancedFacing.toolTip"));
        this.thumbnailScroll = new JCheckBox(Messages.getMessage("PdfCustomGui.thumbnailScroll"));
        this.thumbnailScroll.setToolTipText(Messages.getMessage("PdfCustomGui.thumbnailScroll.toolTip"));
    }

    private void createGeneralPaneGuiItems(SwingGUI gui) {
        this.resolution = new JTextField();
        this.loadStringValue(this.resolution, "resolution", "72");
        this.resolution.setToolTipText(Messages.getMessage("PdfPreferences.resolutionInput.toolTip"));
        this.resolution.addKeyListener(this.numericalKeyListener);
        this.useHinting = new JCheckBox(Messages.getMessage("PdfCustomGui.useHinting"));
        this.useHinting.setToolTipText(Messages.getMessage("PdfPreferences.useHinting.toolTip"));
        this.autoScroll = new JCheckBox(Messages.getMessage("PdfViewerViewMenuAutoscrollSet.text"));
        this.autoScroll.setToolTipText(Messages.getMessage("PdfViewerViewMenuAutoscrollSet.toolTip"));
        this.confirmClose = new JCheckBox(Messages.getMessage("PfdViewerViewMenuConfirmClose.text"));
        this.confirmClose.setToolTipText(Messages.getMessage("PfdViewerViewMenuConfirmClose.toolTip"));
        this.update = new JCheckBox(Messages.getMessage("PdfPreferences.CheckForUpdate"));
        this.update.setToolTipText(Messages.getMessage("PdfPreferences.update.toolTip"));
        this.openLastDoc = new JCheckBox(Messages.getMessage("PdfViewerViewMenuOpenLastDoc.text"));
        this.openLastDoc.setToolTipText(Messages.getMessage("PdfViewerViewMenuOpenLastDoc.toolTip"));
        this.historyClearedLabel = new JLabel(Messages.getMessage("PageLayoutViewMenu.HistoryCleared"));
        this.historyClearedLabel.setForeground(Color.red);
        this.historyClearedLabel.setVisible(false);
        this.clearHistory = new JButton(Messages.getMessage("PageLayoutViewMenu.ClearHistory"));
        this.clearHistory.setToolTipText(Messages.getMessage("PageLayoutViewMenu.ClearHistory.toolTip"));
        this.clearHistory.addActionListener(e2 -> {
            gui.getRecentDocument().clearRecentDocuments(gui.getProperties());
            SwingWorker searcher = new SwingWorker(){

                @Override
                public Object construct() {
                    for (int i2 = 0; i2 < 6; ++i2) {
                        SwingProperties.this.historyClearedLabel.setVisible(!SwingProperties.this.historyClearedLabel.isVisible());
                        try {
                            Thread.sleep(300L);
                            continue;
                        }
                        catch (InterruptedException e2) {
                            LogWriter.writeLog("Exception " + e2);
                        }
                    }
                    return null;
                }
            };
            searcher.start();
        });
    }

    private void setupButtonBarPanel(ButtonBarPanel buttonBarPanel, SwingGUI gui, JPanel toolbar) {
        ButtonGroup group = new ButtonGroup();
        buttonBarPanel.addButton(Messages.getMessage("PdfPreferences.GeneralTitle"), gui.getGUICursor().getURLForImage("display.png"), this.createGeneralSettings(), toolbar, group);
        buttonBarPanel.addButton(Messages.getMessage("PdfPreferences.PageDisplayTitle"), gui.getGUICursor().getURLForImage("pagedisplay.png"), this.createPageDisplaySettings(), toolbar, group);
        buttonBarPanel.addButton(Messages.getMessage("PdfPreferences.InterfaceTitle"), gui.getGUICursor().getURLForImage("interface.png"), this.createInterfaceSettings(), toolbar, group);
        buttonBarPanel.addButton(Messages.getMessage("PdfPreferences.ColorTitle"), gui.getGUICursor().getURLForImage("color.png"), this.createColorSettings(), toolbar, group);
        buttonBarPanel.addButton(Messages.getMessage("PdfPreferences.MenuTitle"), gui.getGUICursor().getURLForImage("menu.png"), this.createMenuSettings(), toolbar, group);
        buttonBarPanel.addButton(Messages.getMessage("PdfPreferences.PrintingTitle"), gui.getGUICursor().getURLForImage("printing.png"), this.createPrintingSettings(), toolbar, group);
    }

    private void setPreferences(SwingGUI gui) {
        int borderStyle = 0;
        int pageMode = this.pageLayout.getSelectedIndex() + 1;
        if (pageMode < 1 || pageMode > 5) {
            pageMode = 1;
        }
        if (this.border.isSelected()) {
            borderStyle = 1;
        }
        this.properties.setValue("borderType", String.valueOf(borderStyle));
        this.properties.setValue("highlightFormFields", String.valueOf(this.showFormFieldHighlights.isSelected()));
        this.properties.setValue("useHinting", String.valueOf(this.useHinting.isSelected()));
        this.properties.setValue("startView", String.valueOf(pageMode));
        this.properties.setValue("pageInsets", String.valueOf(this.pageInsets.getText()));
        this.properties.setValue("pageMoveDelay", String.valueOf(this.pageMoveDelay.getText()));
        this.properties.setValue("windowTitle", String.valueOf(this.windowTitle.getText()));
        String loc = this.iconLocation.getText();
        if (!loc.endsWith("/") && !loc.endsWith("\\")) {
            loc = loc + '/';
        }
        this.properties.setValue("iconLocation", loc);
        this.properties.setValue("sideTabBarCollapseLength", String.valueOf(this.sideTabLength.getText()));
        this.properties.setValue("autoScroll", String.valueOf(this.autoScroll.isSelected()));
        this.properties.setValue("confirmClose", String.valueOf(this.confirmClose.isSelected()));
        this.properties.setValue("openLastDocument", String.valueOf(this.openLastDoc.isSelected()));
        this.properties.setValue("resolution", String.valueOf(this.resolution.getText()));
        this.properties.setValue("searchWindowType", String.valueOf(this.searchStyle.getSelectedIndex()));
        this.properties.setValue("updateResultsDuringSearch", String.valueOf(this.liveSearchResuts.isSelected()));
        this.properties.setValue("automaticupdate", String.valueOf(this.update.isSelected()));
        this.properties.setValue("consistentTabBar", String.valueOf(this.constantTabs.isSelected()));
        this.properties.setValue("highlightComposite", String.valueOf(this.highlightComposite.getText()));
        this.properties.setValue("highlightBoxColor", String.valueOf(this.highlightBoxColor.getBackground() != null ? this.highlightBoxColor.getBackground().getRGB() : 0));
        this.properties.setValue("viewerLookAndFeel", this.lookAndFeel.getItemAt(this.lookAndFeel.getSelectedIndex()));
        int rgb = this.formFieldHighlightColor.getBackground() != null ? this.formFieldHighlightColor.getBackground().getRGB() & 0xFFFFFF : 0;
        int a10 = (int)(255.0f * Float.parseFloat(this.formFieldHighlightComposite.getText()));
        int argb = a10 << 24 | rgb;
        this.properties.setValue("formFieldsHighlightColor", String.valueOf(argb));
        this.properties.setValue("vbgColor", String.valueOf(this.viewBGColor.getBackground() != null ? this.viewBGColor.getBackground().getRGB() : 0));
        this.properties.setValue("pdfDisplayBackground", String.valueOf(this.pdfDecoderBackground.getBackground() != null ? this.pdfDecoderBackground.getBackground().getRGB() : 0));
        this.properties.setValue("vfgColor", String.valueOf(this.foreGroundColor.getBackground() != null ? this.foreGroundColor.getBackground().getRGB() : 0));
        this.properties.setValue("replaceDocumentTextColors", String.valueOf(this.replaceDocTextCol.isSelected()));
        this.properties.setValue("replacePdfDisplayBackground", String.valueOf(this.replaceDisplayBGCol.isSelected()));
        this.properties.setValue("changeTextAndLineart", String.valueOf(this.changeTextAndLineArt.isSelected()));
        this.properties.setValue("invertHighlights", String.valueOf(this.invertHighlight.isSelected()));
        this.properties.setValue("showMouseSelectionBox", String.valueOf(this.showMouseSelectionBox.isSelected()));
        this.properties.setValue("allowRightClick", String.valueOf(this.rightClick.isSelected()));
        this.properties.setValue("allowScrollwheelZoom", String.valueOf(this.scrollwheelZoom.isSelected()));
        this.properties.setValue("enhancedViewerMode", String.valueOf(this.enhancedViewer.isSelected()));
        this.properties.setValue("useOffScreenRendering", String.valueOf(this.offScreenRendering.isSelected()));
        this.properties.setValue("enhanceFractionalLines", String.valueOf(this.enhanceFractionalLines.isSelected()));
        this.properties.setValue("hideLineWeights", String.valueOf(this.hideLineWeights.isSelected()));
        this.properties.setValue("treatURLTextAsLinks", String.valueOf(this.treatURLTextAsLInk.isSelected()));
        this.properties.setValue("enhancedFacingMode", String.valueOf(this.enhancedFacing.isSelected()));
        this.properties.setValue("previewOnSingleScroll", String.valueOf(this.thumbnailScroll.isSelected()));
        this.properties.setValue("printerBlacklist", String.valueOf(this.printerBlacklist.getText()));
        this.properties.setValue("useSmoothImage", String.valueOf(this.useSmoothImage.isSelected()));
        String selectedItem = (String)this.defaultPrinter.getSelectedItem();
        if (selectedItem != null) {
            if (selectedItem.startsWith("System Default")) {
                this.properties.setValue("defaultPrinter", "");
            } else {
                this.properties.setValue("defaultPrinter", selectedItem);
            }
        }
        this.properties.setValue("defaultDPI", String.valueOf(this.defaultPrintResolution.getText()));
        this.properties.setValue("defaultPagesize", String.valueOf(this.defaultPagesize.getSelectedItem()));
        if (this.speech != null) {
            this.properties.setValue("voice", String.valueOf(this.voiceSelect.getSelectedItem()));
        }
        this.saveGUIPreferences(gui);
        try {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            map.put(JPedalSettings.ENHANCE_FRACTIONAL_LINES, this.enhanceFractionalLines.isSelected());
            map.put(JPedalSettings.HIDE_LINE_WEIGHTS, this.hideLineWeights.isSelected());
            map.put(JPedalSettings.HIGHLIGHT_FORM_FIELDS, this.showFormFieldHighlights.isSelected());
            map.put(JPedalSettings.PAGE_COLOR, this.viewBGColor.getBackground() != null ? this.viewBGColor.getBackground().getRGB() : 0);
            if (this.replaceDocTextCol.isSelected()) {
                map.put(JPedalSettings.TEXT_COLOR, this.foreGroundColor.getBackground() != null ? this.foreGroundColor.getBackground().getRGB() : 0);
                map.put(JPedalSettings.CHANGE_LINEART, this.changeTextAndLineArt.isSelected());
            }
            this.decode_pdf.modifyNonstaticJPedalParameters(map);
            RenderUtils.setDisplayOptions(this.decode_pdf.getDynamicRenderer(), this.decode_pdf.getDecoderOptions());
            this.decode_pdf.repaintOffscreenImage();
        }
        catch (PdfException e2) {
            LogWriter.writeLog("Exception whilst live updating settings " + e2);
        }
    }

    private static JPanel makePanel(String title) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel topLeft = new JLabel(title);
        topLeft.setFont(topLeft.getFont().deriveFont(1));
        topLeft.setOpaque(true);
        if (panel.getBackground() != null) {
            topLeft.setBackground(panel.getBackground().brighter());
        }
        JPanel topbar = new JPanel(new BorderLayout());
        topbar.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        topbar.setFont(topbar.getFont().deriveFont(1));
        topbar.setOpaque(true);
        if (panel.getBackground() != null) {
            topbar.setBackground(panel.getBackground().brighter());
        }
        topbar.add((Component)topLeft, "West");
        panel.add((Component)topbar, "North");
        panel.setPreferredSize(new Dimension(400, 300));
        panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        return panel;
    }

    private JPanel createGeneralSettings() {
        this.loadStringValue(this.resolution, "resolution");
        this.loadBooleanValue(this.useHinting, "useHinting");
        this.loadBooleanValue(this.autoScroll, "autoScroll");
        this.loadBooleanValue(this.confirmClose, "confirmClose");
        this.loadBooleanValue(this.update, "automaticupdate");
        this.loadBooleanValue(this.openLastDoc, "openLastDocument");
        JPanel panel = SwingProperties.makePanel(Messages.getMessage("PdfPreferences.GeneralTitle"));
        JPanel pane = new JPanel();
        JScrollPane scroll = new JScrollPane(pane);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 1;
        SwingProperties.setGridBagConstraints(c2, 0, 0, 1, 0.0, 0.0, new Insets(5, 0, 0, 5));
        JLabel label = new JLabel(Messages.getMessage("PdfPreferences.GeneralSection"));
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        label.setFont(label.getFont().deriveFont(1));
        pane.add((Component)label, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 1, 1, 0.0, 0.0, new Insets(10, 0, 0, 5));
        JLabel label2 = new JLabel(Messages.getMessage("PdfViewerViewMenu.Resolution"));
        label2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        pane.add((Component)label2, c2);
        SwingProperties.setGridBagConstraints(c2, 1, 1, 1, 1.0, 0.0, new Insets(10, 0, 0, 0));
        pane.add((Component)this.resolution, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 2, 2, 1.0, 0.0, new Insets(10, 0, 0, 0));
        this.useHinting.setMargin(new Insets(0, 0, 0, 0));
        this.useHinting.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        pane.add((Component)this.useHinting, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 3, 2, 1.0, 0.0, new Insets(10, 0, 0, 0));
        this.autoScroll.setMargin(new Insets(0, 0, 0, 0));
        this.autoScroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        pane.add((Component)this.autoScroll, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 4, 2, 1.0, 0.0, new Insets(10, 0, 0, 0));
        this.confirmClose.setMargin(new Insets(0, 0, 0, 0));
        this.confirmClose.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        pane.add((Component)this.confirmClose, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 5, 2, 0.0, 0.0, new Insets(15, 0, 0, 0));
        JLabel label3 = new JLabel(Messages.getMessage("PdfPreferences.StartUp"));
        label3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        label3.setFont(label3.getFont().deriveFont(1));
        pane.add((Component)label3, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 6, 2, 1.0, 0.0, new Insets(10, 0, 0, 0));
        this.update.setMargin(new Insets(0, 0, 0, 0));
        this.update.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        pane.add((Component)this.update, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 7, 2, 1.0, 0.0, new Insets(10, 0, 0, 0));
        this.openLastDoc.setMargin(new Insets(0, 0, 0, 0));
        this.openLastDoc.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        pane.add((Component)this.openLastDoc, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 8, 2, 1.0, 0.0, new Insets(10, 0, 0, 0));
        JPanel clearHistoryPanel = new JPanel();
        clearHistoryPanel.setLayout(new BoxLayout(clearHistoryPanel, 0));
        clearHistoryPanel.add(this.clearHistory);
        clearHistoryPanel.add(Box.createHorizontalGlue());
        clearHistoryPanel.add(this.historyClearedLabel);
        clearHistoryPanel.add(Box.createHorizontalGlue());
        pane.add((Component)clearHistoryPanel, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 9, 2, 1.0, 1.0, new Insets(10, 0, 0, 0));
        pane.add(Box.createVerticalGlue(), c2);
        panel.add((Component)scroll, "Center");
        return panel;
    }

    private JPanel createPageDisplaySettings() {
        this.setPageDisplayDefaultValues();
        JPanel panel = SwingProperties.makePanel(Messages.getMessage("PdfPreferences.PageDisplayTitle"));
        JPanel pane = new JPanel();
        JScrollPane scroll = new JScrollPane(pane);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 1;
        SwingProperties.setGridBagConstraints(c2, 0, 0, 1, 0.0, 0.0, new Insets(5, 0, 0, 5));
        JLabel label = new JLabel(Messages.getMessage("PdfPreferences.GeneralSection"));
        label.setFont(label.getFont().deriveFont(1));
        pane.add((Component)label, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 1, 2, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)this.enhancedViewer, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 2, 2, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)this.offScreenRendering, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 3, 2, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)this.enhanceFractionalLines, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 4, 2, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)this.treatURLTextAsLInk, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 5, 2, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)this.hideLineWeights, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 6, 2, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)this.useSmoothImage, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 7, 2, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)this.border, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 8, 2, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)new JLabel(Messages.getMessage("PdfViewerViewMenu.pageInsets")), c2);
        SwingProperties.setGridBagConstraints(c2, 1, 8, 2, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)this.pageInsets, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 9, 2, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)new JLabel(Messages.getMessage("PdfViewerViewMenu.pageMoveDelay")), c2);
        SwingProperties.setGridBagConstraints(c2, 1, 9, 2, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)this.pageMoveDelay, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 10, 2, 0.0, 0.0, new Insets(15, 0, 0, 5));
        JLabel label2 = new JLabel(Messages.getMessage("PdfPreferences.DisplayModes"));
        label2.setFont(label2.getFont().deriveFont(1));
        pane.add((Component)label2, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 11, 2, 0.0, 0.0, new Insets(5, 0, 0, 5));
        JLabel label1 = new JLabel(Messages.getMessage("PageLayoutViewMenu.PageLayout"));
        pane.add((Component)label1, c2);
        SwingProperties.setGridBagConstraints(c2, 1, 11, 2, 1.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add(this.pageLayout, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 12, 2, 1.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)this.enhancedFacing, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 13, 2, 1.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)this.thumbnailScroll, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 14, 2, 1.0, 1.0, new Insets(5, 0, 0, 0));
        pane.add(Box.createVerticalGlue(), c2);
        panel.add((Component)scroll, "Center");
        return panel;
    }

    private void setPageDisplayDefaultValues() {
        this.loadBooleanValue(this.enhancedViewer, "enhancedViewerMode");
        this.loadBooleanValue(this.offScreenRendering, "useOffScreenRendering");
        this.loadBooleanValue(this.enhanceFractionalLines, "enhanceFractionalLines");
        this.loadBooleanValue(this.hideLineWeights, "hideLineWeights");
        this.loadBooleanValue(this.treatURLTextAsLInk, "treatURLTextAsLinks");
        this.loadBooleanValue(this.enhancedFacing, "enhancedFacingMode");
        this.loadBooleanValue(this.thumbnailScroll, "previewOnSingleScroll");
        this.loadBooleanValue(this.useSmoothImage, "useSmoothImage");
        this.loadStringValue(this.pageInsets, "pageInsets", "25");
        this.loadStringValue(this.pageMoveDelay, "pageMoveDelay", "500");
        String borderType = this.properties.getValue("borderType").toLowerCase();
        this.border.setSelected(!borderType.isEmpty() && Integer.parseInt(borderType) == 1);
        String propValue = this.properties.getValue("startView");
        if (!propValue.isEmpty()) {
            int mode = Integer.parseInt(propValue);
            if (mode < 1 || mode > 5) {
                mode = 1;
            }
            this.pageLayout.setSelectedIndex(mode - 1);
        }
    }

    private void loadCreateInterfaceSettings() {
        this.loadBooleanValue(this.rightClick, "allowRightClick");
        this.loadBooleanValue(this.scrollwheelZoom, "allowScrollwheelZoom");
        this.loadBooleanValue(this.liveSearchResuts, "updateResultsDuringSearch");
        this.loadBooleanValue(this.constantTabs, "consistentTabBar");
        this.loadBooleanValue(this.showMouseSelectionBox, "showMouseSelectionBox");
        this.loadStringValue(this.windowTitle, "windowTitle");
        this.loadStringValue(this.iconLocation, "iconLocation", classicIconLocation);
        if (darkIconLocation.equals(this.iconLocation.getText())) {
            this.darkIconSet.setSelected(true);
        } else if (classicIconLocation.equals(this.iconLocation.getText())) {
            this.classicIconSet.setSelected(true);
        }
        this.loadStringValue(this.sideTabLength, "sideTabBarCollapseLength", "30");
        String propValue = this.properties.getValue("searchWindowType");
        int index = 0;
        if (!propValue.isEmpty() && (index = Integer.parseInt(propValue)) >= this.searchStyle.getItemCount()) {
            index = 0;
        }
        this.searchStyle.setSelectedIndex(index);
        propValue = this.properties.getValue("viewerLookAndFeel");
        String val = "SystemDefault";
        if (!propValue.isEmpty()) {
            val = propValue;
        }
        this.lookAndFeel.setSelectedItem(val);
    }

    private JScrollPane createAppearanceTab() {
        JPanel contentPane = new JPanel();
        JScrollPane scrollPane = new JScrollPane(contentPane);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 1;
        SwingProperties.setGridBagConstraints(c2, 0, 0, 1, 0.0, 0.0, new Insets(5, 5, 5, 5));
        JLabel label = new JLabel(Messages.getMessage("PdfPreferences.GeneralTitle"));
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        label.setFont(label.getFont().deriveFont(1));
        contentPane.add((Component)label, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 1, 1, 0.0, 0.0, new Insets(3, 5, 0, 5));
        contentPane.add((Component)new JLabel(Messages.getMessage("PdfCustomGui.windowTitle")), c2);
        SwingProperties.setGridBagConstraints(c2, 1, 1, 1, 0.0, 0.0, new Insets(3, 5, 0, 5));
        contentPane.add((Component)this.windowTitle, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 2, 1, 0.0, 0.0, new Insets(5, 5, 5, 5));
        contentPane.add((Component)this.darkIconSet, c2);
        SwingProperties.setGridBagConstraints(c2, 1, 2, 1, 0.0, 0.0, new Insets(5, 5, 5, 5));
        contentPane.add((Component)this.classicIconSet, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 3, 1, 0.0, 0.0, new Insets(5, 5, 5, 5));
        contentPane.add((Component)new JLabel(Messages.getMessage("PdfViewerViewMenu.iconLocation")), c2);
        SwingProperties.setGridBagConstraints(c2, 1, 3, 1, 0.0, 0.0, new Insets(5, 5, 5, 5));
        contentPane.add((Component)this.iconLocation, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 4, 1, 0.0, 0.0, new Insets(5, 5, 5, 5));
        JLabel label5 = new JLabel(Messages.getMessage("PageLayoutViewMenu.SearchLayout"));
        label5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        contentPane.add((Component)label5, c2);
        SwingProperties.setGridBagConstraints(c2, 1, 4, 1, 1.0, 0.0, new Insets(5, 5, 5, 5));
        contentPane.add(this.searchStyle, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 5, 1, 1.0, 0.0, new Insets(5, 0, 0, 5));
        contentPane.add((Component)this.liveSearchResuts, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 7, 1, 0.0, 0.0, new Insets(5, 5, 5, 5));
        JLabel label12 = new JLabel(Messages.getMessage("PdfPreferences.LookAndFeel"));
        label5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        contentPane.add((Component)label12, c2);
        SwingProperties.setGridBagConstraints(c2, 1, 7, 1, 1.0, 0.0, new Insets(5, 5, 5, 5));
        contentPane.add(this.lookAndFeel, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 8, 1, 0.0, 0.0, new Insets(15, 5, 5, 5));
        JLabel label1 = new JLabel(Messages.getMessage("PdfPreferences.SideTab"));
        label1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        label1.setFont(label1.getFont().deriveFont(1));
        contentPane.add((Component)label1, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 9, 1, 0.0, 0.0, new Insets(5, 5, 5, 5));
        JLabel sideTabLengthText = new JLabel(Messages.getMessage("PdfCustomGui.SideTabLength"));
        sideTabLengthText.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        contentPane.add((Component)sideTabLengthText, c2);
        SwingProperties.setGridBagConstraints(c2, 1, 9, 1, 1.0, 0.0, new Insets(5, 5, 5, 5));
        contentPane.add((Component)this.sideTabLength, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 10, 2, 1.0, 0.0, new Insets(5, 5, 5, 5));
        this.constantTabs.setMargin(new Insets(0, 0, 0, 0));
        this.constantTabs.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        contentPane.add((Component)this.constantTabs, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 10, 2, 1.0, 1.0, new Insets(5, 5, 5, 5));
        contentPane.add(Box.createVerticalGlue(), c2);
        return scrollPane;
    }

    private JScrollPane createMouseTab() {
        JPanel contentPane = new JPanel();
        JScrollPane scrollPane = new JScrollPane(contentPane);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 1;
        SwingProperties.setGridBagConstraints(c2, 0, 0, 1, 0.0, 0.0, new Insets(5, 5, 5, 5));
        JLabel label3 = new JLabel(Messages.getMessage("PdfPreferences.GeneralTitle"));
        label3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        label3.setFont(label3.getFont().deriveFont(1));
        contentPane.add((Component)label3, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 1, 2, 0.0, 0.0, new Insets(5, 5, 5, 5));
        this.rightClick.setMargin(new Insets(0, 0, 0, 0));
        this.rightClick.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        contentPane.add((Component)this.rightClick, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 2, 2, 0.0, 0.0, new Insets(5, 5, 5, 5));
        this.scrollwheelZoom.setMargin(new Insets(0, 0, 0, 0));
        this.scrollwheelZoom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        contentPane.add((Component)this.scrollwheelZoom, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 3, 1, 0.0, 0.0, new Insets(0, 0, 0, 5));
        contentPane.add((Component)this.showMouseSelectionBox, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 4, 1, 1.0, 0.0, new Insets(0, 0, 0, 5));
        contentPane.add(Box.createVerticalGlue(), c2);
        return scrollPane;
    }

    private JScrollPane createSpeechTab() {
        JPanel contentPane = new JPanel();
        JScrollPane scrollPane = new JScrollPane(contentPane);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 1;
        SwingProperties.setGridBagConstraints(c2, 0, 0, 1, 0.0, 0.0, new Insets(5, 0, 0, 5));
        JLabel label6 = new JLabel(Messages.getMessage("PdfPreferences.GeneralTitle"));
        label6.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        label6.setFont(label6.getFont().deriveFont(1));
        contentPane.add((Component)label6, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 1, 1, 0.0, 0.0, new Insets(5, 0, 0, 5));
        this.voiceSelect = new JComboBox<String>(this.speech.listVoices());
        JLabel label7 = new JLabel(Messages.getMessage("PdfPreferences.Voice"));
        label7.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        contentPane.add((Component)label7, c2);
        SwingProperties.setGridBagConstraints(c2, 1, 1, 1, 1.0, 0.0, new Insets(5, 0, 0, 0));
        this.voiceSelect.setSelectedItem(this.properties.getValue("voice"));
        contentPane.add(this.voiceSelect, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 2, 1, 1.0, 1.0, new Insets(5, 0, 0, 0));
        contentPane.add(Box.createVerticalGlue(), c2);
        return scrollPane;
    }

    private JPanel createInterfaceSettings() {
        this.loadCreateInterfaceSettings();
        JPanel panel = SwingProperties.makePanel(Messages.getMessage("PdfPreferences.InterfaceTitle"));
        JTabbedPane tabs = new JTabbedPane();
        tabs.add(Messages.getMessage("PdfPreferences.AppearanceTab"), this.createAppearanceTab());
        tabs.add(Messages.getMessage("PdfPreferences.Mouse"), this.createMouseTab());
        if (this.speech != null) {
            tabs.add(Messages.getMessage("PdfPreferences.Speech"), this.createSpeechTab());
        }
        panel.add((Component)tabs, "Center");
        return panel;
    }

    private JPanel createPrintingSettings() {
        this.loadStringValue(this.printerBlacklist, "printerBlacklist");
        String propValue = this.properties.getValue("defaultPrinter");
        if (propValue != null && !propValue.isEmpty()) {
            this.defaultPrinter.setSelectedItem(propValue);
        } else {
            PrintService defaultPrintService = PrintServiceLookup.lookupDefaultPrintService();
            if (defaultPrintService != null) {
                this.defaultPrinter.setSelectedItem("System Default (" + defaultPrintService.getName() + ')');
            } else {
                this.defaultPrinter.setSelectedItem("System Default");
            }
        }
        propValue = this.properties.getValue("defaultPrintResolution");
        if (propValue != null && !propValue.isEmpty()) {
            try {
                propValue = propValue.replaceAll("[^0-9]", "");
                this.defaultPrintResolution.setText(Integer.parseInt(propValue) + "dpi");
            }
            catch (NumberFormatException e2) {
                LogWriter.writeLog("Attempting to get Properties values " + e2);
            }
        }
        JPanel panel = SwingProperties.makePanel(Messages.getMessage("PdfPreferences.PrintingTitle"));
        JPanel pane = new JPanel();
        JScrollPane scroll = new JScrollPane(pane);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 1;
        SwingProperties.setGridBagConstraints(c2, 0, 0, 1, 0.0, 0.0, new Insets(5, 0, 0, 5));
        JLabel label = new JLabel(Messages.getMessage("PdfPreferences.GeneralSection"));
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        label.setFont(label.getFont().deriveFont(1));
        pane.add((Component)label, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 1, 1, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)new JLabel(Messages.getMessage("PdfViewerPrint.defaultPrinter")), c2);
        SwingProperties.setGridBagConstraints(c2, 1, 1, 1, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add(this.defaultPrinter, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 2, 1, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)new JLabel(Messages.getMessage("PdfViewerPrint.defaultPagesize")), c2);
        SwingProperties.setGridBagConstraints(c2, 1, 2, 1, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add(this.defaultPagesize, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 3, 1, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)new JLabel(Messages.getMessage("PdfViewerPrint.defaultDPI")), c2);
        SwingProperties.setGridBagConstraints(c2, 1, 3, 1, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)this.defaultPrintResolution, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 4, 1, 0.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)new JLabel(Messages.getMessage("PdfViewerPrint.blacklist")), c2);
        SwingProperties.setGridBagConstraints(c2, 1, 4, 1, 1.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)this.printerBlacklist, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 5, 1, 0.0, 1.0, new Insets(5, 0, 0, 0));
        pane.add(Box.createVerticalGlue(), c2);
        panel.add(scroll);
        return panel;
    }

    private JPanel createColorSettings() {
        JPanel panel = this.createColorComponents();
        this.setCurrentColorSettings();
        return panel;
    }

    private JPanel createColorComponents() {
        JPanel panel = SwingProperties.makePanel(Messages.getMessage("PdfPreferences.MenuTitle"));
        JPanel pane = new JPanel();
        JScrollPane scroll = new JScrollPane(pane);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 1;
        SwingProperties.setGridBagConstraints(c2, 0, 0, 1, 0.0, 0.0, new Insets(5, 0, 0, 5));
        this.createHighlightComponents(pane, c2);
        this.createFormHighlightComponents(pane, c2);
        this.createDisplayColorComponents(pane, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 15, 2, 1.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add(Box.createVerticalGlue(), c2);
        panel.add((Component)scroll, "Center");
        return panel;
    }

    private void createDisplayPageColorComponents(JPanel pane, GridBagConstraints c2) {
        this.viewBGColor = new JPanel();
        JButton viewerBackgroundButton = new JButton(Messages.getMessage("PdfPreferences.ChangeBackgroundColor"));
        viewerBackgroundButton.addActionListener(e2 -> {
            Color col = JColorChooser.showDialog(null, Messages.getMessage("PdfPreferences.backgroundColorSelect.title"), this.viewBGColor.getBackground());
            this.viewBGColor.setBackground(col);
        });
        SwingProperties.setGridBagConstraints(c2, 0, 9, 1, 0.0, 0.0, new Insets(5, 0, 0, 5));
        this.viewBGColor.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        pane.add((Component)this.viewBGColor, c2);
        SwingProperties.setGridBagConstraints(c2, 1, 9, 1, 1.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)viewerBackgroundButton, c2);
    }

    private void createDisplayTextColorComponents(JPanel pane, GridBagConstraints c2) {
        this.foreGroundColor = new JPanel();
        JButton FGButton = new JButton(Messages.getMessage("PdfPreferences.ChangeForegroundColor"));
        FGButton.addActionListener(e2 -> {
            Color col = JColorChooser.showDialog(null, Messages.getMessage("PdfPreferences.foregroundColorSelect.title"), this.foreGroundColor.getBackground());
            this.foreGroundColor.setBackground(col);
        });
        this.changeTextAndLineArt = new JCheckBox(Messages.getMessage("PdfPreferences.changeLineArt.text"));
        this.changeTextAndLineArt.setToolTipText(Messages.getMessage("PdfPreferences.changeLineArt.toolTip"));
        this.loadBooleanValue(this.changeTextAndLineArt, "changeTextAndLineart");
        this.replaceDocTextCol = new JCheckBox(Messages.getMessage("PdfPreferences.replaceTextColor.text"));
        this.replaceDocTextCol.setToolTipText(Messages.getMessage("PdfPreferences.replaceTextColor.toolTip"));
        this.loadBooleanValue(this.replaceDocTextCol, "replaceDocumentTextColors");
        if (this.replaceDocTextCol.isSelected()) {
            FGButton.setEnabled(true);
            this.foreGroundColor.setEnabled(true);
            this.changeTextAndLineArt.setEnabled(true);
        } else {
            FGButton.setEnabled(false);
            this.foreGroundColor.setEnabled(false);
            this.changeTextAndLineArt.setEnabled(false);
        }
        this.replaceDocTextCol.addActionListener(e2 -> {
            if (((AbstractButton)e2.getSource()).isSelected()) {
                FGButton.setEnabled(true);
                this.foreGroundColor.setEnabled(true);
                this.changeTextAndLineArt.setEnabled(true);
            } else {
                FGButton.setEnabled(false);
                this.foreGroundColor.setEnabled(false);
                this.changeTextAndLineArt.setEnabled(false);
            }
        });
        SwingProperties.setGridBagConstraints(c2, 0, 10, 1, 1.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)this.replaceDocTextCol, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 11, 1, 1.0, 0.0, new Insets(5, 0, 0, 5));
        this.foreGroundColor.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        pane.add((Component)this.foreGroundColor, c2);
        SwingProperties.setGridBagConstraints(c2, 1, 11, 1, 1.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)FGButton, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 12, 1, 1.0, 0.0, new Insets(5, 0, 0, 5));
        pane.add((Component)this.changeTextAndLineArt, c2);
    }

    private void createDisplayDecoderColorComponents(JPanel pane, GridBagConstraints c2) {
        this.pdfDecoderBackground = new JPanel();
        JButton PDBButton = new JButton(Messages.getMessage("PdfPreferences.ChangeDisplayBackgroundColor"));
        PDBButton.addActionListener(e2 -> {
            Color col = JColorChooser.showDialog(null, Messages.getMessage("PdfPreferences.displayColorSelect.title"), this.pdfDecoderBackground.getBackground());
            this.pdfDecoderBackground.setBackground(col);
        });
        this.replaceDisplayBGCol = new JCheckBox(Messages.getMessage("PdfPreferences.replaceDisplayColor.text"));
        this.replaceDisplayBGCol.setToolTipText(Messages.getMessage("PdfPreferences.replaceDisplayColor.toolTip"));
        this.loadBooleanValue(this.replaceDisplayBGCol, "replacePdfDisplayBackground");
        if (this.replaceDisplayBGCol.isSelected()) {
            PDBButton.setEnabled(true);
            this.pdfDecoderBackground.setEnabled(true);
        } else {
            PDBButton.setEnabled(false);
            this.pdfDecoderBackground.setEnabled(false);
        }
        this.replaceDisplayBGCol.addActionListener(e2 -> {
            if (((AbstractButton)e2.getSource()).isSelected()) {
                PDBButton.setEnabled(true);
                this.pdfDecoderBackground.setEnabled(true);
            } else {
                PDBButton.setEnabled(false);
                this.pdfDecoderBackground.setEnabled(false);
            }
        });
        SwingProperties.setGridBagConstraints(c2, 0, 13, 1, 1.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)this.replaceDisplayBGCol, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 14, 1, 1.0, 0.0, new Insets(5, 0, 0, 5));
        this.pdfDecoderBackground.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        pane.add((Component)this.pdfDecoderBackground, c2);
        SwingProperties.setGridBagConstraints(c2, 1, 14, 1, 1.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)PDBButton, c2);
    }

    private void createDisplayColorComponents(JPanel pane, GridBagConstraints c2) {
        SwingProperties.setGridBagConstraints(c2, 0, 8, 1, 0.0, 0.0, new Insets(15, 0, 0, 5));
        JLabel label3 = new JLabel(Messages.getMessage("PdfPreferences.displayColorSection.title"));
        label3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        label3.setFont(label3.getFont().deriveFont(1));
        pane.add((Component)label3, c2);
        this.createDisplayPageColorComponents(pane, c2);
        this.createDisplayTextColorComponents(pane, c2);
        this.createDisplayDecoderColorComponents(pane, c2);
    }

    private void createFormHighlightComponents(JPanel pane, GridBagConstraints c2) {
        JButton ffhBoxButton = new JButton(Messages.getMessage("PdfPreferences.ChangeFormHighlightTextColor"));
        ffhBoxButton.addActionListener(e2 -> {
            Color col = JColorChooser.showDialog(null, Messages.getMessage("PdfPreferences.highlightColorSelect.title"), this.formFieldHighlightColor.getBackground());
            this.formFieldHighlightColor.setBackground(col);
        });
        JLabel ffhCompLabel = new JLabel(Messages.getMessage("PdfPreferences.ChangeFormFieldHighlightTransparency"));
        boolean showFormHighlights = this.showFormFieldHighlights.isSelected();
        this.formFieldHighlightColor.setEnabled(showFormHighlights);
        this.formFieldHighlightComposite.setEnabled(showFormHighlights);
        ffhBoxButton.setEnabled(showFormHighlights);
        this.showFormFieldHighlights.addActionListener(e2 -> {
            boolean showFormHighlight = ((AbstractButton)e2.getSource()).isSelected();
            this.formFieldHighlightColor.setEnabled(showFormHighlight);
            this.formFieldHighlightComposite.setEnabled(showFormHighlight);
            ffhBoxButton.setEnabled(showFormHighlight);
        });
        SwingProperties.setGridBagConstraints(c2, 0, 4, 1, 0.0, 0.0, new Insets(5, 0, 0, 5));
        JLabel labelFFH = new JLabel(Messages.getMessage("PdfPreferences.formFieldhighlightSection.title"));
        labelFFH.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        labelFFH.setFont(labelFFH.getFont().deriveFont(1));
        pane.add((Component)labelFFH, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 5, 1, 0.0, 0.0, new Insets(5, 0, 0, 5));
        this.formFieldHighlightColor.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        pane.add((Component)this.formFieldHighlightColor, c2);
        SwingProperties.setGridBagConstraints(c2, 1, 5, 1, 1.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)ffhBoxButton, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 6, 1, 1.0, 0.0, new Insets(5, 0, 0, 5));
        pane.add((Component)this.formFieldHighlightComposite, c2);
        SwingProperties.setGridBagConstraints(c2, 1, 6, 1, 1.0, 0.0, new Insets(5, 25, 0, 0));
        pane.add((Component)ffhCompLabel, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 7, 2, 0.0, 0.0, new Insets(5, 0, 0, 0));
        this.showFormFieldHighlights.setMargin(new Insets(0, 0, 0, 0));
        this.showFormFieldHighlights.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        pane.add((Component)this.showFormFieldHighlights, c2);
    }

    private void createHighlightComponents(JPanel pane, GridBagConstraints c2) {
        JLabel label2 = new JLabel(Messages.getMessage("PdfPreferences.highlightSection.title"));
        label2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        label2.setFont(label2.getFont().deriveFont(1));
        pane.add((Component)label2, c2);
        JButton hBoxButton = new JButton(Messages.getMessage("PdfPreferences.ChangeHighlightTextColor"));
        hBoxButton.addActionListener(e2 -> {
            Color col = JColorChooser.showDialog(null, Messages.getMessage("PdfPreferences.highlightColorSelect.title"), this.highlightBoxColor.getBackground());
            this.highlightBoxColor.setBackground(col);
        });
        JLabel hCompLabel = new JLabel(Messages.getMessage("PdfPreferences.ChangeHighlightTransparency"));
        boolean enableHighlightOptions = !this.invertHighlight.isSelected();
        this.highlightBoxColor.setEnabled(enableHighlightOptions);
        this.highlightComposite.setEnabled(enableHighlightOptions);
        hBoxButton.setEnabled(enableHighlightOptions);
        hCompLabel.setEnabled(enableHighlightOptions);
        this.invertHighlight.addActionListener(e2 -> {
            boolean enableHighlightOption = !((AbstractButton)e2.getSource()).isSelected();
            this.highlightBoxColor.setEnabled(enableHighlightOption);
            this.highlightComposite.setEnabled(enableHighlightOption);
            hBoxButton.setEnabled(enableHighlightOption);
            hCompLabel.setEnabled(enableHighlightOption);
        });
        SwingProperties.setGridBagConstraints(c2, 0, 1, 1, 0.0, 0.0, new Insets(5, 0, 0, 5));
        this.highlightBoxColor.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        pane.add((Component)this.highlightBoxColor, c2);
        SwingProperties.setGridBagConstraints(c2, 1, 1, 1, 1.0, 0.0, new Insets(5, 0, 0, 0));
        pane.add((Component)hBoxButton, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 2, 1, 1.0, 0.0, new Insets(5, 0, 0, 5));
        pane.add((Component)this.highlightComposite, c2);
        SwingProperties.setGridBagConstraints(c2, 1, 2, 1, 1.0, 0.0, new Insets(5, 25, 0, 0));
        pane.add((Component)hCompLabel, c2);
        SwingProperties.setGridBagConstraints(c2, 0, 3, 1, 1.0, 0.0, new Insets(0, 0, 0, 5));
        pane.add((Component)this.invertHighlight, c2);
    }

    private void setCurrentColorSettings() {
        String propValue = this.properties.getValue("highlightBoxColor");
        int hBoxColor = !propValue.isEmpty() ? Integer.parseInt(propValue) : DecoderOptions.highlightColor.getRGB();
        Color currentBox = new Color(hBoxColor);
        this.highlightBoxColor.setBackground(currentBox);
        this.loadBooleanValue(this.showFormFieldHighlights, "highlightFormFields");
        propValue = this.properties.getValue("formFieldsHighlightColor");
        int ffhBoxColor = !propValue.isEmpty() ? Integer.parseInt(propValue) : DecoderOptions.highlightColor.getRGB();
        Color formFieldHighlightCol = new Color(ffhBoxColor);
        this.formFieldHighlightColor.setBackground(formFieldHighlightCol);
        this.formFieldHighlightComposite.setText(Float.toString((float)(ffhBoxColor >>> 24) / 255.0f));
        this.loadStringValue(this.highlightComposite, "highlightComposite");
        this.loadBooleanValue(this.invertHighlight, "invertHighlights");
        propValue = this.properties.getValue("vbgColor");
        int vbgColor = 0;
        if (!propValue.isEmpty()) {
            vbgColor = Integer.parseInt(propValue);
        } else if (DecoderOptions.backgroundColor != null) {
            vbgColor = DecoderOptions.backgroundColor.getRGB();
        }
        Color ViewerBackgroundColor = new Color(vbgColor);
        this.viewBGColor.setBackground(ViewerBackgroundColor);
        propValue = this.properties.getValue("vfgColor");
        int vfgColor = 0;
        if (!propValue.isEmpty()) {
            vfgColor = Integer.parseInt(propValue);
        }
        Color FGColor = new Color(vfgColor);
        this.foreGroundColor.setBackground(FGColor);
        propValue = this.properties.getValue("pdfDisplayBackground");
        int pdbColor = 0;
        if (!propValue.isEmpty()) {
            pdbColor = Integer.parseInt(propValue);
        }
        Color PDBColor = new Color(pdbColor);
        this.pdfDecoderBackground.setBackground(PDBColor);
    }

    private static void setGridBagConstraints(GridBagConstraints c2, int gridX, int gridY, int gridWidth, double weightX, double weightY, Insets insets) {
        c2.gridx = gridX;
        c2.gridy = gridY;
        c2.gridwidth = gridWidth;
        c2.gridheight = 1;
        c2.weightx = weightX;
        c2.weighty = weightY;
        c2.insets = insets;
    }

    private JPanel createMenuSettings() {
        JPanel panel = SwingProperties.makePanel(Messages.getMessage("PdfPreferences.MenuTitle"));
        JPanel pane = new JPanel(new BorderLayout());
        this.tabs = new JTabbedPane();
        for (int t2 = 0; t2 != this.menuTabs.length; ++t2) {
            this.reverseMessage.put(Messages.getMessage("PdfCustomGui." + this.menuTabs[t2]), this.menuTabs[t2]);
            CheckNode top = new CheckNode(Messages.getMessage("PdfCustomGui." + this.menuTabs[t2]));
            top.setEnabled(true);
            top.setSelected(true);
            ArrayList<CheckNode> last = new ArrayList<CheckNode>();
            last.add(top);
            NodeList nodes = this.properties.getChildren(Messages.getMessage("PdfCustomGui." + this.menuTabs[t2]) + "Menu");
            this.addMenuToTree(t2, nodes, top, last);
            JTree tree = new JTree(top);
            JScrollPane scroll = new JScrollPane(tree);
            tree.setCellRenderer(new CheckRenderer());
            tree.getSelectionModel().setSelectionMode(1);
            tree.addTreeSelectionListener(new MenuTreeListener(tree));
            JPanel display = new JPanel(new BorderLayout());
            JButton hideGuiSection = new JButton();
            String propValue = this.properties.getValue(this.menuTabs[t2]);
            if ("true".equalsIgnoreCase(propValue)) {
                hideGuiSection.setText(Messages.getMessage("PdfCustomGui.HideGuiSection") + ' ' + Messages.getMessage("PdfCustomGui." + this.menuTabs[t2]));
            } else {
                hideGuiSection.setText(Messages.getMessage("PdfCustomGui.ShowGuiSection") + ' ' + Messages.getMessage("PdfCustomGui." + this.menuTabs[t2]));
            }
            int currentTab = t2;
            hideGuiSection.addActionListener(e2 -> {
                if (hideGuiSection.getText().startsWith(Messages.getMessage("PdfCustomGui.ShowGuiSection"))) {
                    hideGuiSection.setText(Messages.getMessage("PdfCustomGui.HideGuiSection") + ' ' + Messages.getMessage("PdfCustomGui." + this.menuTabs[currentTab]));
                } else {
                    hideGuiSection.setText(Messages.getMessage("PdfCustomGui.ShowGuiSection") + ' ' + Messages.getMessage("PdfCustomGui." + this.menuTabs[currentTab]));
                }
            });
            display.add((Component)scroll, "Center");
            display.add((Component)hideGuiSection, "South");
            this.tabs.add((Component)display, Messages.getMessage("PdfCustomGui." + this.menuTabs[t2]));
        }
        pane.add((Component)this.tabs, "Center");
        panel.add((Component)pane, "Center");
        return panel;
    }

    private void addMenuToTree(int tab, NodeList nodes, CheckNode top, List<CheckNode> previous) {
        for (int i2 = 0; i2 != nodes.getLength(); ++i2) {
            String name;
            if (i2 >= nodes.getLength() || (name = nodes.item(i2).getNodeName()).startsWith("#")) continue;
            CheckNode newLeaf = new CheckNode(Messages.getMessage("PdfCustomGui." + name));
            newLeaf.setEnabled(true);
            this.reverseMessage.put(Messages.getMessage("PdfCustomGui." + name), name);
            this.loadBooleanValue(newLeaf, name);
            if (nodes.item(i2).hasChildNodes()) {
                previous.add(top);
                top.add(newLeaf);
                this.addMenuToTree(tab, nodes.item(i2).getChildNodes(), newLeaf, previous);
                continue;
            }
            top.add(newLeaf);
        }
    }

    private class MenuTreeListener
    implements TreeSelectionListener {
        private final JTree tree;

        public MenuTreeListener(JTree tree) {
            this.tree = tree;
        }

        private void setChildrenValue(CheckNode checkNode, boolean status) {
            for (int i2 = 0; i2 != checkNode.getChildCount(); ++i2) {
                ((CheckNode)checkNode.getChildAt(i2)).setSelected(status);
                if (checkNode.getChildAt(i2).getChildCount() <= 0) continue;
                this.setChildrenValue((CheckNode)checkNode.getChildAt(i2), status);
            }
        }

        private void setParentValue(CheckNode checkNode, boolean status) {
            checkNode.setSelected(status);
            if (checkNode.getParent() != null) {
                this.setParentValue((CheckNode)checkNode.getParent(), status);
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e2) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            Runnable updateAComponent = () -> {
                CheckNode checkNode = (CheckNode)node;
                if (checkNode != null) {
                    int result;
                    boolean reversedStatus;
                    boolean bl2 = reversedStatus = !checkNode.isSelected();
                    if ("Preferences".equals(SwingProperties.this.reverseMessage.get(checkNode.getText())) && !reversedStatus && (result = JOptionPane.showConfirmDialog(SwingProperties.this.propertiesDialog, Messages.getMessage("PdfPreferences.disabledPropertiesWarning.text"), Messages.getMessage("PdfPreferences.disabledPropertiesWarning.title"), 0)) == 1) {
                        reversedStatus = true;
                    }
                    if (checkNode.getChildCount() > 0) {
                        this.setChildrenValue(checkNode, reversedStatus);
                    }
                    if (checkNode.getParent() != null && reversedStatus) {
                        this.setParentValue((CheckNode)checkNode.getParent(), true);
                    }
                    checkNode.setSelected(reversedStatus);
                    this.tree.invalidate();
                    this.tree.clearSelection();
                    this.tree.repaint();
                }
            };
            SwingUtilities.invokeLater(updateAComponent);
        }
    }
}

