/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public final class StreamViewer
extends JDialog {
    private StreamViewer() {
    }

    static void display(PdfObjectReader pdfObjectReader, Component relativeTo, String reference) {
        String streamText;
        try {
            streamText = StreamViewer.getStreamText(pdfObjectReader, reference);
            if (streamText == null) {
                JOptionPane.showMessageDialog(relativeTo, Messages.getMessage("PdfViewer.StreamViewerNoStream"));
                LogWriter.writeLog("Failed to read stream: No stream present in object");
                return;
            }
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(relativeTo, Messages.getMessage("PdfViewer.StreamViewerFailed") + ":\n" + e2.getMessage());
            LogWriter.writeLog(e2);
            return;
        }
        JDialog dialog = new JDialog((Frame)null, Messages.getMessage("PdfViewer.StreamViewerTitle") + " - " + reference, false);
        JTextPane textPane = new JTextPane();
        JScrollPane textPaneScrollPane = new JScrollPane(textPane, 22, 30);
        textPaneScrollPane.setPreferredSize(new Dimension(800, 600));
        textPane.setText(streamText);
        dialog.add(textPaneScrollPane);
        dialog.setLocationRelativeTo(relativeTo);
        dialog.setResizable(false);
        dialog.pack();
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
    }

    private static String getStreamText(PdfObjectReader pdfObjectReader, String reference) {
        PdfObject object = new PdfObject(reference);
        pdfObjectReader.readObject(object);
        byte[] bytes = pdfObjectReader.getObjectReader().readStream(object, false, true, false, object.getObjectType() == 1365674082, object.isCompressedStream(), null);
        return bytes == null ? null : new String(bytes);
    }
}

