/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import com.idrsolutions.image.utility.SupportedFormats;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.jpedal.examples.viewer.gui.popups.Save;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class SaveImage
extends Save {
    private final JLabel OutputLabel = new JLabel();
    private final String[][] outputType = SupportedFormats.getSupportedImageEncoders();
    private final JComboBox<String> outputTypeList = new JComboBox();

    public SaveImage(String root_dir, int end_page, int currentPage) {
        super(root_dir, end_page, currentPage);
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            LogWriter.writeLog(e2);
        }
    }

    public final String getPrefix() {
        return (String)this.outputTypeList.getSelectedItem();
    }

    private void jbInit() {
        this.setComp.setEnabled(false);
        this.OutputLabel.setText(Messages.getMessage("PdfViewerMessage.OutputType"));
        for (String[] format : this.outputType) {
            if (!"pdf".equalsIgnoreCase(format[0])) {
                this.outputTypeList.addItem(format[0]);
            }
            String[] list = new String[]{"jpx", "jpeg", "webp"};
            this.outputTypeList.addActionListener(ae2 -> {
                if (Arrays.asList(list).contains(this.outputTypeList.getSelectedItem())) {
                    this.setComp.setEnabled(true);
                } else {
                    this.setComp.setValue(50);
                    this.setComp.setEnabled(false);
                }
            });
        }
        this.startLabel.setHorizontalAlignment(4);
        this.endLabel.setHorizontalAlignment(4);
        this.OutputLabel.setHorizontalAlignment(4);
        this.setCompLabel.setHorizontalAlignment(4);
        this.setLayout(new GridBagLayout());
        SaveImage.addComponentToPanel(this, this.rootFilesLabel, 0, 0, 3);
        SaveImage.addComponentToPanel(this, this.rootDir, 0, 1, 3);
        SaveImage.addComponentToPanel(this, this.changeButton, 3, 1, 1);
        SaveImage.addComponentToPanel(this, this.pageRangeLabel, 0, 2, 3);
        SaveImage.addComponentToPanel(this, this.startLabel, 0, 3, 1);
        SaveImage.addComponentToPanel(this, this.startPage, 1, 3, 1);
        SaveImage.addComponentToPanel(this, this.endLabel, 2, 3, 1);
        SaveImage.addComponentToPanel(this, this.endPage, 3, 3, 1);
        SaveImage.addComponentToPanel(this, this.optionsForFilesLabel, 0, 4, 3);
        SaveImage.addComponentToPanel(this, this.OutputLabel, 0, 5, 1);
        SaveImage.addComponentToPanel(this, this.outputTypeList, 1, 5, 1);
        SaveImage.addComponentToPanel(this, this.setCompLabel, 0, 6, 1);
        SaveImage.addComponentToPanel(this, this.setComp, 1, 6, 4);
    }

    @Override
    public final Dimension getPreferredSize() {
        return new Dimension(500, 250);
    }
}

