/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import com.idrsolutions.image.utility.SupportedFormats;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.jpedal.examples.viewer.gui.popups.Save;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class SaveBitmap
extends Save {
    private final JLabel OutputLabel = new JLabel();
    private final JLabel optionsLabel = new JLabel();
    private final JLabel scalingLabel = new JLabel();
    private static final String[] scales = new String[]{"10", "25", "50", "75", "100"};
    private final JComboBox<String> scaling = new JComboBox<String>(scales);
    private final String[][] formats = SupportedFormats.getSupportedImageEncoders();
    private final JComboBox<String> outputTypeList = new JComboBox();

    public SaveBitmap(String root_dir, int end_page, int currentPage) {
        super(root_dir, end_page, currentPage);
        this.optionsLabel.setFont(new Font("Dialog", 1, 14));
        this.optionsLabel.setText(Messages.getMessage("PdfViewerMenu.options"));
        this.scalingLabel.setText(Messages.getMessage("PdfViewerToolbarScaling.text"));
        this.scaling.setSelectedItem("100");
        this.scaling.setName("exportScaling");
        this.outputTypeList.setName("SaveBitmapImageType");
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            LogWriter.writeLog(e2);
        }
    }

    public final String getPrefix() {
        return (String)this.outputTypeList.getSelectedItem();
    }

    public final int getScaling() {
        String value = (String)this.scaling.getSelectedItem();
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    @Override
    public final Dimension getPreferredSize() {
        return new Dimension(490, 280);
    }

    private void jbInit() {
        this.OutputLabel.setText(Messages.getMessage("PdfViewerMessage.OutputType"));
        for (String[] format : this.formats) {
            if ("pdf".equalsIgnoreCase(format[0])) continue;
            this.outputTypeList.addItem(format[0]);
        }
        this.startLabel.setHorizontalAlignment(4);
        this.endLabel.setHorizontalAlignment(4);
        this.scalingLabel.setHorizontalAlignment(4);
        this.OutputLabel.setHorizontalAlignment(4);
        this.setLayout(new GridBagLayout());
        SaveBitmap.addComponentToPanel(this, this.rootFilesLabel, 0, 0, 3);
        SaveBitmap.addComponentToPanel(this, this.rootDir, 0, 1, 3);
        SaveBitmap.addComponentToPanel(this, this.changeButton, 3, 1, 1);
        SaveBitmap.addComponentToPanel(this, this.pageRangeLabel, 0, 2, 3);
        SaveBitmap.addComponentToPanel(this, this.startLabel, 0, 3, 1);
        SaveBitmap.addComponentToPanel(this, this.startPage, 1, 3, 1);
        SaveBitmap.addComponentToPanel(this, this.endLabel, 2, 3, 1);
        SaveBitmap.addComponentToPanel(this, this.endPage, 3, 3, 1);
        SaveBitmap.addComponentToPanel(this, this.optionsLabel, 0, 4, 3);
        SaveBitmap.addComponentToPanel(this, this.scalingLabel, 0, 5, 1);
        SaveBitmap.addComponentToPanel(this, this.scaling, 1, 5, 1);
        SaveBitmap.addComponentToPanel(this, this.optionsForFilesLabel, 0, 6, 3);
        SaveBitmap.addComponentToPanel(this, this.OutputLabel, 0, 7, 1);
        SaveBitmap.addComponentToPanel(this, this.outputTypeList, 1, 7, 1);
    }
}

