/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class Save
extends JComponent {
    final JTextField startPage = new JTextField();
    final JTextField endPage = new JTextField();
    final JTextField rootDir = new JTextField();
    final JSlider setComp = new JSlider(1, 100);
    final JLabel rootFilesLabel = new JLabel();
    final JButton changeButton = new JButton();
    final JLabel endLabel = new JLabel();
    final JLabel startLabel = new JLabel();
    final JLabel pageRangeLabel = new JLabel();
    final JLabel setCompLabel = new JLabel();
    final String root_dir;
    final int end_page;
    final int currentPage;
    final JLabel optionsForFilesLabel = new JLabel();

    Save(String root_dir, int end_page, int currentPage) {
        int[] labels;
        this.currentPage = currentPage;
        this.root_dir = root_dir;
        this.end_page = end_page;
        this.rootFilesLabel.setFont(new Font("Dialog", 1, 14));
        this.rootFilesLabel.setDisplayedMnemonic('0');
        this.rootFilesLabel.setText(Messages.getMessage("PdfViewerOption.RootDir"));
        this.rootDir.setText(root_dir);
        this.rootDir.setName("extRootDir");
        this.changeButton.setText(Messages.getMessage("PdfViewerOption.Browse"));
        this.changeButton.addActionListener(e2 -> {
            JFileChooser chooser = new JFileChooser(root_dir);
            chooser.setFileSelectionMode(1);
            int state = chooser.showOpenDialog(null);
            File file = chooser.getSelectedFile();
            if (file != null && state == 0) {
                this.rootDir.setText(file.getAbsolutePath());
            }
        });
        this.optionsForFilesLabel.setText(Messages.getMessage("PdfViewerOption.Output"));
        this.optionsForFilesLabel.setFont(new Font("Dialog", 1, 14));
        this.optionsForFilesLabel.setDisplayedMnemonic('0');
        this.pageRangeLabel.setText(Messages.getMessage("PdfViewerOption.PageRange"));
        this.pageRangeLabel.setFont(new Font("Dialog", 1, 14));
        this.pageRangeLabel.setDisplayedMnemonic('0');
        this.startLabel.setText(Messages.getMessage("PdfViewerOption.StartPage"));
        this.endLabel.setText(Messages.getMessage("PdfViewerOption.EndPage"));
        this.startPage.setText("1");
        this.endPage.setText(String.valueOf(end_page));
        this.setCompLabel.setText(Messages.getMessage("PdfViewerOptions.SetComp"));
        this.setComp.setPaintTicks(true);
        this.setComp.setPaintLabels(true);
        Hashtable<Integer, JLabel> position = new Hashtable<Integer, JLabel>();
        for (int label : labels = new int[]{10, 20, 30, 40, 50, 60, 70, 80, 90, 100}) {
            position.put(label, new JLabel(String.valueOf(label)));
        }
        this.setComp.setLabelTable(position);
        this.setComp.addChangeListener(e2 -> this.setCompLabel.setText(Messages.getMessage("PdfViewerOptions.SetComp") + " : " + ((JSlider)e2.getSource()).getValue() + '%'));
    }

    public int display(Component c2, String title) {
        this.setSize(400, 200);
        JPanel popupPanel = new JPanel();
        popupPanel.setLayout(new BorderLayout());
        popupPanel.add((Component)this, "Center");
        popupPanel.setSize(400, 200);
        Object[] options = new Object[]{Messages.getMessage("PdfMessage.Ok"), Messages.getMessage("PdfMessage.Cancel")};
        if (SwingGUI.showMessages) {
            return JOptionPane.showOptionDialog(c2, popupPanel, title, -1, -1, null, options, options[0]);
        }
        return 0;
    }

    public final int getStartPage() {
        return this.validatePageInRange(this.startPage.getText());
    }

    public final String getRootDir() {
        return this.rootDir.getText();
    }

    public final int getEndPage() {
        return this.validatePageInRange(this.endPage.getText());
    }

    public final int getCompression() {
        return this.setComp.getValue();
    }

    private int validatePageInRange(String pageStr) {
        boolean userAlerted;
        int page;
        block7: {
            page = -1;
            userAlerted = false;
            try {
                page = Integer.parseInt(pageStr);
            }
            catch (NumberFormatException e2) {
                LogWriter.writeLog("Exception " + e2 + " in exporting");
                if (!SwingGUI.showMessages) break block7;
                JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerError.InvalidSyntax") + ' ' + pageStr);
                userAlerted = true;
            }
        }
        if (!userAlerted) {
            if (page < 1 && SwingGUI.showMessages) {
                JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerError.NegativePageValue"));
            } else if (page > this.end_page) {
                if (SwingGUI.showMessages) {
                    JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerText.Page") + ' ' + page + ' ' + Messages.getMessage("PdfViewerError.OutOfBounds") + ' ' + Messages.getMessage("PdfViewerText.PageCount") + ' ' + this.end_page);
                }
                page = -1;
            }
        }
        return page;
    }

    @Override
    public final Dimension getSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 330);
    }

    @Override
    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public final Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    static void addComponentToPanel(JComponent panel, JComponent comp, int x2, int y2, int w2) {
        GridBagConstraints consraints = new GridBagConstraints();
        consraints.gridx = x2;
        consraints.gridy = y2;
        consraints.gridwidth = w2;
        consraints.fill = 1;
        consraints.insets = new Insets(5, 5, 5, 5);
        consraints.anchor = 21;
        consraints.weightx = 1.0;
        consraints.weighty = 1.0;
        panel.add((Component)comp, consraints);
    }
}

