/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.print.Paper;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterResolution;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jpedal.PdfDecoder;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.paper.MarginPaper;
import org.jpedal.examples.viewer.paper.PaperSizes;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.PrinterOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class PrintPanel
extends JPanel {
    private int pageCount;
    private int currentPage;
    private int currentPreviewedPage = 1;
    private boolean okClicked;
    private String[] printersList;
    private final PaperSizes paperDefinitions;
    private int defaultResolution;
    private static final double mmPerSubInch = 0.35277777777777775;
    private final PdfDecoderInt pdf;
    private JCheckBox autoRotateCenter;
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JSpinner left;
    private JSpinner right;
    private JSpinner top;
    private JSpinner bottom;
    private JComboBox<String> resolution;
    private JButton okButton;
    private JPanel pageHandlingPanel;
    private JComponent previewComponent;
    private CustomSlider previewSlider;
    private JComboBox<String> pageSize;
    private JTextField pagesFrom;
    private JTextField pagesTo;
    private JCheckBox paperSourceByPDF;
    private JCheckBox grayscale;
    private JSpinner printHandlingCopies;
    private JComboBox<String> printHandlingScaling;
    private JRadioButton printRangeAll;
    private JRadioButton printRangeCurrentPage;
    private JRadioButton printRangeCurrentView;
    private JRadioButton printRangeFrom;
    private JPanel printRangePanel;
    private JCheckBox printRangeReversePages;
    private JComboBox<String> printRangeSubset;
    private JComboBox<String> printerName;
    private JPanel printerPanel;
    private JTabbedPane tabbedPane;

    public PrintPanel(String[] printersList, String defaultPrinter, PaperSizes paperDefinitions, int defaultResolution, int pageNumber, PdfDecoderInt decoder) {
        this.pdf = decoder;
        this.pageCount = this.pdf.getPageCount();
        this.currentPage = pageNumber;
        this.defaultResolution = defaultResolution;
        this.paperDefinitions = paperDefinitions;
        this.printersList = printersList;
        this.initComponents(defaultPrinter);
    }

    public void resetDefaults(String[] printersList, String defaultPrinter, int pageCount, int currentPage) {
        this.printersList = printersList;
        this.pageCount = pageCount;
        this.currentPage = currentPage;
        if (this.pageSize.getItemCount() == 0) {
            return;
        }
        this.resetRangeTab();
        this.printHandlingCopies.setValue(1);
        if (defaultPrinter != null && !defaultPrinter.isEmpty()) {
            this.printerName.setSelectedItem(defaultPrinter);
        }
        this.printerName.setModel(new DefaultComboBoxModel<String>(printersList));
        this.tabbedPane.setSelectedIndex(0);
    }

    private void resetRangeTab() {
        this.pagesFrom.setText("1");
        this.pagesTo.setText(String.valueOf(this.pageCount));
        this.printRangeAll.setSelected(true);
        this.printRangeSubset.setSelectedIndex(0);
        this.printRangeReversePages.setSelected(false);
    }

    private void initComponents(String startingPrinter) {
        this.buttonGroup1 = new ButtonGroup();
        this.printerPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.printerName = new JComboBox();
        this.pageSize = new JComboBox();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.left = new JSpinner();
        this.right = new JSpinner();
        this.top = new JSpinner();
        this.bottom = new JSpinner();
        this.resolution = new JComboBox();
        this.printRangePanel = new JPanel();
        this.pagesFrom = new JTextField();
        this.printRangeCurrentPage = new JRadioButton();
        this.printRangeAll = new JRadioButton();
        this.printRangeCurrentView = new JRadioButton();
        this.printRangeFrom = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.printRangeSubset = new JComboBox();
        this.printRangeReversePages = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.pagesTo = new JTextField();
        this.pageHandlingPanel = new JPanel();
        JPanel previewPanel = new JPanel();
        this.previewComponent = new JComponent(){

            @Override
            public void paintComponent(Graphics g2) {
                PrintPanel.this.printPreview((Graphics2D)g2);
            }
        };
        this.previewSlider = new CustomSlider();
        this.jLabel8 = new JLabel();
        this.printHandlingCopies = new JSpinner();
        this.jLabel9 = new JLabel();
        this.printHandlingScaling = new JComboBox();
        this.autoRotateCenter = new JCheckBox();
        this.paperSourceByPDF = new JCheckBox();
        this.grayscale = new JCheckBox();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.nameElements();
        this.setLayout(null);
        this.add(this.tabbedPane);
        this.tabbedPane.setBounds(10, 7, 400, 339);
        this.createPrinterPanel(startingPrinter);
        this.createPrintRangePanel();
        this.createPageHandlingPanel();
        previewPanel.setLayout(null);
        previewPanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getMessage("PdfViewerLabel.PrintPreview"), 0, 0, new Font("Tahoma", 0, 11)));
        previewPanel.add(this.previewComponent);
        this.previewComponent.setBounds(5, 5, 220, 275);
        previewPanel.add(this.previewSlider);
        this.previewSlider.setBounds(5, 280, 220, 40);
        this.previewSlider.resetValue();
        this.updatePreview();
        this.add(previewPanel);
        previewPanel.setBounds(420, 7, 230, 330);
        this.okButton.setText(Messages.getMessage("PdfMessage.Ok"));
        this.okButton.addActionListener(evt -> this.okEvent());
        this.add(this.okButton);
        this.okButton.setBounds(445, 348, 90, 23);
        this.cancelButton.setText(Messages.getMessage("PdfMessage.Cancel"));
        this.cancelButton.addActionListener(evt -> this.cancelEvent());
        this.add(this.cancelButton);
        this.cancelButton.setBounds(560, 348, 90, 23);
    }

    private void createPageHandlingPanel() {
        this.pageHandlingPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.jLabel8.setText(Messages.getMessage("PdfViewerPrint.Copies"));
        this.pageHandlingPanel.add((Component)this.jLabel8, PrintPanel.setGridBagConstraints(gbc, 0, 0, 1));
        this.printHandlingCopies.setModel(new SpinnerNumberModel(1, 1, 1000, 1));
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 17;
        this.printHandlingCopies.setMinimumSize(new Dimension(65, 22));
        this.printHandlingCopies.setPreferredSize(new Dimension(65, 22));
        this.pageHandlingPanel.add((Component)this.printHandlingCopies, PrintPanel.setGridBagConstraints(gbc, 1, 0, 1));
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.jLabel9.setText(Messages.getMessage("PdfViewerPrint.PageScaling"));
        this.pageHandlingPanel.add((Component)this.jLabel9, PrintPanel.setGridBagConstraints(gbc, 0, 1, 1));
        this.printHandlingScaling.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.getMessage("PdfViewerPrint.NoScaling"), Messages.getMessage("PdfViewerPrint.FitToPrinterMargins"), Messages.getMessage("PdfViewerPrint.ReduceToPrinterMargins")}));
        this.printHandlingScaling.setSelectedIndex(PrinterOptions.LAST_SCALING_CHOICE);
        gbc.insets = new Insets(5, 0, 5, 0);
        this.pageHandlingPanel.add(this.printHandlingScaling, PrintPanel.setGridBagConstraints(gbc, 1, 1, 1));
        gbc.insets = new Insets(5, 5, 5, 5);
        this.printHandlingScaling.addItemListener(e2 -> this.updatePreview());
        this.autoRotateCenter.setSelected(true);
        this.autoRotateCenter.setText(Messages.getMessage("PdfViewerPrint.AutoRotateAndCenter"));
        this.autoRotateCenter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.autoRotateCenter.setMargin(new Insets(0, 0, 0, 0));
        this.pageHandlingPanel.add((Component)this.autoRotateCenter, PrintPanel.setGridBagConstraints(gbc, 0, 2, 2));
        this.autoRotateCenter.addItemListener(e2 -> this.updatePreview());
        this.paperSourceByPDF.setText(Messages.getMessage("PdfViewerPrint.ChoosePaperByPdfSize"));
        this.paperSourceByPDF.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.paperSourceByPDF.setMargin(new Insets(0, 0, 0, 0));
        this.pageHandlingPanel.add((Component)this.paperSourceByPDF, PrintPanel.setGridBagConstraints(gbc, 0, 3, 2));
        this.paperSourceByPDF.addItemListener(e2 -> this.updatePreview());
        this.grayscale.setText(Messages.getMessage("PdfViewerPrint.Grayscale"));
        this.grayscale.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pageHandlingPanel.add((Component)this.grayscale, PrintPanel.setGridBagConstraints(gbc, 0, 4, 2));
        this.grayscale.setMargin(new Insets(0, 0, 0, 0));
        this.grayscale.addItemListener(e2 -> this.updatePreview());
        this.tabbedPane.addTab(Messages.getMessage("PdfViewerPrintTab.handling"), this.pageHandlingPanel);
    }

    private void createPrintRangePanel() {
        this.printRangePanel.setLayout(new GridBagLayout());
        this.setUpRangeSettings();
        this.addRangeOptionsToPanel();
        this.tabbedPane.addTab(Messages.getMessage("PdfViewerPrintTab.range"), this.printRangePanel);
    }

    private void setUpRangeSettings() {
        this.pagesFrom.setText("1");
        this.pagesFrom.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PrintPanel.this.pagesBoxPressed();
            }
        });
        this.pagesFrom.setMinimumSize(new Dimension(65, 22));
        this.pagesFrom.setPreferredSize(new Dimension(65, 22));
        this.jLabel7.setText(Messages.getMessage("PdfViewerPrint.PagesTo"));
        this.pagesTo.setText(String.valueOf(this.pageCount));
        this.pagesTo.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PrintPanel.this.pagesBoxPressed();
            }
        });
        this.pagesTo.setMinimumSize(new Dimension(65, 22));
        this.pagesTo.setPreferredSize(new Dimension(65, 22));
        this.printRangeReversePages.setText(Messages.getMessage("PdfViewerPrint.ReversePages"));
        this.printRangeReversePages.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeReversePages.setMargin(new Insets(0, 0, 0, 0));
        this.printRangeReversePages.addItemListener(e2 -> this.updatePreview());
        this.jLabel4.setText(Messages.getMessage("PdfViewerPrint.Subset"));
        this.printRangeSubset.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.getMessage("PdfViewerPrint.AllPagesInRange"), Messages.getMessage("PdfViewerPrint.OddPagesOnly"), Messages.getMessage("PdfViewerPrint.EvenPagesOnly")}));
        this.printRangeSubset.addItemListener(e2 -> this.updatePreview());
        this.printRangeCurrentPage.setText(Messages.getMessage("PdfViewerRadioButton.CurrentPage"));
        this.printRangeCurrentPage.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeCurrentPage.setMargin(new Insets(0, 0, 0, 0));
        this.printRangeCurrentPage.setOpaque(false);
        this.printRangeCurrentPage.addItemListener(evt -> this.currentPageStateChanged());
        this.printRangeAll.setSelected(true);
        this.printRangeAll.setText(Messages.getMessage("PdfViewerRadioButton.All"));
        this.printRangeAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeAll.setMargin(new Insets(0, 0, 0, 0));
        this.printRangeAll.setOpaque(false);
        this.printRangeAll.addItemListener(evt -> this.allStateChanged());
        this.printRangeCurrentView.setText(Messages.getMessage("PdfViewerPrint.CurrentView"));
        this.printRangeCurrentView.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeCurrentView.setEnabled(true);
        this.printRangeCurrentView.setMargin(new Insets(0, 0, 0, 0));
        this.printRangeCurrentView.setOpaque(false);
        if (this.pdf.getDisplayView() != 1) {
            this.printRangeCurrentView.setEnabled(false);
            this.printRangeCurrentView.setToolTipText(Messages.getMessage("PageLayoutMessage.SinglePageOnly"));
        } else {
            this.printRangeCurrentView.setEnabled(true);
            this.printRangeCurrentView.setToolTipText(null);
        }
        this.printRangeCurrentView.addItemListener(evt -> this.printRangeCurrentView());
        this.printRangeFrom.setText(Messages.getMessage("PdfViewerPrint.PagesFrom"));
        this.printRangeFrom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.printRangeFrom.setMargin(new Insets(0, 0, 0, 0));
        this.printRangeFrom.setOpaque(false);
        this.printRangeFrom.addItemListener(evt -> this.pagesFromStateChanged());
        this.buttonGroup1.add(this.printRangeCurrentPage);
        this.buttonGroup1.add(this.printRangeAll);
        this.buttonGroup1.add(this.printRangeCurrentView);
        this.buttonGroup1.add(this.printRangeFrom);
    }

    private void addRangeOptionsToPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.printRangePanel.add((Component)this.printRangeAll, PrintPanel.setGridBagConstraints(gbc, 0, 0, 1));
        this.printRangePanel.add((Component)this.printRangeCurrentView, PrintPanel.setGridBagConstraints(gbc, 0, 1, 1));
        this.printRangePanel.add((Component)this.printRangeCurrentPage, PrintPanel.setGridBagConstraints(gbc, 0, 2, 1));
        this.printRangePanel.add((Component)this.printRangeFrom, PrintPanel.setGridBagConstraints(gbc, 0, 3, 1));
        this.printRangePanel.add((Component)this.jLabel4, PrintPanel.setGridBagConstraints(gbc, 0, 4, 1));
        this.printRangePanel.add((Component)this.printRangeReversePages, PrintPanel.setGridBagConstraints(gbc, 0, 5, 3));
        gbc.insets = new Insets(0, 0, 0, 0);
        this.printRangePanel.add((Component)this.pagesFrom, PrintPanel.setGridBagConstraints(gbc, 1, 3, 1));
        gbc.insets = new Insets(5, 0, 5, 0);
        this.printRangePanel.add(this.printRangeSubset, PrintPanel.setGridBagConstraints(gbc, 1, 4, 4));
        gbc.insets = new Insets(5, 5, 5, 5);
        this.printRangePanel.add((Component)this.jLabel7, PrintPanel.setGridBagConstraints(gbc, 2, 3, 1));
        gbc.insets = new Insets(0, 0, 0, 0);
        this.printRangePanel.add((Component)this.pagesTo, PrintPanel.setGridBagConstraints(gbc, 3, 3, 1));
    }

    private void createPrinterPanel(String startingPrinter) {
        this.printerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.jLabel1.setText(Messages.getMessage("PdfViewerPrint.Name"));
        this.printerPanel.add((Component)this.jLabel1, PrintPanel.setGridBagConstraints(gbc, 0, 0, 1));
        this.jLabel2.setText(Messages.getMessage("PdfViewerPrint.PageSize"));
        this.printerPanel.add((Component)this.jLabel2, PrintPanel.setGridBagConstraints(gbc, 0, 1, 1));
        this.printerName.setModel(new DefaultComboBoxModel<String>(this.printersList));
        this.printerPanel.add(this.printerName, PrintPanel.setGridBagConstraints(gbc, 1, 0, 5));
        this.addPrinterChangeListener();
        this.pageSize.setModel(new DefaultComboBoxModel<String>(new String[]{"Loading..."}));
        this.pageSize.setEnabled(false);
        this.resolution.setModel(new DefaultComboBoxModel<String>(new String[]{"Loading..."}));
        this.resolution.setEnabled(false);
        this.okButton.setEnabled(false);
        this.loadPrinterDefaults(startingPrinter);
        this.pageSize.addItemListener(e2 -> {
            this.updatePreview();
            this.updateMargins();
        });
        this.pageSize.setMinimumSize(new Dimension(40, 22));
        this.pageSize.setPreferredSize(new Dimension(40, 22));
        this.printerPanel.add(this.pageSize, PrintPanel.setGridBagConstraints(gbc, 1, 1, 5));
        this.jLabel10.setText(Messages.getMessage("PdfViewerPrintMargins.margin"));
        this.printerPanel.add((Component)this.jLabel10, PrintPanel.setGridBagConstraints(gbc, 0, 2, 1));
        this.jLabel11.setText(Messages.getMessage("PdfViewerPrintMargins.left"));
        this.printerPanel.add((Component)this.jLabel11, PrintPanel.setGridBagConstraints(gbc, 1, 2, 1));
        this.left.setModel(new CustomSpinnerModel());
        this.left.setMinimumSize(new Dimension(65, 22));
        this.left.setPreferredSize(new Dimension(65, 22));
        this.printerPanel.add((Component)this.left, PrintPanel.setGridBagConstraints(gbc, 2, 2, 1));
        this.jLabel12.setText(Messages.getMessage("PdfViewerPrintMargins.right"));
        this.printerPanel.add((Component)this.jLabel12, PrintPanel.setGridBagConstraints(gbc, 3, 2, 1));
        this.right.setModel(new CustomSpinnerModel());
        this.right.setMinimumSize(new Dimension(65, 22));
        this.right.setPreferredSize(new Dimension(65, 22));
        this.printerPanel.add((Component)this.right, PrintPanel.setGridBagConstraints(gbc, 4, 2, 1));
        this.jLabel13.setText(Messages.getMessage("PdfViewerPrintMargins.top"));
        this.printerPanel.add((Component)this.jLabel13, PrintPanel.setGridBagConstraints(gbc, 1, 3, 1));
        this.top.setModel(new CustomSpinnerModel());
        this.top.setMinimumSize(new Dimension(65, 22));
        this.top.setPreferredSize(new Dimension(65, 22));
        this.printerPanel.add((Component)this.top, PrintPanel.setGridBagConstraints(gbc, 2, 3, 1));
        this.jLabel14.setText(Messages.getMessage("PdfViewerPrintMargins.bottom"));
        this.printerPanel.add((Component)this.jLabel14, PrintPanel.setGridBagConstraints(gbc, 3, 3, 1));
        this.bottom.setModel(new CustomSpinnerModel());
        this.bottom.setMinimumSize(new Dimension(65, 22));
        this.bottom.setPreferredSize(new Dimension(65, 22));
        this.printerPanel.add((Component)this.bottom, PrintPanel.setGridBagConstraints(gbc, 4, 3, 1));
        this.addMarginChangeListener();
        this.jLabel15.setText(Messages.getMessage("PdfViewerPrintResolution.text"));
        this.printerPanel.add((Component)this.jLabel15, PrintPanel.setGridBagConstraints(gbc, 0, 4, 1));
        this.printerPanel.add(this.resolution, PrintPanel.setGridBagConstraints(gbc, 1, 4, 5));
        this.tabbedPane.addTab(Messages.getMessage("PdfViewerPrintTab.printer"), this.printerPanel);
    }

    private static GridBagConstraints setGridBagConstraints(GridBagConstraints gbc, int x2, int y2, int width) {
        gbc.gridx = x2;
        gbc.gridy = y2;
        gbc.gridwidth = width;
        return gbc;
    }

    private void addPrinterChangeListener() {
        this.printerName.addItemListener(e2 -> {
            this.previewComponent.repaint();
            this.okButton.setEnabled(false);
            this.pageSize.setEnabled(false);
            this.pageSize.setModel(new DefaultComboBoxModel<String>(new String[]{"Loading..."}));
            this.resolution.setEnabled(false);
            this.resolution.setModel(new DefaultComboBoxModel<String>(new String[]{"Loading..."}));
            SwingUtilities.invokeLater(() -> {
                PrintService[] ps = PrintServiceLookup.lookupPrintServices(null, null);
                PrintService p2 = null;
                for (PrintService p1 : ps) {
                    if (!p1.getName().equals(this.printerName.getSelectedItem())) continue;
                    p2 = p1;
                }
                if (p2 != null) {
                    this.resolution.setModel(new DefaultComboBoxModel<String>(PrintPanel.getAvailableResolutions(p2)));
                    int resInd = this.getDefaultResolutionIndex();
                    if (this.resolution.getModel().getSize() > resInd) {
                        this.resolution.setSelectedIndex(resInd);
                    }
                    this.resolution.setEnabled(true);
                    this.paperDefinitions.setPrintService(p2);
                    this.pageSize.setModel(new DefaultComboBoxModel<String>(this.getAvailablePaperSizes()));
                    int pageInd = this.paperDefinitions.getDefaultPageIndex();
                    if (this.pageSize.getModel().getSize() > pageInd) {
                        this.pageSize.setSelectedIndex(pageInd);
                    }
                    this.pageSize.setEnabled(true);
                    this.okButton.setEnabled(true);
                }
                this.updateMargins();
            });
        });
    }

    private void addMarginChangeListener() {
        ChangeListener marginListener = new ChangeListener(){
            static final double mmToSubInch = 2.834645669291339;

            @Override
            public void stateChanged(ChangeEvent e2) {
                MarginPaper paper = PrintPanel.this.getSelectedPaper();
                if (paper == null) {
                    return;
                }
                double l2 = (Double)PrintPanel.this.left.getValue() * 2.834645669291339;
                double r2 = (Double)PrintPanel.this.right.getValue() * 2.834645669291339;
                double t2 = (Double)PrintPanel.this.top.getValue() * 2.834645669291339;
                double b2 = (Double)PrintPanel.this.bottom.getValue() * 2.834645669291339;
                paper.setImageableArea(l2, t2, paper.getWidth() - l2 - r2, paper.getHeight() - t2 - b2);
                PrintPanel.this.updatePreview();
            }
        };
        this.left.addChangeListener(marginListener);
        this.right.addChangeListener(marginListener);
        this.top.addChangeListener(marginListener);
        this.bottom.addChangeListener(marginListener);
    }

    private String getDefaultPrinterName(String startingPrinter) {
        PrintService printer;
        String printerFlag = System.getProperty("org.jpedal.defaultPrinter");
        String printerToUse = null;
        if (printerFlag != null) {
            for (String aPrintersList : this.printersList) {
                if (!printerFlag.equals(aPrintersList)) continue;
                printerToUse = aPrintersList;
                break;
            }
        } else {
            printerToUse = startingPrinter;
        }
        if ((printerToUse == null || printerToUse.isEmpty()) && (printer = PrintServiceLookup.lookupDefaultPrintService()) != null) {
            printerToUse = printer.getName();
        }
        return printerToUse;
    }

    private void loadPrinterDefaults(String startingPrinter) {
        Thread t2 = new Thread(() -> {
            String printerToUse = this.getDefaultPrinterName(startingPrinter);
            PrintService[] ps = PrintServiceLookup.lookupPrintServices(null, null);
            PrintService p2 = null;
            for (PrintService p1 : ps) {
                if (!p1.getName().equals(printerToUse)) continue;
                p2 = p1;
            }
            if (p2 != null) {
                this.paperDefinitions.setPrintService(p2);
                this.resolution.setModel(new DefaultComboBoxModel<String>(PrintPanel.getAvailableResolutions(p2)));
                int defaultResolution = this.getDefaultResolutionIndex();
                if (this.resolution.getModel().getSize() > defaultResolution) {
                    this.resolution.setSelectedIndex(defaultResolution);
                }
                this.resolution.setEnabled(true);
                this.pageSize.setModel(new DefaultComboBoxModel<String>(this.getAvailablePaperSizes()));
                int defaultPageSize = this.paperDefinitions.getDefaultPageIndex();
                if (defaultPageSize < this.pageSize.getModel().getSize()) {
                    this.pageSize.setSelectedIndex(defaultPageSize);
                }
                this.pageSize.setEnabled(true);
                this.okButton.setEnabled(true);
            }
            this.updateMargins();
        });
        t2.setDaemon(true);
        t2.start();
    }

    private static String[] getAvailableResolutions(PrintService p2) {
        PrinterResolution[] resolutions = (PrinterResolution[])p2.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (resolutions == null) {
            return new String[]{"Default"};
        }
        String[] names = new String[resolutions.length];
        for (int i2 = 0; i2 < resolutions.length; ++i2) {
            PrinterResolution res = resolutions[i2];
            names[i2] = res.getCrossFeedResolution(100) + "x" + res.getFeedResolution(100) + " dpi";
        }
        return names;
    }

    public PrinterResolution getResolution() {
        PrintService[] ps = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService p2 = null;
        for (PrintService p1 : ps) {
            if (!p1.getName().equals(this.printerName.getSelectedItem())) continue;
            p2 = p1;
        }
        if (p2 == null) {
            return null;
        }
        PrinterResolution[] resolutions = (PrinterResolution[])p2.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (resolutions == null) {
            return null;
        }
        return resolutions[this.resolution.getSelectedIndex()];
    }

    private int getDefaultResolutionIndex() {
        PrintService[] ps = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService p2 = null;
        for (PrintService p1 : ps) {
            if (!p1.getName().equals(this.printerName.getSelectedItem())) continue;
            p2 = p1;
        }
        if (p2 == null) {
            return 0;
        }
        PrinterResolution[] resolutions = (PrinterResolution[])p2.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (resolutions == null) {
            return 0;
        }
        if (this.defaultResolution == -1) {
            this.defaultResolution = 600;
        }
        int minDiff = Integer.MAX_VALUE;
        int indexToUse = 0;
        for (int i2 = 0; i2 < resolutions.length; ++i2) {
            int fDiff;
            PrinterResolution res = resolutions[i2];
            int cfDiff = res.getCrossFeedResolution(100) - this.defaultResolution;
            if (cfDiff < 0) {
                cfDiff = -cfDiff;
            }
            if ((fDiff = res.getFeedResolution(100) - this.defaultResolution) < 0) {
                fDiff = -fDiff;
            }
            if (cfDiff + fDiff >= minDiff) continue;
            minDiff = cfDiff + fDiff;
            indexToUse = i2;
        }
        return indexToUse;
    }

    private void updateMargins() {
        MarginPaper p2 = this.getSelectedPaper();
        if (p2 == null) {
            return;
        }
        ((CustomSpinnerModel)this.left.getModel()).setMinValue(p2.getMinX() * 0.35277777777777775);
        ((CustomSpinnerModel)this.top.getModel()).setMinValue(p2.getMinY() * 0.35277777777777775);
        ((CustomSpinnerModel)this.right.getModel()).setMinValue((p2.getWidth() - p2.getMaxRX()) * 0.35277777777777775);
        ((CustomSpinnerModel)this.bottom.getModel()).setMinValue((p2.getHeight() - p2.getMaxBY()) * 0.35277777777777775);
        Double a10 = 0.0;
        this.left.setValue(a10);
        this.top.setValue(a10);
        this.right.setValue(a10);
        this.bottom.setValue(a10);
    }

    private void printPreview(Graphics2D g2) {
        int pageHeight;
        int pageWidth;
        int w2 = this.previewComponent.getWidth();
        int h2 = this.previewComponent.getHeight();
        if (this.printRangeCurrentView.isSelected()) {
            pageWidth = (int)(this.pdf.getVisibleRect().getWidth() / (double)this.pdf.getScaling());
            pageHeight = (int)(this.pdf.getVisibleRect().getHeight() / (double)this.pdf.getScaling());
        } else {
            pageWidth = this.pdf.getPdfPageData().getCropBoxWidth(this.currentPreviewedPage);
            pageHeight = this.pdf.getPdfPageData().getCropBoxHeight(this.currentPreviewedPage);
        }
        Paper p2 = this.getPaperForPreview(pageWidth, pageHeight);
        if (p2 == null) {
            g2.setColor(this.getForeground());
            g2.drawString(Messages.getMessage("PdfPrintPreview.Loading"), w2 / 2 - 25, h2 / 2 - 5);
            return;
        }
        int lO = 25;
        int tO = 30;
        int rO = 5;
        int bO = 25;
        double paperHeightInInches = p2.getHeight() / 72.0;
        double paperWidthInInches = p2.getWidth() / 72.0;
        double wScale = (double)(w2 - (lO + 5)) / p2.getWidth();
        double hScale = (double)(h2 - (tO + 25)) / p2.getHeight();
        double scale = Math.min(wScale, hScale);
        p2.setSize(scale * p2.getWidth(), scale * p2.getHeight());
        p2.setImageableArea(scale * p2.getImageableX(), scale * p2.getImageableY(), scale * p2.getImageableWidth(), scale * p2.getImageableHeight());
        pageWidth = (int)(scale * (double)pageWidth);
        pageHeight = (int)(scale * (double)pageHeight);
        double pageScale = 1.0;
        if (this.printHandlingScaling.getSelectedIndex() == 1 || this.printHandlingScaling.getSelectedIndex() == 2 && ((double)pageWidth > p2.getImageableWidth() || (double)pageHeight > p2.getImageableHeight())) {
            pageScale = p2.getImageableWidth() / (double)pageWidth;
            if (p2.getImageableHeight() / (double)pageHeight < pageScale) {
                pageScale = p2.getImageableHeight() / (double)pageHeight;
            }
            pageWidth = (int)(pageScale * (double)pageWidth);
            pageHeight = (int)(pageScale * (double)pageHeight);
        }
        lO = (int)((double)lO + ((double)w2 - ((double)(lO + 5) + p2.getWidth())) / 2.0);
        tO = (int)((double)tO + ((double)h2 - ((double)(tO + 25) + p2.getHeight())) / 2.0);
        PrintPanel.drawPreviewArea(g2, lO, tO, (int)p2.getWidth(), (int)p2.getHeight(), (int)p2.getImageableX(), (int)p2.getImageableY(), (int)p2.getImageableWidth(), (int)p2.getImageableHeight());
        PrintPanel.drawPreviewWidthBar(g2, lO, tO, (int)p2.getWidth(), paperWidthInInches, this.getForeground());
        PrintPanel.drawPreviewHeightBar(g2, lO, tO, (int)p2.getHeight(), paperHeightInInches, this.getForeground());
        this.drawPreviewPage(g2, lO, tO, pageWidth, pageHeight, (int)p2.getImageableX() - 1, (int)p2.getImageableY() - 1, (int)p2.getImageableWidth() - 1, (int)p2.getImageableHeight() - 1);
        PrintPanel.drawPreviewBorder(g2, lO, tO, (int)p2.getWidth(), (int)p2.getHeight(), pageScale, h2);
    }

    private Paper getPaperForPreview(int pageWidth, int pageHeight) {
        Paper p2 = new Paper();
        if (this.paperSourceByPDF.isSelected()) {
            p2.setSize(pageWidth, pageHeight);
            p2.setImageableArea(0.0, 0.0, pageWidth, pageHeight);
        } else {
            MarginPaper mp = this.paperDefinitions.getSelectedPaper((String)this.pageSize.getSelectedItem());
            if (mp != null) {
                p2.setSize(mp.getWidth(), mp.getHeight());
                p2.setImageableArea(mp.getImageableX(), mp.getImageableY(), mp.getImageableWidth(), mp.getImageableHeight());
            } else {
                return null;
            }
        }
        if (this.autoRotateCenter.isSelected() && (pageWidth > pageHeight && p2.getImageableWidth() < p2.getImageableHeight() || pageWidth < pageHeight && p2.getImageableWidth() > p2.getImageableHeight())) {
            p2.setSize(p2.getHeight(), p2.getWidth());
            p2.setImageableArea(p2.getImageableY(), p2.getImageableX(), p2.getImageableHeight(), p2.getImageableWidth());
        }
        return p2;
    }

    private static void drawPreviewBorder(Graphics2D g2, int lO, int tO, int pW, int pH, double pageScale, int h2) {
        g2.setClip(null);
        g2.drawRect(lO, tO, pW, pH);
        NumberFormat f2 = NumberFormat.getNumberInstance();
        f2.setMaximumFractionDigits(0);
        g2.drawString(Messages.getMessage("PdfPrintPreview.UnitScale") + f2.format(pageScale * 100.0) + '%', 5, h2 - 5);
    }

    private void drawPreviewPage(Graphics2D g2, int lO, int tO, int pageWidth, int pageHeight, int iX, int iY, int iW, int iH) {
        try {
            BufferedImage img;
            if (this.printRangeCurrentView.isSelected()) {
                img = new BufferedImage((int)this.pdf.getVisibleRect().getWidth(), (int)this.pdf.getVisibleRect().getHeight(), 2);
                Graphics g3 = img.getGraphics();
                g3.translate((int)(-this.pdf.getVisibleRect().getX()), (int)(-this.pdf.getVisibleRect().getY()));
                Border bStore = ((JComponent)((Object)this.pdf)).getBorder();
                Color cStore = ((Component)((Object)this.pdf)).getBackground();
                ((JComponent)((Object)this.pdf)).setBorder(BorderFactory.createEmptyBorder());
                ((Component)((Object)this.pdf)).setBackground(Color.WHITE);
                ((PdfDecoder)this.pdf).paintComponent(g3);
                ((JComponent)((Object)this.pdf)).setBorder(bStore);
                ((Component)((Object)this.pdf)).setBackground(cStore);
            } else {
                img = this.pdf.getPageAsImage(this.currentPreviewedPage);
            }
            if (this.grayscale.isSelected()) {
                img = ColorSpaceConvertor.convertColorspace(img, 10);
            }
            g2.setClip(lO + iX, tO + iY, iW, iH);
            int centeringX = (int)((double)(iW - pageWidth) / 2.0);
            int centeringY = (int)((double)(iH - pageHeight) / 2.0);
            g2.drawImage(img, lO + iX + centeringX, tO + iY + centeringY, pageWidth, pageHeight, null);
        }
        catch (PdfException e2) {
            LogWriter.writeLog("Caught a PDFException " + e2);
        }
    }

    private static void drawPreviewArea(Graphics2D g2, int lO, int tO, int pW, int pH, int iX, int iY, int iW, int iH) {
        g2.setPaint(Color.WHITE);
        g2.fillRect(lO, tO, pW, pH);
        g2.setPaint(Color.RED);
        g2.drawLine(lO + iX, tO, lO + iX, tO + pH);
        g2.drawLine(lO, tO + iY, lO + pW, tO + iY);
        g2.drawLine(lO + iW + iX, tO, lO + iW + iX, tO + pH);
        g2.drawLine(lO, tO + iH + iY, lO + pW, tO + iH + iY);
    }

    private static void drawPreviewWidthBar(Graphics2D g2, int lO, int tO, int pW, double paperWidthInInches, Color col) {
        g2.setPaint(col);
        NumberFormat f2 = NumberFormat.getNumberInstance();
        f2.setMaximumFractionDigits(1);
        String widthString = f2.format(paperWidthInInches);
        int tLen = widthString.length() * 3;
        g2.drawString(widthString, lO + pW / 2 - tLen, tO - 5);
        g2.drawLine(lO, tO - 15, lO, tO - 5);
        g2.drawLine(lO + pW, tO - 15, lO + pW, tO - 5);
        g2.drawLine(lO, tO - 10, lO + pW / 2 - tLen - 6, tO - 10);
        g2.drawLine(lO + pW / 2 + tLen + 6, tO - 10, lO + pW, tO - 10);
        g2.drawLine(lO, tO - 10, lO + 5, tO - 15);
        g2.drawLine(lO, tO - 10, lO + 5, tO - 5);
        g2.drawLine(lO + pW, tO - 10, lO + pW - 5, tO - 15);
        g2.drawLine(lO + pW, tO - 10, lO + pW - 5, tO - 5);
    }

    private static void drawPreviewHeightBar(Graphics2D g2, int lO, int tO, int pH, double paperHeightInInches, Color col) {
        g2.setPaint(col);
        NumberFormat f2 = NumberFormat.getNumberInstance();
        f2.setMaximumFractionDigits(1);
        String heightString = f2.format(paperHeightInInches);
        int tLen = heightString.length() * 3;
        g2.drawString(heightString, lO - 12 - tLen, tO + pH / 2 + 5);
        g2.drawLine(lO - 15, tO, lO - 5, tO);
        g2.drawLine(lO - 15, tO + pH, lO - 5, tO + pH);
        g2.drawLine(lO - 10, tO, lO - 10, tO + pH / 2 - 8);
        g2.drawLine(lO - 10, tO + pH / 2 + 8, lO - 10, tO + pH);
        g2.drawLine(lO - 10, tO, lO - 5, tO + 5);
        g2.drawLine(lO - 10, tO, lO - 15, tO + 5);
        g2.drawLine(lO - 10, tO + pH, lO - 15, tO + pH - 5);
        g2.drawLine(lO - 10, tO + pH, lO - 5, tO + pH - 5);
    }

    private void nameElements() {
        this.okButton.setName("ok");
        this.cancelButton.setName("cancel");
        this.pageSize.setName("size");
        this.printerName.setName("printer");
        this.autoRotateCenter.setName("autoRot");
        this.paperSourceByPDF.setName("paperSource");
        this.printHandlingScaling.setName("scaling");
        this.tabbedPane.setName("tabPane");
        this.setName("printDialog");
    }

    private void updatePreview() {
        int pagePrintCount;
        int selection = this.previewSlider.getValue();
        SetOfIntegerSyntax set = this.getPrintRange();
        if (set == null) {
            this.currentPreviewedPage = 0;
            pagePrintCount = 0;
        } else {
            int[][] ranges = set.getMembers();
            int count = 0;
            for (int[] range1 : ranges) {
                count += range1[1] - (range1[0] - 1);
            }
            int[] pagesToPrint = new int[count];
            pagePrintCount = pagesToPrint.length;
            count = 0;
            for (int[] range : ranges) {
                int rangeLength = range[1] - (range[0] - 1);
                for (int j2 = 0; j2 < rangeLength; ++j2) {
                    pagesToPrint[count] = range[0] + j2;
                    ++count;
                }
            }
            if (selection > pagePrintCount) {
                selection = 1;
                this.previewSlider.resetValue();
            }
            this.currentPreviewedPage = this.printRangeReversePages.isSelected() ? pagesToPrint[pagesToPrint.length - selection] : pagesToPrint[selection - 1];
        }
        this.previewSlider.setMaxValue(pagePrintCount);
        this.previewComponent.repaint();
    }

    private void pagesBoxPressed() {
        this.printRangeFrom.setSelected(true);
        this.printRangeSubset.setEnabled(true);
        this.printRangeReversePages.setEnabled(true);
        this.updatePreview();
    }

    private void pagesFromStateChanged() {
        if (this.printRangeFrom.isSelected()) {
            this.printRangeSubset.setEnabled(true);
            this.printRangeReversePages.setEnabled(true);
            this.updatePreview();
        }
    }

    private void printRangeCurrentView() {
        if (this.printRangeCurrentView.isSelected()) {
            this.printRangeSubset.setEnabled(false);
            this.printRangeReversePages.setEnabled(false);
            this.updatePreview();
        }
    }

    private void currentPageStateChanged() {
        if (this.printRangeCurrentPage.isSelected()) {
            this.printRangeSubset.setEnabled(false);
            this.printRangeReversePages.setEnabled(false);
            this.updatePreview();
        }
    }

    private void allStateChanged() {
        if (this.printRangeAll.isSelected()) {
            this.printRangeSubset.setEnabled(true);
            this.printRangeReversePages.setEnabled(true);
            this.updatePreview();
        }
    }

    private void cancelEvent() {
        this.okClicked = false;
        this.getTopLevelAncestor().setVisible(false);
    }

    private void okEvent() {
        this.okClicked = true;
        this.getTopLevelAncestor().setVisible(false);
    }

    public SetOfIntegerSyntax getPrintRange() {
        SetOfIntegerSyntax pageRange = null;
        if (this.printRangeAll.isSelected()) {
            pageRange = new PageRanges(1, this.pageCount);
            if (this.printRangeSubset.getSelectedIndex() == 0) {
                return pageRange;
            }
            if (this.printRangeSubset.getSelectedIndex() == 1) {
                pageRange = PrintPanel.getPageRange1(pageRange, 1);
            } else if (this.printRangeSubset.getSelectedIndex() == 2) {
                pageRange = PrintPanel.getPageRange1(pageRange, 0);
            }
        } else if (this.printRangeCurrentPage.isSelected()) {
            pageRange = new PageRanges(this.currentPage);
        } else if (this.printRangeCurrentView.isSelected()) {
            pageRange = new PageRanges(this.currentPage);
        } else if (this.printRangeFrom.isSelected()) {
            int end;
            int start;
            try {
                start = Integer.parseInt(this.pagesFrom.getText());
            }
            catch (NumberFormatException e2) {
                LogWriter.writeLog("Exception in setting page range " + e2);
                this.pagesFrom.setText("1");
                start = 1;
            }
            try {
                end = Integer.parseInt(this.pagesTo.getText());
            }
            catch (NumberFormatException e3) {
                LogWriter.writeLog("Exception in setting page range " + e3);
                this.pagesTo.setText(String.valueOf(this.pageCount));
                end = this.pageCount;
            }
            start = PrintPanel.limitValueToFullPageRange(start, this.pageCount);
            end = PrintPanel.limitValueToFullPageRange(end, this.pageCount);
            this.pagesFrom.setText(String.valueOf(start));
            this.pagesTo.setText(String.valueOf(end));
            if (start > end) {
                int tmp = end;
                end = start;
                start = tmp;
                if (SwingGUI.showMessages) {
                    JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerPrint.SwapValues"));
                }
            }
            pageRange = new PageRanges(start, end);
            if (this.printRangeSubset.getSelectedIndex() == 0) {
                return pageRange;
            }
            if (this.printRangeSubset.getSelectedIndex() == 1) {
                StringBuilder membersStr = new StringBuilder();
                int i2 = -1;
                while ((i2 = pageRange.next(i2)) != -1) {
                    if (i2 % 2 != 1) continue;
                    membersStr.append(i2).append(',');
                }
                String members = membersStr.toString();
                StringBuilder sb = new StringBuilder(members);
                if (members.isEmpty()) {
                    return null;
                }
                sb.deleteCharAt(members.length() - 1);
                members = sb.toString();
                pageRange = new PageRanges(members);
            } else if (this.printRangeSubset.getSelectedIndex() == 2) {
                StringBuilder membersStr = new StringBuilder();
                int i3 = -1;
                while ((i3 = pageRange.next(i3)) != -1) {
                    if (i3 % 2 != 0) continue;
                    membersStr.append(i3).append(',');
                }
                String members = membersStr.toString();
                StringBuilder sb = new StringBuilder(members);
                int length = members.length();
                if (length > 0) {
                    sb.deleteCharAt(length - 1);
                }
                pageRange = !(members = sb.toString()).isEmpty() ? new PageRanges(members) : null;
            }
        }
        return pageRange;
    }

    private static SetOfIntegerSyntax getPageRange1(SetOfIntegerSyntax pageRange, int i2) {
        StringBuilder membersStr = new StringBuilder();
        int i3 = -1;
        while ((i3 = pageRange.next(i3)) != -1) {
            if (i3 % 2 != i2) continue;
            membersStr.append(i3).append(',');
        }
        String members = membersStr.toString();
        StringBuilder sb = new StringBuilder(members);
        sb.deleteCharAt(members.length() - 1);
        members = sb.toString();
        pageRange = new PageRanges(members);
        return pageRange;
    }

    private static int limitValueToFullPageRange(int value, int pageCount) {
        int returnValue = value < 1 ? 1 : Math.min(value, pageCount);
        return returnValue;
    }

    public int getCopies() {
        String copies = this.printHandlingCopies.getValue().toString();
        return Integer.parseInt(copies);
    }

    public int getPageScaling() {
        int option = this.printHandlingScaling.getSelectedIndex();
        int value = 0;
        switch (option) {
            case 0: {
                break;
            }
            case 1: {
                value = 1;
                break;
            }
            case 2: {
                value = 2;
            }
        }
        PrinterOptions.LAST_SCALING_CHOICE = value;
        return value;
    }

    public String getPrinter() {
        if (this.printerName == null) {
            return "";
        }
        if (this.printerName.getSelectedItem() == null) {
            return null;
        }
        return this.printerName.getSelectedItem().toString();
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    public boolean isAutoRotateAndCenter() {
        return this.autoRotateCenter.isSelected();
    }

    public boolean isPaperSourceByPDFSize() {
        return this.paperSourceByPDF.isSelected();
    }

    public boolean isPrintingCurrentView() {
        return this.printRangeCurrentView.isSelected();
    }

    private String[] getAvailablePaperSizes() {
        return this.paperDefinitions.getAvailablePaperSizes();
    }

    public MarginPaper getSelectedPaper() {
        return this.paperDefinitions.getSelectedPaper((String)this.pageSize.getSelectedItem());
    }

    public int getSelectedPrinterOrientation() {
        return this.paperDefinitions.getDefaultPageOrientation();
    }

    public boolean isPagesReversed() {
        return this.printRangeReversePages.isSelected();
    }

    public boolean isOddPagesOnly() {
        return this.printRangeSubset.getSelectedIndex() == 1;
    }

    public boolean isEvenPagesOnly() {
        return this.printRangeSubset.getSelectedIndex() == 2;
    }

    public boolean isMonochrome() {
        return this.grayscale.isSelected();
    }

    private static class CustomSpinnerModel
    extends SpinnerNumberModel {
        private double value;
        private final ArrayList<ChangeListener> listeners = new ArrayList();
        private double minValue;

        private CustomSpinnerModel() {
        }

        @Override
        public Object getPreviousValue() {
            if (this.value <= this.minValue) {
                return null;
            }
            if (this.value - 0.5 < this.minValue) {
                return this.minValue;
            }
            return this.value - 0.5;
        }

        @Override
        public Object getNextValue() {
            return this.value + 0.5;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void addChangeListener(ChangeListener l2) {
            this.listeners.add(l2);
        }

        @Override
        public void removeChangeListener(ChangeListener l2) {
            this.listeners.remove(l2);
        }

        @Override
        public void setValue(Object value) {
            try {
                double newValue = (Double)value;
                this.value = Math.max(newValue, this.minValue);
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception in setting print value " + e2);
                throw new IllegalArgumentException();
            }
            ChangeEvent e3 = new ChangeEvent(this);
            for (ChangeListener listener : this.listeners) {
                if (listener == null) continue;
                listener.stateChanged(e3);
            }
        }

        void setMinValue(double minValue) {
            this.minValue = minValue;
            this.setValue(this.getValue());
        }
    }

    private class CustomSlider
    extends JPanel {
        private int value = 1;
        private int maxValue = 100;
        private static final int rightMargin = 9;
        private static final int leftMargin = 9;
        private boolean dragging;

        CustomSlider() {
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e2) {
                    if (CustomSlider.this.dragging) {
                        CustomSlider.this.value = (int)((double)(e2.getX() - 9) / (double)(CustomSlider.this.getWidth() - 18) * (double)(CustomSlider.this.maxValue - 1) + 1.5);
                        if (CustomSlider.this.value > CustomSlider.this.maxValue) {
                            CustomSlider.this.value = CustomSlider.this.maxValue;
                        }
                        if (CustomSlider.this.value < 1) {
                            CustomSlider.this.value = 1;
                        }
                        PrintPanel.this.updatePreview();
                        CustomSlider.this.repaint();
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    if (e2.getY() < 20) {
                        double newValue = (double)(e2.getX() - 9) / (double)(CustomSlider.this.getWidth() - 18) * (double)(CustomSlider.this.maxValue - 1) + 1.0;
                        if (newValue > (double)CustomSlider.this.value) {
                            CustomSlider.this.value++;
                        } else if (newValue < (double)CustomSlider.this.value) {
                            CustomSlider.this.value--;
                        }
                        if (CustomSlider.this.value > CustomSlider.this.maxValue) {
                            CustomSlider.this.value = CustomSlider.this.maxValue;
                        }
                        if (CustomSlider.this.value < 1) {
                            CustomSlider.this.value = 1;
                        }
                        PrintPanel.this.updatePreview();
                        CustomSlider.this.repaint();
                    }
                }

                @Override
                public void mousePressed(MouseEvent e2) {
                    if (e2.getY() < 20) {
                        CustomSlider.this.dragging = true;
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e2) {
                    CustomSlider.this.dragging = false;
                }
            });
        }

        @Override
        public void paint(Graphics g2) {
            Graphics2D g22 = (Graphics2D)g2;
            g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int w2 = this.getWidth();
            int h2 = this.getHeight();
            g22.setPaint(this.getBackground());
            g22.fillRect(0, 0, w2, h2);
            g22.setPaint(this.getForeground());
            g22.drawString(Messages.getMessage("PdfPrintPreview.Sheet") + this.value + ' ' + Messages.getMessage("PdfPrintPreview.SheetOf") + this.maxValue, 2, h2 - 3);
            g22.setPaint(Color.LIGHT_GRAY);
            g22.fillRect(10, 11, w2 - 19, 3);
            g22.setPaint(Color.GRAY);
            g22.drawLine(9, 12, w2 - 9, 12);
            float pageX = 9.0f + (float)(this.value - 1) / (float)(this.maxValue - 1) * (float)(w2 - 18);
            Ellipse2D.Float number = new Ellipse2D.Float(pageX - 6.0f, 6.5f, 12.0f, 12.0f);
            Ellipse2D.Float number2 = new Ellipse2D.Float(pageX - 4.0f, 8.5f, 8.0f, 8.0f);
            g22.setPaint(Color.BLACK);
            g22.fill(number);
            g22.setPaint(Color.WHITE);
            g22.fill(number2);
        }

        void resetValue() {
            this.value = 1;
            this.repaint();
        }

        void setMaxValue(int maxValue) {
            if (maxValue != this.maxValue) {
                this.value = 1;
                this.maxValue = maxValue;
                PrintPanel.this.updatePreview();
                return;
            }
            this.repaint();
        }

        int getValue() {
            return this.value;
        }
    }
}

