/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.ViewerCommands;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.popups.DisplayXObject;
import org.jpedal.examples.viewer.gui.popups.StreamViewer;
import org.jpedal.examples.viewer.utils.ObjectHighlighter;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class ObjectsViewer
extends JFrame {
    private final Pattern objectReference;
    private final Pattern objectTypeKey;
    private final Pattern objectType;
    private final ObjectHighlighter objectHighlighter;
    private final PdfObjectReader pdfObjectReader;
    private final SwingGUI currentGUI;
    private final Values commonValues;
    private String currentRef = "";
    private boolean showRawStreams;
    private final JTextPane textPane;
    private final JScrollPane textAreaScrollPane;
    private final TransferHandler handler = new TransferHandler(){

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            if ((1 & support.getSourceDropActions()) != 1) {
                return false;
            }
            support.setDropAction(1);
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            Transferable t2 = support.getTransferable();
            try {
                String file = ((File)((List)t2.getTransferData(DataFlavor.javaFileListFlavor)).get(0)).getAbsolutePath();
                ObjectsViewer.this.dispose();
                ObjectsViewer.this.currentGUI.getCommand().executeCommand(ViewerCommands.OPENFILE, new Object[]{file});
                new ObjectsViewer(ObjectsViewer.this.currentGUI, ObjectsViewer.this.commonValues, ObjectsViewer.this.pdfObjectReader).init();
            }
            catch (UnsupportedFlavorException | IOException e2) {
                return false;
            }
            catch (Exception e3) {
                LogWriter.writeLog(e3);
                return true;
            }
            return true;
        }
    };

    public ObjectsViewer(SwingGUI currentGUI, Values commonValues, PdfObjectReader pdfObjectReader) {
        super(Messages.getMessage("PdfViewer.ObjectsWindowTitle"));
        this.currentGUI = currentGUI;
        this.commonValues = commonValues;
        this.pdfObjectReader = pdfObjectReader;
        this.objectReference = Pattern.compile("(?<!%.{0,1000}?)\\d+ \\d+ R");
        this.objectTypeKey = Pattern.compile("/Type\\s*?(/[^\\s\\[\\]/<>\\r\\n()]+)");
        this.objectType = Pattern.compile("^\\d+ \\d+ obj.*?(<<|\\[|\\(|<|true|false|[-+]?(?:\\d*[.])?\\d+|/[^\\s\\[\\]/<>\\r\\n()]+).*?(endobj|stream)$", 32);
        this.objectHighlighter = new ObjectHighlighter(pdfObjectReader.getObjectReader());
        this.textPane = new JTextPane();
        this.textAreaScrollPane = new JScrollPane(this.textPane, 22, 30);
    }

    public void init() throws Exception {
        CharBuffer charBuffer;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.textPane.setFont(new Font("Monospaced", 0, 12));
        this.textPane.setEditable(false);
        this.textAreaScrollPane.setPreferredSize(new Dimension(600, 550));
        JPanel bottomButtons = new JPanel();
        bottomButtons.setLayout(new BorderLayout());
        try (FileInputStream fileInputStream = new FileInputStream(this.commonValues.getSelectedFile());
             FileChannel fileChannel = fileInputStream.getChannel();){
            MappedByteBuffer byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fileChannel.size());
            charBuffer = StandardCharsets.ISO_8859_1.newDecoder().decode(byteBuffer);
        }
        JRadioButton hexButton = new JRadioButton("Hex", true);
        JRadioButton rawButton = new JRadioButton("Raw");
        ActionListener radioButtonActionListener = e2 -> {
            this.showRawStreams = rawButton.isSelected();
            this.setObjectText(this.textPane, charBuffer, this.currentRef);
        };
        hexButton.addActionListener(radioButtonActionListener);
        rawButton.addActionListener(radioButtonActionListener);
        ButtonGroup radioGroup = new ButtonGroup();
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new GridBagLayout());
        radioGroup.add(hexButton);
        radioGroup.add(rawButton);
        radioPanel.add(hexButton);
        radioPanel.add(rawButton);
        bottomButtons.add((Component)radioPanel, "Before");
        JPanel rightSideButtons = new JPanel(new BorderLayout());
        JButton streamButton = new JButton("Decode Stream");
        streamButton.addActionListener(e2 -> StreamViewer.display(this.pdfObjectReader, this, this.currentRef));
        rightSideButtons.add((Component)streamButton, "Before");
        JButton imageButton = new JButton("Show Image");
        imageButton.addActionListener(e2 -> DisplayXObject.display(this.pdfObjectReader, this, this.currentRef));
        rightSideButtons.add((Component)imageButton, "After");
        bottomButtons.add((Component)rightSideButtons, "After");
        JPanel buttonsPanel = new JPanel(new GridLayout(0, 1));
        JScrollPane buttonsPanelScrollPane = new JScrollPane(buttonsPanel);
        buttonsPanelScrollPane.getVerticalScrollBar().setUnitIncrement(6);
        buttonsPanelScrollPane.getHorizontalScrollBar().setUnitIncrement(2);
        buttonsPanelScrollPane.setPreferredSize(new Dimension(400, 550));
        Matcher objectMatcher = Pattern.compile("^(\\d+ \\d+)\\s+obj[\\s\\S]*?(?<!%.{0,1000}?)(?:endobj|stream)\\s*?$", 8).matcher(charBuffer);
        HashMap<String, String> objects = new HashMap<String, String>();
        while (objectMatcher.find()) {
            objects.put(objectMatcher.group(1) + " R", objectMatcher.group(0));
        }
        this.setTransferHandler(this.handler);
        this.textPane.setTransferHandler(this.handler);
        Matcher rootMatcher = Pattern.compile("trailer\\s*?<<.*?/Root\\s*?(\\d+ \\d+ R)", 32).matcher(charBuffer);
        Matcher infoMatcher = Pattern.compile("trailer\\s*?<<.*?/Info\\s*?(\\d+ \\d+ R)", 32).matcher(charBuffer);
        Tree<ObjectInfo> objectTree = new Tree<ObjectInfo>(new ObjectInfo(Paths.get(this.commonValues.getSelectedFile(), new String[0]).getFileName().toString()));
        try {
            if (!rootMatcher.find()) {
                LogWriter.writeLog("Cannot find root object");
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.RootNotFound"));
                return;
            }
            Tree<ObjectInfo> rootObjectTree = this.buildTree(objects, new ObjectInfo(rootMatcher.group(1), "/Root"));
            objectTree.add(rootObjectTree);
            if (infoMatcher.find()) {
                Tree<ObjectInfo> infoObjectTree = this.buildTree(objects, new ObjectInfo(infoMatcher.group(1), "/Info"));
                objectTree.add(infoObjectTree);
            } else {
                LogWriter.writeLog("Cannot find info object");
            }
        }
        catch (IllegalStateException e3) {
            LogWriter.writeLog("Cannot find trailer");
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.TrailerNotFound"));
            return;
        }
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(objectTree);
        final ExpandableTreeModel model = new ExpandableTreeModel(rootNode);
        ObjectsViewer.insertNextLayer(rootNode, model);
        JTree objectJTree = new JTree(model);
        objectJTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                ObjectsViewer.insertNextLayer((DefaultMutableTreeNode)path.getLastPathComponent(), model);
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                ObjectsViewer.removeChildren((DefaultMutableTreeNode)path.getLastPathComponent(), model);
            }
        });
        objectJTree.addTreeSelectionListener(e2 -> {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)objectJTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            this.setObjectText(this.textPane, charBuffer, ((ObjectInfo)((Tree)node.getUserObject()).t).ref);
            this.textAreaScrollPane.getViewport().setViewPosition(new Point(0, 0));
            this.textPane.setCaretPosition(0);
        });
        buttonsPanel.add(objectJTree);
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.add((Component)buttonsPanelScrollPane, gridBagConstraints);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints contentGridBagConstraints = new GridBagConstraints();
        contentGridBagConstraints.fill = 1;
        contentGridBagConstraints.gridx = 0;
        contentGridBagConstraints.gridy = 0;
        contentPane.add((Component)this.textAreaScrollPane, contentGridBagConstraints);
        contentGridBagConstraints.fill = 2;
        contentGridBagConstraints.gridx = 0;
        contentGridBagConstraints.gridy = 1;
        contentPane.add((Component)bottomButtons, contentGridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridx = 1;
        this.add((Component)contentPane, gridBagConstraints);
        this.pack();
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(this.currentGUI.getFrame());
        this.setVisible(true);
    }

    private Tree<ObjectInfo> buildTree(HashMap<String, String> objects, ObjectInfo root) {
        Tree<ObjectInfo> tree = new Tree<ObjectInfo>(root);
        HashMap<String, Tree<ObjectInfo>> nodeStore = new HashMap<String, Tree<ObjectInfo>>();
        Tree<ObjectInfo> builtTree = this.buildTreeAux(objects, root, tree, nodeStore);
        for (String ref : nodeStore.keySet()) {
            String object = objects.get(ref);
            Matcher typeMatcher = this.objectType.matcher(object);
            Matcher keyMatcher = this.objectTypeKey.matcher(object);
            if (keyMatcher.find()) {
                ((ObjectInfo)((Tree)nodeStore.get(ref)).t).keyType = keyMatcher.group(1);
            }
            if (!typeMatcher.find()) continue;
            String type = typeMatcher.group(1);
            if (type == null) {
                ((ObjectInfo)((Tree)nodeStore.get(ref)).t).type = "";
                continue;
            }
            if ("<<".equals(type)) {
                String stream = typeMatcher.group(2);
                if (stream == null) {
                    ((ObjectInfo)((Tree)nodeStore.get(ref)).t).type = "";
                    continue;
                }
                if ("stream".equals(stream)) {
                    ((ObjectInfo)((Tree)nodeStore.get(ref)).t).type = "Stream";
                    continue;
                }
                ((ObjectInfo)((Tree)nodeStore.get(ref)).t).type = "Dictionary";
                continue;
            }
            if ("[".equals(type)) {
                ((ObjectInfo)((Tree)nodeStore.get(ref)).t).type = "Array";
                continue;
            }
            if ("(".equals(type)) {
                ((ObjectInfo)((Tree)nodeStore.get(ref)).t).type = "String";
                continue;
            }
            if ("<".equals(type)) {
                ((ObjectInfo)((Tree)nodeStore.get(ref)).t).type = "Hex String";
                continue;
            }
            if ("true".equals(type) || "false".equals(type)) {
                ((ObjectInfo)((Tree)nodeStore.get(ref)).t).type = "Boolean";
                continue;
            }
            if (type.matches("[-+]?(?:\\d*[.])?\\d+")) {
                ((ObjectInfo)((Tree)nodeStore.get(ref)).t).type = "Number";
                continue;
            }
            if (type.matches("/[^\\s\\[\\]/<>\\r\\n()]+")) {
                ((ObjectInfo)((Tree)nodeStore.get(ref)).t).type = "Name";
                continue;
            }
            ((ObjectInfo)((Tree)nodeStore.get(ref)).t).type = "";
        }
        return builtTree;
    }

    private Tree<ObjectInfo> buildTreeAux(HashMap<String, String> objects, ObjectInfo root, Tree<ObjectInfo> tree, HashMap<String, Tree<ObjectInfo>> nodeStore) {
        if (nodeStore.containsKey(root.ref)) {
            return tree;
        }
        nodeStore.put(root.ref, tree);
        Matcher matcher = this.objectReference.matcher(objects.get(root.ref));
        while (matcher.find()) {
            ObjectInfo object;
            this.buildTreeAux(objects, object, nodeStore.containsKey((object = new ObjectInfo(matcher.group())).ref) ? tree.add(nodeStore.get(object.ref)) : tree.add(object), nodeStore);
        }
        return tree;
    }

    private void setObjectText(JTextPane textPane, CharSequence charSequence, String reference) {
        reference = reference.substring(0, reference.length() - 1);
        Matcher objectCapture = Pattern.compile('^' + reference + "obj.*?endobj$", 40).matcher(charSequence);
        if (!objectCapture.find()) {
            textPane.setText("Cannot parse object");
            return;
        }
        this.objectHighlighter.highlight(this.showRawStreams ? ObjectHighlighter.getBytesAsString(objectCapture.group().getBytes(StandardCharsets.ISO_8859_1)) : this.objectHighlighter.hexifyStream(objectCapture.group().getBytes(StandardCharsets.ISO_8859_1)), textPane);
        this.currentRef = reference + 'R';
    }

    private static void insertNextLayer(DefaultMutableTreeNode parentNode, DefaultTreeModel model) {
        Tree parent = (Tree)parentNode.getUserObject();
        for (int i2 = 0; i2 < parent.children.size(); ++i2) {
            model.insertNodeInto(new DefaultMutableTreeNode(parent.children.get(i2)), parentNode, i2);
        }
    }

    private static void removeChildren(DefaultMutableTreeNode parentNode, DefaultTreeModel model) {
        while (parentNode.getChildCount() > 0) {
            model.removeNodeFromParent((MutableTreeNode)parentNode.getChildAt(0));
        }
    }

    public static class ExpandableTreeModel
    extends DefaultTreeModel {
        public ExpandableTreeModel(TreeNode root) {
            super(root);
        }

        @Override
        public boolean isLeaf(Object node) {
            return ((Tree)((DefaultMutableTreeNode)node).getUserObject()).children.isEmpty();
        }
    }

    private static class ObjectInfo {
        private final String ref;
        private String keyType;
        private String type;

        public ObjectInfo(String ref, String keyType) {
            this.ref = ref;
            this.keyType = keyType;
            this.type = "";
        }

        private ObjectInfo(String ref) {
            this.ref = ref;
            this.keyType = "";
            this.type = "";
        }

        public String toString() {
            return this.keyType + ' ' + this.ref + ' ' + this.type;
        }
    }

    private static class Tree<T> {
        private final T t;
        private final ArrayList<Tree<T>> children;

        public Tree(T t2) {
            this.t = t2;
            this.children = new ArrayList();
        }

        public Tree<T> add(T t2) {
            Tree<T> child = new Tree<T>(t2);
            this.children.add(child);
            return child;
        }

        public Tree<T> add(Tree<T> tree) {
            this.children.add(tree);
            return tree;
        }

        public String toString() {
            return this.t.toString();
        }
    }
}

