/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jpedal.utils.Messages;

public final class ErrorDialog {
    private ErrorDialog() {
    }

    public static void showError(Throwable th, String message, Component parent, String fileName) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.anchor = 17;
        c2.gridx = 0;
        c2.gridy = 0;
        panel.add((Component)new JLabel(message), c2);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        String trace = sw.toString();
        JTextArea ta = new JTextArea(trace);
        ta.setEditable(false);
        ta.setRows(10);
        ta.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(ta, 20, 31);
        scrollPane.setVisible(false);
        c2.gridy = 1;
        c2.ipady = 10;
        JLabel info = new JLabel(Messages.getMessage("PdfViewerError.CopyStacktrace"));
        info.setVisible(false);
        panel.add((Component)info, c2);
        c2.ipady = 0;
        c2.gridy = 2;
        panel.add((Component)scrollPane, c2);
        JButton okButton = new JButton(Messages.getMessage("PdfViewerButton.ShowDetails"));
        okButton.addActionListener(arg0 -> {
            JButton button = (JButton)arg0.getSource();
            if (scrollPane.isVisible()) {
                scrollPane.setVisible(false);
                info.setVisible(false);
                button.setText(Messages.getMessage("PdfViewerButton.ShowDetails"));
            } else {
                scrollPane.setVisible(true);
                info.setVisible(true);
                button.setText(Messages.getMessage("PdfViewerButton.HideDetails"));
            }
            JDialog parentDialog = (JDialog)button.getTopLevelAncestor();
            parentDialog.pack();
            parentDialog.setLocationRelativeTo(parent);
        });
        Object[] buttonRowObjects = new Object[]{okButton, Messages.getMessage("PdfViewerButton.Exit")};
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(panel);
        optionPane.setMessageType(0);
        optionPane.setOptionType(-1);
        optionPane.setOptions(buttonRowObjects);
        JDialog dialog = optionPane.createDialog(parent, fileName);
        dialog.pack();
        dialog.setVisible(true);
    }
}

