/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jpedal.io.IdrOutputStream;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.security.CryptoIDR;
import org.jpedal.utils.LogWriter;

public class DownloadProgress {
    private File tempURLFile;
    private boolean isDownloading = true;
    private int progress;
    private final String pdfUrl;

    public DownloadProgress(String pdfUrl) {
        this.pdfUrl = pdfUrl;
    }

    public void startDownload(String encPassword) {
        this.progress = 0;
        if (this.pdfUrl.startsWith("jar:/")) {
            this.downloadFromJar(encPassword);
        } else {
            this.downloadFromURL(encPassword);
        }
        this.progress = 100;
        this.isDownloading = false;
    }

    private void downloadFromURL(String encPassword) {
        URL url = null;
        try {
            url = this.pdfUrl.startsWith("file:/") && this.pdfUrl.charAt(7) != '/' ? new URL(this.pdfUrl.replaceFirst("file:/*?", "file:///")) : new URL(this.pdfUrl);
        }
        catch (IOException e2) {
            LogWriter.writeLog("[PDF] Exception " + e2 + " opening URL " + this.pdfUrl);
            LogWriter.writeLog(e2);
        }
        if (url != null) {
            try (InputStream is = url.openStream();){
                String str = url.getPath().substring(url.getPath().lastIndexOf(47) + 1);
                int fileLength = url.openConnection().getContentLength();
                int fileLengthPercent = fileLength / 100;
                this.tempURLFile = ObjectStore.createTempFile(str);
                this.saveEncrypted(is, fileLengthPercent, encPassword.getBytes());
            }
            catch (IOException e3) {
                LogWriter.writeLog("[PDF] Exception " + e3 + " opening URL " + this.pdfUrl);
                LogWriter.writeLog(e3);
            }
        }
    }

    private void downloadFromJar(String encPassword) {
        try (InputStream is = this.getClass().getResourceAsStream(this.pdfUrl.substring(4));){
            this.tempURLFile = ObjectStore.createTempFile("file.pdf");
            this.saveEncrypted(is, 0, encPassword.getBytes());
        }
        catch (IOException e2) {
            LogWriter.writeLog("[PDF] Exception " + e2 + " opening URL " + this.pdfUrl);
            LogWriter.writeLog(e2);
        }
    }

    private void saveEncrypted(InputStream is, int fileLengthPercent, byte[] encPassword) throws IOException {
        CryptoIDR crypto = new CryptoIDR(encPassword);
        try (IdrOutputStream outputStream = new IdrOutputStream(new FileOutputStream(this.tempURLFile), crypto);){
            int read;
            byte[] buffer = new byte[4096];
            int current = 0;
            while ((read = is.read(buffer)) != -1) {
                this.progress = (current += read) / fileLengthPercent;
                outputStream.write(buffer, 0, read);
            }
            outputStream.flush();
            is.close();
        }
    }

    public File getFile() {
        return this.tempURLFile;
    }

    public boolean isDownloading() {
        return this.isDownloading;
    }

    public int getProgress() {
        return this.progress;
    }
}

