/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.Component;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.XObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.image.DO;
import org.jpedal.utils.LogWriter;

public final class DisplayXObject {
    private DisplayXObject() {
    }

    public static void display(PdfObjectReader pdfObjectReader, Component relativeTo, String reference) {
        BufferedImage bufferedImage = DisplayXObject.getImage(pdfObjectReader, reference);
        if (bufferedImage == null) {
            return;
        }
        JDialog dialog = new JDialog((Frame)null, reference, false);
        dialog.add(new JLabel(new ImageIcon(bufferedImage)));
        dialog.setLocationRelativeTo(relativeTo);
        dialog.setResizable(true);
        dialog.pack();
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
    }

    private static BufferedImage getImage(PdfObjectReader pdfObjectReader, String reference) {
        try {
            XObject xObject = new XObject(reference);
            pdfObjectReader.readObject(xObject);
            DO aDo = new DO(1, pdfObjectReader, null, null, new PdfImageData(), new PdfPageData(), null);
            aDo.setParams(new ParserOptions());
            aDo.setRes(new PdfObjectCache());
            return aDo.processImageXObject(xObject, null, pdfObjectReader.readStream(xObject, false, true, false, false, false, xObject.getCacheName(pdfObjectReader.getObjectReader())), null);
        }
        catch (Exception e2) {
            LogWriter.writeLog(e2);
            return null;
        }
    }
}

