/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.print.attribute.standard.PageRanges;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.popups.Save;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class DeletePDFPages
extends Save {
    private static final long serialVersionUID = 7720446319401470639L;
    private final ButtonGroup buttonGroup1 = new ButtonGroup();
    private final JToggleButton jToggleButton3 = new JToggleButton();
    private final JToggleButton jToggleButton2 = new JToggleButton();
    private final JRadioButton printAll = new JRadioButton();
    private final JRadioButton printCurrent = new JRadioButton();
    private final JRadioButton printPages = new JRadioButton();
    private final JTextField pagesBox = new JTextField();

    public DeletePDFPages(String root_dir, int end_page, int currentPage) {
        super(root_dir, end_page, currentPage);
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            LogWriter.writeLog(e2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int[] getDeletedPages() {
        int[] pagesToExport = null;
        if (this.printAll.isSelected()) {
            pagesToExport = new int[this.end_page];
            for (int i2 = 0; i2 < this.end_page; ++i2) {
                pagesToExport[i2] = i2 + 1;
            }
            return pagesToExport;
        } else if (this.printCurrent.isSelected()) {
            pagesToExport = new int[]{this.currentPage};
            return pagesToExport;
        } else {
            if (!this.printPages.isSelected()) return pagesToExport;
            try {
                PageRanges pages = new PageRanges(this.pagesBox.getText());
                int count = 0;
                int i3 = -1;
                while ((i3 = pages.next(i3)) != -1) {
                    ++count;
                }
                pagesToExport = new int[count];
                count = 0;
                i3 = -1;
                while ((i3 = pages.next(i3)) != -1) {
                    if (i3 > this.end_page) {
                        if (!SwingGUI.showMessages) return null;
                        JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerText.Page") + ' ' + i3 + ' ' + Messages.getMessage("PdfViewerError.OutOfBounds") + ' ' + Messages.getMessage("PdfViewerText.PageCount") + ' ' + this.end_page);
                        return null;
                    }
                    pagesToExport[count] = i3;
                    ++count;
                }
                return pagesToExport;
            }
            catch (IllegalArgumentException e2) {
                LogWriter.writeLog("Exception " + e2 + " in exporting pdfs");
                if (!SwingGUI.showMessages) return pagesToExport;
                JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerError.InvalidSyntax"));
            }
        }
        return pagesToExport;
    }

    private void jbInit() {
        this.pageRangeLabel.setText(Messages.getMessage("PdfViewerPageRange.text"));
        this.pageRangeLabel.setBounds(new Rectangle(13, 13, 199, 26));
        this.printCurrent.setText(Messages.getMessage("PdfViewerRadioButton.CurrentPage"));
        this.printCurrent.setBounds(new Rectangle(23, 62, 100, 22));
        this.printCurrent.setSelected(true);
        this.printPages.setText(Messages.getMessage("PdfViewerRadioButton.Pages"));
        this.printPages.setBounds(new Rectangle(23, 84, 70, 22));
        this.pagesBox.setBounds(new Rectangle(95, 84, 200, 22));
        this.pagesBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                DeletePDFPages.this.jToggleButton2.setSelected(true);
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (DeletePDFPages.this.pagesBox.getText().isEmpty()) {
                    DeletePDFPages.this.printCurrent.setSelected(true);
                } else {
                    DeletePDFPages.this.printPages.setSelected(true);
                }
            }
        });
        JTextArea pagesInfo = new JTextArea(Messages.getMessage("PdfViewerMessage.PageNumberOrRange") + '\n' + Messages.getMessage("PdfViewerMessage.PageRangeExample"));
        pagesInfo.setBounds(new Rectangle(15, 115, 400, 40));
        pagesInfo.setOpaque(false);
        this.optionsForFilesLabel.setBounds(new Rectangle(13, 168, 199, 26));
        this.add((Component)this.printAll, null);
        this.add((Component)this.printCurrent, null);
        this.add((Component)this.printPages, null);
        this.add((Component)this.pagesBox, null);
        this.add((Component)pagesInfo, null);
        this.add((Component)this.changeButton, null);
        this.add((Component)this.pageRangeLabel, null);
        this.add((Component)this.jToggleButton2, null);
        this.add((Component)this.jToggleButton3, null);
        this.buttonGroup1.add(this.printAll);
        this.buttonGroup1.add(this.printCurrent);
        this.buttonGroup1.add(this.printPages);
    }

    @Override
    public final Dimension getPreferredSize() {
        return new Dimension(370, 180);
    }
}

