/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import org.jpedal.parser.DecoderOptions;

class ButtonBarPanel
extends JPanel {
    private Component currentComponent;

    ButtonBarPanel(JPanel toolbar) {
        this.setLayout(new BorderLayout());
        JScrollPane jsp = new JScrollPane();
        jsp.getViewport().add(toolbar);
        jsp.setHorizontalScrollBarPolicy(31);
        jsp.setVerticalScrollBarPolicy(22);
        this.add((Component)jsp, "West");
    }

    void addButton(String title, URL iconUrl, final Component component, JPanel bar, ButtonGroup group) {
        AbstractAction action = new AbstractAction(title, new ImageIcon(iconUrl)){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ButtonBarPanel.this.show(component);
            }
        };
        JToggleButton button = new JToggleButton(action);
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setContentAreaFilled(false);
        if (DecoderOptions.isRunningOnMac) {
            button.setHorizontalAlignment(2);
        }
        button.setAlignmentX(0.5f);
        bar.add(button);
        group.add(button);
        if (group.getSelection() == null) {
            button.setSelected(true);
            this.show(component);
        }
    }

    private void show(Component component) {
        if (this.currentComponent != null) {
            this.remove(this.currentComponent);
        }
        this.currentComponent = component;
        this.add("Center", this.currentComponent);
        this.revalidate();
        this.repaint();
    }
}

