/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

class VTextIcon
implements Icon,
PropertyChangeListener {
    private final String fLabel;
    private String[] fCharStrings;
    private int[] fCharWidths;
    private int[] fPosition;
    private int fWidth;
    private int fHeight;
    private int fCharHeight;
    private int fDescent;
    private final int fRotation;
    private final Component fComponent;
    private static final int POSITION_NORMAL = 0;
    private static final int POSITION_TOP_RIGHT = 1;
    private static final int POSITION_FAR_TOP_RIGHT = 2;
    private static final int ROTATE_NONE = 1;
    private static final int ROTATE_LEFT = 2;
    private static final int ROTATE_RIGHT = 4;
    private static final String sDrawsInTopRight = "\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u308e\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7\u30ee\u30f5\u30f6";
    private static final String sDrawsInFarTopRight = "\u3001\u3002";
    private static final int DEFAULT_CJK = 1;
    private static final int LEGAL_ROMAN = 7;
    private static final int DEFAULT_ROMAN = 4;
    private static final int LEGAL_MUST_ROTATE = 6;
    private static final int DEFAULT_MUST_ROTATE = 2;
    private static final double NINETY_DEGREES = Math.toRadians(90.0);
    private static final int kBufferSpace = 5;

    VTextIcon(Component component, String label) {
        this.fComponent = component;
        this.fLabel = label;
        this.fRotation = VTextIcon.verifyRotation(label);
        this.calcDimensions();
        this.fComponent.addPropertyChangeListener(this);
    }

    public String toString() {
        return this.fLabel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e2) {
        String prop = e2.getPropertyName();
        if ("font".equals(prop)) {
            this.recalcDimensions();
        }
    }

    private void recalcDimensions() {
        int wOld = this.fWidth;
        int hOld = this.fHeight;
        this.calcDimensions();
        if (wOld != this.fWidth || hOld != this.fHeight) {
            this.fComponent.invalidate();
        }
    }

    private void calcDimensions() {
        FontMetrics fm = this.fComponent.getFontMetrics(this.fComponent.getFont());
        this.fCharHeight = fm.getAscent() + fm.getDescent();
        this.fDescent = fm.getDescent();
        if (this.fRotation == 1) {
            int len = this.fLabel.length();
            char[] data = new char[len];
            this.fLabel.getChars(0, len, data, 0);
            this.fWidth = 0;
            this.fCharStrings = new String[len];
            this.fCharWidths = new int[len];
            this.fPosition = new int[len];
            for (int i2 = 0; i2 < len; ++i2) {
                char ch = data[i2];
                this.fCharWidths[i2] = fm.charWidth(ch);
                if (this.fCharWidths[i2] > this.fWidth) {
                    this.fWidth = this.fCharWidths[i2];
                }
                this.fCharStrings[i2] = new String(data, i2, 1);
                this.fPosition[i2] = sDrawsInTopRight.indexOf(ch) >= 0 ? 1 : (sDrawsInFarTopRight.indexOf(ch) >= 0 ? 2 : 0);
            }
            this.fHeight = this.fCharHeight * len + this.fDescent;
        } else {
            this.fWidth = this.fCharHeight;
            this.fHeight = fm.stringWidth(this.fLabel) + 10;
        }
    }

    @Override
    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        g2.setColor(c2.getForeground());
        g2.setFont(c2.getFont());
        switch (this.fRotation) {
            case 1: {
                int yPos = y2 + this.fCharHeight;
                for (int i2 = 0; i2 < this.fCharStrings.length; ++i2) {
                    switch (this.fPosition[i2]) {
                        case 0: {
                            g2.drawString(this.fCharStrings[i2], x2 + (this.fWidth - this.fCharWidths[i2]) / 2, yPos);
                            break;
                        }
                        case 1: {
                            int tweak = this.fCharHeight / 3;
                            g2.drawString(this.fCharStrings[i2], x2 + tweak / 2, yPos - tweak);
                            break;
                        }
                        case 2: {
                            int tweak = this.fCharHeight - this.fCharHeight / 3;
                            g2.drawString(this.fCharStrings[i2], x2 + tweak / 2, yPos - tweak);
                        }
                    }
                    yPos += this.fCharHeight;
                }
                break;
            }
            case 2: {
                g2.translate(x2 + this.fWidth, y2 + this.fHeight);
                ((Graphics2D)g2).rotate(-NINETY_DEGREES);
                g2.drawString(this.fLabel, 5, -this.fDescent);
                ((Graphics2D)g2).rotate(NINETY_DEGREES);
                g2.translate(-(x2 + this.fWidth), -(y2 + this.fHeight));
                break;
            }
            case 4: {
                g2.translate(x2, y2);
                ((Graphics2D)g2).rotate(NINETY_DEGREES);
                g2.drawString(this.fLabel, 5, -this.fDescent);
                ((Graphics2D)g2).rotate(-NINETY_DEGREES);
                g2.translate(-x2, -y2);
                break;
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.fWidth;
    }

    @Override
    public int getIconHeight() {
        return this.fHeight;
    }

    private static int verifyRotation(String label) {
        int legal;
        boolean hasCJK = false;
        boolean hasMustRotate = false;
        int len = label.length();
        char[] data = new char[len];
        label.getChars(0, len, data, 0);
        for (int i2 = 0; i2 < len; ++i2) {
            char ch = data[i2];
            if (ch >= '\u4e00' && ch <= '\u9fff' || ch >= '\u3400' && ch <= '\u4dff' || ch >= '\uf900' && ch <= '\ufaff' || ch >= '\u3040' && ch <= '\u309f' || ch >= '\u30a0' && ch <= '\u30ff') {
                hasCJK = true;
            }
            if (!(ch >= '\u0590' && ch <= '\u05ff' || ch >= '\u0600' && ch <= '\u06ff') && (ch < '\u0700' || ch > '\u074f')) continue;
            hasMustRotate = true;
        }
        if (hasCJK) {
            return 1;
        }
        int n2 = legal = hasMustRotate ? 6 : 7;
        if ((2 & legal) > 0) {
            return 2;
        }
        return hasMustRotate ? 2 : 4;
    }
}

