/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SwingOutline
extends JScrollPane {
    private final Map<String, String> pageLookupTableViaTitle = new HashMap<String, String>();
    private final Map<Integer, String> nodeToRef = new HashMap<Integer, String>();
    private final Map<Integer, String> closedNodes = new HashMap<Integer, String>();
    private final DefaultMutableTreeNode top = new DefaultMutableTreeNode("Root");
    private JTree tree;
    private boolean hasDuplicateTitles;

    SwingOutline() {
        JLabel noOutline = new JLabel("No outline");
        this.getViewport().add(noOutline);
    }

    void reset(Node rootNode) {
        this.top.removeAllChildren();
        if (this.tree != null) {
            this.getViewport().remove(this.tree);
        }
        this.pageLookupTableViaTitle.clear();
        this.nodeToRef.clear();
        this.closedNodes.clear();
        this.hasDuplicateTitles = false;
        if (rootNode != null) {
            this.readChildNodes(rootNode, this.top, 0);
        }
        this.tree = new JTree(this.top);
        this.tree.setName("Tree");
        if (rootNode != null) {
            this.expandAll();
        }
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.getViewport().add(this.tree);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
    }

    private void expandAll() {
        for (int row = 1; row < 4; ++row) {
            if (!this.closedNodes.containsKey(row)) {
                this.tree.expandRow(row);
                continue;
            }
            this.tree.collapseRow(row);
        }
    }

    private int readChildNodes(Node rootNode, DefaultMutableTreeNode topNode, int nodeIndex) {
        if (topNode == null) {
            topNode = this.top;
        }
        NodeList children = rootNode.getChildNodes();
        int childCount = children.getLength();
        for (int i2 = 0; i2 < childCount; ++i2) {
            Node child = children.item(i2);
            Element currentElement = (Element)child;
            String title = currentElement.getAttribute("title");
            String page = currentElement.getAttribute("page");
            String isClosed = currentElement.getAttribute("isClosed");
            String ref = currentElement.getAttribute("objectRef");
            if (this.pageLookupTableViaTitle.containsKey(title)) {
                this.hasDuplicateTitles = true;
            } else {
                this.pageLookupTableViaTitle.put(title, page);
            }
            if ("true".equals(isClosed)) {
                this.closedNodes.put(nodeIndex, "x");
            }
            this.nodeToRef.put(nodeIndex, ref);
            ++nodeIndex;
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(title);
            topNode.add(childNode);
            if (!child.hasChildNodes()) continue;
            nodeIndex = this.readChildNodes(child, childNode, nodeIndex);
        }
        return nodeIndex;
    }

    String getPage(String title) {
        if (this.hasDuplicateTitles) {
            return null;
        }
        return this.pageLookupTableViaTitle.get(title);
    }

    String convertNodeIDToRef(int nodeNumber) {
        return this.nodeToRef.get(nodeNumber);
    }

    JTree getTree() {
        return this.tree;
    }

    DefaultMutableTreeNode getLastSelectedPathComponent() {
        return (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
    }
}

