/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import com.idrsolutions.image.JDeli;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.NumberFormatter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jpedal.FileAccess;
import org.jpedal.FileAccessHelper;
import org.jpedal.PdfDecoder;
import org.jpedal.PdfDecoderInt;
import org.jpedal.constants.JPedalSettings;
import org.jpedal.display.Display;
import org.jpedal.display.GUIDisplay;
import org.jpedal.display.PageOffsets;
import org.jpedal.display.swing.MultiDisplay;
import org.jpedal.display.swing.PageFlowDisplay;
import org.jpedal.display.swing.SingleDisplay;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.RecentDocuments;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.ViewerCommands;
import org.jpedal.examples.viewer.commands.OpenFile;
import org.jpedal.examples.viewer.commands.PageNavigator;
import org.jpedal.examples.viewer.gui.Buttons;
import org.jpedal.examples.viewer.gui.GUIModifier;
import org.jpedal.examples.viewer.gui.PageMoveTracker;
import org.jpedal.examples.viewer.gui.SwingCursor;
import org.jpedal.examples.viewer.gui.SwingOutline;
import org.jpedal.examples.viewer.gui.VTextIcon;
import org.jpedal.examples.viewer.gui.popups.PrintPanel;
import org.jpedal.examples.viewer.gui.swing.ColorListCellRenderer;
import org.jpedal.examples.viewer.gui.swing.FrameCloser;
import org.jpedal.examples.viewer.gui.swing.SearchList;
import org.jpedal.examples.viewer.gui.swing.SwingAnnotationPanel;
import org.jpedal.examples.viewer.gui.swing.SwingAttachmentsPanel;
import org.jpedal.examples.viewer.gui.swing.SwingCombo;
import org.jpedal.examples.viewer.gui.swing.SwingCommandListener;
import org.jpedal.examples.viewer.gui.swing.SwingLayersPanel;
import org.jpedal.examples.viewer.gui.swing.SwingMenuItems;
import org.jpedal.examples.viewer.gui.swing.SwingMouseListener;
import org.jpedal.examples.viewer.gui.swing.SwingMouseUtils;
import org.jpedal.examples.viewer.gui.swing.SwingPageChanger;
import org.jpedal.examples.viewer.gui.swing.SwingPortfolioDetail;
import org.jpedal.examples.viewer.gui.swing.SwingPortfolioTile;
import org.jpedal.examples.viewer.gui.swing.SwingScrollListener;
import org.jpedal.examples.viewer.gui.swing.SwingSearchWindow;
import org.jpedal.examples.viewer.gui.swing.SwingSignaturesPanel;
import org.jpedal.examples.viewer.gui.swing.SwingThumbnailPanel;
import org.jpedal.examples.viewer.paper.PaperSizes;
import org.jpedal.examples.viewer.utils.LimitDecodeTrackerNoSwing;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.external.AnnotationHandler;
import org.jpedal.external.CustomMessageHandler;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.external.ImageNameCollector;
import org.jpedal.external.RenderChangeListener;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.gui.CommandWindow;
import org.jpedal.io.LimitDecodeTracker;
import org.jpedal.io.PageLabels;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.linear.LinearThread;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.CommandParser;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.text.Tj;
import org.jpedal.render.BaseDisplay;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.StringUtils;
import org.jpedal.utils.SwingWorker;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SwingGUI {
    public static final int BUTTONBAR = 0;
    public static final int NAVBAR = 1;
    public static final int PAGES = 2;
    public static final String version;
    public static final int CURSOR = 1;
    public static final int GRAB_CURSOR = 1;
    public static final int GRABBING_CURSOR = 2;
    public static final int DEFAULT_CURSOR = 3;
    public static final int PAN_CURSOR = 4;
    public static final int PAN_CURSORL = 5;
    public static final int PAN_CURSORTL = 6;
    public static final int PAN_CURSORT = 7;
    public static final int PAN_CURSORTR = 8;
    public static final int PAN_CURSORR = 9;
    public static final int PAN_CURSORBR = 10;
    public static final int PAN_CURSORB = 11;
    public static final int PAN_CURSORBL = 12;
    private static final int glowThickness = 11;
    private static final int minimumScreenWidth = 700;
    public static boolean deletePropertiesOnExit;
    public static boolean alwaysShowMouse;
    public static boolean showMessages;
    static int expandedSize;
    private static int collapsedSize;
    private static int inset;
    private static int defaultSelection;
    private static String windowTitle;
    private final Color glowOuterColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private final Color glowInnerColor = new Color(0.8f, 0.75f, 0.45f, 0.8f);
    private final Values commonValues;
    private final SwingThumbnailPanel thumbnails;
    private final PropertiesFile properties;
    private RecentDocuments recent;
    private SwingCommandListener currentCommandListener;
    private Commands currentCommands;
    private CustomMessageHandler customMessageHandler;
    private SwingMenuItems menuItems;
    private PdfLayerList layersObject;
    private boolean finishedDecoding;
    private Font textFont = new Font("Serif", 0, 12);
    private boolean bookmarksGenerated;
    private SwingSearchWindow searchFrame;
    private String pageTitle;
    private String bookmarksTitle;
    private String signaturesTitle;
    private String layersTitle;
    private String annotationTitle;
    private String attachmentsTitle;
    private PdfDecoderInt decode_pdf;
    private SwingOutline tree;
    private float[] scalingFloatValues = new float[]{1.0f, 1.0f, 1.0f, 0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 2.5f, 5.0f, 7.5f, 10.0f};
    private float scaling = 1.0f;
    private int rotation;
    private SwingCombo rotationBox;
    private SwingCombo scalingBox;
    private RefreshLayout viewListener;
    private final Buttons swButtons = new Buttons();
    private final SwingCursor guiCursor = new SwingCursor();
    private SwingMouseListener mouseHandler;
    private Timer memoryMonitor;
    private SwingScrollListener scrollListener;
    private JScrollBar thumbscroll;
    private final JPanel top;
    private boolean sideTabBarOpenByDefault;
    private String startSelectedTab = "";
    private boolean hasListener;
    private boolean isSetup;
    private int lastTabSelected = -1;
    private boolean tabsExpanded;
    private PaperSizes paperSizes;
    private final JPanel multibox;
    private boolean pageTurnScalingAppropriate = true;
    private JToolBar navButtons;
    private final JPanel containerForThumbnails;
    private JLabel coords;
    private Container frame;
    private Container portfolioParent;
    private JTabbedPane navOptionsPanel;
    private JSplitPane displayPane;
    private JScrollPane scrollPane;
    private StatusBar statusBar;
    private StatusBar downloadBar;
    private JLabel pageCounter1;
    private JTextField pageCounter2;
    private JLabel pageCounter3;
    private SwingSignaturesPanel signaturesTree;
    private SwingLayersPanel layersPanel;
    private SwingAnnotationPanel annotationsPanel;
    private SwingPortfolioDetail detailView;
    private SwingPortfolioTile tileView;
    private SwingAttachmentsPanel attachmentsPanel;
    private boolean tabsNotInitialised = true;
    private JToolBar navToolBar;
    private JToolBar pagesToolBar;
    private final JProgressBar memoryBar;
    private final JToolBar cursor;
    private PrintPanel printPanel;
    private JPanel glassPane;
    private boolean searchInMenu;
    private JTextField searchText;
    private JToggleButton options;
    private JPopupMenu menu;
    private boolean cursorOverPage;
    private final JLayeredPane lpane;
    private Map<FormObject, String> objs;
    private long start = System.currentTimeMillis();
    private boolean allowScrolling = true;
    private boolean confirmClose;
    private boolean debugMode;
    private ImageNameCollector imageNameCollector = new ImageNameCollector(){};

    public SwingGUI(PdfDecoderInt decode_pdf, Values commonValues, SwingThumbnailPanel thumbnails, PropertiesFile properties) {
        this.decode_pdf = decode_pdf;
        this.commonValues = commonValues;
        this.thumbnails = thumbnails;
        this.properties = properties;
        this.statusBar = new StatusBar(new Color(235, 154, 0));
        this.downloadBar = new StatusBar(new Color(185, 209, 0));
        this.top = new JPanel();
        this.multibox = new JPanel();
        this.navButtons = new JToolBar();
        this.containerForThumbnails = new JPanel();
        this.coords = new JLabel();
        this.frame = new JFrame();
        this.portfolioParent = ((RootPaneContainer)((Object)this.frame)).getContentPane();
        this.navOptionsPanel = new JTabbedPane();
        this.pageCounter2 = new JTextField(4);
        this.pageCounter3 = new JLabel();
        this.memoryBar = new JProgressBar();
        this.cursor = new JToolBar();
        this.navToolBar = new JToolBar();
        this.pagesToolBar = new JToolBar();
        this.signaturesTree = new SwingSignaturesPanel();
        this.layersPanel = new SwingLayersPanel();
        this.scrollPane = new JScrollPane();
        this.tree = new SwingOutline();
        this.lpane = new JLayeredPane(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doLayout() {
                Object object = this.getTreeLock();
                synchronized (object) {
                    int w2 = this.getWidth();
                    int h2 = this.getHeight();
                    for (Component c2 : this.getComponents()) {
                        c2.setBounds(0, 0, w2, h2);
                    }
                }
            }
        };
        this.setupDisplay();
    }

    public static int getPDFDisplayInset() {
        return inset;
    }

    private static void setHHighlightComposite(String propValue) {
        float value = Float.parseFloat(propValue);
        if (value > 1.0f) {
            value = 1.0f;
        }
        if (value < 0.0f) {
            value = 0.0f;
        }
        DecoderOptions.highlightComposite = value;
    }

    private static void getFlattenedTreeNodes(TreeNode theNode, List<TreeNode> items) {
        items.add(theNode);
        int count = theNode.getChildCount();
        for (int i2 = 0; i2 < count; ++i2) {
            SwingGUI.getFlattenedTreeNodes(theNode.getChildAt(i2), items);
        }
    }

    private void setupDisplay() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setDisplayView(1, 2);
        } else {
            Runnable doPaintComponent = () -> this.setDisplayView(1, 2);
            try {
                SwingUtilities.invokeAndWait(doPaintComponent);
            }
            catch (InterruptedException | InvocationTargetException e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
        this.decode_pdf.addExternalHandler(this, 11);
        this.menuItems = new SwingMenuItems(this.properties);
    }

    public JSplitPane getDisplayPane() {
        return this.displayPane;
    }

    public JScrollBar getThumbnailScrollBar() {
        return this.thumbscroll;
    }

    public void setThumbnailScrollBarVisibility(boolean isVisible) {
        this.thumbscroll.setVisible(isVisible);
    }

    public void setThumbnailScrollBarValue(int pageNum) {
        this.thumbscroll.setValue(pageNum);
    }

    public String getPropertiesFileLocation() {
        return this.properties.getConfigFile();
    }

    public String getBookmark(String bookmark) {
        return this.tree.getPage(bookmark);
    }

    public void reinitialiseTabs(boolean showVisible) {
        if ("true".equalsIgnoreCase(this.properties.getValue("ShowSidetabbar"))) {
            if (!showVisible && !"true".equalsIgnoreCase(this.properties.getValue("consistentTabBar"))) {
                if (this.sideTabBarOpenByDefault) {
                    this.displayPane.setDividerLocation(expandedSize);
                    this.tabsExpanded = true;
                } else {
                    this.displayPane.setDividerLocation(collapsedSize);
                    this.tabsExpanded = false;
                    this.navOptionsPanel.setSelectedIndex(-1);
                }
            }
            this.lastTabSelected = -1;
            if (this.commonValues.isPDF()) {
                this.setupPdfDependantTabs();
            }
            if (this.tabsNotInitialised) {
                this.navOptionsPanel.setSelectedIndex(-1);
                for (int i2 = 0; i2 != this.navOptionsPanel.getTabCount(); ++i2) {
                    if (DecoderOptions.isRunningOnMac) {
                        if (!this.navOptionsPanel.getTitleAt(i2).equals(this.startSelectedTab)) continue;
                        this.navOptionsPanel.setSelectedIndex(i2);
                        break;
                    }
                    if (!this.navOptionsPanel.getIconAt(i2).toString().equals(this.startSelectedTab)) continue;
                    this.navOptionsPanel.setSelectedIndex(i2);
                    break;
                }
            }
        }
    }

    private void setupPdfDependantTabs() {
        int outlineTab;
        if (!this.decode_pdf.hasOutline()) {
            outlineTab = this.getTabIndex(this.bookmarksTitle);
            if (outlineTab != -1) {
                this.navOptionsPanel.remove(outlineTab);
            }
        } else if ("true".equalsIgnoreCase(this.properties.getValue("Bookmarkstab")) && (outlineTab = this.getTabIndex(this.bookmarksTitle)) == -1) {
            if (DecoderOptions.isRunningOnMac && UIManager.getLookAndFeel().isNativeLookAndFeel()) {
                this.navOptionsPanel.addTab(this.bookmarksTitle, this.tree);
            } else {
                VTextIcon textIcon2 = new VTextIcon(this.navOptionsPanel, this.bookmarksTitle);
                this.navOptionsPanel.addTab(null, textIcon2, this.tree);
            }
        }
        AcroRenderer currentFormRenderer = this.decode_pdf.getFormRenderer();
        Iterator<FormObject> signatureObjects = null;
        if (currentFormRenderer != null) {
            signatureObjects = currentFormRenderer.getSignatureObjects();
        }
        if (signatureObjects != null) {
            this.signaturesTree.reinitialise(this.decode_pdf, signatureObjects);
            this.checkTabShown(this.signaturesTitle);
        } else {
            this.removeTab(this.signaturesTitle);
        }
        this.layersObject = (PdfLayerList)this.decode_pdf.getJPedalObject(826881374);
        if (this.layersObject != null && this.layersObject.getLayersCount() > 0) {
            this.checkTabShown(this.layersTitle);
            this.layersPanel.reinitialise(this.layersObject, this.decode_pdf, this.scrollPane, this.commonValues.getCurrentPage());
        } else {
            this.removeTab(this.layersTitle);
        }
        PdfObjectReader reader = this.decode_pdf.getIO();
        Object[] embeddedFiles = null;
        if (reader != null) {
            if (reader.getNamesLookup() != null) {
                embeddedFiles = reader.getNamesLookup().getEmbeddedFiles();
            }
            if (this.attachmentsPanel == null) {
                this.attachmentsPanel = new SwingAttachmentsPanel(this);
            }
            if (this.attachmentsPanel.loadEmbeddedFileData(this.decode_pdf, embeddedFiles)) {
                this.checkTabShown(this.attachmentsTitle);
            } else {
                this.removeTab(this.attachmentsTitle);
            }
        }
        if (this.decode_pdf.getDisplayView() == 1 && !this.decode_pdf.isEncrypted()) {
            this.checkTabShown(this.annotationTitle);
        } else {
            this.removeTab(this.annotationTitle);
        }
        this.setBookmarks(false);
    }

    private int getTabIndex(String title) {
        int tabIndex = -1;
        if (DecoderOptions.isRunningOnMac) {
            for (int jj = 0; jj < this.navOptionsPanel.getTabCount(); ++jj) {
                if (!this.navOptionsPanel.getTitleAt(jj).equals(title)) continue;
                tabIndex = jj;
            }
        } else {
            for (int jj = 0; jj < this.navOptionsPanel.getTabCount(); ++jj) {
                if (!this.navOptionsPanel.getIconAt(jj).toString().equals(title)) continue;
                tabIndex = jj;
            }
        }
        return tabIndex;
    }

    private void checkTabShown(String title) {
        int outlineTab = this.getTabIndex(title);
        if (outlineTab == -1) {
            if (DecoderOptions.isRunningOnMac && UIManager.getLookAndFeel().isNativeLookAndFeel()) {
                if (title.equals(this.signaturesTitle) && "true".equalsIgnoreCase(this.properties.getValue("Signaturestab"))) {
                    this.navOptionsPanel.addTab(this.signaturesTitle, this.signaturesTree);
                    this.navOptionsPanel.setTitleAt(this.navOptionsPanel.getTabCount() - 1, this.signaturesTitle);
                } else if (title.equals(this.layersTitle) && "true".equalsIgnoreCase(this.properties.getValue("Layerstab"))) {
                    JScrollPane layerScrollPane = new JScrollPane();
                    layerScrollPane.getViewport().add(this.layersPanel);
                    layerScrollPane.setVerticalScrollBarPolicy(20);
                    layerScrollPane.setHorizontalScrollBarPolicy(30);
                    this.navOptionsPanel.addTab(this.layersTitle, layerScrollPane);
                    this.navOptionsPanel.setTitleAt(this.navOptionsPanel.getTabCount() - 1, this.layersTitle);
                } else if (title.equals(this.annotationTitle) && "true".equalsIgnoreCase(this.properties.getValue("AnnotationTab")) && SwingAnnotationPanel.addPanel()) {
                    this.navOptionsPanel.addTab(this.annotationTitle, this.annotationsPanel.getDisplayPanel());
                    this.navOptionsPanel.setTitleAt(this.navOptionsPanel.getTabCount() - 1, this.annotationTitle);
                } else if (title.equals(this.attachmentsTitle) && "true".equalsIgnoreCase(this.properties.getValue("AttachmentsTab"))) {
                    this.navOptionsPanel.addTab(this.attachmentsTitle, this.attachmentsPanel);
                    this.navOptionsPanel.setTitleAt(this.navOptionsPanel.getTabCount() - 1, this.attachmentsTitle);
                }
            } else if (title.equals(this.signaturesTitle) && "true".equalsIgnoreCase(this.properties.getValue("Signaturestab"))) {
                VTextIcon textIcon2 = new VTextIcon(this.navOptionsPanel, this.signaturesTitle);
                this.navOptionsPanel.addTab(null, textIcon2, this.signaturesTree);
            } else if (title.equals(this.layersTitle) && "true".equalsIgnoreCase(this.properties.getValue("Layerstab"))) {
                VTextIcon textIcon = new VTextIcon(this.navOptionsPanel, this.layersTitle);
                JScrollPane scrollPane = new JScrollPane();
                scrollPane.getViewport().add(this.layersPanel);
                scrollPane.setVerticalScrollBarPolicy(20);
                scrollPane.setHorizontalScrollBarPolicy(30);
                this.navOptionsPanel.addTab(null, textIcon, scrollPane);
            } else if (title.equals(this.annotationTitle) && "true".equalsIgnoreCase(this.properties.getValue("AnnotationTab")) && SwingAnnotationPanel.addPanel()) {
                VTextIcon textIcon = new VTextIcon(this.navOptionsPanel, this.annotationTitle);
                this.navOptionsPanel.addTab(null, textIcon, this.annotationsPanel.getDisplayPanel());
            } else if (title.equals(this.attachmentsTitle) && "true".equalsIgnoreCase(this.properties.getValue("AttachmentsTab"))) {
                VTextIcon textIcon = new VTextIcon(this.navOptionsPanel, this.attachmentsTitle);
                this.navOptionsPanel.addTab(null, textIcon, this.attachmentsPanel);
            }
        }
    }

    private void removeTab(String title) {
        int outlineTab = this.getTabIndex(title);
        if (outlineTab != -1) {
            this.navOptionsPanel.remove(outlineTab);
        }
    }

    public void stopThumbnails() {
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.terminateDrawing();
            this.thumbnails.removeAllListeners();
        }
    }

    public void reinitThumbnails() {
        this.isSetup = false;
    }

    public void resetNavBar() {
        if (!"true".equalsIgnoreCase(this.properties.getValue("consistentTabBar"))) {
            this.displayPane.setDividerLocation(collapsedSize);
            this.navOptionsPanel.setSelectedIndex(-1);
            this.tabsNotInitialised = true;
        }
        this.layersPanel.resetLayers();
        this.swButtons.setPageLayoutButtonsEnabled(false);
    }

    public void setNoPagesDecoded() {
        this.bookmarksGenerated = false;
        this.resetNavBar();
        if (this.scrollListener != null) {
            this.scrollListener.lastImage = null;
        }
    }

    public SwingThumbnailPanel getThumbnailPanel() {
        return this.thumbnails;
    }

    public SwingOutline getOutlinePanel() {
        return this.tree;
    }

    public JScrollBar getVerticalScrollBar() {
        if (this.scrollPane.getVerticalScrollBar().isVisible()) {
            return this.scrollPane.getVerticalScrollBar();
        }
        return this.thumbscroll;
    }

    public void setScrollBarPolicy(ScrollPolicy pol) {
        switch (pol) {
            case VERTICAL_NEVER: {
                this.scrollPane.setVerticalScrollBarPolicy(21);
                break;
            }
            case VERTICAL_AS_NEEDED: {
                this.scrollPane.setVerticalScrollBarPolicy(20);
                break;
            }
            case HORIZONTAL_NEVER: {
                this.scrollPane.setHorizontalScrollBarPolicy(31);
                break;
            }
            case HORIZONTAL_AS_NEEDED: {
                this.scrollPane.setHorizontalScrollBarPolicy(30);
            }
        }
    }

    public void setRootContainer(Object rawValue) {
        String customWindowSize;
        JPanel temp;
        Container rootContainer;
        if (rawValue == null) {
            throw new RuntimeException("Null containers not allowed.");
        }
        Container c2 = rootContainer = (Container)rawValue;
        if (rootContainer instanceof JTabbedPane) {
            temp = new JPanel(new BorderLayout());
            rootContainer.add(temp);
            c2 = temp;
        } else if (rootContainer instanceof JScrollPane) {
            temp = new JPanel(new BorderLayout());
            ((JScrollPane)rootContainer).getViewport().add(temp);
            c2 = temp;
        } else if (rootContainer instanceof JSplitPane) {
            throw new RuntimeException("To add the viewer to a split pane please pass through either JSplitPane.getLeftComponent() or JSplitPane.getRightComponent()");
        }
        if (rootContainer instanceof JFrame) {
            this.portfolioParent = ((RootPaneContainer)((Object)rootContainer)).getContentPane();
        } else {
            c2.setLayout(new BorderLayout());
            this.portfolioParent = c2;
        }
        int width = Integer.parseInt(this.properties.getValue("startViewerWidth"));
        int height = Integer.parseInt(this.properties.getValue("startViewerHeight"));
        Dimension d2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (width < 0) {
            width = d2.width / 2;
            if (width < 700) {
                width = 700;
            }
            this.properties.setValue("startViewerWidth", String.valueOf(width));
        }
        if (height < 0) {
            height = d2.height / 2;
            this.properties.setValue("startViewerHeight", String.valueOf(height));
        }
        if ((customWindowSize = System.getProperty("org.jpedal.startWindowSize")) != null) {
            StringTokenizer values = new StringTokenizer(customWindowSize, "x");
            if (values.countTokens() != 2) {
                throw new RuntimeException("Unable to use value for org.jpedal.startWindowSize=" + customWindowSize + "\nValue should be in format org.jpedal.startWindowSize=200x300");
            }
            try {
                width = Integer.parseInt(values.nextToken().trim());
                height = Integer.parseInt(values.nextToken().trim());
            }
            catch (NumberFormatException ee) {
                throw new RuntimeException("Unable to use value for org.jpedal.startWindowSize=" + customWindowSize + "\nValue should be in format org.jpedal.startWindowSize=200x300 " + ee);
            }
        }
        c2.setPreferredSize(new Dimension(width, height));
        this.frame = c2;
    }

    public void resetRotationBox() {
        PdfPageData currentPageData = this.decode_pdf.getPdfPageData();
        if (this.decode_pdf.getDisplayView() == 1) {
            this.rotation = currentPageData.getRotation(this.commonValues.getCurrentPage());
        }
        if (this.getSelectedComboIndex(251) != this.rotation / 90) {
            this.setSelectedComboIndex(251, this.rotation / 90);
        } else if (!Values.isProcessing()) {
            this.decode_pdf.repaint();
        }
    }

    public PropertiesFile getProperties() {
        return this.properties;
    }

    public void searchInTab(SwingSearchWindow searchFrame) {
        this.searchFrame = searchFrame;
        this.searchFrame.init(this.decode_pdf, this.commonValues);
        if (DecoderOptions.isRunningOnMac && UIManager.getLookAndFeel().isNativeLookAndFeel()) {
            if (this.thumbnails.isShownOnscreen()) {
                this.navOptionsPanel.addTab("Search", searchFrame.getContentPane());
            }
        } else {
            VTextIcon textIcon2 = new VTextIcon(this.navOptionsPanel, "Search");
            this.navOptionsPanel.addTab(null, textIcon2, searchFrame.getContentPane());
        }
        JTextField searchTextLocal = new JTextField();
        searchTextLocal.setColumns(this.searchText.getColumns());
        searchTextLocal.setText(this.searchText.getText());
        searchTextLocal.addKeyListener(this.searchText.getKeyListeners()[this.searchText.getKeyListeners().length - 1]);
        searchTextLocal.addFocusListener(this.searchText.getFocusListeners()[this.searchText.getFocusListeners().length - 1]);
        searchTextLocal.addActionListener(e2 -> {
            this.navOptionsPanel.setSelectedComponent(searchFrame.getContentPane());
            if (!this.tabsExpanded) {
                this.displayPane.setDividerLocation(expandedSize);
                this.tabsExpanded = true;
                this.thumbnails.setIsDisplayedOnscreen(false);
            }
            this.searchText.setText(searchTextLocal.getText());
        });
        this.searchText.addActionListener(e2 -> searchTextLocal.setText(this.searchText.getText()));
        this.swButtons.getTopButtons().add(searchTextLocal);
    }

    private JToggleButton createMenuBarSearchOptions() {
        if (this.options == null) {
            this.options = new JToggleButton(new ImageIcon(this.guiCursor.getURLForImage("menuSearchOptions.png")));
            this.menu = new JPopupMenu();
            this.options.setBorder(null);
            this.options.setName("SEARCHOPTIONS");
            this.options.addItemListener(e2 -> {
                if (e2.getStateChange() == 1) {
                    this.menu.show((Component)e2.getSource(), 0, ((Component)e2.getSource()).getHeight());
                }
            });
            this.options.setFocusable(false);
            this.options.setToolTipText(Messages.getMessage("PdfViewerSearch.Options"));
            JCheckBoxMenuItem wholeWords = new JCheckBoxMenuItem(Messages.getMessage("PdfViewerSearch.WholeWords"));
            wholeWords.setToolTipText(Messages.getMessage("PdfViewerSearch.WholeWordsTooltip"));
            wholeWords.addActionListener(e2 -> {
                this.searchFrame.setWholeWords(((AbstractButton)e2.getSource()).isSelected());
                this.enableSearchItems(true);
            });
            JCheckBoxMenuItem caseSense = new JCheckBoxMenuItem(Messages.getMessage("PdfViewerSearch.CaseSense"));
            caseSense.setToolTipText(Messages.getMessage("PdfViewerSearch.CaseSenseTooltip"));
            caseSense.addActionListener(e2 -> {
                this.searchFrame.setCaseSensitive(((AbstractButton)e2.getSource()).isSelected());
                this.enableSearchItems(true);
            });
            JCheckBoxMenuItem multiLine = new JCheckBoxMenuItem(Messages.getMessage("PdfViewerSearch.MultiLine"));
            multiLine.setToolTipText(Messages.getMessage("PdfViewerSearch.MultiLineTooltip"));
            multiLine.addActionListener(e2 -> {
                this.searchFrame.setMultiLine(((AbstractButton)e2.getSource()).isSelected());
                this.enableSearchItems(true);
            });
            JCheckBoxMenuItem ignoreSpaces = new JCheckBoxMenuItem(Messages.getMessage("PdfViewerSearch.IgnoreSpaces"));
            ignoreSpaces.setToolTipText(Messages.getMessage("PdfViewerSearch.IgnoreSpacesTooltip"));
            ignoreSpaces.addActionListener(e2 -> {
                this.searchFrame.setIgnoreSpaces(((AbstractButton)e2.getSource()).isSelected());
                this.enableSearchItems(true);
            });
            this.menu.add(wholeWords);
            this.menu.add(caseSense);
            this.menu.add(multiLine);
            this.menu.add(ignoreSpaces);
            this.menu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
                    SwingGUI.this.options.setSelected(false);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e2) {
                    SwingGUI.this.options.setSelected(false);
                }
            });
        }
        return this.options;
    }

    private void searchInMenu(SwingSearchWindow searchFrame) {
        this.searchFrame = searchFrame;
        this.searchInMenu = true;
        searchFrame.find(this.decode_pdf, this.commonValues);
        this.swButtons.getTopButtons().add(this.searchText);
        this.swButtons.getTopButtons().add(this.createMenuBarSearchOptions());
        this.swButtons.addButton(0, Messages.getMessage("PdfViewerSearch.Previous"), "search_previous.gif", 18, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.swButtons.addButton(0, Messages.getMessage("PdfViewerSearch.Next"), "search_next.gif", 19, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.swButtons.getButton(19).setEnabled(false);
        this.swButtons.getButton(18).setEnabled(false);
        this.swButtons.getButton(19).setVisible(true);
        this.swButtons.getButton(18).setVisible(true);
    }

    public void setPropertiesFileLocation(String file) {
        this.properties.loadProperties(file);
    }

    public Commands getCommand() {
        return this.currentCommands;
    }

    public SwingAnnotationPanel getAnnotationPanel() {
        return this.annotationsPanel;
    }

    public void init(Commands currentCommands) {
        this.currentCommandListener = new SwingCommandListener(currentCommands);
        this.customMessageHandler = (CustomMessageHandler)this.decode_pdf.getExternalHandler(15);
        if (this.customMessageHandler != null) {
            DecoderOptions.showErrorMessages = false;
            showMessages = false;
        }
        this.currentCommands = currentCommands;
        this.initProperties();
        this.annotationsPanel = new SwingAnnotationPanel(this);
        this.decode_pdf.setInset(inset, inset);
        this.setViewerTitle();
        this.setViewerIcon();
        this.setDefaultPdfDecoderParameters();
        this.setupCenterPanelBackground();
        this.setupComboBoxes();
        if (LogWriter.isRunningFromIDE) {
            this.nameElements();
        }
        this.setupPDFDisplayPane();
        this.setupBorderPanes();
        this.swButtons.init(true);
        this.createTopMenuBar();
        this.setupBottomToolBarItems();
        this.createOtherToolBars();
        this.initButtonsAndMenu();
        this.createNavbar();
        this.initCoordBox();
        if (this.searchFrame != null && this.searchFrame.getViewStyle() == 2) {
            this.searchInMenu(this.searchFrame);
        }
        this.initStatus();
        this.frame.invalidate();
        this.frame.validate();
        this.frame.repaint();
        GUIModifier.load(this.properties, this);
        this.initViewerWindow();
        this.redrawDocumentOnResize();
        this.setupPDFBorder();
        if (this.sideTabBarOpenByDefault) {
            this.displayPane.setDividerLocation(expandedSize);
            this.tabsExpanded = true;
        } else {
            this.displayPane.setDividerLocation(collapsedSize);
            this.tabsExpanded = false;
            this.navOptionsPanel.setSelectedIndex(-1);
        }
        this.mouseHandler = new SwingMouseListener((PdfDecoder)this.decode_pdf, this, this.commonValues, currentCommands);
        this.mouseHandler.setupMouse();
        long eventMask = 32L;
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){
            boolean listenerCalled;

            @Override
            public void eventDispatched(AWTEvent e2) {
                if (SwingGUI.this.decode_pdf != null && !this.listenerCalled && e2.getID() == 503) {
                    this.listenerCalled = true;
                    Point mousePosition = ((Component)((Object)SwingGUI.this.decode_pdf)).getMousePosition();
                    if (SwingGUI.this.annotationsPanel != null && SwingAnnotationPanel.addPanel() && SwingGUI.this.glassPane != null) {
                        mousePosition = SwingGUI.this.glassPane.getMousePosition();
                    }
                    if (mousePosition != null) {
                        SwingGUI.this.mouseHandler.allowMouseCoordsUpdate();
                        ((Component)((Object)SwingGUI.this.decode_pdf)).dispatchEvent(new MouseEvent((Component)((Object)SwingGUI.this.decode_pdf), e2.getID(), System.currentTimeMillis(), 0, mousePosition.x, mousePosition.y, 0, false));
                    }
                    this.listenerCalled = false;
                }
            }
        }, 32L);
        if (LogWriter.isRunningFromIDE && !this.debugMode) {
            LimitDecodeTracker decodeLimiter = new LimitDecodeTracker(this.menuItems, (PdfDecoder)this.decode_pdf);
            this.decode_pdf.addExternalHandler(decodeLimiter, 31);
        }
    }

    private void setDefaultPdfDecoderParameters() {
        boolean separateCoverOn = "true".equalsIgnoreCase(this.properties.getValue("separateCoverOn"));
        this.decode_pdf.getPages().setBoolean(Display.BoolValue.SEPARATE_COVER, separateCoverOn);
        boolean showFormFieldHighlights = "true".equalsIgnoreCase(this.properties.getValue("highlightFormFields"));
        int formFieldHighlightColor = Integer.parseInt(this.properties.getValue("formFieldsHighlightColor"));
        boolean useOffScreenRendering = "true".equalsIgnoreCase(this.properties.getValue("useOffScreenRendering"));
        boolean fullOffScreenRendering = "true".equalsIgnoreCase(this.properties.getValue("fullOffScreenRendering"));
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        map.put(JPedalSettings.HIGHLIGHT_FORM_FIELDS, showFormFieldHighlights);
        map.put(JPedalSettings.HIGHLIGHT_FORM_FIELDS_COLOR, formFieldHighlightColor);
        map.put(JPedalSettings.OFF_SCREEN_RENDERING, useOffScreenRendering);
        map.put(JPedalSettings.FULL_OFF_SCREEN_RENDERING, fullOffScreenRendering);
        try {
            this.decode_pdf.modifyNonstaticJPedalParameters(map);
        }
        catch (PdfException e2) {
            LogWriter.writeLog("Error setting values from properties " + e2);
        }
    }

    private void initViewerWindow() {
        String customWindowSize;
        int width = Integer.parseInt(this.properties.getValue("startViewerWidth"));
        int height = Integer.parseInt(this.properties.getValue("startViewerHeight"));
        Dimension d2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (width < 0) {
            width = d2.width / 2;
            if (width < 700) {
                width = 700;
            }
            this.properties.setValue("startViewerWidth", String.valueOf(width));
        }
        if (height < 0) {
            height = d2.height / 2;
            this.properties.setValue("startViewerHeight", String.valueOf(height));
        }
        if ((customWindowSize = System.getProperty("org.jpedal.startWindowSize")) != null) {
            StringTokenizer values = new StringTokenizer(customWindowSize, "x");
            if (values.countTokens() != 2) {
                throw new RuntimeException("Unable to use value for org.jpedal.startWindowSize=" + customWindowSize + "\nValue should be in format org.jpedal.startWindowSize=200x300");
            }
            try {
                width = Integer.parseInt(values.nextToken().trim());
                height = Integer.parseInt(values.nextToken().trim());
            }
            catch (NumberFormatException ee) {
                throw new RuntimeException("Unable to use value for org.jpedal.startWindowSize=" + customWindowSize + "\nValue should be in format org.jpedal.startWindowSize=200x300 " + ee);
            }
        }
        this.createMainViewerWindow(width, height);
    }

    private void initButtonsAndMenu() {
        this.menuItems.createMainMenu(true, this.currentCommandListener, this.currentCommands, this.swButtons);
        this.swButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.openFile"), "open.gif", 10, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.swButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.saveFile"), "save.gif", 5, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.swButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.print"), "print.gif", 6, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        if (this.searchFrame != null && this.searchFrame.getViewStyle() == 0) {
            this.searchFrame.setViewStyle(0);
            this.swButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.search"), "find.gif", 12, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        }
        this.swButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.properties"), "properties.gif", 9, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.swButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.snapshot"), "snapshot.gif", 13, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.swButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.minimise"), "minimise.gif", 64, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.swButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.zoom"), "zoom.gif", 63, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        JSeparator sep = new JSeparator(1);
        sep.setPreferredSize(new Dimension(5, 32));
        this.swButtons.getTopButtons().add(sep);
        this.addCombo(Messages.getMessage("PdfViewerToolbarTooltip.zoomin"), 252);
        this.swButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.rotateLeft"), "rotateLeft.gif", 35, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.swButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.rotateRight"), "rotateRight.gif", 36, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.addCombo(Messages.getMessage("PdfViewerToolbarTooltip.rotation"), 251);
        this.swButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.mouseMode"), "mouse_select.png", 29, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        JSeparator sep2 = new JSeparator(1);
        sep2.setPreferredSize(new Dimension(5, 32));
        this.swButtons.getTopButtons().add(sep2);
        this.swButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.help"), "help.png", 998, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.swButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.openSystemDefault"), "openSystem.png", 37, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
    }

    private void initProperties() {
        String val;
        String propValue = this.properties.getValue("pageInsets");
        if (!propValue.isEmpty()) {
            inset = Integer.parseInt(propValue);
        }
        if (!(propValue = this.properties.getValue("changeTextAndLineart")).isEmpty() && "true".equalsIgnoreCase(propValue)) {
            this.currentCommands.executeCommand(ViewerCommands.CHANGELINEART, new Object[]{Boolean.parseBoolean(propValue)});
        }
        windowTitle = !(propValue = this.properties.getValue("windowTitle")).isEmpty() ? propValue : Messages.getMessage("PdfViewer.titlebar") + ' ' + version;
        propValue = this.properties.getValue("vbgColor");
        if (!propValue.isEmpty()) {
            this.currentCommands.executeCommand(ViewerCommands.SETPAGECOLOR, new Object[]{Integer.parseInt(propValue)});
        }
        if (!(propValue = this.properties.getValue("replaceDocumentTextColors")).isEmpty() && "true".equalsIgnoreCase(propValue) && !(propValue = this.properties.getValue("vfgColor")).isEmpty()) {
            this.currentCommands.executeCommand(ViewerCommands.SETTEXTCOLOR, new Object[]{Integer.parseInt(propValue)});
        }
        if (!(propValue = this.properties.getValue("TextColorThreshold")).isEmpty()) {
            this.currentCommands.executeCommand(ViewerCommands.SETREPLACEMENTCOLORTHRESHOLD, new Object[]{Integer.parseInt(propValue)});
        }
        if (!(propValue = this.properties.getValue("enhanceFractionalLines")).isEmpty()) {
            this.currentCommands.executeCommand(ViewerCommands.SETENHANCEFRACTIONALLINES, new Object[]{Boolean.parseBoolean(propValue)});
        }
        if (!(propValue = this.properties.getValue("hideLineWeights")).isEmpty()) {
            this.currentCommands.executeCommand(ViewerCommands.SETHIDELINEWEIGHTS, new Object[]{Boolean.parseBoolean(propValue)});
        }
        if (!(propValue = this.properties.getValue("autoScroll")).isEmpty()) {
            this.allowScrolling = Boolean.parseBoolean(propValue);
        }
        if (!(propValue = this.properties.getValue("confirmClose")).isEmpty()) {
            this.confirmClose = "true".equals(propValue);
        }
        if (!(propValue = this.properties.getValue("resolution")).isEmpty()) {
            this.setDpi(Integer.parseInt(propValue));
        }
        if (!(propValue = this.properties.getValue("startView")).isEmpty()) {
            int pageMode = Integer.parseInt(propValue);
            if (pageMode < 1 || pageMode > 5) {
                pageMode = 1;
            }
            this.decode_pdf.setPageMode(pageMode);
        }
        if (!(val = this.properties.getValue("highlightBoxColor")).isEmpty()) {
            DecoderOptions.highlightColor = new Color(Integer.parseInt(val));
        }
        if (!(propValue = this.properties.getValue("useSmoothImage")).isEmpty()) {
            HashMap<Integer, Object> map = new HashMap<Integer, Object>();
            map.put(JPedalSettings.SMOOTH_IMAGES, Boolean.valueOf(propValue));
            try {
                this.decode_pdf.modifyNonstaticJPedalParameters(map);
            }
            catch (PdfException e2) {
                LogWriter.writeLog(e2);
            }
        }
        if (!(propValue = this.properties.getValue("highlightTextColor")).isEmpty()) {
            DecoderOptions.backgroundColor = new Color(Integer.parseInt(propValue));
        }
        if (!(propValue = this.properties.getValue("showMouseSelectionBox")).isEmpty()) {
            DecoderOptions.showMouseBox = Boolean.parseBoolean(propValue);
        }
        if (!(propValue = this.properties.getValue("enhancedViewerMode")).isEmpty()) {
            this.decode_pdf.useNewGraphicsMode(Boolean.parseBoolean(propValue));
        }
        if (!(propValue = this.properties.getValue("highlightComposite")).isEmpty()) {
            SwingGUI.setHHighlightComposite(propValue);
        }
        if (!(propValue = this.properties.getValue("borderType")).isEmpty()) {
            this.decode_pdf.getPages().setBorderPresent(Integer.parseInt(propValue) == 1);
        }
        if (!(propValue = this.properties.getValue("allowCursorToChange")).isEmpty()) {
            GUIDisplay.allowChangeCursor = "true".equalsIgnoreCase(propValue);
        }
        if (!(propValue = this.properties.getValue("invertHighlights")).isEmpty()) {
            BaseDisplay.invertHighlight = Boolean.parseBoolean(propValue);
        }
        if (!(propValue = this.properties.getValue("enhancedFacingMode")).isEmpty()) {
            GUIDisplay.default_turnoverOn = Boolean.parseBoolean(propValue);
        }
        propValue = this.properties.getValue("useHinting");
        String propValue2 = System.getProperty("org.jpedal.useTTFontHinting");
        if (propValue2 != null) {
            if (!propValue.isEmpty() && !propValue2.equalsIgnoreCase(propValue)) {
                JOptionPane.showMessageDialog(null, Messages.getMessage("PdfCustomGui.hintingFlagFileConflict"));
            }
            TTGlyph.useHinting = "true".equalsIgnoreCase(propValue2);
        } else {
            TTGlyph.useHinting = !propValue.isEmpty() && "true".equalsIgnoreCase(propValue);
        }
        propValue = this.properties.getValue("iconLocation");
        if (!propValue.isEmpty()) {
            this.guiCursor.setIconLocation(propValue);
        }
    }

    private void nameElements() {
        this.menuItems.getCurrentMenu().setName("menuBar");
        this.frame.setName("frame");
        this.pageCounter2.setName("pageCounter");
        this.rotationBox.setName("rotationBox");
        this.scalingBox.setName("scalingBox");
    }

    private void createOtherToolBars() {
        this.top.add((Component)this.menuItems.getCurrentMenu(), "North");
        this.top.add((Component)this.swButtons.getTopButtons(), "Center");
        if (this.frame instanceof JFrame) {
            ((RootPaneContainer)((Object)this.frame)).getContentPane().add((Component)this.navButtons, "South");
        } else {
            this.frame.add((Component)this.navButtons, "South");
        }
        if (this.frame instanceof JFrame) {
            ((RootPaneContainer)((Object)this.frame)).getContentPane().add((Component)this.displayPane, "Center");
        } else {
            this.frame.add((Component)this.displayPane, "Center");
        }
    }

    private void handleTabbedPanes() {
        if (this.tabsNotInitialised) {
            return;
        }
        int tabSelected = this.navOptionsPanel.getSelectedIndex();
        if (tabSelected == -1) {
            return;
        }
        if (!this.tabsExpanded) {
            String tabName = DecoderOptions.isRunningOnMac ? this.navOptionsPanel.getTitleAt(tabSelected) : this.navOptionsPanel.getIconAt(tabSelected).toString();
            this.thumbnails.setIsDisplayedOnscreen(tabName.equals(this.pageTitle));
            if (tabName.equals(this.annotationTitle)) {
                if (this.decode_pdf.isEncrypted()) {
                    this.showMessageDialog(Messages.getMessage("PdfViewerMessage.NewAnnotInEncryptedFile"), Messages.getMessage("PdfViewerGeneral.Warning"), 2);
                }
                this.annotationsPanel.populateList(this.decode_pdf);
            }
            this.displayPane.setDividerLocation(expandedSize);
            this.tabsExpanded = true;
        } else if (this.lastTabSelected == tabSelected) {
            this.displayPane.setDividerLocation(collapsedSize);
            this.tabsExpanded = false;
            this.thumbnails.setIsDisplayedOnscreen(false);
            this.navOptionsPanel.setSelectedIndex(-1);
        }
        this.lastTabSelected = tabSelected;
    }

    public void setMultibox(int[] flags) {
        if (alwaysShowMouse) {
            this.multibox.removeAll();
            this.multibox.add((Component)this.coords, "Center");
            this.multibox.repaint();
            return;
        }
        if (flags.length > 1 && flags[0] == 1) {
            if (this.cursorOverPage != (flags[1] == 1)) {
                this.cursorOverPage = flags[1] == 1;
            } else {
                return;
            }
        }
        if (this.statusBar.isEnabled() && this.statusBar.isVisible() && !this.statusBar.isDone()) {
            this.multibox.removeAll();
            this.statusBar.getStatusObject().setSize(this.multibox.getSize());
            this.multibox.add(this.statusBar.getStatusObject(), "Center");
            this.multibox.repaint();
            return;
        }
        if (this.cursor.isEnabled() && this.cursor.isVisible() && this.cursorOverPage && this.decode_pdf.isOpen()) {
            this.multibox.removeAll();
            this.multibox.add((Component)this.coords, "Center");
            this.multibox.repaint();
            return;
        }
        if (this.downloadBar.isEnabled() && this.downloadBar.isVisible() && !this.downloadBar.isDone() && (this.decode_pdf.isLoadingLinearizedPDF() || !this.decode_pdf.isOpen())) {
            this.multibox.removeAll();
            this.downloadBar.getStatusObject().setSize(this.multibox.getSize());
            this.multibox.add(this.downloadBar.getStatusObject(), "Center");
            this.multibox.repaint();
            return;
        }
        if (this.memoryBar.isEnabled() && this.memoryBar.isVisible()) {
            this.multibox.removeAll();
            this.memoryBar.setSize(this.multibox.getSize());
            this.memoryBar.setForeground(new Color(125, 145, 255));
            this.multibox.add((Component)this.memoryBar, "Center");
            this.multibox.repaint();
        }
    }

    private void setTitle(String title) {
        if (this.frame instanceof JFrame) {
            ((Frame)this.frame).setTitle(title);
        }
    }

    public void resetComboBoxes(boolean value) {
        this.scalingBox.setEnabled(value);
        this.rotationBox.setEnabled(value);
    }

    public SwingCombo getCombo(int ID2) {
        switch (ID2) {
            case 252: {
                return this.scalingBox;
            }
            case 251: {
                return this.rotationBox;
            }
        }
        return null;
    }

    public void scaleAndRotate() {
        if (this.decode_pdf != null) {
            if (this.decode_pdf.getDisplayView() == 5) {
                this.decode_pdf.setPageParameters(this.scaling, this.commonValues.getCurrentPage(), this.rotation);
                return;
            }
            if (!this.decode_pdf.isOpen() && OpenFile.isPDf) {
                return;
            }
        }
        Insets borderInsets = new Insets(0, 0, 0, 0);
        if (this.scrollPane.getBorder() != null && this.scrollPane.getBorder().getBorderInsets(this.scrollPane) != null) {
            borderInsets = this.scrollPane.getBorder().getBorderInsets(this.scrollPane);
        }
        float width = this.scrollPane.getWidth() - inset - inset - borderInsets.left - borderInsets.right;
        float height = this.scrollPane.getHeight() - inset - inset - borderInsets.top - borderInsets.bottom;
        if (this.decode_pdf != null) {
            int index = this.getSelectedComboIndex(252);
            if (this.decode_pdf.getDisplayView() == 5) {
                this.setSelectedComboIndex(252, 0);
                index = 0;
                this.scalingBox.setEnabled(false);
            } else if (this.decode_pdf.getDisplayView() != 5) {
                this.scalingBox.setEnabled(true);
            }
            if (index == -1) {
                float zoom = SwingGUI.getScalingFromString((String)this.getSelectedComboItem(252));
                if (zoom == -1.0f) {
                    index = defaultSelection;
                    this.setSelectedComboIndex(252, index);
                } else {
                    this.scaling = this.decode_pdf.getDPIFactory().adjustScaling(zoom / 100.0f);
                    this.setSelectedComboItem(252, String.valueOf(zoom));
                }
            }
            int page = this.commonValues.getCurrentPage();
            if (this.commonValues.isMultiTiff()) {
                page = 1;
            }
            if (index != -1 || this.decode_pdf.getDisplayView() == 1 || this.decode_pdf.getDisplayView() == 4 && this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON)) {
                Dimension contentSize = this.getContentDimensions(page);
                if (this.displayPane != null) {
                    width -= (float)this.displayPane.getDividerSize();
                }
                this.setupScalingValue(index, width, height, contentSize.width, contentSize.height);
            }
            this.decode_pdf.setPageParameters(this.scaling, page, this.rotation);
            this.setRotation();
        }
        if (LogWriter.isRunningFromIDE) {
            System.out.println("Memory usage after zoom=" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000L);
        }
        this.annotationsPanel.getAnnotationListener().updateSelectionPosition();
    }

    private Dimension getContentDimensions(int page) {
        Dimension dimensions = new Dimension();
        PdfPageData pageData = this.decode_pdf.getPdfPageData();
        int raw_rotation = this.decode_pdf.getDisplayView() == 4 ? pageData.getRotation(page) : 0;
        boolean isRotated = (this.rotation + raw_rotation) % 180 == 90;
        PageOffsets offsets = (PageOffsets)this.decode_pdf.getExternalHandler(17);
        switch (this.decode_pdf.getDisplayView()) {
            case 3: {
                SwingGUI.handleContinuousModes(dimensions, isRotated, offsets, offsets.getMaxH() * 2, offsets.getMaxW() * 2);
                break;
            }
            case 2: {
                SwingGUI.handleContinuousModes(dimensions, isRotated, offsets, offsets.getMaxH(), offsets.getMaxW());
                break;
            }
            case 4: {
                SwingGUI.handleFacing(page, dimensions, pageData, isRotated, this.decode_pdf, this.commonValues);
                break;
            }
            default: {
                if (isRotated) {
                    dimensions.width = pageData.getCropBoxHeight(page);
                    dimensions.height = pageData.getCropBoxWidth(page);
                    break;
                }
                dimensions.width = pageData.getCropBoxWidth(page);
                dimensions.height = pageData.getCropBoxHeight(page);
            }
        }
        if (dimensions.width == 0 && dimensions.height == 0 && this.commonValues.getBufferedImg() != null) {
            if (isRotated) {
                dimensions.width = this.commonValues.getBufferedImg().getHeight();
                dimensions.height = this.commonValues.getBufferedImg().getWidth();
            } else {
                dimensions.width = this.commonValues.getBufferedImg().getWidth();
                dimensions.height = this.commonValues.getBufferedImg().getHeight();
            }
        }
        return dimensions;
    }

    private static void handleFacing(int page, Dimension dimensions, PdfPageData pageData, boolean isRotated, PdfDecoderInt decode_pdf, Values commonValues) {
        int leftPage;
        if (decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER)) {
            leftPage = page / 2 * 2;
            if (commonValues.getPageCount() == 2) {
                leftPage = 1;
            }
        } else {
            leftPage = page;
            if ((leftPage & 1) == 0) {
                --leftPage;
            }
        }
        if (leftPage == 0) {
            ++leftPage;
        }
        if (isRotated) {
            dimensions.width = pageData.getCropBoxHeight(leftPage);
            dimensions.width = leftPage + 1 > commonValues.getPageCount() || leftPage == 1 ? (dimensions.width *= 2) : (dimensions.width += pageData.getCropBoxHeight(leftPage + 1));
            dimensions.height = pageData.getCropBoxWidth(leftPage);
            if (leftPage + 1 <= commonValues.getPageCount() && dimensions.height < pageData.getCropBoxWidth(leftPage + 1)) {
                dimensions.height = pageData.getCropBoxWidth(leftPage + 1);
            }
        } else {
            dimensions.width = pageData.getCropBoxWidth(leftPage);
            dimensions.width = leftPage + 1 > commonValues.getPageCount() ? (dimensions.width *= 2) : (dimensions.width += pageData.getCropBoxWidth(leftPage + 1));
            dimensions.height = pageData.getCropBoxHeight(leftPage);
            if (leftPage + 1 <= commonValues.getPageCount() && dimensions.height < pageData.getCropBoxHeight(leftPage + 1)) {
                dimensions.height = pageData.getCropBoxHeight(leftPage + 1);
            }
        }
    }

    private static void handleContinuousModes(Dimension dimensions, boolean isRotated, PageOffsets offsets, int i2, int i22) {
        if (isRotated) {
            dimensions.width = i2;
            dimensions.height = offsets.getMaxW();
        } else {
            dimensions.width = i22;
            dimensions.height = offsets.getMaxH();
        }
    }

    private static float getScalingFromString(String numberValue) {
        float zoom = -1.0f;
        if (numberValue != null && !numberValue.isEmpty()) {
            if (numberValue.endsWith("%")) {
                numberValue = numberValue.substring(0, numberValue.length() - 1);
            }
            try {
                zoom = Float.parseFloat(numberValue);
            }
            catch (NumberFormatException e2) {
                char c2;
                int ii;
                LogWriter.writeLog("Exception in getting zoom " + e2);
                int length = numberValue.length();
                for (ii = 0; ii < length && ((c2 = numberValue.charAt(ii)) >= '0' && c2 <= '9' || c2 == '.'); ++ii) {
                }
                if (ii > 0) {
                    numberValue = numberValue.substring(0, ii);
                }
                try {
                    zoom = Float.parseFloat(numberValue);
                }
                catch (NumberFormatException e1) {
                    LogWriter.writeLog("Exception in getting zoom " + e1);
                    zoom = -1.0f;
                }
            }
            if (zoom > 1000.0f) {
                zoom = 1000.0f;
            }
        }
        return zoom;
    }

    private void setupScalingValue(int index, float viewWidth, float viewHeight, float contentWidth, float contentHeight) {
        int scrollbarWidth = 0;
        Object scrollbarWidthObj = UIManager.get("ScrollBar.width");
        if (scrollbarWidthObj instanceof Integer && (scrollbarWidth = ((Integer)scrollbarWidthObj).intValue()) < 0) {
            scrollbarWidth = 0;
        }
        float window_factor = 1.0f;
        int loopCount = 0;
        while (loopCount++ <= scrollbarWidth) {
            float x_factor = viewWidth / contentWidth;
            float y_factor = viewHeight / contentHeight;
            window_factor = Math.min(x_factor, y_factor);
            if (index == -1) continue;
            if (index < 3) {
                switch (index) {
                    case 0: {
                        this.scaling = window_factor;
                        break;
                    }
                    case 1: {
                        this.scaling = y_factor;
                        break;
                    }
                    case 2: {
                        this.scaling = x_factor;
                    }
                }
                float scaledWidth = this.scaling * contentWidth;
                float scaledHeight = this.scaling * contentHeight;
                if (index == 1 && scaledWidth > viewWidth) {
                    viewHeight -= 1.0f;
                    continue;
                }
                if (index != 2 || !(scaledHeight > viewHeight)) break;
                viewWidth -= 1.0f;
                continue;
            }
            this.scaling = this.decode_pdf.getDPIFactory().adjustScaling(this.scalingFloatValues[index]);
            break;
        }
        if (this.decode_pdf.getDisplayView() == 4) {
            boolean bl2 = this.pageTurnScalingAppropriate = this.scaling <= window_factor;
        }
        if (this.thumbscroll != null) {
            if (this.decode_pdf.getDisplayView() == 1 && this.scaling <= window_factor) {
                this.scrollPane.setVerticalScrollBarPolicy(21);
                this.scrollPane.setHorizontalScrollBarPolicy(31);
                this.thumbscroll.setVisible(this.commonValues.getFileType() == Values.FileType.PDF);
            } else {
                this.scrollPane.setVerticalScrollBarPolicy(20);
                this.scrollPane.setHorizontalScrollBarPolicy(30);
                this.thumbscroll.setVisible(false);
            }
        }
    }

    public void snapScalingToDefaults(float newScaling) {
        float window_factor;
        float y_factor;
        float x_factor;
        newScaling = this.decode_pdf.getDPIFactory().adjustScaling(newScaling / 100.0f);
        float width = this.scrollPane.getViewport().getWidth() - inset - inset;
        float height = this.scrollPane.getViewport().getHeight() - inset - inset;
        Dimension contentSize = this.getContentDimensions(this.commonValues.getCurrentPage());
        if (this.displayPane != null) {
            width -= (float)this.displayPane.getDividerSize();
        }
        if ((x_factor = width / (float)contentSize.width) < (y_factor = height / (float)contentSize.height)) {
            window_factor = x_factor;
            x_factor = -1.0f;
        } else {
            window_factor = y_factor;
            y_factor = -1.0f;
        }
        if (this.getSelectedComboIndex(252) != 0 && ((double)newScaling < (double)window_factor * 1.1 && (double)newScaling > (double)window_factor * 0.91 || window_factor > this.scaling && window_factor < newScaling || window_factor < this.scaling && window_factor > newScaling)) {
            this.setSelectedComboIndex(252, 0);
            this.scaling = window_factor;
        } else if (y_factor != -1.0f && this.getSelectedComboIndex(252) != 1 && ((double)newScaling < (double)y_factor * 1.1 && (double)newScaling > (double)y_factor * 0.91 || y_factor > this.scaling && y_factor < newScaling || y_factor < this.scaling && y_factor > newScaling)) {
            this.setSelectedComboIndex(252, 1);
            this.scaling = y_factor;
        } else if (x_factor != -1.0f && this.getSelectedComboIndex(252) != 2 && ((double)newScaling < (double)x_factor * 1.1 && (double)newScaling > (double)x_factor * 0.91 || x_factor > this.scaling && x_factor < newScaling || x_factor < this.scaling && x_factor > newScaling)) {
            this.setSelectedComboIndex(252, 2);
            this.scaling = x_factor;
        } else {
            this.setSelectedComboItem(252, String.valueOf((int)this.decode_pdf.getDPIFactory().removeScaling(newScaling * 100.0f)));
            this.scaling = newScaling;
        }
    }

    public void rotate() {
        this.rotation = Integer.parseInt((String)this.getSelectedComboItem(251));
        this.scaleAndRotate();
        ((JComponent)((Object)this.decode_pdf)).updateUI();
    }

    private void scrollToPage(int page) {
        this.commonValues.setCurrentPage(page);
        if (this.commonValues.getCurrentPage() > 0) {
            int yCord = 0;
            if (this.decode_pdf.getDisplayView() != 1) {
                yCord = this.decode_pdf.getPages().getYCordForPage(page);
            }
            if ((this.decode_pdf.getDisplayView() == 3 || this.decode_pdf.getDisplayView() == 4) && page == 1) {
                this.scrollPane.getHorizontalScrollBar().setValue((int)((float)this.decode_pdf.getPdfPageData().getCropBoxWidth(this.commonValues.getCurrentPage()) * this.scaling));
            } else {
                this.scrollPane.getHorizontalScrollBar().setValue(0);
            }
            this.scrollPane.getVerticalScrollBar().setValue(yCord);
        }
        if (this.decode_pdf.getPageCount() > 1) {
            this.swButtons.setPageLayoutButtonsEnabled(true);
        }
    }

    private void setupThumbnailPanel() {
        if (this.isSetup) {
            return;
        }
        this.isSetup = true;
        if (this.thumbnails.isShownOnscreen()) {
            int pages = this.decode_pdf.getPageCount();
            this.thumbnails.setupThumbnails(pages, this.textFont, this.decode_pdf.getPdfPageData());
            JButton[] buttons = this.thumbnails.getButtons();
            for (int i2 = 0; i2 < pages; ++i2) {
                ((AbstractButton)buttons[i2]).addActionListener(new SwingPageChanger(this, this.commonValues, i2));
            }
            this.thumbnails.addComponentListener();
        }
    }

    public void setBookmarks(boolean alwaysGenerate) {
        if (this.bookmarksGenerated && !alwaysGenerate || this.decode_pdf.isLoadingLinearizedPDF()) {
            return;
        }
        this.bookmarksGenerated = true;
        Document doc = this.decode_pdf.getOutlineAsXML();
        Node rootNode = null;
        if (doc != null) {
            rootNode = doc.getFirstChild();
        }
        if (rootNode != null) {
            this.tree.reset(rootNode);
            this.tree.getTree().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e2) {
                    DefaultMutableTreeNode node = SwingGUI.this.tree.getLastSelectedPathComponent();
                    int[] selected = SwingGUI.this.tree.getTree().getSelectionRows();
                    if (selected != null && selected.length != 0) {
                        Rectangle r2 = SwingGUI.this.tree.getTree().getRowBounds(selected[0]);
                        if (node == null || !r2.contains(e2.getX(), e2.getY())) {
                            return;
                        }
                    }
                    SwingGUI.this.triggerBookmark(node);
                }
            });
            this.tree.getTree().addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e2) {
                    DefaultMutableTreeNode node;
                    if (e2.getKeyCode() == 10 && (node = SwingGUI.this.tree.getLastSelectedPathComponent()) != null) {
                        SwingGUI.this.triggerBookmark(node);
                    }
                }
            });
        } else {
            this.tree.reset(null);
        }
    }

    private void triggerBookmark(DefaultMutableTreeNode node) {
        JTree jtree = this.tree.getTree();
        DefaultTreeModel treeModel = (DefaultTreeModel)jtree.getModel();
        ArrayList<TreeNode> flattenedTree = new ArrayList<TreeNode>();
        SwingGUI.getFlattenedTreeNodes((TreeNode)treeModel.getRoot(), flattenedTree);
        flattenedTree.remove(0);
        int index = flattenedTree.indexOf(node);
        String ref = this.tree.convertNodeIDToRef(index);
        PdfObject Aobj = this.decode_pdf.getOutlineData().getAobj(ref);
        if (Aobj != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.decode_pdf.getFormRenderer().getActionHandler().gotoDest(Aobj, 3, 339034948);
            } else {
                try {
                    SwingUtilities.invokeAndWait(() -> this.decode_pdf.getFormRenderer().getActionHandler().gotoDest(Aobj, 3, 339034948));
                }
                catch (InterruptedException | InvocationTargetException e2) {
                    LogWriter.writeLog("Exception: " + e2.getMessage());
                }
            }
        }
    }

    private void initStatus() {
        this.decode_pdf.setStatusBarObject(this.statusBar);
        this.setMultibox(new int[0]);
    }

    public void setCoordText(String string) {
        this.coords.setText(string);
    }

    private void initCoordBox() {
        this.coords.setOpaque(true);
        this.coords.setBorder(BorderFactory.createEtchedBorder());
        this.coords.setPreferredSize(this.multibox.getPreferredSize());
        this.coords.setSize(this.multibox.getPreferredSize());
        this.coords.setText("  X:  Y:   ");
    }

    public void setPageNumber() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setPageNumberWorker();
            if (this.isSetup) {
                this.setThumbnails();
            }
        } else {
            Runnable r2 = () -> {
                this.setPageNumberWorker();
                if (this.isSetup) {
                    this.setThumbnails();
                }
            };
            try {
                SwingUtilities.invokeAndWait(r2);
            }
            catch (InterruptedException | InvocationTargetException e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
    }

    private void setPageNumberWorker() {
        if (this.pageCounter2 == null) {
            return;
        }
        if (!this.decode_pdf.isOpen() && !this.commonValues.isMultiTiff()) {
            this.pageCounter2.setText("0");
            this.pageCounter3.setText(Messages.getMessage("PdfViewerOfLabel.text") + " 0");
        } else {
            if (this.thumbscroll != null) {
                this.thumbscroll.setMaximum(this.decode_pdf.getPageCount());
                this.thumbscroll.setValue(this.commonValues.getCurrentPage() - 1);
            }
            int currentPage = this.commonValues.getCurrentPage();
            if (this.decode_pdf.getDisplayView() == 4 || this.decode_pdf.getDisplayView() == 3) {
                if (this.decode_pdf.getPageCount() == 2) {
                    this.pageCounter2.setText(this.getPageLabel(1) + '/' + this.getPageLabel(2));
                } else if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER)) {
                    int base = currentPage & 0xFFFFFFFE;
                    if (base != this.decode_pdf.getPageCount() && base != 0) {
                        this.pageCounter2.setText(this.getPageLabel(base) + '/' + this.getPageLabel(base + 1));
                    } else {
                        this.pageCounter2.setText(this.getPageLabel(currentPage));
                    }
                } else {
                    int base = currentPage - (1 - (currentPage & 1));
                    if (base != this.decode_pdf.getPageCount()) {
                        this.pageCounter2.setText(this.getPageLabel(base) + '/' + this.getPageLabel(base + 1));
                    } else {
                        this.pageCounter2.setText(this.getPageLabel(currentPage));
                    }
                }
            } else {
                this.pageCounter2.setText(this.getPageLabel(currentPage));
            }
            if (this.pageLabelDiffers(currentPage)) {
                this.pageCounter3.setText("(" + currentPage + ' ' + Messages.getMessage("PdfViewerOfLabel.text") + ' ' + this.commonValues.getPageCount() + ')');
            } else {
                this.pageCounter3.setText(Messages.getMessage("PdfViewerOfLabel.text") + ' ' + this.commonValues.getPageCount());
            }
            this.swButtons.hideRedundentNavButtons(this);
        }
    }

    private void createNavbar() {
        if (this.memoryMonitor == null) {
            this.memoryMonitor = new Timer(500, event -> {
                int free = (int)(Runtime.getRuntime().freeMemory() / 0x100000L);
                int total = (int)(Runtime.getRuntime().totalMemory() / 0x100000L);
                if (this.finishedDecoding) {
                    this.finishedDecoding = false;
                }
                this.memoryBar.setMaximum(total);
                this.memoryBar.setValue(total - free);
                this.memoryBar.setStringPainted(true);
                this.memoryBar.setString(total - free + "M of " + total + 'M');
            });
            this.memoryMonitor.start();
        }
        this.multibox.setLayout(new BorderLayout());
        this.navButtons.add((Component)this.multibox, "West");
        this.navButtons.add(Box.createHorizontalGlue());
        this.navToolBar.add(Box.createHorizontalGlue());
        this.swButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.RewindToStart"), "start.gif", 50, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.swButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.Rewind10"), "fback.gif", 51, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.swButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.Rewind1"), "back.gif", 52, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.pageCounter1 = new JLabel(Messages.getMessage("PdfViewerPageLabel.text"));
        this.pageCounter1.setOpaque(false);
        this.navToolBar.add(this.pageCounter1);
        this.navToolBar.add(this.pageCounter2);
        this.navToolBar.add(this.pageCounter3);
        this.swButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.Forward1"), "forward.gif", 53, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.swButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.Forward10"), "fforward.gif", 54, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.swButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.ForwardLast"), "end.gif", 55, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.navToolBar.add(Box.createHorizontalGlue());
        if (this.debugMode) {
            this.addLimitDecodeSlider();
        }
        this.swButtons.addButton(2, Messages.getMessage("PageLayoutButton.SinglePage"), "single.gif", 57, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.swButtons.addButton(2, Messages.getMessage("PageLayoutButton.Continuous"), "continuous.gif", 58, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.swButtons.addButton(2, Messages.getMessage("PageLayoutButton.ContinousFacing"), "continuous_facing.gif", 59, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.swButtons.addButton(2, Messages.getMessage("PageLayoutButton.Facing"), "facing.gif", 60, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.swButtons.addButton(2, Messages.getMessage("PageLayoutButton.PageFlow"), "pageflow.gif", 61, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.navButtons.add((Component)this.pagesToolBar, "East");
        Dimension size = this.pagesToolBar.getPreferredSize();
        this.multibox.setPreferredSize(size);
        this.navButtons.add((Component)this.navToolBar, "Center");
    }

    private void addLimitDecodeSlider() {
        CommandWindow commandWindow;
        JToolBar decoderPanel = new JToolBar();
        decoderPanel.setFloatable(false);
        decoderPanel.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 2;
        c2.gridy = 0;
        final JSlider slider = new JSlider();
        slider.setMinimum(0);
        slider.setMinorTickSpacing(1);
        slider.setMinorTickSpacing(10);
        slider.setValue(0);
        c2.gridx = 0;
        c2.weightx = 0.0;
        NumberFormat format = NumberFormat.getInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setMinimum(Integer.valueOf(0));
        formatter.setAllowsInvalid(true);
        formatter.setCommitsOnValidEdit(false);
        final JFormattedTextField field = new JFormattedTextField(formatter);
        CommandParser.commandWindow = commandWindow = new CommandWindow();
        Tj.commandWindow = commandWindow;
        final DefaultListModel<String> listModel = new DefaultListModel<String>();
        commandWindow.setListModel(listModel);
        final HashSet<String> commands = new HashSet<String>();
        commandWindow.setHashSet(commands);
        final JList<String> list = new JList<String>(listModel);
        JScrollPane scrollPane = new JScrollPane(list, 22, 31);
        JScrollBar v2 = scrollPane.getVerticalScrollBar();
        final TreeSet<String> breaks = new TreeSet<String>(Comparator.comparingInt(cmd -> Integer.parseInt(cmd.substring(0, cmd.indexOf(58)))));
        list.setCellRenderer(new ColorListCellRenderer(commands, breaks, 300));
        LimitDecodeTrackerNoSwing errorTracker = new LimitDecodeTrackerNoSwing((PdfDecoder)this.decode_pdf, formatter, field, slider, breaks, list);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                int value = (Integer)field.getValue();
                if (e2 != null && (e2.getKeyChar() == '\n' || e2.getKeyChar() == '\r')) {
                    field.setValue(value);
                }
                slider.setValue(value);
            }
        };
        field.addKeyListener(keyAdapter);
        slider.addChangeListener(e2 -> {
            if (slider.getValueIsAdjusting()) {
                return;
            }
            int value = slider.getValue();
            field.setValue(value);
            errorTracker.repaint(value);
            v2.setValue(v2.getMaximum());
        });
        this.decode_pdf.addExternalHandler(errorTracker, 31);
        c2.gridx = 1;
        this.swButtons.addButtonToToolBarWithConstraints("Start", "start.gif", -1, this.menuItems, this, e2 -> {
            field.setValue(0);
            keyAdapter.keyReleased(null);
        }, decoderPanel, c2);
        c2.gridx = 2;
        this.swButtons.addButtonToToolBarWithConstraints("Retreat by 1", "back.gif", -1, this.menuItems, this, e2 -> {
            if ((Integer)field.getValue() <= 0) {
                field.setValue(0);
            } else {
                field.setValue((Integer)field.getValue() - 1);
            }
            keyAdapter.keyReleased(null);
        }, decoderPanel, c2);
        c2.gridx = 3;
        c2.weightx = 1.0;
        decoderPanel.add((Component)field, c2);
        c2.weightx = 0.0;
        c2.gridx = 4;
        this.swButtons.addButtonToToolBarWithConstraints("Advance by 1", "forward.gif", -1, this.menuItems, this, e2 -> {
            if ((Integer)field.getValue() >= (Integer)formatter.getMaximum()) {
                field.setValue(formatter.getMaximum());
            } else {
                field.setValue((Integer)field.getValue() + 1);
            }
            keyAdapter.keyReleased(null);
        }, decoderPanel, c2);
        c2.gridx = 5;
        this.swButtons.addButtonToToolBarWithConstraints("End", "end.gif", -1, this.menuItems, this, e2 -> {
            field.setValue(formatter.getMaximum());
            keyAdapter.keyReleased(null);
        }, decoderPanel, c2);
        c2.gridx = 6;
        c2.fill = 3;
        JSeparator separator = new JSeparator(1);
        decoderPanel.add((Component)separator, c2);
        c2.fill = 2;
        c2.gridx = 7;
        this.swButtons.addButtonToToolBarWithConstraints("Next breakpoint", "resume.gif", -1, this.menuItems, this, e2 -> {
            if (((Integer)field.getValue()).intValue() == ((Integer)formatter.getMaximum()).intValue()) {
                try {
                    String firstBreak = (String)breaks.first();
                    field.setValue(Integer.parseInt(firstBreak.substring(0, firstBreak.indexOf(58))));
                    keyAdapter.keyReleased(null);
                    return;
                }
                catch (NoSuchElementException firstBreak) {
                    // empty catch block
                }
            }
            String nextBreakpoint = null;
            int nextBreakpointCommand = -1;
            if (!breaks.isEmpty()) {
                for (String breakPoint : breaks) {
                    nextBreakpointCommand = Integer.parseInt(breakPoint.substring(0, breakPoint.indexOf(58)));
                    if (nextBreakpointCommand <= (Integer)field.getValue()) continue;
                    nextBreakpoint = breakPoint;
                    break;
                }
            }
            if (nextBreakpoint == null) {
                field.setValue(formatter.getMaximum());
            } else {
                field.setValue(nextBreakpointCommand);
            }
            keyAdapter.keyReleased(null);
        }, decoderPanel, c2);
        c2.gridx = 8;
        this.swButtons.addButtonToToolBarWithConstraints("Clear breakpoints", "clearb.gif", -1, this.menuItems, this, e2 -> {
            breaks.clear();
            list.repaint();
        }, decoderPanel, c2);
        ListSelectionListener listSelectionListener = e2 -> {
            if (list.getValueIsAdjusting()) {
                return;
            }
            String command = (String)list.getSelectedValue();
            if (commands.contains(command)) {
                if (breaks.contains(command)) {
                    breaks.remove(command);
                } else {
                    breaks.add(command);
                }
            }
            list.clearSelection();
        };
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                this.showMenu(e2);
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                this.showMenu(e2);
            }

            private void showMenu(MouseEvent e2) {
                if (!e2.isPopupTrigger()) {
                    return;
                }
                int clicked = list.locationToIndex(e2.getPoint());
                if (clicked != -1 && list.getCellBounds(clicked, clicked).contains(e2.getPoint())) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem breakItem = new JMenuItem("Set breakpoint");
                    breakItem.addActionListener(e1 -> {
                        String command = (String)listModel.get(clicked);
                        if (commands.contains(command)) {
                            if (breaks.contains(command)) {
                                breaks.remove(command);
                            } else {
                                breaks.add(command);
                            }
                            list.repaint();
                        }
                    });
                    menu.add(breakItem);
                    String command = (String)listModel.get(clicked);
                    Pattern doPattern = Pattern.compile("^\\d+?:\\s+?DO$", 2);
                    Matcher doMatcher = doPattern.matcher(command);
                    if (doMatcher.matches()) {
                        JMenuItem imageItem = new JMenuItem("View Image");
                        imageItem.addActionListener(e1 -> {
                            String imageCacheName = SwingGUI.this.imageNameCollector.getCacheName(((String)listModel.get(clicked - 1)).substring(1));
                            if (imageCacheName == null) {
                                LogWriter.writeLog("[Warning] Cannot find image name in collector");
                                return;
                            }
                            JDialog imageDialog = new JDialog((Frame)null, doMatcher.group(), false);
                            imageDialog.add(new JLabel(new ImageIcon(SwingGUI.this.decode_pdf.getObjectStore().loadStoredImage(imageCacheName))));
                            imageDialog.pack();
                            imageDialog.setLocationRelativeTo(SwingGUI.this.frame);
                            imageDialog.setDefaultCloseOperation(2);
                            imageDialog.setVisible(true);
                        });
                        menu.add(imageItem);
                    } else {
                        Pattern idPattern = Pattern.compile("^(\\d+?):\\s+?ID$", 2);
                        Matcher idMatcher = idPattern.matcher(command);
                        if (idMatcher.matches()) {
                            JMenuItem imageItem = new JMenuItem("View Inline Image");
                            imageItem.addActionListener(e1 -> {
                                String imageCacheName = SwingGUI.this.imageNameCollector.getCacheNameFromIDToken(Integer.parseInt(idMatcher.group(1)));
                                if (imageCacheName == null) {
                                    LogWriter.writeLog("[Warning] Cannot find image name in collector");
                                    return;
                                }
                                JDialog imageDialog = new JDialog((Frame)null, idMatcher.group(), false);
                                imageDialog.add(new JLabel(new ImageIcon(SwingGUI.this.decode_pdf.getObjectStore().loadStoredImage(imageCacheName))));
                                imageDialog.pack();
                                imageDialog.setLocationRelativeTo(SwingGUI.this.frame);
                                imageDialog.setDefaultCloseOperation(2);
                                imageDialog.setVisible(true);
                            });
                            menu.add(imageItem);
                        }
                    }
                    menu.add(new JSeparator(0));
                    JMenuItem copyItem = new JMenuItem("Copy Text");
                    copyItem.addActionListener(e1 -> Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection((String)listModel.get(clicked)), null));
                    menu.add(copyItem);
                    menu.show(list, e2.getX(), e2.getY());
                }
            }
        };
        list.addListSelectionListener(listSelectionListener);
        list.addMouseListener(listMouseListener);
        list.setSelectionMode(0);
        list.setFont(new Font("Monospaced", 0, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setPreferredSize(new Dimension(400, 400));
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        panel.add((Component)slider, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        panel.add((Component)scrollPane, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 15;
        panel.add((Component)decoderPanel, gridBagConstraints);
        ((RootPaneContainer)((Object)this.frame)).getContentPane().add((Component)panel, "East");
    }

    public void setPage(int page) {
        boolean isSeparacteCover;
        if (this.decode_pdf.getDisplayView() == 3 && (page & 1) == 1 && page != 1) {
            --page;
        }
        if (this.decode_pdf.getDisplayView() == 4 && ((isSeparacteCover = this.decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER)) ? (page & 1) == 1 && page != 1 : (page & 1) == 0)) {
            --page;
        }
        this.commonValues.setCurrentPage(page);
        this.setPageNumber();
    }

    public void setRotationFromExternal(int rot) {
        this.rotation = rot;
        this.rotationBox.setSelectedIndex(this.rotation / 90);
        if (!Values.isProcessing()) {
            this.decode_pdf.repaint();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setScalingFromExternal(Object[] scale) {
        String selectedScale = "";
        if (scale.length == 1) {
            String scaleValue = scale[0].toString();
            if (scaleValue == null) throw new IllegalArgumentException("Missing second parameter: No custom value set");
            selectedScale = StringUtils.isNumber(scaleValue) ? scaleValue + '%' : scaleValue;
        } else if (scale.length == 2) {
            selectedScale = scale[1].toString();
        }
        this.scalingBox.setSelectedItem(selectedScale);
    }

    public Container getFrame() {
        return this.frame;
    }

    public void showMessageDialog(String message1) {
        boolean showMessage;
        boolean bl2 = showMessage = this.customMessageHandler == null || this.customMessageHandler.showMessage(message1);
        if (showMessage) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.frame, message1));
        }
    }

    public void showMessageDialog(Object message, String title, int type) {
        boolean showMessage;
        boolean bl2 = showMessage = this.customMessageHandler == null || this.customMessageHandler.showMessage(message);
        if (showMessage) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.frame, message, title, type));
        }
    }

    public String showInputDialog(Object message, String title, int type) {
        String returnMessage = null;
        if (this.customMessageHandler != null) {
            returnMessage = this.customMessageHandler.requestInput(new Object[]{message, title, title});
        }
        if (returnMessage == null) {
            return JOptionPane.showInputDialog(this.frame, message, title, type);
        }
        return returnMessage;
    }

    public String showInputDialog(String message) {
        String returnMessage = null;
        if (this.customMessageHandler != null) {
            returnMessage = this.customMessageHandler.requestInput(new String[]{message});
        }
        if (returnMessage == null) {
            return JOptionPane.showInputDialog(this.frame, (Object)message);
        }
        return returnMessage;
    }

    public int showConfirmDialog(String message, String message2, int option) {
        int returnMessage = -1;
        if (this.customMessageHandler != null) {
            returnMessage = this.customMessageHandler.requestConfirm(new Object[]{message, message2, String.valueOf(option)});
        }
        if (returnMessage == -1) {
            return JOptionPane.showConfirmDialog(this.frame, message, message2, option);
        }
        return returnMessage;
    }

    public int showOverwriteDialog(String file, boolean yesToAllPresent) {
        int n2;
        int returnMessage = -1;
        if (this.customMessageHandler != null) {
            returnMessage = this.customMessageHandler.requestConfirm(new Object[]{file, String.valueOf(yesToAllPresent)});
        }
        if (returnMessage != -1) {
            return returnMessage;
        }
        if (yesToAllPresent) {
            Object[] buttonRowObjects = new Object[]{Messages.getMessage("PdfViewerConfirmButton.Yes"), Messages.getMessage("PdfViewerConfirmButton.YesToAll"), Messages.getMessage("PdfViewerConfirmButton.No"), Messages.getMessage("PdfViewerConfirmButton.Cancel")};
            n2 = JOptionPane.showOptionDialog(this.frame, file + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Overwrite"), -1, 3, null, buttonRowObjects, buttonRowObjects[0]);
        } else {
            n2 = JOptionPane.showOptionDialog(this.frame, file + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Overwrite"), 0, 3, null, null, null);
        }
        return n2;
    }

    public void showMessageDialog(Object info) {
        boolean showMessage;
        boolean bl2 = showMessage = this.customMessageHandler == null || this.customMessageHandler.showMessage(info);
        if (showMessage) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.frame, info));
        }
    }

    public void showFirstTimePopup() {
        boolean showMessage;
        boolean bl2 = showMessage = this.customMessageHandler == null || this.customMessageHandler.showMessage("first time popup");
        if (!showMessage) {
            return;
        }
        try {
            final JPanel a10 = new JPanel();
            a10.setLayout(new BoxLayout(a10, 1));
            MouseAdapter supportListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e2) {
                    if (GUIDisplay.allowChangeCursor) {
                        a10.setCursor(new Cursor(12));
                    }
                }

                @Override
                public void mouseExited(MouseEvent e2) {
                    if (GUIDisplay.allowChangeCursor) {
                        a10.setCursor(new Cursor(0));
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e2) {
                    try {
                        Desktop.getDesktop().browse(new URI(Messages.getMessage("PdfViewer.SupportLink.Link")));
                    }
                    catch (Exception e1) {
                        SwingGUI.this.showMessageDialog(e1.getMessage() + ' ' + Messages.getMessage("PdfViewer.ErrorWebsite"));
                    }
                }
            };
            JLabel img = new JLabel(new ImageIcon(this.getClass().getResource("/org/jpedal/examples/viewer/res/supportScreenshot.png")));
            img.setBorder(BorderFactory.createRaisedBevelBorder());
            img.setAlignmentX(0.5f);
            img.addMouseListener(supportListener);
            a10.add(img);
            JLabel supportLink = new JLabel("<html><center><u>" + Messages.getMessage("PdfViewer.SupportLink.Text1") + ' ' + Messages.getMessage("PdfViewer.SupportLink.Text2") + "</u></html>");
            supportLink.setMaximumSize(new Dimension(245, 60));
            supportLink.setForeground(Color.BLUE);
            supportLink.addMouseListener(supportListener);
            supportLink.setAlignmentX(0.5f);
            a10.add(supportLink);
            a10.add(Box.createRigidArea(new Dimension(10, 10)));
            JOptionPane.showMessageDialog(this.frame, a10, Messages.getMessage("PdfViewerTitle.RunningFirstTime"), -1);
        }
        catch (Error | Exception e2) {
            System.err.println(Messages.getMessage("PdfViewerFirstRunDialog.Error") + ' ' + e2);
        }
    }

    public int showConfirmDialog(Object message, String title, int optionType, int messageType) {
        int returnMessage = -1;
        if (this.customMessageHandler != null) {
            returnMessage = this.customMessageHandler.requestConfirm(new Object[]{message, title, String.valueOf(optionType), String.valueOf(messageType)});
        }
        if (returnMessage == -1) {
            return JOptionPane.showConfirmDialog(this.frame, message, title, optionType, messageType);
        }
        return returnMessage;
    }

    public void setDownloadProgress(String message, int percentage) {
        this.downloadBar.setProgress(message, percentage);
        this.setMultibox(new int[0]);
    }

    public void updateStatusMessage(String message) {
        this.statusBar.updateStatus(message, 0);
    }

    public void resetStatusMessage(String message) {
        this.statusBar.resetStatus(message);
    }

    public void setStatusProgress(int size) {
        this.statusBar.setProgress(size);
        this.setMultibox(new int[0]);
    }

    public int getSplitDividerLocation() {
        return this.displayPane.getDividerLocation();
    }

    public PrintPanel printDialog(String[] printersList, String defaultPrinter) {
        JDialog printDialog = new JDialog((Frame)null, Messages.getMessage("PdfViewerLabel.Printer"), true);
        printDialog.setDefaultCloseOperation(2);
        String propValue = this.properties.getValue("defaultDPI");
        int defaultDPI = -1;
        if (propValue != null && !propValue.isEmpty()) {
            try {
                propValue = propValue.replaceAll("[^0-9]", "");
                defaultDPI = Integer.parseInt(propValue);
            }
            catch (NumberFormatException e2) {
                LogWriter.writeLog("Caught an Exception " + e2);
            }
        }
        if (this.printPanel == null) {
            this.printPanel = new PrintPanel(printersList, defaultPrinter, this.getPaperSizes(), defaultDPI, this.commonValues.getCurrentPage(), this.decode_pdf);
        } else {
            this.printPanel.resetDefaults(printersList, defaultPrinter, this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
        }
        printDialog.getContentPane().add(this.printPanel);
        printDialog.setSize(670, 415);
        printDialog.setResizable(false);
        printDialog.setLocationRelativeTo(this.frame);
        printDialog.setName("printDialog");
        printDialog.setVisible(true);
        printDialog.remove(this.printPanel);
        return this.printPanel;
    }

    public PaperSizes getPaperSizes() {
        if (this.paperSizes == null) {
            this.paperSizes = new PaperSizes(this.properties.getValue("defaultPagesize"));
        }
        return this.paperSizes;
    }

    private void setThumbnails() {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                if (SwingGUI.this.thumbnails.isShownOnscreen()) {
                    SwingGUI.this.setupThumbnailPanel();
                    SwingGUI.this.thumbnails.generateOtherVisibleThumbnails(SwingGUI.this.commonValues.getCurrentPage());
                }
                return null;
            }
        };
        worker.start();
    }

    public void setSearchText(Object searchText) {
        this.searchText = (JTextField)searchText;
    }

    public void setResults(SearchList results) {
        if (this.searchInMenu && results.getResultCount() == 0) {
            this.showMessageDialog(Messages.getMessage("PdfViewerFileMenuFind.noResultText") + " \"" + results.getSearchTerm() + '\"', Messages.getMessage("PdfViewerFileMenuFind.noResultTitle"), 1);
        }
    }

    public JTabbedPane getSideTabBar() {
        return this.navOptionsPanel;
    }

    private void enableSearchItems(boolean enabled) {
        if (this.searchInMenu) {
            this.searchText.setEnabled(enabled);
            this.options.setEnabled(enabled);
            this.swButtons.getButton(19).setEnabled(false);
            this.swButtons.getButton(18).setEnabled(false);
        } else if (this.swButtons.getButton(12) != null) {
            this.swButtons.getButton(12).setEnabled(enabled);
        }
    }

    private void removeSearchWindow() {
        this.searchFrame.removeSearchWindow(false);
    }

    public void alterProperty(String value, boolean set) {
        GUIModifier.alterProperty(value, set, this);
    }

    /*
     * WARNING - void declaration
     */
    public void dispose() {
        int n2;
        JTree disposeTree;
        for (AWTEventListener aWTEventListener : Toolkit.getDefaultToolkit().getAWTEventListeners()) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(aWTEventListener);
        }
        for (EventListener eventListener : this.frame.getComponentListeners()) {
            this.frame.removeComponentListener((ComponentListener)eventListener);
        }
        if (this.options != null) {
            for (EventListener eventListener : this.options.getItemListeners()) {
                this.options.removeItemListener((ItemListener)eventListener);
            }
        }
        if (this.menu != null) {
            for (EventListener eventListener : this.menu.getPopupMenuListeners()) {
                this.menu.removePopupMenuListener((PopupMenuListener)eventListener);
            }
            this.menu.removeAll();
        }
        this.thumbnails.removeAllListeners();
        this.thumbnails.dispose();
        if (this.scrollListener != null) {
            this.scrollListener.dispose();
        }
        this.mouseHandler.dispose();
        if (this.navButtons != null) {
            this.navButtons.removeAll();
        }
        this.menuItems.dispose();
        if (this.coords != null) {
            this.coords.removeAll();
        }
        if (this.navOptionsPanel != null) {
            SwingGUI.disposeNavOptions(this.navOptionsPanel);
        }
        if (this.thumbscroll != null) {
            SwingGUI.disposeThumbnailScroll(this.thumbscroll);
        }
        if (this.scrollPane != null) {
            SwingGUI.disposeScrollPane(this.scrollPane);
        }
        if (this.signaturesTree != null) {
            this.signaturesTree.setCellRenderer(null);
            this.signaturesTree.removeAll();
        }
        if (this.layersPanel != null) {
            this.layersPanel.removeAll();
        }
        if (this.annotationsPanel != null) {
            this.annotationsPanel.dispose();
        }
        this.searchFrame.dispose();
        if (this.navToolBar != null) {
            SwingGUI.disposeNavToolBar(this.navToolBar);
        }
        if (this.pagesToolBar != null) {
            SwingGUI.disposePageToolBar(this.pagesToolBar);
        }
        if (this.memoryMonitor != null) {
            this.disposeMemoryMonitor();
        }
        if (this.viewListener != null) {
            this.viewListener.dispose();
        }
        this.removeSearchWindow();
        this.swButtons.dispose();
        if (this.displayPane != null) {
            this.disposeDisplayPane();
        }
        if (this.attachmentsPanel != null) {
            this.attachmentsPanel.dispose();
            this.attachmentsPanel = null;
        }
        if ((disposeTree = this.tree.getTree()) != null) {
            SwingGUI.disposeTree(disposeTree);
        }
        this.removePageListener();
        SwingGUI.removeGUIListeners((Component)((Object)this.decode_pdf));
        if (this.glassPane != null) {
            SwingGUI.removeGUIListeners(this.glassPane);
            this.glassPane.removeAll();
        }
        this.disposeFrame();
        if (this.lpane != null) {
            void var4_16;
            void var4_14;
            EventListener[] eventListenerArray = this.lpane.getPropertyChangeListeners();
            n2 = eventListenerArray.length;
            boolean bl2 = false;
            while (var4_14 < n2) {
                PropertyChangeListener propertyChangeListener = eventListenerArray[var4_14];
                this.lpane.removePropertyChangeListener(propertyChangeListener);
                ++var4_14;
            }
            eventListenerArray = this.lpane.getComponentListeners();
            n2 = eventListenerArray.length;
            boolean bl3 = false;
            while (var4_16 < n2) {
                EventListener eventListener = eventListenerArray[var4_16];
                this.lpane.removeComponentListener((ComponentListener)eventListener);
                ++var4_16;
            }
            this.lpane.removeAll();
        }
        if (this.containerForThumbnails != null) {
            void var4_18;
            PropertyChangeListener[] propertyChangeListenerArray = this.containerForThumbnails.getPropertyChangeListeners();
            n2 = propertyChangeListenerArray.length;
            boolean bl4 = false;
            while (var4_18 < n2) {
                PropertyChangeListener propertyChangeListener = propertyChangeListenerArray[var4_18];
                this.containerForThumbnails.removePropertyChangeListener(propertyChangeListener);
                ++var4_18;
            }
            this.containerForThumbnails.removeAll();
        }
        if (this.frame != null) {
            this.frame.removeAll();
        }
        this.decode_pdf.closePdfFile();
        this.decode_pdf.dispose();
        ((Container)((Object)this.decode_pdf)).removeAll();
        this.setGlobalVariablesToNull();
        this.tree = null;
        this.scalingFloatValues = null;
        this.rotationBox = null;
        this.scalingBox = null;
    }

    private void setGlobalVariablesToNull() {
        this.options = null;
        this.menu = null;
        this.scrollListener = null;
        this.mouseHandler = null;
        this.pageTitle = null;
        this.bookmarksTitle = null;
        this.signaturesTitle = null;
        this.layersTitle = null;
        this.annotationTitle = null;
        this.attachmentsTitle = null;
        this.currentCommandListener = null;
        this.navButtons = null;
        this.coords = null;
        this.navOptionsPanel = null;
        this.thumbscroll = null;
        this.scrollPane = null;
        this.textFont = null;
        this.statusBar = null;
        this.downloadBar = null;
        this.pageCounter2 = null;
        this.pageCounter3 = null;
        this.signaturesTree = null;
        this.layersPanel = null;
        this.annotationsPanel = null;
        this.searchFrame = null;
        this.navToolBar = null;
        this.pagesToolBar = null;
        this.layersObject = null;
        this.viewListener = null;
        this.glassPane = null;
        this.frame = null;
        this.portfolioParent = null;
        this.decode_pdf = null;
    }

    private static void disposePageToolBar(JToolBar toolBar) {
        for (MouseListener mouseListener : toolBar.getMouseListeners()) {
            toolBar.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : toolBar.getMouseMotionListeners()) {
            toolBar.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        toolBar.removeAll();
    }

    private static void disposeNavToolBar(JToolBar navBar) {
        Component[] comps;
        for (Component comp : comps = navBar.getComponents()) {
            for (PropertyChangeListener propertyChangeListener : comp.getPropertyChangeListeners()) {
                comp.removePropertyChangeListener(propertyChangeListener);
            }
            for (EventListener eventListener : comp.getComponentListeners()) {
                comp.removeComponentListener((ComponentListener)eventListener);
            }
        }
        navBar.removeAll();
    }

    private static void disposeScrollPane(JScrollPane scrollPane) {
        for (PropertyChangeListener propertyChangeListener : scrollPane.getPropertyChangeListeners()) {
            scrollPane.removePropertyChangeListener(propertyChangeListener);
        }
        for (EventListener eventListener : scrollPane.getMouseWheelListeners()) {
            scrollPane.removeMouseWheelListener((MouseWheelListener)eventListener);
        }
        for (EventListener eventListener : scrollPane.getMouseMotionListeners()) {
            scrollPane.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        for (EventListener eventListener : scrollPane.getFocusListeners()) {
            scrollPane.removeFocusListener((FocusListener)eventListener);
        }
        scrollPane.removeAll();
    }

    private static void disposeNavOptions(JTabbedPane navOptions) {
        for (MouseListener mouseListener : navOptions.getMouseListeners()) {
            navOptions.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : navOptions.getChangeListeners()) {
            navOptions.removeChangeListener((ChangeListener)eventListener);
        }
        navOptions.removeAll();
    }

    private static void disposeThumbnailScroll(JScrollBar thumbnailScroll) {
        for (MouseListener mouseListener : thumbnailScroll.getMouseListeners()) {
            thumbnailScroll.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : thumbnailScroll.getPropertyChangeListeners()) {
            thumbnailScroll.removePropertyChangeListener((PropertyChangeListener)eventListener);
        }
        thumbnailScroll.removeAll();
    }

    private void disposeMemoryMonitor() {
        this.memoryMonitor.stop();
        ActionListener[] al2 = this.memoryMonitor.getActionListeners();
        for (int i2 = 0; i2 != al2.length; ++i2) {
            this.memoryMonitor.removeActionListener(al2[i2]);
        }
    }

    private void disposeFrame() {
        if (this.frame instanceof JFrame) {
            JFrame disposeFrame = (JFrame)this.frame;
            for (ComponentListener listener : disposeFrame.getComponentListeners()) {
                disposeFrame.removeComponentListener(listener);
            }
        } else {
            Container disposeComp = this.frame;
            for (ComponentListener listener : disposeComp.getComponentListeners()) {
                disposeComp.removeComponentListener(listener);
            }
        }
    }

    private static void removeGUIListeners(Component comp) {
        for (KeyListener keyListener : comp.getKeyListeners()) {
            comp.removeKeyListener(keyListener);
        }
        for (EventListener eventListener : comp.getMouseListeners()) {
            comp.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : comp.getMouseWheelListeners()) {
            comp.removeMouseWheelListener((MouseWheelListener)eventListener);
        }
        for (EventListener eventListener : comp.getMouseMotionListeners()) {
            comp.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
    }

    private static void disposeTree(JTree disposeTree) {
        for (MouseListener mouseListener : disposeTree.getMouseListeners()) {
            disposeTree.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : disposeTree.getKeyListeners()) {
            disposeTree.removeKeyListener((KeyListener)eventListener);
        }
        disposeTree.removeAll();
    }

    private void disposeDisplayPane() {
        for (PropertyChangeListener propertyChangeListener : this.displayPane.getPropertyChangeListeners()) {
            this.displayPane.removePropertyChangeListener(propertyChangeListener);
        }
        for (EventListener eventListener : this.displayPane.getMouseListeners()) {
            this.displayPane.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : this.displayPane.getComponentListeners()) {
            this.displayPane.removeComponentListener((ComponentListener)eventListener);
        }
        this.displayPane.removeAll();
    }

    public boolean getPageTurnScalingAppropriate() {
        return this.pageTurnScalingAppropriate;
    }

    public SwingCursor getGUICursor() {
        return this.guiCursor;
    }

    public String getTitles(String title) {
        if (title.equals(this.pageTitle)) {
            return this.pageTitle;
        }
        if (title.equals(this.bookmarksTitle)) {
            return this.bookmarksTitle;
        }
        if (title.equals(this.signaturesTitle)) {
            return this.signaturesTitle;
        }
        if (title.equals(this.layersTitle)) {
            return this.layersTitle;
        }
        if (title.equals(this.annotationTitle)) {
            return this.annotationTitle;
        }
        if (title.equals(this.attachmentsTitle)) {
            return this.attachmentsTitle;
        }
        return null;
    }

    public Buttons getButtons() {
        return this.swButtons;
    }

    private void setViewerIcon() {
        URL path;
        if (this.frame instanceof JFrame && (path = this.guiCursor.getURLForImage("icon.png")) != null) {
            try {
                BufferedImage fontIcon = JDeli.read(path.openStream());
                ((Window)this.frame).setIconImage(fontIcon);
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception attempting to set icon " + e2);
            }
        }
    }

    public SwingMenuItems getMenuItems() {
        return this.menuItems;
    }

    public void decodePage() {
        if (SwingAnnotationPanel.addPanel()) {
            this.annotationsPanel.getAnnotationListener().setFormMode(SwingAnnotationPanel.FORMMODE.CREATION);
        }
        if (this.thumbscroll != null) {
            this.setThumbnailScrollBarValue(this.commonValues.getCurrentPage() - 1);
        }
        this.decodeGUIPage();
    }

    public PdfDecoder getPdfDecoder() {
        return (PdfDecoder)this.decode_pdf;
    }

    private void addComboListenerAndLabel(SwingCombo combo) {
        combo.addActionListener(this.currentCommandListener);
    }

    private void addGUIComboBoxes(SwingCombo combo) {
        this.swButtons.getTopButtons().add(combo);
    }

    private void setupCenterPanelBackground() {
        String propValue = this.properties.getValue("replacePdfDisplayBackground");
        Color background = new Color(190, 190, 190);
        if (!propValue.isEmpty() && "true".equalsIgnoreCase(propValue)) {
            propValue = this.properties.getValue("pdfDisplayBackground");
            if (!propValue.isEmpty()) {
                this.currentCommands.executeCommand(ViewerCommands.SETDISPLAYBACKGROUND, new Object[]{Integer.parseInt(propValue)});
            }
            background = new Color(Integer.parseInt(propValue));
        } else if (this.decode_pdf.getDecoderOptions().getDisplayBackgroundColor() != null) {
            background = this.decode_pdf.getDecoderOptions().getDisplayBackgroundColor();
        } else if (this.decode_pdf.useNewGraphicsMode()) {
            background = new Color(55, 55, 65);
        }
        ((Component)((Object)this.decode_pdf)).setBackground(background);
        this.frame.setBackground(background);
    }

    private void setupComboBoxes() {
        String[] rotationValues = new String[]{"0", "90", "180", "270"};
        String[] scalingValues = new String[]{Messages.getMessage("PdfViewerScaleWindow.text"), Messages.getMessage("PdfViewerScaleHeight.text"), Messages.getMessage("PdfViewerScaleWidth.text"), "25%", "50%", "75%", "100%", "125%", "150%", "200%", "250%", "500%", "750%", "1000%"};
        String choosenScaling = System.getProperty("org.jpedal.defaultViewerScaling");
        if (choosenScaling == null) {
            choosenScaling = this.properties.getValue("startScaling");
        }
        if (choosenScaling != null) {
            int total = scalingValues.length;
            for (int aa2 = 0; aa2 < total; ++aa2) {
                if (!scalingValues[aa2].equals(choosenScaling)) continue;
                defaultSelection = aa2;
                aa2 = total;
            }
        }
        this.scalingBox = new SwingCombo(scalingValues);
        this.scalingBox.setEditable(true);
        this.scalingBox.setSelectedIndex(defaultSelection);
        this.rotationBox = new SwingCombo(rotationValues);
        this.rotationBox.setSelectedIndex(0);
    }

    private void setupKeyboardControl() {
        ((Component)((Object)this.decode_pdf)).addKeyListener(new KeyAdapter(){
            int count;
            int pageChange;
            java.util.Timer t2;

            @Override
            public void keyPressed(KeyEvent e2) {
                final JScrollBar scroll = SwingGUI.this.scrollPane.getVerticalScrollBar();
                int keyPressed = e2.getKeyCode();
                if (keyPressed == 37 || keyPressed == 39) {
                    if (SwingGUI.this.scrollPane.getWidth() > ((Component)((Object)SwingGUI.this.decode_pdf)).getWidth()) {
                        this.pageChange = keyPressed == 37 ? --this.pageChange : ++this.pageChange;
                    }
                } else if ((keyPressed == 38 || keyPressed == 40) && this.count == 0) {
                    if (keyPressed == 38 && scroll.getValue() == scroll.getMinimum() && SwingGUI.this.commonValues.getCurrentPage() > 1) {
                        --this.pageChange;
                    } else if (keyPressed == 40 && (scroll.getValue() == scroll.getMaximum() - scroll.getHeight() || scroll.getHeight() == 0) && SwingGUI.this.commonValues.getCurrentPage() < SwingGUI.this.decode_pdf.getPageCount()) {
                        ++this.pageChange;
                    }
                }
                ++this.count;
                if (this.pageChange != 0) {
                    if (this.t2 != null) {
                        this.t2.cancel();
                    }
                    TimerTask t2 = new TimerTask(){

                        @Override
                        public void run() {
                            int p2 = SwingGUI.this.commonValues.getCurrentPage() + pageChange;
                            if (p2 < 1) {
                                p2 = 1;
                            } else if (p2 > SwingGUI.this.decode_pdf.getPageCount()) {
                                p2 = SwingGUI.this.decode_pdf.getPageCount();
                            }
                            if (p2 != SwingGUI.this.commonValues.getCurrentPage()) {
                                String page = String.valueOf(p2);
                                SwingUtilities.invokeLater(() -> {
                                    SwingGUI.this.currentCommands.executeCommand(ViewerCommands.GOTO, new Object[]{page});
                                    if (scroll.getValue() == scroll.getMinimum() && SwingGUI.this.commonValues.getCurrentPage() > 1) {
                                        scroll.setValue(scroll.getMaximum());
                                    } else if ((scroll.getValue() == scroll.getMaximum() - scroll.getHeight() || scroll.getHeight() == 0) && SwingGUI.this.commonValues.getCurrentPage() < SwingGUI.this.decode_pdf.getPageCount()) {
                                        scroll.setValue(scroll.getMinimum());
                                    }
                                });
                            }
                            pageChange = 0;
                            if (t2 != null) {
                                t2.cancel();
                            }
                        }
                    };
                    this.t2 = new java.util.Timer();
                    this.t2.schedule(t2, 500L);
                }
            }

            @Override
            public void keyReleased(KeyEvent e2) {
                this.count = 0;
            }
        });
    }

    private void setupPDFDisplayPane() {
        if (SwingAnnotationPanel.addPanel()) {
            this.glassPane = new JPanel();
            this.glassPane.setLayout(null);
            this.glassPane.setOpaque(false);
            this.lpane.add(this.scrollPane, 0, 0);
            this.lpane.add(this.glassPane, 1, 1);
        }
        this.thumbscroll = new JScrollBar(1, 0, 1, 0, 1);
        this.thumbscroll.setName("ThumbnailScroll");
        if (this.scrollListener == null) {
            this.scrollListener = new SwingScrollListener(this, "true".equalsIgnoreCase(this.properties.getValue("previewOnSingleScroll")));
        }
        this.thumbscroll.addAdjustmentListener(this.scrollListener);
        this.thumbscroll.addMouseListener(this.scrollListener);
        this.containerForThumbnails.setLayout(new BorderLayout());
        this.containerForThumbnails.add((Component)this.thumbscroll, "East");
        this.scrollPane.getViewport().add((Component)((Object)this.decode_pdf));
        if (SwingAnnotationPanel.addPanel()) {
            this.containerForThumbnails.add((Component)this.lpane, "Center");
        } else {
            this.containerForThumbnails.add((Component)this.scrollPane, "Center");
        }
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(80);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(80);
        this.setupKeyboardControl();
    }

    private void setupBorderPanes() {
        String propValue;
        this.navOptionsPanel.setTabPlacement(2);
        this.navOptionsPanel.setOpaque(true);
        this.navOptionsPanel.setMinimumSize(new Dimension(collapsedSize, 100));
        this.navOptionsPanel.setName("NavPanel");
        this.navOptionsPanel.setFocusable(false);
        this.setupSidebarTitles();
        this.displayPane = new JSplitPane(1, this.navOptionsPanel, this.containerForThumbnails);
        this.displayPane.setOneTouchExpandable(false);
        this.displayPane.addPropertyChangeListener("dividerLocation", e2 -> {
            this.scrollPane.getViewport().setSize(this.scrollPane.getViewport().getWidth() + (Integer)e2.getOldValue() - (Integer)e2.getNewValue(), this.scrollPane.getViewport().getHeight());
            int dividerPos = (Integer)e2.getNewValue();
            if (this.tabsExpanded && dividerPos > collapsedSize) {
                expandedSize = dividerPos;
            }
            this.scaleAndRotate();
        });
        if (DecoderOptions.isRunningOnMac && UIManager.getLookAndFeel().isNativeLookAndFeel()) {
            this.navOptionsPanel.addTab(this.pageTitle, this.thumbnails);
            this.navOptionsPanel.setTitleAt(this.navOptionsPanel.getTabCount() - 1, this.pageTitle);
            if (this.thumbnails.isShownOnscreen()) {
                this.navOptionsPanel.addTab(this.bookmarksTitle, this.tree);
                this.navOptionsPanel.setTitleAt(this.navOptionsPanel.getTabCount() - 1, this.bookmarksTitle);
            }
        } else {
            this.tree.setBorder(null);
            this.thumbnails.setBorder(null);
            if (this.thumbnails.isShownOnscreen()) {
                VTextIcon textIcon1 = new VTextIcon(this.navOptionsPanel, this.pageTitle);
                this.navOptionsPanel.addTab(null, textIcon1, this.thumbnails);
            }
            VTextIcon textIcon2 = new VTextIcon(this.navOptionsPanel, this.bookmarksTitle);
            this.navOptionsPanel.addTab(null, textIcon2, this.tree);
        }
        if (!(propValue = this.properties.getValue("startSideTabOpen")).isEmpty()) {
            this.sideTabBarOpenByDefault = "true".equalsIgnoreCase(propValue);
        }
        if (!(propValue = this.properties.getValue("startSelectedSideTab")).isEmpty()) {
            this.startSelectedTab = propValue;
        }
        if (!this.hasListener) {
            this.hasListener = true;
            this.navOptionsPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    SwingGUI.this.handleTabbedPanes();
                }
            });
        }
    }

    private void setupBottomToolBarItems() {
        this.pageCounter2.setEditable(true);
        this.pageCounter2.setToolTipText(Messages.getMessage("PdfViewerTooltip.goto"));
        this.pageCounter2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), this.pageCounter2.getBorder()));
        this.pageCounter2.setColumns(2);
        this.pageCounter2.setMaximumSize(this.pageCounter2.getPreferredSize());
        this.pageCounter2.addActionListener(arg0 -> {
            PageLabels pageLabels;
            String value = this.pageCounter2.getText().trim();
            PdfObjectReader reader = this.decode_pdf.getIO();
            if (reader != null && (pageLabels = reader.getPageLabels()) != null && pageLabels.containsValue(value)) {
                Set entries = pageLabels.entrySet();
                for (Map.Entry e2 : entries) {
                    if (!((String)e2.getValue()).equals(value)) continue;
                    value = ((Integer)e2.getKey()).toString();
                    break;
                }
            }
            this.currentCommands.executeCommand(ViewerCommands.GOTO, new Object[]{value});
        });
        this.pageCounter2.setHorizontalAlignment(0);
        this.setPageNumber();
        this.pageCounter3 = new JLabel(Messages.getMessage("PdfViewerOfLabel.text") + ' ');
        this.pageCounter3.setOpaque(false);
        this.navToolBar.setLayout(new BoxLayout(this.navToolBar, 2));
        this.navToolBar.setFloatable(false);
        this.pagesToolBar.setFloatable(false);
        this.navButtons.setBorder(BorderFactory.createEmptyBorder());
        this.navButtons.setLayout(new BorderLayout());
        this.navButtons.setFloatable(false);
        this.navButtons.setPreferredSize(new Dimension(5, 24));
    }

    private void setupPDFBorder() {
        if (this.decode_pdf.useNewGraphicsMode()) {
            this.decode_pdf.setPDFBorder(new AbstractBorder(){

                @Override
                public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
                    Graphics2D g22 = (Graphics2D)g2;
                    int cornerDepth = 6;
                    g22.setPaint(new GradientPaint(x2, 0.0f, SwingGUI.this.glowOuterColor, x2 + 11, 0.0f, SwingGUI.this.glowInnerColor));
                    g22.fillRect(x2, y2 + 11, 11, height - 22);
                    g22.setPaint(new GradientPaint(x2 - 6 + 11, y2 + height + 6 - 11, SwingGUI.this.glowOuterColor, x2 + 11, y2 + height - 11, SwingGUI.this.glowInnerColor));
                    g22.fillRect(x2, y2 + height - 11, 11, 11);
                    g22.setPaint(new GradientPaint(0.0f, y2 + height, SwingGUI.this.glowOuterColor, 0.0f, y2 + height - 11, SwingGUI.this.glowInnerColor));
                    g22.fillRect(x2 + 11, y2 + height - 11, width - 22, 11);
                    g22.setPaint(new GradientPaint(x2 + width + 6 - 11, y2 + height + 6 - 11, SwingGUI.this.glowOuterColor, x2 + width - 11, y2 + height - 11, SwingGUI.this.glowInnerColor));
                    g22.fillRect(x2 + width - 11, y2 + height - 11, 11, 11);
                    g22.setPaint(new GradientPaint(x2 + width, 0.0f, SwingGUI.this.glowOuterColor, x2 + width - 11, 0.0f, SwingGUI.this.glowInnerColor));
                    g22.fillRect(x2 + width - 11, y2 + 11, 11, height - 22);
                    g22.setPaint(new GradientPaint(x2 + width - 11 + 6, y2 + 11 - 6, SwingGUI.this.glowOuterColor, x2 + width - 11, y2 + 11, SwingGUI.this.glowInnerColor));
                    g22.fillRect(x2 + width - 11, y2, 11, 11);
                    g22.setPaint(new GradientPaint(0.0f, y2, SwingGUI.this.glowOuterColor, 0.0f, y2 + 11, SwingGUI.this.glowInnerColor));
                    g22.fillRect(x2 + 11, y2, width - 22, 11);
                    g22.setPaint(new GradientPaint(x2 - 6 + 11, y2 - 6 + 11, SwingGUI.this.glowOuterColor, x2 + 11, y2 + 11, SwingGUI.this.glowInnerColor));
                    g22.fillRect(x2, y2, 11, 11);
                    g22.setPaint(Color.black);
                    g22.drawRect(x2 + 11, y2 + 11, width - 22, height - 22);
                }

                @Override
                public Insets getBorderInsets(Component c2, Insets insets) {
                    insets.set(11, 11, 11, 11);
                    return insets;
                }
            });
        } else {
            this.decode_pdf.setPDFBorder(BorderFactory.createLineBorder(Color.black, 1));
        }
    }

    private void createTopMenuBar() {
        this.top.setLayout(new BorderLayout());
        if (this.frame instanceof JFrame) {
            ((RootPaneContainer)((Object)this.frame)).getContentPane().add((Component)this.top, "North");
        } else {
            this.frame.add((Component)this.top, "North");
        }
    }

    private void redrawDocumentOnResize() {
        this.frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                if (((Component)((Object)SwingGUI.this.decode_pdf)).getParent() != null && (SwingGUI.this.getSelectedComboIndex(252) < 3 || SwingGUI.this.decode_pdf.getDisplayView() == 4)) {
                    SwingGUI.this.scaleAndRotate();
                }
            }
        });
    }

    private void createMainViewerWindow(int width, int height) {
        if (this.frame instanceof JFrame) {
            this.frame.setSize(width, height);
            ((Window)this.frame).setLocationRelativeTo(null);
            ((JFrame)this.frame).setDefaultCloseOperation(0);
            ((Window)this.frame).addWindowListener(new FrameCloser(this.currentCommands, this, this.decode_pdf, this.thumbnails, this.commonValues, this.properties));
            this.frame.setVisible(true);
        }
    }

    public RecentDocuments getRecentDocument() {
        if (this.recent == null) {
            this.recent = new RecentDocuments(PropertiesFile.getNoRecentDocumentsToDisplay());
        }
        return this.recent;
    }

    public void setRecentDocument() {
        this.recent = new RecentDocuments(PropertiesFile.getNoRecentDocumentsToDisplay());
    }

    public void openFile(String fileToOpen) {
        if (fileToOpen != null) {
            OpenFile.open(fileToOpen, this.commonValues, this.searchFrame, this, this.decode_pdf, this.properties, this.thumbnails);
        }
    }

    public void open(String fileName) {
        OpenFile.open(fileName, this.commonValues, this.searchFrame, this, this.decode_pdf, this.properties, this.thumbnails);
    }

    public void enablePageCounter(PageCounter value, boolean enabled, boolean visibility) {
        switch (value) {
            case PAGECOUNTER1: {
                this.pageCounter1.setVisible(visibility);
                this.pageCounter1.setEnabled(enabled);
                break;
            }
            case PAGECOUNTER2: {
                this.pageCounter2.setVisible(visibility);
                this.pageCounter2.setEnabled(enabled);
                break;
            }
            case PAGECOUNTER3: {
                this.pageCounter3.setVisible(visibility);
                this.pageCounter3.setEnabled(enabled);
                break;
            }
            case ALL: {
                this.pageCounter1.setVisible(visibility);
                this.pageCounter1.setEnabled(enabled);
                this.pageCounter2.setVisible(visibility);
                this.pageCounter2.setEnabled(enabled);
                this.pageCounter3.setVisible(visibility);
                this.pageCounter3.setEnabled(enabled);
                break;
            }
            default: {
                System.out.println("No Value detected, please choose from Enum PageCounter in GUI.java");
            }
        }
    }

    public void setPageCounterText(PageCounter value, String text) {
        switch (value) {
            case PAGECOUNTER1: {
                this.pageCounter1.setText(text);
                break;
            }
            case PAGECOUNTER2: {
                this.pageCounter2.setText(text);
                break;
            }
            case PAGECOUNTER3: {
                this.pageCounter3.setText(text);
                break;
            }
            default: {
                System.out.println("No Value detected, please choose from Enum PageCounter in GUI.java");
            }
        }
    }

    public Object getPageCounter(PageCounter value) {
        switch (value) {
            case PAGECOUNTER1: {
                return this.pageCounter1;
            }
            case PAGECOUNTER2: {
                return this.pageCounter2;
            }
            case PAGECOUNTER3: {
                return this.pageCounter3;
            }
        }
        System.out.println("No Value detected, please choose from Enum PageCounter in GUI.java");
        return 0;
    }

    public void updateTextBoxSize() {
        int col = String.valueOf(this.commonValues.getPageCount()).length();
        if (this.decode_pdf.getIO().getPageLabels() != null) {
            Collection values = this.decode_pdf.getIO().getPageLabels().values();
            for (String value : values) {
                int length = value.length();
                if (col >= length) continue;
                col = length;
            }
        }
        if (this.decode_pdf.getDisplayView() == 4 || this.decode_pdf.getDisplayView() == 3) {
            col *= 2;
        }
        if (col < 2) {
            col = 2;
        }
        this.pageCounter2.setColumns(col);
        this.pageCounter2.setMaximumSize(this.pageCounter2.getPreferredSize());
        this.navToolBar.invalidate();
        this.navToolBar.doLayout();
    }

    public void enableCursor(boolean enabled, boolean visible) {
        this.cursor.setEnabled(enabled);
        this.cursor.setVisible(visible);
    }

    public void enableMemoryBar(boolean enabled, boolean visible) {
        this.multibox.setEnabled(enabled);
        this.multibox.setVisible(visible);
    }

    public void enableNavigationBar(boolean enabled, boolean visible) {
        this.navButtons.setEnabled(enabled);
        this.navButtons.setVisible(visible);
    }

    public void enableDownloadBar(boolean enabled, boolean visible) {
        this.downloadBar.setEnabled(enabled);
        this.downloadBar.setVisible(visible);
    }

    public int getSidebarTabCount() {
        return this.navOptionsPanel.getTabCount();
    }

    public String getSidebarTabTitleAt(int pos) {
        if (this.navOptionsPanel.getIconAt(pos) != null) {
            return this.navOptionsPanel.getIconAt(pos).toString();
        }
        return "";
    }

    public void removeSidebarTabAt(int pos) {
        this.navOptionsPanel.remove(pos);
    }

    private double getDividerLocation() {
        return this.displayPane.getDividerLocation();
    }

    public float scaleToVisible(float left, float right, float top, float bottom) {
        float heightScaling;
        float widthScaling;
        float width = this.scrollPane.getViewport().getWidth() - inset - inset;
        float height = this.scrollPane.getViewport().getHeight() - inset - inset;
        if (this.displayPane != null) {
            width -= (float)this.displayPane.getDividerSize();
        }
        if ((widthScaling = (right - left) / width) > (heightScaling = (top - bottom) / height)) {
            return this.decode_pdf.getDPIFactory().adjustScaling(widthScaling);
        }
        return this.decode_pdf.getDPIFactory().adjustScaling(heightScaling);
    }

    public static int getDropShadowDepth() {
        return 11;
    }

    public void setupSplitPaneDivider(int size, boolean visibility) {
        this.displayPane.setDividerSize(size);
        this.displayPane.getLeftComponent().setEnabled(visibility);
        this.displayPane.getLeftComponent().setVisible(visibility);
    }

    private static double getStartSize() {
        return collapsedSize;
    }

    public static void setStartSize(int size) {
        collapsedSize = size;
    }

    public JScrollPane getPageContainer() {
        return this.scrollPane;
    }

    public void enableStatusBar(boolean enabled, boolean visible) {
        this.statusBar.setEnabled(enabled);
        this.statusBar.setVisible(visible);
    }

    public Point convertComponentCoordsToPageCoords(int x2, int y2, int page) {
        return SwingMouseUtils.getCoordsOnPage(x2, y2, page, this.decode_pdf, this, this.commonValues);
    }

    public void setDisplayView(int displayView, int orientation) {
        int lastDisplayView = this.decode_pdf.getDisplayView();
        if (this.decode_pdf.isOpen() && lastDisplayView != displayView) {
            PdfObject collectionObj = this.decode_pdf.getIO().getPDFObject(-2139781200);
            if (displayView == 6 || displayView == 7) {
                if (collectionObj == null) {
                    this.showMessageDialog(Messages.getMessage("PdfPortfolio.nonPortfolioIncorrectDisplay"));
                    return;
                }
                switch (displayView) {
                    case 6: {
                        this.setupDetailPortfolioView();
                        break;
                    }
                    case 7: {
                        this.setupTilePortfolioView();
                    }
                }
            } else if (lastDisplayView == 6 || lastDisplayView == 7) {
                this.setupPdfView();
            }
        }
        if (this.annotationsPanel != null && SwingAnnotationPanel.addPanel()) {
            this.annotationsPanel.getAnnotationListener().setFormMode(SwingAnnotationPanel.FORMMODE.CREATION);
        }
        if (this.viewListener != null) {
            ((Component)((Object)this.decode_pdf)).removeComponentListener(this.viewListener);
            this.viewListener.dispose();
            this.viewListener = null;
        }
        boolean hasChanged = this.setDisplayView2(displayView, orientation);
        int pageNumber = this.decode_pdf.getPageNumber();
        if (pageNumber > 0 && hasChanged) {
            try {
                this.decode_pdf.setPageParameters(this.scaling, pageNumber, this.decode_pdf.getDisplayRotation());
                ((Component)((Object)this.decode_pdf)).invalidate();
                ((JComponent)((Object)this.decode_pdf)).updateUI();
                this.decode_pdf.decodePage(pageNumber);
                if (this.decode_pdf.getDisplayView() == 1) {
                    this.checkTabShown(this.annotationTitle);
                } else {
                    this.removeTab(this.annotationTitle);
                }
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
        this.enableSearchItems(displayView == 1 || displayView == 2 || displayView == 3);
        if (this.viewListener == null) {
            this.viewListener = new RefreshLayout(this.decode_pdf);
            ((Component)((Object)this.decode_pdf)).addComponentListener(this.viewListener);
        }
    }

    public boolean allowScrolling() {
        return this.allowScrolling;
    }

    public boolean confirmClose() {
        return this.confirmClose;
    }

    public void toogleAutoScrolling() {
        this.allowScrolling = !this.allowScrolling;
    }

    public int getRotation() {
        return this.rotation;
    }

    public float getScaling() {
        return this.scaling;
    }

    public Values getValues() {
        return this.commonValues;
    }

    private void addCombo(String tooltip, int ID2) {
        SwingCombo combo = null;
        switch (ID2) {
            case 252: {
                combo = this.scalingBox;
                break;
            }
            case 251: {
                combo = this.rotationBox;
            }
        }
        if (combo != null) {
            combo.setID(ID2);
            if (!tooltip.isEmpty()) {
                combo.setToolTipText(tooltip);
                this.addGUIComboBoxes(combo);
                this.addComboListenerAndLabel(combo);
            }
        }
    }

    public Map<FormObject, String> getHotspots() {
        return Collections.unmodifiableMap(this.objs);
    }

    private void createUniqueAnnotationIcons() {
        if (this.objs == null) {
            this.objs = new HashMap<FormObject, String>();
        } else {
            this.objs.clear();
        }
        ((AnnotationHandler)this.decode_pdf.getExternalHandler(25)).handleAnnotations(this.decode_pdf, this.objs, this.commonValues.getCurrentPage());
    }

    private void setDpi(int dpi) {
        this.decode_pdf.getDPIFactory().setDpi(dpi);
    }

    public int getGlowThickness() {
        return 11;
    }

    public Color getGlowOuterColor() {
        return this.glowOuterColor;
    }

    public Color getGlowInnerColor() {
        return this.glowInnerColor;
    }

    public void setSearchFrame(SwingSearchWindow searchFrame) {
        this.searchFrame = searchFrame;
    }

    private void setRotation() {
        if (this.rotation > 360) {
            this.rotation -= 360;
        }
        if (this.getSelectedComboIndex(251) != this.rotation / 90) {
            this.setSelectedComboIndex(251, this.rotation / 90);
        }
    }

    public int getSelectedComboIndex(int ID2) {
        switch (ID2) {
            case 252: {
                return this.scalingBox.getSelectedIndex();
            }
            case 251: {
                return this.rotationBox.getSelectedIndex();
            }
        }
        return -1;
    }

    public void setSelectedComboIndex(int ID2, int index) {
        switch (ID2) {
            case 252: {
                this.scalingBox.setSelectedIndex(index);
                break;
            }
            case 251: {
                this.rotationBox.setSelectedIndex(index);
            }
        }
    }

    public Object getSelectedComboItem(int ID2) {
        switch (ID2) {
            case 252: {
                return this.scalingBox.getSelectedItem();
            }
            case 251: {
                return this.rotationBox.getSelectedItem();
            }
        }
        return null;
    }

    public void setSelectedComboItem(int ID2, String index) {
        switch (ID2) {
            case 252: {
                if (StringUtils.isNumber(index)) {
                    index = index + '%';
                }
                this.scalingBox.setSelectedItem(index);
                break;
            }
            case 251: {
                this.rotationBox.setSelectedItem(index);
            }
        }
    }

    private void prepareForDecode() {
        this.decode_pdf.getPages().setHighlightedImage(null);
        this.resetRotationBox();
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.terminateDrawing();
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.setupThumbnailPanel();
            LinearThread linearizedBackgroundRenderer = (LinearThread)this.decode_pdf.getJPedalObject(-1276915978);
            if (linearizedBackgroundRenderer != null && !linearizedBackgroundRenderer.isAlive()) {
                this.thumbnails.drawThumbnails();
            }
        }
        if (this.decode_pdf.getDisplayView() == 1) {
            this.setPageCounterText(PageCounter.PAGECOUNTER2, this.getPageLabel(this.commonValues.getCurrentPage()));
            if (this.pageLabelDiffers(this.commonValues.getCurrentPage())) {
                this.setPageCounterText(PageCounter.PAGECOUNTER3, "(" + this.commonValues.getCurrentPage() + ' ' + Messages.getMessage("PdfViewerOfLabel.text") + ' ' + this.commonValues.getPageCount() + ')');
            } else {
                this.setPageCounterText(PageCounter.PAGECOUNTER3, Messages.getMessage("PdfViewerOfLabel.text") + ' ' + this.commonValues.getPageCount());
            }
        }
        this.updateTextBoxSize();
        this.tabsNotInitialised = false;
        this.decode_pdf.setExtractionMode(65);
        this.decode_pdf.getTextLines().clearHighlights();
    }

    private void performDecoding() {
        Values.setProcessing(true);
        this.setCursor(2);
        if (LogWriter.isRunningFromIDE) {
            this.start = System.currentTimeMillis();
        }
        try {
            String status;
            this.statusBar.updateStatus("Decoding Page", 0);
            try {
                String status2;
                this.decode_pdf.decodePage(this.commonValues.getCurrentPage());
                Object errorTracker = this.decode_pdf.getExternalHandler(31);
                if (this.debugMode && errorTracker instanceof LimitDecodeTrackerNoSwing) {
                    ((LimitDecodeTrackerNoSwing)errorTracker).onPageChange();
                }
                this.decode_pdf.waitForDecodingToFinish();
                if (this.decode_pdf.getPageDecodeStatus(64)) {
                    status2 = "Too many shapes on page";
                    this.showMessageDialog("Too many shapes on page");
                }
                if (!this.decode_pdf.getPageDecodeStatus(2)) {
                    status2 = Messages.getMessage("PdfViewer.ImageDisplayError") + Messages.getMessage("PdfViewer.ImageDisplayError1") + Messages.getMessage("PdfViewer.ImageDisplayError2") + Messages.getMessage("PdfViewer.ImageDisplayError3") + Messages.getMessage("PdfViewer.ImageDisplayError4") + Messages.getMessage("PdfViewer.ImageDisplayError5") + Messages.getMessage("PdfViewer.ImageDisplayError6") + Messages.getMessage("PdfViewer.ImageDisplayError7");
                    this.showMessageDialog(status2);
                }
                if (this.decode_pdf.getPageDecodeStatus(32)) {
                    status2 = Messages.getMessage("PdfCustomGui.ttHintingRequired");
                    this.showMessageDialog(status2);
                }
                if (this.decode_pdf.getPageDecodeStatus(4)) {
                    status2 = "This page contains non-embedded CID fonts \n" + this.decode_pdf.getPageDecodeStatusReport(4) + "\nwhich may need mapping to display correctly.\nSee https://support.idrsolutions.com/jpedal/api-documents/pdf-fonts-how-they-work-and-how-they-can-be-displayed-in";
                    this.showMessageDialog(status2);
                }
                if (this.decode_pdf.getExternalHandler(25) != null) {
                    FormFactory formfactory = this.decode_pdf.getFormRenderer().getFormFactory();
                    if (formfactory.getType() == 1) {
                        Runnable doPaintComponent2 = this::createUniqueAnnotationIcons;
                        SwingUtilities.invokeLater(doPaintComponent2);
                    } else {
                        this.createUniqueAnnotationIcons();
                    }
                }
                this.statusBar.updateStatus("Displaying Page", 0);
            }
            catch (Exception e2) {
                System.err.println(Messages.getMessage("PdfViewerError.Exception") + ' ' + e2 + ' ' + Messages.getMessage("PdfViewerError.DecodePage"));
                LogWriter.writeLog(e2);
                Values.setProcessing(false);
            }
            if (DecoderOptions.showErrorMessages && (status = this.decode_pdf.getPageDecodeReport()).contains("java.lang.OutOfMemoryError")) {
                status = Messages.getMessage("PdfViewer.OutOfMemoryDisplayError") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError1") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError2") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError3") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError4") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError5");
                this.showMessageDialog(status);
            }
            Values.setProcessing(false);
            this.setViewerTitle();
            if (LogWriter.isRunningFromIDE) {
                System.out.println((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000L + "K");
                System.out.println((float)Math.abs((System.currentTimeMillis() - this.start) / 100L) / 10.0f + "s");
            }
            if (this.decode_pdf.getPageCount() > 0 && this.thumbnails.isShownOnscreen() && this.decode_pdf.getDisplayView() == 1) {
                this.thumbnails.generateOtherVisibleThumbnails(this.commonValues.getCurrentPage());
            }
        }
        catch (Exception e3) {
            LogWriter.writeLog(e3);
            Values.setProcessing(false);
            this.setViewerTitle();
        }
    }

    private void decodeGUIPage() {
        this.prepareForDecode();
        switch (this.decode_pdf.getDisplayView()) {
            case 4: {
                this.scaleAndRotate();
                this.scrollToPage(this.commonValues.getCurrentPage());
                this.decode_pdf.getPages().decodeOtherPages(this.commonValues.getCurrentPage());
                return;
            }
            case 2: 
            case 3: {
                this.scaleAndRotate();
                this.scrollToPage(this.commonValues.getCurrentPage());
                return;
            }
            case 5: {
                return;
            }
        }
        this.resetComboBoxes(false);
        this.swButtons.setPageLayoutButtonsEnabled(false);
        this.performDecoding();
        this.statusBar.setProgress(100);
        this.setMultibox(new int[0]);
        this.resetComboBoxes(true);
        if (this.decode_pdf.getPageCount() > 1) {
            this.swButtons.setPageLayoutButtonsEnabled(true);
        }
        if (this.frame != null) {
            this.reinitialiseTabs(this.getDividerLocation() > SwingGUI.getStartSize());
        }
        this.finishedDecoding = true;
        this.scaleAndRotate();
        this.setCursor(1);
    }

    public void setViewerTitle() {
        String title = this.commonValues.getSelectedFile() == null ? windowTitle + ' ' : windowTitle + ' ' + this.commonValues.getSelectedFile();
        PdfObject linearObj = (PdfObject)this.decode_pdf.getJPedalObject(2004845231);
        if (linearObj != null) {
            LinearThread linearizedBackgroundReaderer = (LinearThread)this.decode_pdf.getJPedalObject(-1276915978);
            title = linearizedBackgroundReaderer != null && linearizedBackgroundReaderer.isAlive() ? title + " (still loading)" : title + " (Linearized)";
        }
        if (this.commonValues.isFormsChanged()) {
            title = "* " + title;
        }
        if (FileAccessHelper.bb > 0) {
            title = "(" + FileAccessHelper.bb + " days left) " + title;
        }
        this.setTitle(title);
    }

    private void setupSidebarTitles() {
        this.pageTitle = Messages.getMessage("PdfViewerJPanel.thumbnails");
        this.bookmarksTitle = Messages.getMessage("PdfViewerJPanel.bookmarks");
        this.layersTitle = Messages.getMessage("PdfViewerJPanel.layers");
        this.signaturesTitle = Messages.getMessage("PdfViewerJPanel.signatures");
        this.annotationTitle = Messages.getMessage("PdfViewerJPanel.annotations");
        this.attachmentsTitle = Messages.getMessage("PdfViewerJPanel.attachments");
    }

    public String getPageLabel(int pageNumber) {
        String value;
        if (this.commonValues.isPDF() && (value = this.decode_pdf.getIO().convertPageNumberToLabel(pageNumber)) != null) {
            return value;
        }
        return String.valueOf(pageNumber);
    }

    private boolean pageLabelDiffers(int pageNumber) {
        String value;
        PdfObjectReader reader = this.decode_pdf.getIO();
        if (reader != null && (value = reader.convertPageNumberToLabel(pageNumber)) != null) {
            return !value.equals(String.valueOf(pageNumber));
        }
        return false;
    }

    public void hideVersionNumber() {
        windowTitle = "JPedal PDF workflow tools";
        this.setViewerTitle();
    }

    public void showVersionNumber() {
        windowTitle = Messages.getMessage("PdfViewer.titlebar") + ' ' + version;
        this.setViewerTitle();
    }

    public void removePageListener() {
        if (this.viewListener != null) {
            this.decode_pdf.getPages().flushPageCaches();
            ((Component)((Object)this.decode_pdf)).removeComponentListener(this.viewListener);
            this.viewListener.dispose();
            this.viewListener = null;
        }
    }

    public void triggerPageTurnAnimation(PdfDecoderInt decode_pdf, Values commonValues, int updatedTotal, boolean rightTurn) {
        float pageW = decode_pdf.getPdfPageData().getCropBoxWidth(1);
        float pageH = decode_pdf.getPdfPageData().getCropBoxHeight(1);
        if (decode_pdf.getPdfPageData().getRotation(1) % 180 == 90) {
            float temp = pageW;
            pageW = pageH;
            pageH = temp;
        }
        Point corner = new Point();
        corner.x = (int)(decode_pdf.getVisibleRect().getWidth() / 2.0);
        corner.x = rightTurn ? (int)((float)corner.x - pageW) : (int)((float)corner.x + pageW);
        corner.y = (int)((float)decode_pdf.getInsetH() + pageH);
        Point cursor = new Point();
        cursor.x = (int)(decode_pdf.getVisibleRect().getWidth() / 2.0 + (double)pageW);
        cursor.x = rightTurn ? (int)((float)cursor.x + pageW) : (int)((float)cursor.x - pageW);
        cursor.y = (int)((float)decode_pdf.getInsetH() + pageH);
        SwingGUI currentGUI = this;
        Thread animation = new Thread(() -> {
            int velocity = 1;
            if (rightTurn ? cursor.x <= corner.x : cursor.x >= corner.x) {
                cursor.x = corner.x - 1;
            }
            double distX = corner.x - cursor.x;
            while (rightTurn ? cursor.getX() >= corner.getX() : cursor.getX() <= corner.getX()) {
                double xMove = (double)velocity * distX * 0.001;
                if (rightTurn && xMove > -1.0) {
                    xMove = -1.0;
                } else if (!rightTurn && xMove < 1.0) {
                    xMove = 1.0;
                }
                cursor.setLocation(cursor.getX() + xMove, cursor.getY());
                if (rightTurn) {
                    decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 999);
                } else {
                    decode_pdf.setUserOffsets((int)cursor.getX(), (int)cursor.getY(), 998);
                }
                if (velocity < 32) {
                    velocity *= 2;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    LogWriter.writeLog(e2);
                }
            }
            commonValues.setCurrentPage(updatedTotal);
            this.setPageNumber();
            decode_pdf.setPageParameters(this.scaling, commonValues.getCurrentPage());
            this.decodePage();
            PageNavigator.setPageTurnAnimating(false, currentGUI);
            decode_pdf.setUserOffsets(0, 0, 995);
        });
        animation.setDaemon(true);
        PageNavigator.setPageTurnAnimating(true, this);
        animation.start();
    }

    private void setCursor(int type) {
        if (type == 1) {
            ((Component)((Object)this.decode_pdf)).setCursor(Cursor.getPredefinedCursor(0));
        } else if (type == 2) {
            ((Component)((Object)this.decode_pdf)).setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    private boolean setDisplayView2(int displayView, int orientation) {
        DynamicVectorRenderer currentDisplay;
        DecoderOptions options = this.decode_pdf.getDecoderOptions();
        Display pages = this.decode_pdf.getPages();
        FileAccess fileAccess = (FileAccess)this.decode_pdf.getExternalHandler(35);
        int pageNumber = this.decode_pdf.getPageNumber();
        ExternalHandlers externalHandlers = this.decode_pdf.getExternalHandler();
        PdfDecoder comp = (PdfDecoder)this.decode_pdf;
        int lastDisplayView = this.decode_pdf.getDisplayView();
        options.setPageAlignment(orientation);
        if (pages != null) {
            pages.stopGeneratingPage();
        }
        boolean hasChanged = displayView != lastDisplayView;
        options.setDisplayView(displayView);
        if (lastDisplayView != displayView && lastDisplayView == 5 && pages != null) {
            pages.dispose();
        }
        Object customSwingHandle = externalHandlers.getExternalHandler(4);
        if (this.decode_pdf.getFormRenderer() != null) {
            this.decode_pdf.getFormRenderer().getCompData().setRootDisplayComponent(this.decode_pdf);
        }
        switch (displayView) {
            case 1: {
                if (pages != null && !hasChanged) break;
                currentDisplay = this.decode_pdf.getDynamicRenderer();
                pages = new SingleDisplay(pageNumber, currentDisplay, comp, options);
                break;
            }
            case 5: {
                if (pages instanceof PageFlowDisplay) {
                    return hasChanged;
                }
                if (this.decode_pdf.getFormRenderer() != null) {
                    this.decode_pdf.getFormRenderer().getCompData().setRootDisplayComponent(null);
                }
                if (lastDisplayView != 1) {
                    this.setDisplayView(1, 0);
                    this.setDisplayView(5, 0);
                    return hasChanged;
                }
                ((JScrollPane)comp.getParent().getParent()).setVerticalScrollBarPolicy(21);
                ((JScrollPane)comp.getParent().getParent()).setHorizontalScrollBarPolicy(31);
                pages = new PageFlowDisplay((SwingGUI)customSwingHandle, this.decode_pdf);
                break;
            }
            default: {
                pages = new MultiDisplay(pageNumber, null, displayView, comp, options, fileAccess);
                RenderChangeListener customRenderChangeListener = (RenderChangeListener)externalHandlers.getExternalHandler(21);
                if (customRenderChangeListener == null) break;
                pages.setObjectValue(21, customRenderChangeListener);
            }
        }
        if (lastDisplayView == 5) {
            comp.removeAll();
            comp.setLayout(null);
            ((JScrollPane)comp.getParent().getParent()).setVerticalScrollBarPolicy(20);
            ((JScrollPane)comp.getParent().getParent()).setHorizontalScrollBarPolicy(30);
            Timer t2 = new Timer(1000, e2 -> comp.repaint());
            t2.setRepeats(false);
            t2.start();
        }
        if (fileAccess.getOffset() == null) {
            fileAccess.setOffset(new PageOffsets(this.decode_pdf.getPageCount(), this.decode_pdf.getPdfPageData()));
        }
        pages.setup(options.useHardwareAcceleration(), fileAccess.getOffset());
        currentDisplay = this.decode_pdf.getDynamicRenderer();
        pages.init(this.scaling, this.decode_pdf.getDisplayRotation(), this.decode_pdf.getPageNumber(), currentDisplay, true);
        pages.setPageRotation(this.decode_pdf.getDisplayRotation());
        pages.forceRedraw();
        pages.refreshDisplay();
        comp.pages = pages;
        return hasChanged;
    }

    public JPanel getGlassPane() {
        return this.glassPane;
    }

    private void setupTilePortfolioView() {
        if (this.tileView == null) {
            this.tileView = new SwingPortfolioTile(this);
        }
        this.tileView.loadCollectionValues(this.decode_pdf);
        if (this.detailView != null) {
            this.portfolioParent.remove(this.detailView);
        }
        if (this.tileView != null) {
            this.portfolioParent.remove(this.tileView);
        }
        this.portfolioParent.remove(this.displayPane);
        this.portfolioParent.add((Component)this.tileView, "Center");
        this.menuItems.getMenuItem(66).setSelected(true);
        this.menuItems.getMenuItem(65).setSelected(false);
        this.portfolioParent.repaint();
        this.frame.validate();
    }

    private void setupDetailPortfolioView() {
        if (this.detailView == null) {
            this.detailView = new SwingPortfolioDetail(this);
        }
        this.detailView.loadCollectionValues(this.decode_pdf);
        if (this.detailView != null) {
            this.portfolioParent.remove(this.detailView);
        }
        if (this.tileView != null) {
            this.portfolioParent.remove(this.tileView);
        }
        this.portfolioParent.remove(this.displayPane);
        this.portfolioParent.add((Component)this.detailView, "Center");
        this.menuItems.getMenuItem(66).setSelected(false);
        this.menuItems.getMenuItem(65).setSelected(true);
        this.portfolioParent.repaint();
        this.frame.validate();
    }

    private void setupPdfView() {
        if (this.detailView != null) {
            this.portfolioParent.remove(this.detailView);
        }
        if (this.tileView != null) {
            this.portfolioParent.remove(this.tileView);
        }
        this.portfolioParent.remove(this.displayPane);
        this.portfolioParent.add((Component)this.displayPane, "Center");
        this.portfolioParent.validate();
        this.displayPane.repaint();
        this.scaleAndRotate();
    }

    public void setupGUIElementsForFiletype(Values.FileType type) {
        this.swButtons.getButton(35).setVisible((type == Values.FileType.PDF || type == Values.FileType.IMAGES) && "true".equalsIgnoreCase(this.properties.getValue("RotateLeftbutton")));
        this.swButtons.getButton(36).setVisible((type == Values.FileType.PDF || type == Values.FileType.IMAGES) && "true".equalsIgnoreCase(this.properties.getValue("RotateRightbutton")));
        this.swButtons.getButton(63).setVisible((type == Values.FileType.PDF || type == Values.FileType.IMAGES) && "true".equalsIgnoreCase(this.properties.getValue("ZoomInbutton")));
        this.swButtons.getButton(64).setVisible((type == Values.FileType.PDF || type == Values.FileType.IMAGES) && "true".equalsIgnoreCase(this.properties.getValue("ZoomOutbutton")));
        this.swButtons.getButton(29).setVisible(type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("MouseModeButton")));
        this.swButtons.getButton(50).setVisible((type == Values.FileType.PDF || type == Values.FileType.IMAGES && this.commonValues.isMultiTiff()) && "true".equalsIgnoreCase(this.properties.getValue("Firstbottom")));
        this.swButtons.getButton(51).setVisible((type == Values.FileType.PDF || type == Values.FileType.IMAGES && this.commonValues.isMultiTiff()) && "true".equalsIgnoreCase(this.properties.getValue("Back10bottom")));
        this.swButtons.getButton(52).setVisible((type == Values.FileType.PDF || type == Values.FileType.IMAGES && this.commonValues.isMultiTiff()) && "true".equalsIgnoreCase(this.properties.getValue("Backbottom")));
        this.swButtons.getButton(53).setVisible((type == Values.FileType.PDF || type == Values.FileType.IMAGES && this.commonValues.isMultiTiff()) && "true".equalsIgnoreCase(this.properties.getValue("Forwardbottom")));
        this.swButtons.getButton(54).setVisible((type == Values.FileType.PDF || type == Values.FileType.IMAGES && this.commonValues.isMultiTiff()) && "true".equalsIgnoreCase(this.properties.getValue("Forward10bottom")));
        this.swButtons.getButton(55).setVisible((type == Values.FileType.PDF || type == Values.FileType.IMAGES && this.commonValues.isMultiTiff()) && "true".equalsIgnoreCase(this.properties.getValue("Lastbottom")));
        this.swButtons.getButton(57).setVisible(type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("Singlebottom")));
        this.swButtons.getButton(58).setVisible(type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("Continuousbottom")));
        this.swButtons.getButton(60).setVisible(type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("Facingbottom")));
        this.swButtons.getButton(59).setVisible(type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("Continuousfacingbottom")));
        this.swButtons.getButton(61).setVisible(type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("PageFlowbottom")));
        this.swButtons.getButton(6).setVisible((type == Values.FileType.PDF || type == Values.FileType.IMAGES) && "true".equalsIgnoreCase(this.properties.getValue("Printbutton")));
        this.swButtons.getButton(13).setVisible(type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("Snapshotbutton")));
        this.multibox.setVisible(type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("Memorybottom")));
        this.navButtons.setVisible((type == Values.FileType.PDF || type == Values.FileType.IMAGES && this.commonValues.isMultiTiff()) && "true".equalsIgnoreCase(this.properties.getValue("ShowNavigationbar")));
        this.getCombo(252).setVisibility((type == Values.FileType.PDF || type == Values.FileType.IMAGES) && "true".equalsIgnoreCase(this.properties.getValue("Scalingdisplay")));
        this.getCombo(251).setVisibility((type == Values.FileType.PDF || type == Values.FileType.IMAGES) && "true".equalsIgnoreCase(this.properties.getValue("Rotationdisplay")));
        boolean showPageCounter = "true".equalsIgnoreCase(this.properties.getValue("Gotobottom"));
        this.pageCounter1.setVisible((type == Values.FileType.PDF || type == Values.FileType.IMAGES && this.commonValues.isMultiTiff()) && showPageCounter);
        this.pageCounter2.setVisible((type == Values.FileType.PDF || type == Values.FileType.IMAGES && this.commonValues.isMultiTiff()) && showPageCounter);
        this.pageCounter3.setVisible((type == Values.FileType.PDF || type == Values.FileType.IMAGES && this.commonValues.isMultiTiff()) && showPageCounter);
        boolean showMenubarSearch = "2".equalsIgnoreCase(this.properties.getValue("searchWindowType"));
        this.swButtons.getButton(19).setVisible(type == Values.FileType.PDF && showMenubarSearch);
        this.swButtons.getButton(18).setVisible(type == Values.FileType.PDF && showMenubarSearch);
        this.searchText.setVisible(type == Values.FileType.PDF);
        if (this.options != null) {
            this.options.setVisible(type == Values.FileType.PDF && showMenubarSearch);
        }
        this.navOptionsPanel.setVisible(type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("ShowSidetabbar")));
        this.menuItems.setMenuItemVisibility(319, type == Values.FileType.PORTFOLIO);
        this.menuItems.setMenuItemVisibility(5, type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("Save")));
        this.menuItems.setMenuItemVisibility(500, type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("Resaveasforms")));
        this.menuItems.setMenuItemVisibility(9, type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("Documentproperties")));
        this.menuItems.setMenuItemVisibility(12, type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("Find")));
        this.menuItems.setMenuItemVisibility(6, type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("Print")));
        this.menuItems.setMenuItemVisibility(32, type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("separateCover")));
        this.menuItems.setMenuItemVisibility(30, (type == Values.FileType.PDF || type == Values.FileType.IMAGES) && "true".equalsIgnoreCase(this.properties.getValue("panMode")));
        this.menuItems.setMenuItemVisibility(31, type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("textSelect")));
        this.menuItems.setMenuItemVisibility(62, (type == Values.FileType.PDF || type == Values.FileType.IMAGES) && "true".equalsIgnoreCase(this.properties.getValue("Fullscreen")));
        this.menuItems.setMenuItemVisibility(50, (type == Values.FileType.PDF || type == Values.FileType.IMAGES && this.commonValues.isMultiTiff()) && "true".equalsIgnoreCase(this.properties.getValue("Firstpage")));
        this.menuItems.setMenuItemVisibility(52, (type == Values.FileType.PDF || type == Values.FileType.IMAGES && this.commonValues.isMultiTiff()) && "true".equalsIgnoreCase(this.properties.getValue("Backpage")));
        this.menuItems.setMenuItemVisibility(56, (type == Values.FileType.PDF || type == Values.FileType.IMAGES && this.commonValues.isMultiTiff()) && "true".equalsIgnoreCase(this.properties.getValue("Goto")));
        this.menuItems.setMenuItemVisibility(53, (type == Values.FileType.PDF || type == Values.FileType.IMAGES && this.commonValues.isMultiTiff()) && "true".equalsIgnoreCase(this.properties.getValue("Forwardpage")));
        this.menuItems.setMenuItemVisibility(55, (type == Values.FileType.PDF || type == Values.FileType.IMAGES && this.commonValues.isMultiTiff()) && "true".equalsIgnoreCase(this.properties.getValue("Lastpage")));
        this.menuItems.setMenuItemVisibility(310, (type == Values.FileType.PDF || type == Values.FileType.IMAGES) && "true".equalsIgnoreCase(this.properties.getValue("EditMenu")));
        this.menuItems.setMenuItemVisibility(309, (type == Values.FileType.PDF || type == Values.FileType.IMAGES) && "true".equalsIgnoreCase(this.properties.getValue("PagelayoutMenu")));
        this.menuItems.setMenuItemVisibility(25, type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("Copy")));
        this.menuItems.setMenuItemVisibility(26, type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("Selectall")));
        this.menuItems.setMenuItemVisibility(27, type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("Deselectall")));
        this.menuItems.setMenuItemVisibility(3, type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("Images")));
        this.menuItems.setMenuItemVisibility(4, type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("Text")));
        this.menuItems.setMenuItemVisibility(304, type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("ContentMenu")));
        this.menuItems.setMenuItemVisibility(2, type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("Bitmap")));
        this.menuItems.setMenuItemVisibility(307, type == Values.FileType.PDF && "true".equalsIgnoreCase(this.properties.getValue("ExportMenu")));
        this.menuItems.setMenuItemVisibility(38, type == Values.FileType.PDF && this.debugMode);
        this.menuItems.setMenuItemVisibility(39, type == Values.FileType.PDF && this.debugMode);
        this.menuItems.setMenuItemVisibility(319, type == Values.FileType.PORTFOLIO);
        if (type == Values.FileType.IMAGES) {
            this.currentCommands.executeCommand(ViewerCommands.PANMODE, null);
        } else {
            this.currentCommands.executeCommand(ViewerCommands.TEXTSELECT, null);
        }
        this.swButtons.checkButtonSeparators();
        this.menuItems.checkMenuItemSeparators();
        this.frame.revalidate();
    }

    public void setDebugMode(boolean enableDebugMode) {
        this.debugMode = enableDebugMode;
        this.menuItems.setDebugMode(enableDebugMode);
        this.imageNameCollector = new ImageNameCollector(){
            final HashMap<String, String> names = new HashMap();

            @Override
            public void put(String imageName, String cacheName) {
                this.names.put(SwingGUI.this.decode_pdf.getPageNumber() + "-" + imageName, cacheName);
            }

            @Override
            public String getCacheName(String imageName) {
                return this.names.get(SwingGUI.this.decode_pdf.getPageNumber() + "-" + imageName);
            }

            @Override
            public String getCacheNameFromIDToken(int tokenNumber) {
                String prefix = SwingGUI.this.decode_pdf.getPageNumber() + "-";
                String suffix = "-IN-" + tokenNumber;
                for (String name : this.names.keySet()) {
                    if (!name.startsWith(prefix) || !name.endsWith(suffix)) continue;
                    return this.names.get(name);
                }
                return null;
            }

            @Override
            public boolean cacheAllToDisk() {
                return true;
            }
        };
        this.decode_pdf.setImageNameCollector(this.imageNameCollector);
    }

    static {
        showMessages = true;
        expandedSize = 190;
        collapsedSize = 30;
        inset = 25;
        Properties props = new Properties();
        try (InputStream is = SwingGUI.class.getResourceAsStream("/version.num");){
            if (is != null) {
                try {
                    props.load(is);
                }
                catch (IOException ex) {
                    LogWriter.writeLog("Exception: " + ex.getMessage());
                }
            }
        }
        catch (IOException e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        String versionSet = props.getProperty("release");
        version = versionSet != null ? versionSet : "@VERSION@";
    }

    private class RefreshLayout
    extends ComponentAdapter {
        final PdfDecoderInt decode_pdf;
        final PageMoveTracker tracker = new PageMoveTracker();
        int delay = 500;

        RefreshLayout(PdfDecoderInt pdf) {
            this.decode_pdf = pdf;
            String value = SwingGUI.this.properties.getValue("pageMoveDelay");
            if (value != null && !value.isEmpty()) {
                this.delay = Integer.parseInt(value);
            }
        }

        @Override
        public void componentMoved(ComponentEvent e2) {
            this.tracker.startTimer(this.decode_pdf.getPages(), this.decode_pdf.getPageNumber(), (FileAccess)this.decode_pdf.getExternalHandler(35), this.delay);
        }

        @Override
        public void componentResized(ComponentEvent e2) {
            int displayView = this.decode_pdf.getDisplayView();
            PdfPageData pageData = this.decode_pdf.getPdfPageData();
            int page = this.decode_pdf.getPageNumber();
            if (displayView != 1 && displayView != 5) {
                Rectangle r2 = this.decode_pdf.getVisibleRect();
                if (pageData.getScaledCropBoxWidth(page) <= r2.width && pageData.getScaledCropBoxHeight(page) <= r2.height) {
                    SwingGUI.this.scrollToPage(page);
                }
                this.tracker.startTimer(this.decode_pdf.getPages(), this.decode_pdf.getPageNumber(), (FileAccess)this.decode_pdf.getExternalHandler(35), this.delay);
            }
        }

        void dispose() {
            this.tracker.dispose();
        }
    }

    public static enum PageCounter {
        PAGECOUNTER1,
        PAGECOUNTER2,
        PAGECOUNTER3,
        ALL;

    }

    public static enum ScrollPolicy {
        VERTICAL_AS_NEEDED,
        HORIZONTAL_AS_NEEDED,
        VERTICAL_NEVER,
        HORIZONTAL_NEVER;

    }
}

