/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import com.idrsolutions.image.JDeli;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jpedal.utils.LogWriter;

public class SwingCursor {
    private String iconLocation = "/org/jpedal/examples/viewer/res/";
    private Cursor grabCursor;
    private Cursor grabbingCursor;
    private Cursor panCursor;
    private Cursor panCursorL;
    private Cursor panCursorTL;
    private Cursor panCursorT;
    private Cursor panCursorTR;
    private Cursor panCursorR;
    private Cursor panCursorBR;
    private Cursor panCursorB;
    private Cursor panCursorBL;

    public Cursor getCursor(int type) {
        switch (type) {
            case 1: {
                if (this.grabCursor == null) {
                    this.grabCursor = this.createCustomCursor("grab32.png", "grab", 8, 8);
                }
                return this.grabCursor;
            }
            case 2: {
                if (this.grabbingCursor == null) {
                    this.grabbingCursor = this.createCustomCursor("grabbing32.png", "grabbing", 8, 8);
                }
                return this.grabbingCursor;
            }
            case 4: {
                if (this.panCursor == null) {
                    this.panCursor = this.createCustomCursor("pan32.png", "pan", 10, 10);
                }
                return this.panCursor;
            }
            case 5: {
                if (this.panCursorL == null) {
                    this.panCursorL = this.createCustomCursor("panl32.png", "panl", 11, 10);
                }
                return this.panCursorL;
            }
            case 6: {
                if (this.panCursorTL == null) {
                    this.panCursorTL = this.createCustomCursor("pantl32.png", "pantl", 10, 10);
                }
                return this.panCursorTL;
            }
            case 7: {
                if (this.panCursorT == null) {
                    this.panCursorT = this.createCustomCursor("pant32.png", "pant", 10, 11);
                }
                return this.panCursorT;
            }
            case 8: {
                if (this.panCursorTR == null) {
                    this.panCursorTR = this.createCustomCursor("pantr32.png", "pantr", 10, 10);
                }
                return this.panCursorTR;
            }
            case 9: {
                if (this.panCursorR == null) {
                    this.panCursorR = this.createCustomCursor("panr32.png", "panr", 10, 10);
                }
                return this.panCursorR;
            }
            case 10: {
                if (this.panCursorBR == null) {
                    this.panCursorBR = this.createCustomCursor("panbr32.png", "panbr", 10, 10);
                }
                return this.panCursorBR;
            }
            case 11: {
                if (this.panCursorB == null) {
                    this.panCursorB = this.createCustomCursor("panb32.png", "panb", 10, 10);
                }
                return this.panCursorB;
            }
            case 12: {
                if (this.panCursorBL == null) {
                    this.panCursorBL = this.createCustomCursor("panbl32.png", "panbl", 10, 10);
                }
                return this.panCursorBL;
            }
        }
        return Cursor.getDefaultCursor();
    }

    private Cursor createCustomCursor(String fileName, String cursorName, int x2, int y2) {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Image img = kit.getImage(this.getURLForImage(fileName));
        return kit.createCustomCursor(img, new Point(x2, y2), cursorName);
    }

    public void setIconLocation(String location) {
        this.iconLocation = location;
    }

    public URL getURLForImage(String path) {
        path = this.iconLocation + path;
        String file = path.substring(path.lastIndexOf(47) + 1);
        path = path.substring(0, path.indexOf(46)) + ".gif";
        File p2 = new File(path);
        URL url = this.getClass().getResource(path);
        if (p2.exists()) {
            try {
                url = p2.toURI().toURL();
            }
            catch (MalformedURLException e2) {
                LogWriter.writeLog("Exception attempting get path for image " + e2);
            }
        }
        if (url == null) {
            path = path.substring(0, path.indexOf(46)) + ".png";
            p2 = new File(path);
            url = this.getClass().getResource(path);
            if (p2.exists()) {
                try {
                    url = p2.toURI().toURL();
                }
                catch (MalformedURLException e3) {
                    LogWriter.writeLog("Exception attempting get path for image " + e3);
                }
            }
        }
        if (url == null) {
            path = "/org/jpedal/examples/viewer/res/" + file;
            url = this.getClass().getResource(path);
        }
        return url;
    }

    public BufferedImage getCursorImageForFX(int type) {
        switch (type) {
            case 1: {
                try {
                    return JDeli.read(this.getURLForImage("grab32.png").openStream());
                }
                catch (Exception e2) {
                    LogWriter.writeLog("Exception in getting image " + e2);
                    return null;
                }
            }
            case 2: {
                try {
                    return JDeli.read(this.getURLForImage("grabbing32.png").openStream());
                }
                catch (Exception e3) {
                    LogWriter.writeLog("Exception in getting image " + e3);
                    return null;
                }
            }
        }
        return null;
    }
}

