/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.commands.OpenFile;
import org.jpedal.examples.viewer.gui.BaseTransferHandler;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.utils.LogWriter;

public class SingleViewTransferHandler
extends BaseTransferHandler {
    public SingleViewTransferHandler(SwingGUI currentGUI, Commands currentCommands) {
        super(currentGUI, currentCommands);
    }

    @Override
    public boolean importData(JComponent src, Transferable transferable) {
        try {
            Object dragImport = this.getImport(transferable);
            if (dragImport instanceof String) {
                String url = (String)dragImport;
                if (url.indexOf("file:/") != url.lastIndexOf("file:/")) {
                    this.currentGUI.showMessageDialog("You may only import 1 file at a time");
                } else {
                    this.openFile(url);
                }
            } else if (dragImport instanceof List) {
                List files = (List)dragImport;
                if (files.size() == 1) {
                    this.openFile(((File)files.get(0)).getAbsolutePath());
                } else {
                    this.currentGUI.showMessageDialog("You may only import 1 file at a time");
                }
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception e " + e2.getMessage());
            return false;
        }
        return true;
    }

    private void openFile(String file) {
        boolean isValid = OpenFile.isSupportedFileExtension(file.toLowerCase());
        if (isValid) {
            this.currentCommands.handleTransferedFile(file);
        } else {
            this.currentGUI.showMessageDialog("You may only import a valid PDF or image");
        }
    }
}

