/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.util.Timer;
import java.util.TimerTask;
import org.jpedal.FileAccess;
import org.jpedal.display.Display;

class PageMoveTracker {
    private Timer t2;
    private TimerTask listener;

    PageMoveTracker() {
    }

    public void dispose() {
        if (this.listener != null) {
            this.listener.cancel();
        }
        if (this.t2 != null) {
            this.t2.cancel();
            this.t2.purge();
        }
        this.listener = null;
        this.t2 = null;
    }

    void startTimer(Display pages, int pageNumber, FileAccess fileAccess, int delay) {
        if (this.t2 == null) {
            this.t2 = new Timer();
        }
        if (this.listener != null) {
            this.listener.cancel();
            this.t2.purge();
        }
        this.listener = new PageListener(pages, pageNumber, fileAccess);
        this.t2.schedule(this.listener, delay);
    }

    private final class PageListener
    extends TimerTask {
        final Display pages;
        final FileAccess fileAccess;
        final int pageNumber;

        private PageListener(Display pages, int pageNumber, FileAccess fileAccess) {
            this.pages = pages;
            this.pageNumber = pageNumber;
            this.fileAccess = fileAccess;
        }

        @Override
        public void run() {
            if (this.pages != null) {
                this.pages.stopGeneratingPage();
                if (this.pageNumber < 1) {
                    this.fileAccess.setPageNumber(1);
                }
                this.pages.decodeOtherPages(this.pageNumber);
            }
            this.cancel();
        }
    }
}

