/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.objects.PdfPageData;

public final class MouseSelector {
    private MouseSelector() {
    }

    public static int adjustForAlignment(int cx, PdfDecoderInt decode_pdf) {
        if (decode_pdf.getPageAlignment() == 2) {
            int width = decode_pdf.getPaneBounds()[0];
            int pdfWidth = decode_pdf.getPDFWidth();
            if (decode_pdf.getDisplayView() != 1) {
                pdfWidth = decode_pdf.getMaxSizeWH()[0];
            }
            if (width > pdfWidth) {
                cx -= (width - pdfWidth) / 2;
            }
        }
        return cx;
    }

    public static int[] updateXY(int originalX, int originalY, PdfDecoderInt decode_pdf, Values commonValues) {
        PdfPageData page_data = decode_pdf.getPdfPageData();
        int mediaW = page_data.getMediaBoxWidth(commonValues.getCurrentPage());
        int mediaH = page_data.getMediaBoxHeight(commonValues.getCurrentPage());
        int cropX = page_data.getCropBoxX(commonValues.getCurrentPage());
        int cropY = page_data.getCropBoxY(commonValues.getCurrentPage());
        int cropW = page_data.getCropBoxWidth(commonValues.getCurrentPage());
        int cropH = page_data.getCropBoxHeight(commonValues.getCurrentPage());
        float scaling = page_data.getScalingValue();
        int rotation = page_data.getRotation(commonValues.getCurrentPage());
        int inset = SwingGUI.getPDFDisplayInset();
        int x2 = (int)((float)(MouseSelector.adjustForAlignment(originalX, decode_pdf) - inset) / scaling);
        int y2 = (int)((float)(originalY - inset) / scaling);
        if (commonValues.maxViewY != 0) {
            x2 = (int)((double)((float)x2 - (float)commonValues.dx * scaling) / commonValues.viewportScale);
            y2 = (int)(((double)mediaH - (double)((float)mediaH - (float)y2 / scaling - (float)commonValues.dy) / commonValues.viewportScale) * (double)scaling);
        }
        int[] ret = new int[2];
        switch (rotation) {
            case 90: {
                ret[1] = x2 + cropY;
                ret[0] = y2 + cropX;
                break;
            }
            case 180: {
                ret[0] = mediaW - (x2 + mediaW - cropW - cropX);
                ret[1] = y2 + cropY;
                break;
            }
            case 270: {
                ret[1] = mediaH - (x2 + mediaH - cropH - cropY);
                ret[0] = mediaW - (y2 + mediaW - cropW - cropX);
                break;
            }
            default: {
                ret[0] = x2 + cropX;
                ret[1] = mediaH - (y2 + mediaH - cropH - cropY);
            }
        }
        return ret;
    }
}

