/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.TreeCellRenderer;
import org.jpedal.examples.viewer.gui.CheckNode;

public class CheckRenderer
extends JPanel
implements TreeCellRenderer {
    private final JCheckBox check;
    private final TreeLabel label;

    public CheckRenderer() {
        this.setLayout(null);
        this.check = new JCheckBox();
        this.label = new TreeLabel();
        this.add(this.check);
        this.add(this.label);
        this.check.setBackground(UIManager.getColor("Tree.textBackground"));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
        this.setEnabled(tree.isEnabled());
        if (value instanceof CheckNode) {
            this.check.setSelected(((CheckNode)value).isSelected());
            this.setEnabled(((CheckNode)value).isEnabled());
            this.check.setEnabled(((CheckNode)value).isEnabled());
            this.label.setFont(tree.getFont());
            this.label.setText(stringValue);
            this.label.setSelected(isSelected);
            this.label.setFocus(hasFocus);
            return this;
        }
        return new JLabel(stringValue);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d_check = this.check.getPreferredSize();
        Dimension d_label = this.label.getPreferredSize();
        return new Dimension(d_check.width + d_label.width, Math.max(d_check.height, d_label.height));
    }

    @Override
    public void doLayout() {
        Dimension pane = this.getSize();
        Dimension checkboxSize = this.check.getPreferredSize();
        Dimension labelSize = this.label.getPreferredSize();
        int checkBoxOffset = (pane.height - checkboxSize.height) / 2;
        int labelOffset = (pane.height - labelSize.height) / 2;
        this.check.setLocation(0, checkBoxOffset);
        this.check.setBounds(0, checkBoxOffset, checkboxSize.width, checkboxSize.height);
        this.label.setLocation(checkboxSize.width, labelOffset);
        this.label.setBounds(checkboxSize.width, labelOffset, labelSize.width, labelSize.height);
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    static class TreeLabel
    extends JLabel {
        boolean isSelected;
        boolean hasFocus;

        TreeLabel() {
        }

        @Override
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        @Override
        public void paint(Graphics g2) {
            String str = this.getText();
            if (str != null && !str.isEmpty()) {
                if (this.isSelected) {
                    g2.setColor(UIManager.getColor("Tree.selectionBackground"));
                } else {
                    g2.setColor(UIManager.getColor("Tree.textBackground"));
                }
                Dimension d2 = this.getPreferredSize();
                int imageOffset = 0;
                Icon currentI = this.getIcon();
                if (currentI != null) {
                    imageOffset = currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                }
                g2.fillRect(imageOffset, 0, d2.width - 1 - imageOffset, d2.height);
                if (this.hasFocus) {
                    g2.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                    g2.drawRect(imageOffset, 0, d2.width - 1 - imageOffset, d2.height - 1);
                }
            }
            super.paint(g2);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension retDimension = super.getPreferredSize();
            if (retDimension != null) {
                retDimension = new Dimension(retDimension.width + 3, retDimension.height);
            }
            return retDimension;
        }

        void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        void setFocus(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }
    }
}

