/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseListener;
import org.jpedal.display.Display;
import org.jpedal.display.GUIDisplay;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingButton;
import org.jpedal.examples.viewer.gui.swing.SwingCommandListener;
import org.jpedal.examples.viewer.gui.swing.SwingMenuItems;

public class Buttons {
    private JToolBar topButtons;
    private final ButtonGroup layoutGroup = new ButtonGroup();
    private final HashMap<Integer, SwingButton> buttonMap = new HashMap();
    private boolean isSingle;

    public void init(boolean isSingle) {
        this.topButtons = new JToolBar();
        this.isSingle = isSingle;
        this.setupButtonStyle();
    }

    public SwingButton getButton(int ID2) {
        return this.buttonMap.computeIfAbsent(ID2, k2 -> new SwingButton());
    }

    public void dispose() {
        Collection<SwingButton> buttons = this.buttonMap.values();
        Iterator<SwingButton> it = buttons.iterator();
        while (it.hasNext()) {
            SwingButton button = it.next();
            Buttons.removeListenersFromButtons(button);
            it.remove();
        }
        this.buttonMap.clear();
        Enumeration<AbstractButton> menuItemButtons = this.layoutGroup.getElements();
        while (menuItemButtons.hasMoreElements()) {
            JCheckBoxMenuItem button = (JCheckBoxMenuItem)menuItemButtons.nextElement();
            for (MenuDragMouseListener listener : button.getMenuDragMouseListeners()) {
                button.removeMenuDragMouseListener(listener);
            }
            Buttons.removeListenersFromButtons(button);
        }
        if (this.topButtons != null) {
            this.topButtons.removeAll();
        }
        this.topButtons = null;
    }

    private static void removeListenersFromButtons(AbstractButton button) {
        for (ActionListener actionListener : button.getActionListeners()) {
            button.removeActionListener(actionListener);
        }
        for (EventListener eventListener : button.getMouseListeners()) {
            button.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : button.getChangeListeners()) {
            button.removeChangeListener((ChangeListener)eventListener);
        }
        for (EventListener eventListener : button.getPropertyChangeListeners()) {
            button.removePropertyChangeListener((PropertyChangeListener)eventListener);
        }
        for (EventListener eventListener : button.getItemListeners()) {
            button.removeItemListener((ItemListener)eventListener);
        }
    }

    public void setBackNavigationButtonsEnabled(boolean flag) {
        if (this.buttonMap.containsKey(52)) {
            this.buttonMap.get(52).setEnabled(flag);
        }
        if (this.buttonMap.containsKey(50)) {
            this.buttonMap.get(50).setEnabled(flag);
        }
        if (this.buttonMap.containsKey(51)) {
            this.buttonMap.get(51).setEnabled(flag);
        }
    }

    public void setForwardNavigationButtonsEnabled(boolean flag) {
        if (this.buttonMap.containsKey(53)) {
            this.buttonMap.get(53).setEnabled(flag);
        }
        if (this.buttonMap.containsKey(55)) {
            this.buttonMap.get(55).setEnabled(flag);
        }
        if (this.buttonMap.containsKey(54)) {
            this.buttonMap.get(54).setEnabled(flag);
        }
    }

    public void setPageLayoutButtonsEnabled(boolean flag) {
        Enumeration<AbstractButton> menuOptions;
        if (!this.isSingle) {
            return;
        }
        if (this.buttonMap.containsKey(58)) {
            this.buttonMap.get(58).setEnabled(flag);
        }
        if (this.buttonMap.containsKey(59)) {
            this.buttonMap.get(59).setEnabled(flag);
        }
        if (this.buttonMap.containsKey(60)) {
            this.buttonMap.get(60).setEnabled(flag);
        }
        if (this.buttonMap.containsKey(61)) {
            this.buttonMap.get(61).setEnabled(flag);
        }
        if ((menuOptions = this.layoutGroup.getElements()).hasMoreElements()) {
            menuOptions.nextElement().setEnabled(true);
            while (menuOptions.hasMoreElements()) {
                menuOptions.nextElement().setEnabled(flag);
            }
        }
    }

    public void alignLayoutMenuOption(int mode) {
        Enumeration<AbstractButton> menuOptions = this.layoutGroup.getElements();
        for (int i2 = 1; menuOptions.hasMoreElements() && i2 != mode; ++i2) {
            menuOptions.nextElement();
        }
        menuOptions.nextElement().setSelected(true);
    }

    public ButtonGroup getLayoutGroup() {
        return this.layoutGroup;
    }

    public void checkButtonSeparators() {
        boolean before = false;
        boolean after = false;
        JComponent currentSep = null;
        for (int k2 = 0; k2 != this.topButtons.getComponentCount(); ++k2) {
            if (this.topButtons.getComponent(k2) instanceof JSeparator) {
                if (currentSep != null) {
                    currentSep.setVisible(before && after);
                    before = before || after;
                    after = false;
                }
                currentSep = (JSeparator)this.topButtons.getComponent(k2);
                continue;
            }
            if (!this.topButtons.getComponent(k2).isVisible()) continue;
            if (currentSep == null) {
                before = true;
                continue;
            }
            after = true;
        }
        if (currentSep != null) {
            currentSep.setVisible(before && after);
        }
    }

    public JToolBar getTopButtons() {
        return this.topButtons;
    }

    public void addButton(int line, String toolTip, String path, int ID2, SwingMenuItems swMenuItems, SwingGUI currentGUI, SwingCommandListener currentCommandListener, JToolBar pagesToolBar, JToolBar navToolBar) {
        SwingButton newButton = new SwingButton();
        Buttons.setButtonValues(ID2, swMenuItems, currentGUI, newButton);
        Buttons.setMouseListener(newButton);
        newButton.init(currentGUI.getGUICursor().getURLForImage(path), ID2, toolTip);
        newButton.addActionListener(currentCommandListener);
        switch (line) {
            case 0: {
                this.topButtons.add(newButton);
                break;
            }
            case 1: {
                navToolBar.add(newButton);
                break;
            }
            case 2: {
                pagesToolBar.add((Component)newButton, "Center");
                break;
            }
        }
        this.buttonMap.put(ID2, newButton);
    }

    public void addButtonToToolBarWithConstraints(String toolTip, String path, int ID2, SwingMenuItems swMenuItems, SwingGUI currentGUI, ActionListener actionListener, JToolBar panel, GridBagConstraints c2) {
        SwingButton newButton = new SwingButton();
        Buttons.setButtonValues(ID2, swMenuItems, currentGUI, newButton);
        Buttons.setMouseListener(newButton);
        newButton.init(currentGUI.getGUICursor().getURLForImage(path), ID2, toolTip);
        newButton.addActionListener(actionListener);
        panel.add((Component)newButton, c2);
        this.buttonMap.put(ID2, newButton);
    }

    private static void setButtonValues(int ID2, SwingMenuItems swMenuItems, SwingGUI currentGUI, SwingButton newButton) {
        switch (ID2) {
            case 57: {
                newButton.setName("SINGLE");
                newButton.addActionListener(e2 -> swMenuItems.setMenusForDisplayMode(57, -1));
                break;
            }
            case 58: {
                newButton.setName("CONTINUOUS");
                newButton.addActionListener(e2 -> swMenuItems.setMenusForDisplayMode(58, -1));
                break;
            }
            case 59: {
                newButton.setName("CONTINUOUS_FACING");
                newButton.addActionListener(e2 -> swMenuItems.setMenusForDisplayMode(59, -1));
                break;
            }
            case 60: {
                newButton.setName("FACING");
                newButton.addActionListener(e2 -> swMenuItems.setMenusForDisplayMode(60, -1));
                break;
            }
            case 61: {
                newButton.setName("PAGEFLOW");
                newButton.addActionListener(e2 -> swMenuItems.setMenusForDisplayMode(61, -1));
                break;
            }
            case 18: {
                newButton.setEnabled(false);
                newButton.setName("PREVIOUSRESULT");
                break;
            }
            case 19: {
                newButton.setEnabled(false);
                newButton.setName("NEXTRESULT");
                break;
            }
            case 10: {
                newButton.setName("open");
                break;
            }
            case 6: {
                newButton.setName("print");
                break;
            }
            case 12: {
                newButton.setName("search");
                break;
            }
            case 29: {
                newButton.addActionListener(e2 -> {
                    if (currentGUI.getPdfDecoder().getDisplayView() == 1) {
                        swMenuItems.setMenusForDisplayMode(29, currentGUI.getCommand().getMouseMode().getMouseMode());
                    }
                });
                newButton.setName("mousemode");
                break;
            }
            case 50: {
                newButton.setName("firstPage");
                break;
            }
            case 51: {
                newButton.setName("10BackPage");
                break;
            }
            case 52: {
                newButton.setName("backPage");
                break;
            }
            case 53: {
                newButton.setName("forwardPage");
                break;
            }
            case 54: {
                newButton.setName("10ForwardPage");
                break;
            }
            case 55: {
                newButton.setName("lastPage");
                break;
            }
            case 63: {
                newButton.setName("zoomIn");
                break;
            }
            case 64: {
                newButton.setName("zoomOut");
                break;
            }
            case 35: {
                newButton.setName("rotateLeft");
                break;
            }
            case 36: {
                newButton.setName("rotateRight");
            }
        }
    }

    private static void setMouseListener(Component newButton) {
        newButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e2) {
                if (GUIDisplay.allowChangeCursor) {
                    ((Component)e2.getSource()).setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e2) {
                if (GUIDisplay.allowChangeCursor) {
                    ((Component)e2.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    public void hideRedundentNavButtons(SwingGUI currentGUI) {
        int displayView = currentGUI.getPdfDecoder().getDisplayView();
        int maxPages = currentGUI.getPdfDecoder().getPageCount();
        if (currentGUI.getValues().isMultiTiff()) {
            maxPages = currentGUI.getValues().getPageCount();
        }
        if ((displayView == 4 && currentGUI.getPdfDecoder().getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || displayView == 3) && (maxPages & 1) == 1) {
            --maxPages;
        }
        if (currentGUI.getValues().getCurrentPage() == 1) {
            this.setBackNavigationButtonsEnabled(false);
            currentGUI.getMenuItems().setBackNavigationItemsEnabled(false);
        } else {
            this.setBackNavigationButtonsEnabled(true);
            currentGUI.getMenuItems().setBackNavigationItemsEnabled(true);
        }
        if (currentGUI.getValues().getCurrentPage() == maxPages) {
            this.setForwardNavigationButtonsEnabled(false);
            currentGUI.getMenuItems().setForwardNavigationItemsEnabled(false);
        } else {
            this.setForwardNavigationButtonsEnabled(true);
            currentGUI.getMenuItems().setForwardNavigationItemsEnabled(true);
        }
        currentGUI.getMenuItems().setGoToNavigationItemEnabled(maxPages != 1);
        if (currentGUI.getThumbnailScrollBar() != null && displayView != 1) {
            if (displayView == 5) {
                currentGUI.setScrollBarPolicy(SwingGUI.ScrollPolicy.VERTICAL_NEVER);
                currentGUI.setScrollBarPolicy(SwingGUI.ScrollPolicy.HORIZONTAL_NEVER);
            } else {
                currentGUI.setScrollBarPolicy(SwingGUI.ScrollPolicy.VERTICAL_AS_NEEDED);
                currentGUI.setScrollBarPolicy(SwingGUI.ScrollPolicy.HORIZONTAL_AS_NEEDED);
            }
            currentGUI.setThumbnailScrollBarVisibility(false);
        }
    }

    private void setupButtonStyle() {
        this.topButtons.setBorder(BorderFactory.createEmptyBorder());
        this.topButtons.setLayout(new FlowLayout(3));
        this.topButtons.setFloatable(false);
        this.topButtons.setFont(new Font("SansSerif", 0, 8));
    }

    public void setVisible(boolean set) {
        this.topButtons.setVisible(set);
    }

    public void setEnabled(boolean set) {
        this.topButtons.setEnabled(set);
    }
}

