/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.SecureDocumentBuilderFactory;
import org.jpedal.utils.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class BaseTransferHandler
extends TransferHandler {
    final Commands currentCommands;
    final SwingGUI currentGUI;

    BaseTransferHandler(SwingGUI currentGUI, Commands currentCommands) {
        this.currentGUI = currentGUI;
        this.currentCommands = currentCommands;
    }

    @Override
    public boolean canImport(JComponent dest, DataFlavor[] flavors) {
        return true;
    }

    Object getImport(Transferable transferable) {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        DataFlavor listFlavor = null;
        int lastFlavor = flavors.length - 1;
        for (int f2 = 0; f2 <= lastFlavor; ++f2) {
            if (!flavors[f2].isFlavorJavaFileListType()) continue;
            listFlavor = flavors[f2];
        }
        try {
            DataFlavor bestTextFlavor = DataFlavor.selectBestTextFlavor(flavors);
            if (bestTextFlavor != null) {
                Reader r2 = bestTextFlavor.getReaderForText(transferable);
                String textData = BaseTransferHandler.readTextDate(r2);
                if ((textData = BaseTransferHandler.removeChar(textData)).contains("ftp:/")) {
                    this.currentGUI.showMessageDialog("Files cannot be opened via FTP");
                    return null;
                }
                textData = BaseTransferHandler.getURL(textData);
                textData = textData.replaceAll("%20", " ");
                return textData;
            }
            if (listFlavor != null) {
                return transferable.getTransferData(listFlavor);
            }
        }
        catch (UnsupportedFlavorException | IOException | ParserConfigurationException | SAXException e2) {
            LogWriter.writeLog("Caught exception decoding transfer:" + e2.getMessage());
            return null;
        }
        return null;
    }

    private static String removeChar(String s2) {
        StringBuilder r2 = new StringBuilder();
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (s2.charAt(i2) == '\u0000') continue;
            r2.append(s2.charAt(i2));
        }
        return r2.toString();
    }

    private static String getURL(String textData) throws ParserConfigurationException, SAXException, IOException {
        if (!textData.startsWith("http://") && !textData.startsWith("file://")) {
            SecureDocumentBuilderFactory dbf = new SecureDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(StringUtils.toBytes(textData)));
            Element a10 = (Element)doc.getElementsByTagName("a").item(0);
            textData = BaseTransferHandler.getHrefAttribute(a10);
        }
        return textData;
    }

    private static String readTextDate(Reader r2) throws IOException {
        StringBuilder textData;
        try (BufferedReader br2 = new BufferedReader(r2);){
            textData = new StringBuilder();
            String line = br2.readLine();
            while (line != null) {
                textData.append(line);
                line = br2.readLine();
            }
        }
        return textData.toString();
    }

    private static String getHrefAttribute(Element element) {
        NamedNodeMap attrs = element.getAttributes();
        Node nameNode = attrs.getNamedItem("href");
        if (nameNode != null) {
            return nameNode.getNodeValue();
        }
        return "";
    }
}

