/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.popups.XrefViewer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public final class Xref {
    private Xref() {
    }

    public static void execute(Object[] args, SwingGUI currentGUI, Values commonValues, PdfDecoderInt decode_pdf) {
        if (args == null) {
            if (commonValues.getSelectedFile() == null) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.OpenFile"));
            } else if (!decode_pdf.isExtractionAllowed()) {
                if (commonValues.isPDF()) {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPermissionsError.Extraction"));
                }
            } else {
                XrefViewer xrefViewer = new XrefViewer(decode_pdf.getIO());
                try {
                    xrefViewer.init(currentGUI);
                }
                catch (Exception e2) {
                    LogWriter.writeLog("Exception reading Xref: " + e2);
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.XrefParsingError"));
                }
            }
        }
    }
}

