/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.objects.PdfPageData;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.Messages;

public final class SelectAll {
    private SelectAll() {
    }

    public static void execute(SwingGUI currentGUI, PdfDecoderInt decode_pdf, Values commonValues) {
        if (decode_pdf.getDisplayView() == 1) {
            int pageNumber = commonValues.getCurrentPage();
            int[][] allHighlights = decode_pdf.getTextLines().getLineAreasAs2DArray(pageNumber);
            int[] rect = new int[4];
            PdfPageData pageData = decode_pdf.getPdfPageData();
            if (allHighlights != null) {
                rect = SelectAll.getSelectedArea(pageNumber, allHighlights, pageData);
                decode_pdf.getTextLines().clearHighlights();
                decode_pdf.getTextLines().addHighlights(allHighlights, true, commonValues.getCurrentPage());
            } else {
                rect[3] = decode_pdf.getPdfPageData().getCropBoxHeight(commonValues.getCurrentPage());
                rect[2] = decode_pdf.getPdfPageData().getCropBoxWidth(commonValues.getCurrentPage());
                rect[0] = decode_pdf.getPdfPageData().getCropBoxX(commonValues.getCurrentPage());
                rect[1] = decode_pdf.getPdfPageData().getCropBoxY(commonValues.getCurrentPage());
            }
            commonValues.m_x1 = rect[0];
            commonValues.m_x2 = rect[0] + rect[2];
            commonValues.m_y1 = rect[1];
            commonValues.m_y2 = rect[1] + rect[3];
            decode_pdf.updateCursorBoxOnScreen(null, 0);
            decode_pdf.getPages().setHighlightedImage(null);
            decode_pdf.updateCursorBoxOnScreen(rect, DecoderOptions.highlightColor.getRGB());
            decode_pdf.repaintPane(commonValues.getCurrentPage());
        } else {
            currentGUI.showMessageDialog(Messages.getMessage("PageLayoutMessage.SinglePageOnly"));
        }
    }

    private static int[] getSelectedArea(int pageNumber, int[][] allHighlights, PdfPageData pageData) {
        int[] rect = new int[4];
        int cropX1 = pageData.getCropBoxX(pageNumber);
        int cropY1 = pageData.getCropBoxY(pageNumber);
        int cropX2 = cropX1 + pageData.getCropBoxWidth(pageNumber);
        int cropY2 = cropY1 + pageData.getCropBoxHeight(pageNumber);
        int top = 0;
        int bottom = 0;
        int count = allHighlights.length;
        for (int r2 = 0; r2 != count; ++r2) {
            int minX = allHighlights[r2][0];
            int minY = allHighlights[r2][1];
            int maxX = minX + allHighlights[r2][2];
            int maxY = minY + allHighlights[r2][3];
            if ((cropX1 < minX && minX < cropX2 || cropX1 < maxX && maxX < cropX2) && (cropY1 < minY && minY < cropY2 || cropY1 < maxY && maxY < cropY2)) {
                if (allHighlights[top] == null || minY > allHighlights[top][1]) {
                    top = r2;
                }
                if (allHighlights[bottom] != null && minY >= allHighlights[bottom][1]) continue;
                bottom = r2;
                continue;
            }
            allHighlights[r2] = null;
        }
        rect[0] = allHighlights[top][0];
        rect[1] = allHighlights[top][1] + allHighlights[top][3] / 2;
        rect[3] = allHighlights[bottom][1] + allHighlights[bottom][3] / 2 - rect[1];
        rect[2] = allHighlights[bottom][0] + allHighlights[bottom][2] - rect[0];
        return rect;
    }
}

