/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.objects.PdfPageData;

public final class Scroll {
    private Scroll() {
    }

    public static void execute(Object[] args, SwingGUI currentGUI, Values commonValues, PdfDecoderInt decode_pdf) {
        if (args != null) {
            int[] scrollTo = (int[])args[0];
            int page = commonValues.getCurrentPage();
            if (args.length > 1 && args[1] != null) {
                page = (Integer)args[1];
            }
            if (scrollTo != null) {
                currentGUI.setPage(page);
                Scroll.rectToHighlight(scrollTo, page, decode_pdf);
                ((Component)((Object)decode_pdf)).invalidate();
                decode_pdf.repaint();
            }
        }
    }

    public static void rectToHighlight(int[] highlight, int page, PdfDecoderInt decode_pdf) {
        int x2 = 0;
        int y2 = 0;
        int w2 = 0;
        int h2 = 0;
        int insetW = decode_pdf.getInsetW();
        int insetH = decode_pdf.getInsetH();
        float scaling = decode_pdf.getScaling();
        int scrollInterval = decode_pdf.getScrollInterval();
        int displayView = decode_pdf.getDisplayView();
        if (page < 1 || page > decode_pdf.getPageCount()) {
            page = decode_pdf.getPageNumber();
        }
        PdfPageData pageData = decode_pdf.getPdfPageData();
        int cropW = pageData.getCropBoxWidth(page);
        int cropH = pageData.getCropBoxHeight(page);
        int cropX = pageData.getCropBoxX(page);
        int cropY = pageData.getCropBoxY(page);
        switch (decode_pdf.getDisplayRotation()) {
            case 0: {
                x2 = (int)((float)(highlight[0] - cropX) * scaling) + insetW;
                y2 = (int)((float)(cropH - (highlight[1] - cropY)) * scaling) + insetH;
                w2 = (int)((float)highlight[2] * scaling);
                h2 = (int)((float)highlight[3] * scaling);
                break;
            }
            case 90: {
                x2 = (int)((float)(highlight[1] - cropY) * scaling) + insetH;
                y2 = (int)((float)(highlight[0] - cropX) * scaling) + insetW;
                w2 = (int)((float)highlight[3] * scaling);
                h2 = (int)((float)highlight[2] * scaling);
                break;
            }
            case 180: {
                x2 = (int)((float)(cropW - (highlight[0] - cropX)) * scaling) + insetW;
                y2 = (int)((float)(highlight[1] - cropY) * scaling) + insetH;
                w2 = (int)((float)highlight[2] * scaling);
                h2 = (int)((float)highlight[3] * scaling);
                break;
            }
            case 270: {
                x2 = (int)((float)(cropH - (highlight[1] - cropY)) * scaling) + insetH;
                y2 = (int)((float)(cropW - (highlight[0] - cropX)) * scaling) + insetW;
                w2 = (int)((float)highlight[3] * scaling);
                h2 = (int)((float)highlight[2] * scaling);
            }
        }
        if (displayView != 1 && displayView != 5) {
            x2 += decode_pdf.getPages().getXCordForPage(page);
            y2 += decode_pdf.getPages().getYCordForPage(page);
        }
        Rectangle visibleRect = decode_pdf.getVisibleRect();
        x2 = x2 > visibleRect.x + visibleRect.width / 2 ? (x2 += visibleRect.width / 2 - highlight[2] / 2) : (x2 -= visibleRect.width / 2 - highlight[2] / 2);
        y2 = y2 > visibleRect.y + visibleRect.height / 2 ? (y2 += visibleRect.height / 2 - highlight[3] / 2) : (y2 -= visibleRect.height / 2 - highlight[3] / 2);
        Rectangle scrollto = new Rectangle(x2 - scrollInterval, y2 - scrollInterval, w2 + scrollInterval * 2, h2 + scrollInterval * 2);
        ((JComponent)((Object)decode_pdf)).scrollRectToVisible(scrollto);
    }
}

